/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Extractors;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AnyFilter;
import com.tangosol.util.filter.BetweenFilter;
import com.tangosol.util.filter.ContainsAllFilter;
import com.tangosol.util.filter.ContainsAnyFilter;
import com.tangosol.util.filter.ContainsFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.IsNotNullFilter;
import com.tangosol.util.filter.IsNullFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import com.tangosol.util.filter.LikeFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.NotEqualsFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PredicateFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.filter.RegexFilter;
import com.tangosol.util.filter.ScriptFilter;
import com.tangosol.util.function.Remote;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Filters {
    public static <T> Filter<T> all(Filter<? super T> ... filters) {
        return new AllFilter(filters);
    }

    public static <T> Filter<T> any(Filter<? super T> ... filters) {
        return new AnyFilter(filters);
    }

    public static <T> Filter<T> always() {
        return AlwaysFilter.INSTANCE();
    }

    public static <T> Filter<T> never() {
        return NeverFilter.INSTANCE();
    }

    public static <T> Filter<T> present() {
        return PresentFilter.INSTANCE();
    }

    public static <T> Filter<T> not(Filter<T> filter) {
        return new NotFilter<T>(filter);
    }

    public static <T, E> Filter<T> isNull(ValueExtractor<T, E> extractor) {
        return new IsNullFilter<T, E>(extractor);
    }

    public static <T, E> Filter<T> isNotNull(ValueExtractor<T, E> extractor) {
        return new IsNotNullFilter<T, E>(extractor);
    }

    public static <T, E> Filter<T> equal(String fieldName, E value) {
        return Filters.equal(Extractors.extract(fieldName), value);
    }

    public static <T, E> Filter<T> equal(ValueExtractor<T, ? extends E> extractor, E value) {
        return new EqualsFilter<T, E>(extractor, value);
    }

    public static <T, E> Filter<T> notEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new NotEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> Filter<T> less(ValueExtractor<T, ? extends E> extractor, E value) {
        return new LessFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> Filter<T> lessEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new LessEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> Filter<T> greater(ValueExtractor<T, ? extends E> extractor, E value) {
        return new GreaterFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> Filter<T> greaterEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new GreaterEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> Filter<T> between(ValueExtractor<T, ? extends E> extractor, E from, E to) {
        return new BetweenFilter<T, E>(extractor, from, to);
    }

    public static <T, E, C extends Collection<? extends E>> Filter<T> contains(ValueExtractor<T, C> extractor, E value) {
        return new ContainsFilter<T, C>(extractor, value);
    }

    public static <T, E> Filter<T> arrayContains(ValueExtractor<T, E[]> extractor, E value) {
        return new ContainsFilter<T, E[]>(extractor, (E[])value);
    }

    public static <T, E, C extends Collection<? extends E>> Filter<T> containsAll(ValueExtractor<T, C> extractor, Set<? extends E> setValues) {
        return new ContainsAllFilter<T, C>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E, C extends Collection<? extends E>> Filter<T> containsAll(ValueExtractor<T, C> extractor, E ... values) {
        return new ContainsAllFilter<T, C>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> Filter<T> arrayContainsAll(ValueExtractor<T, E[]> extractor, Set<? extends E> setValues) {
        return new ContainsAllFilter<T, E[]>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> Filter<T> arrayContainsAll(ValueExtractor<T, E[]> extractor, E ... values) {
        return new ContainsAllFilter<T, E[]>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E, C extends Collection<? extends E>> Filter<T> containsAny(ValueExtractor<T, C> extractor, Set<? extends E> setValues) {
        return new ContainsAnyFilter<T, C>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E, C extends Collection<? extends E>> Filter<T> containsAny(ValueExtractor<T, C> extractor, E ... values) {
        return new ContainsAnyFilter<T, C>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> Filter<T> arrayContainsAny(ValueExtractor<T, E[]> extractor, Set<? extends E> setValues) {
        return new ContainsAnyFilter<T, E[]>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> Filter<T> arrayContainsAny(ValueExtractor<T, E[]> extractor, E ... values) {
        return new ContainsAnyFilter<T, E[]>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> Filter<T> in(ValueExtractor<T, ? extends E> extractor, Set<? extends E> setValues) {
        return new InFilter<T, E>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> Filter<T> in(ValueExtractor<T, ? extends E> extractor, E ... values) {
        return new InFilter<T, E>(extractor, new HashSet<E>(Arrays.asList(values)));
    }

    public static <T, E> Filter<T> like(ValueExtractor<T, E> extractor, String sPattern) {
        return Filters.like(extractor, sPattern, '\u0000', false);
    }

    public static <T, E> Filter<T> like(ValueExtractor<T, E> extractor, String sPattern, char chEscape) {
        return Filters.like(extractor, sPattern, chEscape, false);
    }

    public static <T, E> Filter<T> like(ValueExtractor<T, E> extractor, String sPattern, boolean fIgnoreCase) {
        return Filters.like(extractor, sPattern, '\u0000', fIgnoreCase);
    }

    public static <T, E> Filter<T> like(ValueExtractor<T, E> extractor, String sPattern, char chEscape, boolean fIgnoreCase) {
        return new LikeFilter<T, E>(extractor, sPattern, chEscape, fIgnoreCase);
    }

    public static <T, E> Filter<T> regex(ValueExtractor<T, E> extractor, String sRegex) {
        return new RegexFilter<T, E>(extractor, sRegex);
    }

    public static <T> Filter<T> predicate(Remote.Predicate<T> predicate) {
        return new PredicateFilter(predicate);
    }

    public static <T, E> Filter<T> predicate(ValueExtractor<T, ? extends E> extractor, Remote.Predicate<? super E> predicate) {
        return new PredicateFilter<T, E>(extractor, predicate);
    }

    public static <V> Filter<V> script(String sLanguage, String sScriptPath, Object ... aoArgs) {
        return new ScriptFilter(sLanguage, sScriptPath, aoArgs);
    }
}

