/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleMapEntry;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

public class MapEvent<K, V>
extends EventObject
implements PortableObject {
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    public static final int ENTRY_DELETED = 3;
    @JsonbProperty(value="id")
    protected int m_nId;
    @JsonbProperty(value="key")
    protected K m_oKey;
    @JsonbProperty(value="oldValue", nillable=true)
    protected V m_oValueOld;
    @JsonbProperty(value="newValue", nillable=true)
    protected V m_oValueNew;

    public MapEvent() {
        super(new Object());
        this.source = null;
    }

    public MapEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew) {
        super(map);
        this.m_nId = nId;
        this.m_oKey = oKey;
        this.m_oValueOld = oValueOld;
        this.m_oValueNew = oValueNew;
    }

    public ObservableMap getMap() {
        return (ObservableMap)this.getSource();
    }

    public int getId() {
        return this.m_nId;
    }

    public K getKey() {
        return this.m_oKey;
    }

    public V getOldValue() {
        return this.m_oValueOld;
    }

    public V getNewValue() {
        return this.m_oValueNew;
    }

    public Map.Entry<K, V> getOldEntry() {
        return new SimpleMapEntry<K, V>(){

            @Override
            public K getKey() {
                return MapEvent.this.getKey();
            }

            @Override
            public V getValue() {
                return MapEvent.this.getOldValue();
            }

            @Override
            public V setValue(V oValue) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map.Entry<K, V> getNewEntry() {
        return new SimpleMapEntry<K, V>(){

            @Override
            public K getKey() {
                return MapEvent.this.getKey();
            }

            @Override
            public V getValue() {
                return MapEvent.this.getNewValue();
            }

            @Override
            public V setValue(V oValue) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isInsert() {
        return this.m_nId == 1;
    }

    public boolean isUpdate() {
        return this.m_nId == 2;
    }

    public boolean isDelete() {
        return this.m_nId == 3;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nId = in.readInt(0);
        this.m_oKey = in.readObject(1);
        this.m_oValueOld = in.readObject(2);
        this.m_oValueNew = in.readObject(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nId);
        out.writeObject(1, this.m_oKey);
        out.writeObject(2, this.m_oValueOld);
        out.writeObject(3, this.m_oValueNew);
    }

    @Override
    public String toString() {
        String sEvt = this.getClass().getName();
        String sSrc = this.getSource().getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + '{' + sSrc.substring(sSrc.lastIndexOf(46) + 1) + this.getDescription() + '}';
    }

    public void dispatch(Listeners listeners) {
        this.dispatch(listeners, true);
    }

    public void dispatch(Listeners listeners, boolean fStrict) {
        if (listeners != null) {
            EventListener[] targets = listeners.listeners();
            Span span = TracingHelper.getActiveSpan();
            if (span != null) {
                span.setMetadata(Span.Metadata.LISTENER_CLASSES.key(), listeners.getListenerClassNames());
            }
            int i = targets.length;
            while (--i >= 0) {
                MapListener target = (MapListener)targets[i];
                try {
                    if (!this.shouldDispatch(target)) continue;
                    this.dispatch(target);
                }
                catch (RuntimeException e) {
                    if (fStrict || Thread.currentThread().isInterrupted()) {
                        throw e;
                    }
                    Base.err(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(MapListener<? super K, ? super V> listener) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = null;
        Object oSource = this.getSource();
        if (oSource instanceof ClassLoaderAware) {
            loader = thread.getContextClassLoader();
            thread.setContextClassLoader(((ClassLoaderAware)oSource).getContextClassLoader());
        }
        try {
            if (!this.shouldDispatch(listener)) return;
            switch (this.getId()) {
                case 1: {
                    listener.entryInserted(this);
                    return;
                }
                case 2: {
                    listener.entryUpdated(this);
                    return;
                }
                case 3: {
                    listener.entryDeleted(this);
                    return;
                }
            }
            return;
        }
        finally {
            if (loader != null) {
                thread.setContextClassLoader(loader);
            }
        }
    }

    protected boolean shouldDispatch(MapListener listener) {
        return true;
    }

    protected String getDescription() {
        switch (this.getId()) {
            case 1: {
                return " inserted: key=" + this.getKey() + ", value=" + this.getNewValue();
            }
            case 2: {
                return " updated: key=" + this.getKey() + ", old value=" + this.getOldValue() + ", new value=" + this.getNewValue();
            }
            case 3: {
                return " deleted: key=" + this.getKey() + ", value=" + this.getOldValue();
            }
        }
        throw new IllegalStateException();
    }

    public static String getDescription(int nId) {
        switch (nId) {
            case 1: {
                return "inserted";
            }
            case 2: {
                return "updated";
            }
            case 3: {
                return "deleted";
            }
        }
        return "<unknown: " + nId + '>';
    }
}

