/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;

public class ObservableHashMap<K, V>
extends SafeHashMap<K, V>
implements ObservableMap<K, V> {
    protected transient MapListenerSupport m_listenerSupport;

    public ObservableHashMap() {
    }

    public ObservableHashMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        super(cInitialBuckets, flLoadFactor, flGrowthRate);
    }

    @Override
    public synchronized V put(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public synchronized V remove(Object oKey) {
        Entry entry = (Entry)this.getEntryInternal(oKey);
        if (entry == null) {
            return null;
        }
        this.removeEntryInternal(entry);
        entry.onRemove();
        return entry.getValue();
    }

    @Override
    public synchronized void clear() {
        this.clear(false);
    }

    @Override
    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void addMapListener(MapListener<? super K, ? super V> listener, K key, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, key, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener<? super K, ? super V> listener, K key) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, key);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener<? super K, ? super V> listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    @Override
    public synchronized void removeMapListener(MapListener<? super K, ? super V> listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void truncate() {
        this.clear(true);
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            ObservableHashMap observableHashMap = this;
            synchronized (observableHashMap) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    @Override
    protected SafeHashMap.Entry<K, V> instantiateEntry() {
        return new Entry();
    }

    protected void clear(boolean fTruncate) {
        if (fTruncate) {
            super.clear();
        } else {
            SafeHashMap.Entry[] aeBucket = this.m_aeBucket;
            super.clear();
            int c = aeBucket.length;
            for (int i = 0; i < c; ++i) {
                Entry entry = (Entry)aeBucket[i];
                while (entry != null) {
                    entry.onRemove();
                    entry = (Entry)entry.m_eNext;
                }
            }
        }
    }

    protected class Entry<K, V>
    extends SafeHashMap.Entry<K, V> {
        protected Entry() {
        }

        @Override
        protected void onAdd() {
            ObservableHashMap map = ObservableHashMap.this;
            if (map.hasListeners()) {
                map.dispatchEvent(new MapEvent(map, 1, this.getKey(), null, this.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V setValue(V oValue) {
            ObservableHashMap map;
            ObservableHashMap observableHashMap = map = ObservableHashMap.this;
            synchronized (observableHashMap) {
                V oPrev = super.setValue(oValue);
                if (map.hasListeners()) {
                    map.dispatchEvent(new MapEvent(map, 2, this.getKey(), oPrev, oValue));
                }
                return oPrev;
            }
        }

        protected void onRemove() {
            ObservableHashMap map = ObservableHashMap.this;
            if (map.hasListeners()) {
                map.dispatchEvent(new MapEvent(map, 3, this.getKey(), this.getValue(), null));
            }
        }
    }
}

