/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractSparseArray;
import com.tangosol.util.LongArray;

public class PrimitiveSparseArray
extends AbstractSparseArray<Long>
implements LongArray<Long> {
    public PrimitiveSparseArray() {
    }

    public PrimitiveSparseArray(PrimitiveSparseArray array) {
        Iterator iter = (Iterator)array.iterator();
        while (iter.hasNext()) {
            long lValue = iter.nextPrimitive();
            long lIndex = iter.getIndex();
            this.setPrimitive(lIndex, lValue);
        }
    }

    @Override
    public LongArray.Iterator iterator() {
        return super.iterator();
    }

    @Override
    public LongArray.Iterator iterator(long lIndex) {
        return super.iterator(lIndex);
    }

    @Override
    public LongArray.Iterator reverseIterator() {
        return super.reverseIterator();
    }

    @Override
    public LongArray.Iterator reverseIterator(long lIndex) {
        return super.reverseIterator(lIndex);
    }

    public long getPrimitive(long lIndex) {
        PrimitiveNode node = (PrimitiveNode)this.find(lIndex);
        return node == null ? -1L : node.getPrimitiveValue();
    }

    public long removePrimitive(long lIndex) {
        PrimitiveNode node = (PrimitiveNode)this.find(lIndex);
        if (node == null) {
            return -1L;
        }
        this.remove(node);
        return node.getPrimitiveValue();
    }

    public long setPrimitive(long lIndex, long lValue) {
        PrimitiveNode node = (PrimitiveNode)this.findInsertionPoint(lIndex);
        if (node != null && node.getKey() == lIndex) {
            return node.setPrimitiveValue(lValue);
        }
        this.balancedInsertion(node, this.instantiateNode(lIndex, lValue));
        return -1L;
    }

    @Override
    protected AbstractSparseArray.Node instantiateNode(long lKey, Long value) {
        return this.instantiateNode(lKey, (long)value);
    }

    @Override
    protected AbstractSparseArray.Node instantiateNode(long lKey, long lValue) {
        return new PrimitiveNode(lKey, lValue);
    }

    @Override
    protected AbstractSparseArray.Crawler instantiateCrawler(AbstractSparseArray.Node head, int fromdir, boolean fForward) {
        return new Iterator(head, fromdir, fForward);
    }

    public class Iterator
    extends AbstractSparseArray.Crawler
    implements LongArray.Iterator<Long> {
        protected Iterator(AbstractSparseArray.Node head, int fromdir, boolean fForward) {
            super(head, fromdir, fForward);
        }

        public long nextPrimitive() {
            return ((PrimitiveNode)this.nextNode()).getPrimitiveValue();
        }

        public long getPrimitiveValue() {
            return ((PrimitiveNode)this.currentNode()).getPrimitiveValue();
        }

        public long setPrimitiveValue(long lValue) {
            return ((PrimitiveNode)this.currentNode()).setPrimitiveValue(lValue);
        }
    }

    protected static class PrimitiveNode
    extends AbstractSparseArray.Node<Long> {
        protected long m_lValue;

        public PrimitiveNode(long lKey, long lValue) {
            this.key = lKey;
            this.m_lValue = lValue;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public Long setValue(Long value) {
            return this.setPrimitiveValue(value);
        }

        @Override
        public Long getValue() {
            return this.getPrimitiveValue();
        }

        public long setPrimitiveValue(long lValue) {
            long lOldValue = this.m_lValue;
            this.m_lValue = lValue;
            return lOldValue;
        }

        public long getPrimitiveValue() {
            return this.m_lValue;
        }
    }
}

