/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.comparator.SafeComparator;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SafeSortedMap<K, V>
extends ConcurrentSkipListMap<K, V> {
    public static final Object NULL = new Null();

    public SafeSortedMap() {
        this((Comparator<K>)null);
    }

    public SafeSortedMap(SortedMap<K, V> that) {
        this(that.comparator());
        this.putAll(that);
    }

    public SafeSortedMap(Comparator<K> comparator) {
        super((Comparator & Serializable)(o1, o2) -> {
            if (comparator != null && !(comparator instanceof SafeComparator)) {
                try {
                    return comparator.compare(o1, o2);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
            if (o1 == NULL) {
                return o2 == NULL ? 0 : -1;
            }
            if (o2 == NULL) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        });
    }

    @Override
    public V get(Object oKey) {
        return SafeSortedMap.ensureReturnValue(super.get(oKey == null ? NULL : oKey));
    }

    @Override
    public V put(K oKey, V oValue) {
        return (V)SafeSortedMap.ensureReturnValue(super.put(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
    }

    @Override
    public V remove(Object oKey) {
        return SafeSortedMap.ensureReturnValue(super.remove(oKey == null ? NULL : oKey));
    }

    @Override
    public boolean equals(Object oMap) {
        if (oMap == this) {
            return true;
        }
        if (!(oMap instanceof Map)) {
            return false;
        }
        for (Map.Entry entry : ((Map)oMap).entrySet()) {
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (Objects.equals(oValue, this.get(oKey))) continue;
            return false;
        }
        return true;
    }

    @Override
    public SafeSortedMap<K, V> clone() {
        return new SafeSortedMap<K, V>(this);
    }

    @Override
    public boolean containsKey(Object oKey) {
        return super.containsKey(oKey == null ? NULL : oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return super.containsValue(oValue == null ? NULL : oValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(super.entrySet());
    }

    @Override
    public NavigableSet<K> keySet() {
        return super.containsKey(NULL) ? new KeySet(super.keySet()) : super.keySet();
    }

    @Override
    public Collection<V> values() {
        return new Values(super.values());
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        return new SubMap(super.descendingMap());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new KeySet(super.descendingKeySet());
    }

    public Map.Entry<K, V> getEntry(K oKey) {
        oKey = oKey == null ? NULL : oKey;
        NavigableMap mapSub = super.subMap(oKey, true, oKey, true);
        return mapSub.isEmpty() ? null : SafeSortedMap.ensureReturnEntry(mapSub.firstEntry());
    }

    @Override
    public K firstKey() {
        return SafeSortedMap.ensureReturnKey(super.firstKey());
    }

    @Override
    public K lastKey() {
        return SafeSortedMap.ensureReturnKey(super.lastKey());
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K oFromKey, boolean fFromInclusive, K oToKey, boolean fToInclusive) {
        return new SubMap(super.subMap(oFromKey == null ? NULL : oFromKey, fFromInclusive, oToKey == null ? NULL : oToKey, fToInclusive));
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K oToKey, boolean fInclusive) {
        return new SubMap(super.headMap(oToKey == null ? NULL : oToKey, fInclusive));
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K oFromKey, boolean fInclusive) {
        return new SubMap(super.tailMap(oFromKey == null ? NULL : oFromKey, fInclusive));
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K oFromKey, K oToKey) {
        return this.subMap((Object)oFromKey, true, (Object)oToKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K oToKey) {
        return this.headMap((Object)oToKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public V putIfAbsent(K oKey, V oValue) {
        return (V)SafeSortedMap.ensureReturnValue(super.putIfAbsent(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
    }

    @Override
    public V getOrDefault(Object oKey, V oDefaultValue) {
        return (V)SafeSortedMap.ensureReturnValue(super.getOrDefault(oKey == null ? NULL : oKey, oDefaultValue == null ? NULL : oDefaultValue));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        super.forEach(action);
    }

    @Override
    public boolean remove(Object oKey, Object oValue) {
        return super.remove(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue);
    }

    @Override
    public boolean replace(K oKey, V oOldValue, V oNewValue) {
        return super.replace(oKey == null ? NULL : oKey, oOldValue == null ? NULL : oOldValue, oNewValue == null ? NULL : oNewValue);
    }

    @Override
    public V replace(K oKey, V oValue) {
        return (V)SafeSortedMap.ensureReturnValue(super.replace(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K oKey, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K oKey, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(K oKey, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K oKey, V oValue, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("SafeSortedMap is not serializable");
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException("SafeSortedMap is not serializable");
    }

    private static <K, V> Map.Entry<K, V> ensureReturnEntry(Map.Entry<K, V> e) {
        return e.getKey() == NULL || e.getValue() == NULL ? new NullableEntry<K, V>(e) : e;
    }

    private static <K> K ensureReturnKey(K oKey) {
        return oKey == NULL ? null : (K)oKey;
    }

    private static <V> V ensureReturnValue(V oValue) {
        return oValue == NULL ? null : (V)oValue;
    }

    public static class Null {
    }

    private static class EntryIterator<K, V>
    extends SortedIterator<Map.Entry<K, V>> {
        EntryIterator(Iterator<Map.Entry<K, V>> iter) {
            super(iter);
        }

        @Override
        public Map.Entry<K, V> next() {
            return new NullableEntry((Map.Entry)this.m_iter.next());
        }
    }

    private static class SortedIterator<T>
    implements Iterator<T> {
        protected final Iterator<T> m_iter;

        SortedIterator(Iterator<T> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public T next() {
            T oObj = this.m_iter.next();
            return oObj == NULL ? null : (T)oObj;
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }

    protected static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Cloneable,
    Serializable {
        private final ConcurrentNavigableMap<K, V> m_map;

        SubMap(ConcurrentNavigableMap<K, V> oMap) {
            this.m_map = oMap;
        }

        @Override
        public SubMap<K, V> clone() {
            return new SubMap<K, V>(this);
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.m_map.containsKey(oKey == null ? NULL : oKey);
        }

        @Override
        public V get(Object oKey) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.get(oKey == null ? NULL : oKey));
        }

        @Override
        public V put(K oKey, V oValue) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.put(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
        }

        @Override
        public V remove(Object oKey) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.remove(oKey == null ? NULL : oKey));
        }

        @Override
        public int size() {
            return this.m_map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        @Override
        public boolean containsValue(Object oValue) {
            return this.m_map.containsValue(oValue == null ? NULL : oValue);
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        @Override
        public ConcurrentNavigableMap<K, V> subMap(K oFromKey, boolean fFromInclusive, K oToKey, boolean fToInclusive) {
            return new SubMap<K, V>(this.m_map.subMap(oFromKey == null ? NULL : oFromKey, fFromInclusive, oToKey == null ? NULL : oToKey, fToInclusive));
        }

        @Override
        public ConcurrentNavigableMap<K, V> headMap(K oToKey, boolean fInclusive) {
            return new SubMap<K, V>(this.m_map.subMap(NULL, false, oToKey == null ? NULL : oToKey, fInclusive));
        }

        @Override
        public ConcurrentNavigableMap<K, V> tailMap(K oFromKey, boolean fInclusive) {
            return new SubMap<K, V>(this.m_map.tailMap(oFromKey == null ? NULL : oFromKey, fInclusive));
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m_map.comparator();
        }

        @Override
        public ConcurrentNavigableMap<K, V> subMap(K oFromKey, K oToKey) {
            return this.subMap((Object)oFromKey, true, (Object)oToKey, false);
        }

        @Override
        public ConcurrentNavigableMap<K, V> headMap(K oToKey) {
            return this.headMap((Object)oToKey, false);
        }

        @Override
        public ConcurrentNavigableMap<K, V> tailMap(K oFromKey) {
            return this.tailMap((Object)oFromKey, true);
        }

        @Override
        public K firstKey() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_map.firstKey());
        }

        @Override
        public K lastKey() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_map.lastKey());
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K oKey) {
            return SafeSortedMap.ensureReturnEntry(this.m_map.lowerEntry(oKey == null ? NULL : oKey));
        }

        @Override
        public K lowerKey(K oKey) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_map.lowerKey(oKey == null ? NULL : oKey));
        }

        @Override
        public Map.Entry<K, V> floorEntry(K oKey) {
            return SafeSortedMap.ensureReturnEntry(this.m_map.floorEntry(oKey == null ? NULL : oKey));
        }

        @Override
        public K floorKey(K oKey) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_map.floorKey(oKey == null ? NULL : oKey));
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K oKey) {
            return SafeSortedMap.ensureReturnEntry(this.m_map.ceilingEntry(oKey == null ? NULL : oKey));
        }

        @Override
        public K ceilingKey(K oKey) {
            return (K)SafeSortedMap.ensureReturnValue(this.m_map.ceilingKey(oKey == null ? NULL : oKey));
        }

        @Override
        public Map.Entry<K, V> higherEntry(K oKey) {
            return SafeSortedMap.ensureReturnEntry(this.m_map.higherEntry(oKey == null ? NULL : oKey));
        }

        @Override
        public K higherKey(K oKey) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_map.higherKey(oKey == null ? NULL : oKey));
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return SafeSortedMap.ensureReturnEntry(this.m_map.firstEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return SafeSortedMap.ensureReturnEntry(this.m_map.lastEntry());
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return SafeSortedMap.ensureReturnEntry(this.m_map.pollFirstEntry());
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return SafeSortedMap.ensureReturnEntry(this.m_map.pollLastEntry());
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m_map.descendingMap());
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this.m_map.keySet());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        @Override
        public Collection<V> values() {
            return new Values(this.m_map.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this.m_map.entrySet());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public V putIfAbsent(K oKey, V oValue) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.putIfAbsent(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
        }

        @Override
        public V getOrDefault(Object oKey, V oDefaultValue) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.getOrDefault(oKey == null ? NULL : oKey, oDefaultValue == null ? NULL : oDefaultValue));
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            ConcurrentNavigableMap.super.forEach(action);
        }

        @Override
        public boolean remove(Object oKey, Object oValue) {
            return this.m_map.remove(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue);
        }

        @Override
        public boolean replace(K oKey, V oOldValue, V oNewValue) {
            return this.m_map.replace(oKey == null ? NULL : oKey, oOldValue == null ? NULL : oOldValue, oNewValue == null ? NULL : oNewValue);
        }

        @Override
        public V replace(K oKey, V oValue) {
            return (V)SafeSortedMap.ensureReturnValue(this.m_map.replace(oKey == null ? NULL : oKey, oValue == null ? NULL : oValue));
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K oKey, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K oKey, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K oKey, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K oKey, V oValue, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Values<V>
    extends AbstractCollection<V> {
        private final Collection<V> m_colValues;

        Values(Collection<V> colValues) {
            this.m_colValues = colValues;
        }

        @Override
        public Iterator<V> iterator() {
            return new SortedIterator<V>(this.m_colValues.iterator());
        }

        @Override
        public boolean isEmpty() {
            return this.m_colValues.isEmpty();
        }

        @Override
        public int size() {
            return this.m_colValues.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m_colValues.contains(o == null ? NULL : o);
        }

        @Override
        public void clear() {
            this.m_colValues.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toList().toArray();
        }

        private List<V> toList() {
            ArrayList<Object> list = new ArrayList<Object>(this.m_colValues.size());
            for (V v : this.m_colValues) {
                list.add(SafeSortedMap.ensureReturnValue(v));
            }
            return list;
        }

        @Override
        public Spliterator<V> spliterator() {
            return (Spliterator)((Object)this.iterator());
        }
    }

    protected static class KeySet<K>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        final NavigableSet<K> m_set;

        KeySet(NavigableSet<K> s) {
            this.m_set = s;
        }

        @Override
        public int size() {
            return this.m_set.size();
        }

        @Override
        public K lower(K e) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.lower(e));
        }

        @Override
        public K floor(K e) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.floor(e));
        }

        @Override
        public K ceiling(K e) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.ceiling(e));
        }

        @Override
        public K higher(K e) {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.higher(e));
        }

        @Override
        public K pollFirst() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.pollFirst());
        }

        @Override
        public K pollLast() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.pollLast());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new KeySet<K>(this.m_set.descendingSet());
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new SortedIterator<K>(this.m_set.descendingIterator());
        }

        @Override
        public NavigableSet<K> subSet(K oFromElement, K oToElement) {
            return this.subSet(oFromElement, true, oToElement, false);
        }

        @Override
        public NavigableSet<K> subSet(K oFromElement, boolean fFromInclusive, K oToElement, boolean fToInclusive) {
            return new KeySet<Object>(this.m_set.subSet(oFromElement == null ? NULL : oFromElement, fFromInclusive, oToElement == null ? NULL : oToElement, fToInclusive));
        }

        @Override
        public NavigableSet<K> headSet(K oToElement, boolean fInclusive) {
            return new KeySet<Object>(this.m_set.headSet(oToElement == null ? NULL : oToElement, fInclusive));
        }

        @Override
        public NavigableSet<K> headSet(K oToElement) {
            return this.headSet(oToElement, false);
        }

        @Override
        public NavigableSet<K> tailSet(K oFromElement, boolean fInclusive) {
            return new KeySet<Object>(this.m_set.tailSet(oFromElement == null ? NULL : oFromElement, fInclusive));
        }

        @Override
        public NavigableSet<K> tailSet(K oFromElement) {
            return this.tailSet((K)(oFromElement == null ? NULL : oFromElement), true);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m_set.comparator();
        }

        @Override
        public K first() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.first());
        }

        @Override
        public K last() {
            return (K)SafeSortedMap.ensureReturnKey(this.m_set.last());
        }

        @Override
        public Iterator<K> iterator() {
            return new SortedIterator<K>(this.m_set.iterator());
        }
    }

    protected static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> m_set;

        EntrySet(Set<Map.Entry<K, V>> s) {
            this.m_set = s;
        }

        @Override
        public int size() {
            return this.m_set.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.m_set.iterator());
        }
    }

    protected static class NullableEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> m_entry;

        NullableEntry(Map.Entry<K, V> entry) {
            this.m_entry = entry;
        }

        @Override
        public K getKey() {
            return (K)(this.m_entry == null ? null : SafeSortedMap.ensureReturnKey(this.m_entry.getKey()));
        }

        @Override
        public V getValue() {
            return (V)(this.m_entry == null ? null : SafeSortedMap.ensureReturnValue(this.m_entry.getValue()));
        }

        @Override
        public V setValue(V oValue) {
            if (this.m_entry == null) {
                throw new NullPointerException();
            }
            return (V)this.m_entry.setValue(oValue == null ? NULL : oValue);
        }
    }
}

