/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.BackingMapContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SimpleMemoryCalculator;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InflatableSet;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleMapIndex
extends Base
implements MapIndex {
    protected ValueExtractor m_extractor;
    protected Comparator m_comparator;
    protected boolean m_fOrdered;
    protected Map m_mapForward;
    private boolean m_fOptimizeMV = true;
    protected Map m_mapInverse;
    protected boolean m_fSplitCollection;
    protected volatile long m_cUnits;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected BackingMapContext m_ctx;
    protected long m_ldtLogMissingIdx;
    protected int m_cLogMissingIdx;
    protected Set m_setKeyExcluded;
    protected boolean m_fForwardIndex;
    protected boolean m_fImmutableValues;

    public SimpleMapIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, BackingMapContext ctx) {
        this(extractor, fOrdered, comparator, true, ctx);
    }

    protected SimpleMapIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, boolean fInit, BackingMapContext ctx) {
        SimpleMapIndex.azzert(extractor != null);
        this.m_extractor = extractor;
        this.m_fOrdered = fOrdered;
        this.m_comparator = comparator;
        this.m_fSplitCollection = !(extractor instanceof MultiExtractor);
        this.m_ctx = ctx;
        this.m_cUnits = 0L;
        this.m_calculator = this.instantiateCalculator();
        boolean bl = this.m_fImmutableValues = extractor instanceof KeyExtractor || extractor instanceof AbstractExtractor && ((AbstractExtractor)extractor).getTarget() == 1;
        if (fInit) {
            this.initialize(true);
        }
    }

    public ValueExtractor getValueExtractor() {
        return this.m_extractor;
    }

    @Override
    public boolean isOrdered() {
        return this.m_fOrdered;
    }

    @Override
    public boolean isPartial() {
        return !this.m_setKeyExcluded.isEmpty();
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public Map getIndexContents() {
        return this.m_mapInverse;
    }

    public Object get(Object oKey) {
        Map map = this.m_mapForward;
        if (map == null) {
            return NO_VALUE;
        }
        Object oValue = map.get(oKey);
        return oValue == null && !map.containsKey(oKey) ? NO_VALUE : oValue;
    }

    public void insert(Map.Entry entry) {
        this.insertInternal(entry);
    }

    public void update(Map.Entry entry) {
        if (!this.m_fImmutableValues) {
            this.updateInternal(entry);
        }
    }

    public void delete(Map.Entry entry) {
        this.deleteInternal(entry);
    }

    public boolean isOptimizeMV() {
        return this.m_fOptimizeMV;
    }

    public void setOptimizeMV(boolean fOptimizeMV) {
        this.m_fOptimizeMV = fOptimizeMV;
    }

    public long getUnits() {
        return this.m_cUnits;
    }

    protected void setUnits(long cUnits) {
        this.m_cUnits = Math.max(cUnits, 0L);
    }

    public ConfigurableCacheMap.UnitCalculator getCalculator() {
        return this.m_calculator;
    }

    public boolean isForwardIndexSupported() {
        return this.m_fForwardIndex;
    }

    protected void initialize(boolean fForwardIndex) {
        this.m_fForwardIndex = fForwardIndex;
        this.m_mapInverse = this.instantiateInverseIndex(this.m_fOrdered, this.m_comparator);
        this.m_mapForward = fForwardIndex ? this.instantiateForwardIndex() : null;
        this.m_setKeyExcluded = new SafeHashSet();
    }

    protected Map.Entry getForwardEntry(Object oKey) {
        return this.m_mapForward == null ? null : ((SegmentedHashMap)this.m_mapForward).getEntry(oKey);
    }

    protected void addForwardEntry(Object oKey, Object oIxValueNew) {
        Map mapForward = this.m_mapForward;
        if (mapForward != null) {
            mapForward.put(oKey, oIxValueNew);
            this.onMappingAdded();
        }
    }

    protected void removeForwardEntry(Object oKey) {
        if (this.m_mapForward != null) {
            this.m_mapForward.remove(oKey);
            this.onMappingRemoved();
        }
    }

    protected Object extractNewValue(Map.Entry entry) {
        try {
            return InvocableMapHelper.extractFromEntry(this.m_extractor, entry);
        }
        catch (RuntimeException e) {
            CacheFactory.log("An Exception occurred during index update for key " + entry.getKey() + ". The entry will be excluded from the index" + (this.m_ctx == null ? "" : " for cache " + this.m_ctx.getCacheName()) + ".\n", 2);
            CacheFactory.log(e + ":\n" + SimpleMapIndex.getStackTrace(e), 2);
            return NO_VALUE;
        }
    }

    protected Object extractOldValue(MapTrigger.Entry entry) {
        try {
            return InvocableMapHelper.extractOriginalFromEntry(this.m_extractor, entry);
        }
        catch (RuntimeException e) {
            return NO_VALUE;
        }
    }

    protected Collection ensureCollection(Object oValue) {
        if (oValue == NO_VALUE) {
            return Collections.emptySet();
        }
        if (oValue instanceof Collection) {
            return (Collection)oValue;
        }
        if (oValue instanceof Object[]) {
            return new ImmutableArrayList((Object[])oValue).getSet();
        }
        return Collections.singleton(oValue);
    }

    protected Map instantiateForwardIndex() {
        this.setUnits(this.getUnits() + (long)IndexCalculator.MAP_OVERHEAD);
        return new SegmentedHashMap();
    }

    protected Map instantiateInverseIndex(boolean fOrdered, Comparator comparator) {
        this.setUnits(this.getUnits() + (long)IndexCalculator.MAP_OVERHEAD);
        if (fOrdered) {
            if (!(comparator instanceof SafeComparator)) {
                comparator = new SafeComparator(comparator);
            }
            return new SafeSortedMap(comparator);
        }
        return new SegmentedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertInternal(Map.Entry entry) {
        Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        Object oIxValue = this.extractNewValue(entry);
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            if (oIxValue == NO_VALUE) {
                this.updateExcludedKeys(entry, true);
            } else {
                oIxValue = this.addInverseMapping(oIxValue, oKey);
                this.addForwardEntry(oKey, oIxValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateInternal(Map.Entry entry) {
        Object object = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        Object oIxValueNew = this.extractNewValue(entry);
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            void var2_4;
            void var5_10;
            Map.Entry entryFwd = this.getForwardEntry(object);
            if (entryFwd == null) {
                if (!(entry instanceof MapTrigger.Entry)) throw new IllegalStateException("Cannot extract the old value");
                Object object2 = this.extractOldValue((MapTrigger.Entry)entry);
            } else {
                Object k = entryFwd.getKey();
                Object v = entryFwd.getValue();
            }
            if (SimpleMapIndex.equals(var5_10, oIxValueNew) && (entryFwd != null || !this.isPartial())) return;
            if (var5_10 == NO_VALUE) {
                this.removeInverseMapping(NO_VALUE, (Object)var2_4, this.ensureCollection(oIxValueNew));
            } else if (this.m_fSplitCollection && var5_10 instanceof Collection || var5_10 instanceof Object[]) {
                this.removeInverseMapping(this.collectRemoved(var5_10, oIxValueNew), var2_4);
            } else {
                this.removeInverseMapping(var5_10, var2_4);
            }
            if (oIxValueNew == NO_VALUE) {
                if (entryFwd != null) {
                    this.removeForwardEntry(var2_4);
                }
                this.updateExcludedKeys(entry, true);
            } else {
                oIxValueNew = this.addInverseMapping(oIxValueNew, var2_4);
                if (entryFwd == null) {
                    this.addForwardEntry(var2_4, oIxValueNew);
                } else {
                    entryFwd.setValue(oIxValueNew);
                }
                this.updateExcludedKeys(entry, false);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteInternal(Map.Entry entry) {
        Object object = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        SimpleMapIndex simpleMapIndex = this;
        synchronized (simpleMapIndex) {
            void var4_7;
            Map mapForward = this.m_mapForward;
            if (mapForward == null) {
                if (!(entry instanceof MapTrigger.Entry)) throw new IllegalStateException("Cannot extract the old value");
                Object object2 = this.extractOldValue((MapTrigger.Entry)entry);
            } else {
                Object v = mapForward.remove(object);
                this.onMappingRemoved();
            }
            this.removeInverseMapping(var4_7, object);
            this.updateExcludedKeys(entry, false);
            return;
        }
    }

    protected Object addInverseMapping(Object oIxValue, Object oKey) {
        Map mapInverse = this.m_mapInverse;
        oIxValue = this.m_fSplitCollection && oIxValue instanceof Collection || oIxValue instanceof Object[] ? this.addInverseCollectionMapping(mapInverse, oIxValue, oKey) : this.addInverseMapping(mapInverse, oIxValue, oKey);
        return oIxValue;
    }

    protected Object addInverseMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Set setKeys;
        Map.Entry entry = this.m_fOrdered ? ((SafeSortedMap)mapIndex).getEntry(oIxValue) : ((SegmentedHashMap)mapIndex).getEntry(oIxValue);
        Object oExtracted = null;
        if (entry == null) {
            oExtracted = oIxValue;
            setKeys = this.instantiateSet();
            mapIndex.put(oExtracted, setKeys);
        } else {
            setKeys = (Set)entry.getValue();
            oIxValue = entry.getKey();
        }
        setKeys.add(oKey);
        this.onMappingAdded(oExtracted, setKeys.size());
        return oIxValue;
    }

    protected Object addInverseCollectionMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Iterator<Object> iterator;
        LiteSet setCandidateKeys = null;
        boolean fCandidate = this.m_fOptimizeMV && this.m_mapForward != null;
        boolean fScanForward = false;
        int cCost = 0;
        int THRESHOLD = 500;
        Iterator<Object> iterator2 = iterator = oIxValue instanceof Object[] ? new SimpleEnumerator<Object>((Object[])oIxValue) : ((Collection)oIxValue).iterator();
        while (iterator.hasNext()) {
            Object oValue = iterator.next();
            Object oExtracted = null;
            Set setKeys = (Set)mapIndex.get(oValue);
            if (setKeys == null) {
                fCandidate = false;
                setKeys = this.instantiateSet();
                oExtracted = oValue;
                mapIndex.put(oExtracted, setKeys);
            } else if (fCandidate && !fScanForward) {
                if (setCandidateKeys == null) {
                    cCost = setKeys.size();
                    if (cCost <= 500) {
                        setCandidateKeys = new LiteSet(setKeys);
                    } else {
                        fScanForward = true;
                    }
                } else if ((cCost += 4 * Math.max(setCandidateKeys.size(), setKeys.size())) <= 500) {
                    setCandidateKeys.retainAll(setKeys);
                }
            }
            setKeys.add(oKey);
            this.onMappingAdded(oExtracted, setKeys.size());
        }
        if (fCandidate && (fScanForward || setCandidateKeys != null)) {
            int cSize = oIxValue instanceof Object[] ? ((Object[])oIxValue).length : ((Collection)oIxValue).size();
            Iterator iter = fScanForward ? this.m_mapForward.values().iterator() : setCandidateKeys.iterator();
            int c = 2000 / (cSize + 1);
            for (int i = 0; i < c && iter.hasNext(); ++i) {
                Object oCandidateValue;
                Object object = oCandidateValue = fScanForward ? iter.next() : this.get(iter.next());
                if (!Base.equalsDeep(oCandidateValue, oIxValue)) continue;
                return oCandidateValue;
            }
        }
        return oIxValue;
    }

    protected void removeInverseMapping(Object oIxValue, Object oKey, Collection colIgnore) {
        Map mapInverse = this.m_mapInverse;
        if (oIxValue == NO_VALUE && !this.isKeyExcluded(oKey)) {
            Iterator iter = mapInverse.keySet().iterator();
            while (iter.hasNext()) {
                this.removeInverseMapping(iter.next(), oKey, colIgnore);
            }
        } else if (oIxValue instanceof Collection && this.m_fSplitCollection) {
            for (Object oElemValue : (Collection)oIxValue) {
                if (colIgnore != null && colIgnore.contains(oElemValue)) continue;
                this.removeInverseMapping(mapInverse, oElemValue, oKey);
            }
        } else if (oIxValue instanceof Object[]) {
            for (Object oElemValue : (Object[])oIxValue) {
                if (colIgnore != null && colIgnore.contains(oElemValue)) continue;
                this.removeInverseMapping(mapInverse, oElemValue, oKey);
            }
        } else {
            this.removeInverseMapping(mapInverse, oIxValue, oKey);
        }
    }

    protected void removeInverseMapping(Object oIxValue, Object oKey) {
        this.removeInverseMapping(oIxValue, oKey, null);
    }

    protected void removeInverseMapping(Map mapIndex, Object oIxValue, Object oKey) {
        Set setKeys = (Set)mapIndex.get(oIxValue);
        if (setKeys == null) {
            if (!this.isPartial() && oIxValue != null) {
                this.logMissingIdx(oIxValue, oKey);
            }
        } else {
            Object oExtracted = null;
            setKeys.remove(oKey);
            if (setKeys.isEmpty()) {
                oExtracted = oIxValue;
                mapIndex.remove(oExtracted);
            }
            this.onMappingRemoved(oExtracted);
        }
    }

    protected void logMissingIdx(Object oIxValue, Object oKey) {
        int cLog;
        long ldtLogResume;
        long ldtNow = SimpleMapIndex.getSafeTimeMillis();
        if (ldtNow > (ldtLogResume = this.m_ldtLogMissingIdx + 300000L)) {
            this.m_ldtLogMissingIdx = ldtNow;
            this.m_cLogMissingIdx = 0;
        }
        if ((cLog = ++this.m_cLogMissingIdx) < 10) {
            SimpleMapIndex.log("Missing inverse index: value=" + oIxValue + ", key=" + oKey);
        } else if (cLog == 10) {
            SimpleMapIndex.log("Suppressing missing inverse index messages for " + (ldtLogResume - ldtNow) / 1000L + " seconds");
        }
    }

    protected Set collectRemoved(Object oIxValueOld, Object oIxValueNew) {
        HashSet<Object> setRemove = oIxValueOld instanceof Collection ? new HashSet((Collection)oIxValueOld) : new HashSet<Object>(Arrays.asList((Object[])oIxValueOld));
        setRemove.removeAll(this.ensureCollection(oIxValueNew));
        return setRemove;
    }

    protected Set instantiateSet() {
        return new InflatableSet();
    }

    protected ConfigurableCacheMap.UnitCalculator instantiateCalculator() {
        return new IndexCalculator(this.m_ctx, this);
    }

    protected void onMappingRemoved() {
        this.onMappingRemoved(null);
    }

    protected void onMappingRemoved(Object oValue) {
        IndexCalculator calc = (IndexCalculator)this.getCalculator();
        int cb = calc.getEntrySize() + (oValue == null ? 0 : calc.calculateUnits(null, oValue) + IndexCalculator.SET_OVERHEAD + IndexCalculator.INFLATION_OVERHEAD);
        this.setUnits(this.getUnits() - (long)cb);
    }

    protected void onMappingAdded() {
        this.onMappingAdded(null, 0);
    }

    protected void onMappingAdded(Object oValue, int cSize) {
        IndexCalculator calc = (IndexCalculator)this.getCalculator();
        int cb = calc.getEntrySize() + (oValue == null ? 0 : calc.calculateUnits(null, oValue) + IndexCalculator.SET_OVERHEAD) + (cSize == 2 ? IndexCalculator.INFLATION_OVERHEAD : 0);
        this.setUnits(this.getUnits() + (long)cb);
    }

    protected void updateExcludedKeys(Map.Entry entry, boolean fExclude) {
        Set setExcluded = this.m_setKeyExcluded;
        if (fExclude || !setExcluded.isEmpty()) {
            Object oKey = entry.getKey();
            if (fExclude) {
                setExcluded.add(oKey);
            } else {
                setExcluded.remove(oKey);
            }
        }
    }

    protected boolean isKeyExcluded(Object oKey) {
        return this.m_setKeyExcluded.contains(oKey);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fVerbose) {
        return ClassHelper.getSimpleName(this.getClass()) + ": Extractor=" + this.getValueExtractor() + ", Ordered=" + this.isOrdered() + ", Footprint=" + Base.toMemorySizeString(this.getUnits(), false) + ", Content=" + (fVerbose ? this.getIndexContents().keySet() : Integer.valueOf(this.getIndexContents().size()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleMapIndex)) {
            return false;
        }
        SimpleMapIndex that = (SimpleMapIndex)o;
        return SimpleMapIndex.equals(this.getComparator(), that.getComparator()) && SimpleMapIndex.equals(this.getValueExtractor(), that.getValueExtractor()) && this.isOrdered() == that.isOrdered();
    }

    public int hashCode() {
        return this.m_comparator == null ? 0 : this.m_comparator.hashCode() + this.m_extractor.hashCode() + (this.m_fOrdered ? 1 : 0);
    }

    public static class IndexCalculator
    extends SimpleMemoryCalculator {
        protected SimpleMapIndex m_index;
        protected CalculatorState m_state = CalculatorState.UNINITIALIZED;
        protected int m_cbFixed;
        protected final Converter m_converter;
        protected final ConfigurableCacheMap.UnitCalculator m_calculator;
        protected static final int MAP_OVERHEAD = IndexCalculator.calculateShallowSize(SegmentedHashMap.class) + IndexCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        protected static final int ENTRY_OVERHEAD = IndexCalculator.padMemorySize(SIZE_OBJECT_REF + 4) + (IndexCalculator.calculateShallowSize(SegmentedHashMap.Entry.class) + IndexCalculator.calculateShallowSize(SafeHashMap.Entry.class)) / 2;
        protected static final int SET_OVERHEAD = IndexCalculator.calculateShallowSize(InflatableSet.class);
        protected static final int INFLATION_OVERHEAD = IndexCalculator.calculateShallowSize(SafeHashMap.class) + IndexCalculator.calculateShallowSize(InflatableSet.class) + SIZE_OBJECT + IndexCalculator.padMemorySize(SIZE_BASIC_OBJECT + 4);
        protected static final int DEFAULT_SIZE = 32;

        public IndexCalculator(BackingMapContext ctx, SimpleMapIndex index) {
            this.m_index = index;
            if (ctx == null) {
                this.m_converter = null;
                this.m_calculator = null;
                return;
            }
            this.m_converter = ctx.getManagerContext().getValueToInternalConverter();
            ObservableMap mapBack = ctx.getBackingMap();
            if (mapBack instanceof ReadWriteBackingMap) {
                mapBack = ((ReadWriteBackingMap)mapBack).getInternalCache();
            }
            this.m_calculator = mapBack instanceof ConfigurableCacheMap ? ((ConfigurableCacheMap)mapBack).getUnitCalculator() : null;
        }

        protected CalculatorState getCalculatorState(Class clz) {
            if (MAP_FIXED_SIZES.containsKey(clz)) {
                return CalculatorState.FIXED;
            }
            if (clz == String.class || clz == Binary.class) {
                return CalculatorState.STANDARD;
            }
            if (clz.isArray()) {
                switch (this.getCalculatorState(clz.getComponentType())) {
                    case FIXED: 
                    case STANDARD: {
                        return CalculatorState.STANDARD;
                    }
                }
            }
            return CalculatorState.UNKNOWN;
        }

        protected synchronized CalculatorState initialize(Object o) {
            CalculatorState state;
            ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
            if (calculator != null) {
                try {
                    calculator.calculateUnits(null, o);
                    this.m_state = CalculatorState.CONFIGURED;
                    return this.m_state;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((state = this.m_state) == CalculatorState.UNINITIALIZED) {
                state = this.getCalculatorState(o.getClass());
                switch (state) {
                    case UNKNOWN: {
                        String sMsg = calculator == null ? "There is no configured calculator for " + o.getClass().getCanonicalName() + "; this " + this.m_index + " will estimate the index size using serialization, which could impact its performance" : "The configured calculator " + calculator.getClass().getCanonicalName() + " cannot be used to estimate the size of " + o.getClass().getCanonicalName() + "; this " + this.m_index + " will estimate the index size using serialization, which could impact its performance";
                        CacheFactory.log(sMsg, 3);
                        this.m_state = state;
                        break;
                    }
                    case FIXED: {
                        this.m_cbFixed = super.sizeOf(o);
                    }
                    default: {
                        this.m_state = state;
                    }
                }
            }
            return state;
        }

        @Override
        protected int getEntrySize() {
            return ENTRY_OVERHEAD;
        }

        @Override
        public int sizeOf(Object o) {
            try {
                switch (this.m_state) {
                    case UNINITIALIZED: {
                        this.initialize(o);
                        return this.sizeOf(o);
                    }
                    case FIXED: {
                        return this.m_cbFixed;
                    }
                    case STANDARD: {
                        return super.sizeOf(o);
                    }
                    case CONFIGURED: {
                        return this.m_calculator.calculateUnits(null, o);
                    }
                    case UNKNOWN: {
                        Converter conv = this.getConverter();
                        return conv == null ? 32 : super.sizeOf(conv.convert(o));
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                return 32;
            }
        }

        protected Converter getConverter() {
            return this.m_converter;
        }

        public static enum CalculatorState {
            UNINITIALIZED,
            UNKNOWN,
            FIXED,
            STANDARD,
            CONFIGURED;

        }
    }
}

