/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.comparator.SafeComparator;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class SortedBag<E>
extends AbstractCollection<E> {
    protected static final Object NO_VALUE = new Object();
    protected AtomicLong m_atomicNonce = new AtomicLong(0L);
    protected NavigableMap m_map;
    protected Comparator<? super E> m_comparator;

    protected SortedBag() {
        this(SafeComparator.INSTANCE);
    }

    public SortedBag(Comparator<? super E> comparator) {
        this.m_comparator = comparator == null ? SafeComparator.INSTANCE : comparator;
        this.m_map = this.instantiateInternalMap(this.m_comparator);
    }

    protected NavigableMap getInternalMap() {
        return this.m_map;
    }

    protected Comparator<? super E> getComparator() {
        return this.m_comparator;
    }

    protected AtomicLong getNonceCounter() {
        return this.m_atomicNonce;
    }

    @Override
    public int size() {
        return this.getInternalMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalMap().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        Object oCeiling = this.getInternalMap().ceilingKey(o);
        return oCeiling != null && Base.equals(o, this.unwrap(oCeiling));
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iter = this.getInternalMap().keySet().iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return SortedBag.this.unwrap(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public boolean add(E o) {
        NavigableMap map = this.getInternalMap();
        do {
            if (!Base.equals(o, this.unwrap(map.ceilingKey(o)))) continue;
            map.put(this.wrap(o), NO_VALUE);
            return true;
        } while (map.put(o, NO_VALUE) != null);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Object oCeiling;
        NavigableMap map = this.getInternalMap();
        while (Base.equals(o, this.unwrap(oCeiling = map.ceilingKey(o)))) {
            if (map.remove(oCeiling) == null) continue;
            return true;
        }
        return false;
    }

    public SortedBag<E> subBag(E fromElement, E toElement) {
        return new ViewBag(fromElement, toElement);
    }

    public SortedBag<E> headBag(E toElement) {
        return new ViewBag(null, toElement);
    }

    public SortedBag<E> tailBag(E fromElement) {
        return new ViewBag(fromElement, null);
    }

    public E first() {
        return this.unwrap(this.getInternalMap().firstKey());
    }

    public E last() {
        return this.unwrap(this.getInternalMap().lastKey());
    }

    public E removeFirst() {
        Map.Entry entryRemoved = this.getInternalMap().pollFirstEntry();
        return entryRemoved == null ? null : (E)this.unwrap(entryRemoved.getKey());
    }

    public E removeLast() {
        Map.Entry entryRemoved = this.getInternalMap().pollLastEntry();
        return entryRemoved == null ? null : (E)this.unwrap(entryRemoved.getKey());
    }

    protected NavigableMap instantiateInternalMap(Comparator comparator) {
        return new TreeMap(new WrapperComparator(comparator));
    }

    protected UniqueElement<E> wrap(E o) {
        return new UniqueElement<E>(o);
    }

    protected E unwrap(Object o) {
        return (E)(o instanceof UniqueElement ? ((UniqueElement)o).f_elem : o);
    }

    protected class UniqueElement<E>
    implements Comparable {
        protected final long f_nUniqueId;
        protected final E f_elem;

        public UniqueElement(E elem) {
            this.f_elem = elem;
            this.f_nUniqueId = SortedBag.this.getNonceCounter().incrementAndGet();
        }

        public int compareTo(Object o) {
            Comparator comparator = SortedBag.this.getComparator();
            if (o instanceof UniqueElement) {
                UniqueElement that = (UniqueElement)o;
                int nCompare = comparator.compare(this.f_elem, that.f_elem);
                long nIdThis = this.f_nUniqueId;
                long nIdThat = that.f_nUniqueId;
                return nCompare == 0 ? (nIdThis == nIdThat ? 0 : (nIdThis < nIdThat ? -1 : 1)) : nCompare;
            }
            int nCompare = comparator.compare(this.f_elem, o);
            return nCompare < 0 ? -1 : 1;
        }
    }

    protected class ViewBag
    extends SortedBag<E> {
        protected final Object f_oFrom;
        protected final Object f_oTo;

        public ViewBag(E from, E to) {
            NavigableMap mapInternal = SortedBag.this.getInternalMap();
            this.m_map = from == null ? mapInternal.headMap(to, false) : (to == null ? mapInternal.tailMap(from, true) : mapInternal.subMap(from, true, to, false));
            this.m_atomicNonce = SortedBag.this.getNonceCounter();
            this.m_comparator = SortedBag.this.getComparator();
            this.f_oFrom = from;
            this.f_oTo = to;
        }

        @Override
        public boolean add(E o) {
            this.checkRange(o);
            return super.add(o);
        }

        @Override
        public SortedBag<E> subBag(E fromElement, E toElement) {
            this.checkRange(fromElement);
            this.checkRange(toElement);
            return super.subBag(fromElement, toElement);
        }

        @Override
        public SortedBag<E> headBag(E toElement) {
            this.checkRange(toElement);
            return super.headBag(toElement);
        }

        @Override
        public SortedBag<E> tailBag(E fromElement) {
            this.checkRange(fromElement);
            return super.tailBag(fromElement);
        }

        protected void checkRange(Object o) {
            Comparator comparator = this.getComparator();
            if (this.f_oFrom != null && comparator.compare(o, this.f_oFrom) < 0 || this.f_oTo != null && comparator.compare(o, this.f_oTo) >= 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    protected class WrapperComparator
    implements Comparator {
        protected final Comparator f_comparator;

        public WrapperComparator(Comparator comparator) {
            this.f_comparator = comparator;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof UniqueElement) {
                return ((UniqueElement)o1).compareTo(o2);
            }
            if (o2 instanceof UniqueElement) {
                return -((UniqueElement)o2).compareTo(o1);
            }
            return this.f_comparator.compare(o1, o2);
        }
    }
}

