/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Random;
import javax.json.bind.annotation.JsonbProperty;

public class UID
extends Base
implements Comparable,
Serializable,
ExternalizableLite,
PortableObject {
    private static Random s_rnd = UID.getRandom();
    private static int s_nHostAddr;
    private static int s_nLastCount;
    private static final Object LOCK;
    @JsonbProperty(value="address")
    private int m_nAddr;
    @JsonbProperty(value="dateTime")
    private long m_lDatetime;
    @JsonbProperty(value="count")
    private int m_nCount;

    public static void main(String[] asArgs) {
        try {
            if (asArgs.length >= 2) {
                InetAddress addr = InetAddress.getByName(asArgs[0]);
                int nCnt = Integer.parseInt(asArgs[1]);
                int nAddr = (int)(UID.toLong(addr) & 0xFFFFFFFFL);
                UID.out(new UID(nAddr, new Date().getTime(), nCnt));
            } else {
                int cIds = Math.max(1, Integer.parseInt(asArgs[0]));
                for (int i = 0; i < cIds; ++i) {
                    UID uid = new UID();
                    String sUID = uid.toString();
                    UID.azzert(uid.equals(new UID(sUID)));
                    UID.out(uid);
                }
            }
        }
        catch (Exception e) {
            try {
                UID uid = new UID(asArgs[0]);
                UID.out("Address  =" + UID.toString(uid.getAddress()));
                UID.out("Timestamp=" + new Date(uid.getTimestamp()));
                UID.out("Port     =" + (uid.getCount() & 0xFFFF));
                UID.out("MachineId=" + ((uid.getCount() & 0xFFFF0000) >>> 16));
            }
            catch (Exception ex) {
                UID.out("Usage:");
                UID.out("   java com.tangosol.util.UID <number> | <UID> | (<IP> <count>)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        this.m_nAddr = s_nHostAddr;
        this.m_lDatetime = UID.getSafeTimeMillis();
        Object object = LOCK;
        synchronized (object) {
            this.m_nCount = ++s_nLastCount;
        }
    }

    public UID(int nAddr, long lDatetime, int nCount) {
        this.m_nAddr = nAddr;
        this.m_lDatetime = lDatetime;
        this.m_nCount = nCount;
    }

    public UID(byte[] ab) {
        UID.azzert(ab != null && ab.length == 16);
        this.m_nAddr = (ab[0] & 0xFF) << 24 | (ab[1] & 0xFF) << 16 | (ab[2] & 0xFF) << 8 | ab[3] & 0xFF;
        this.m_lDatetime = (long)(ab[4] & 0xFF) << 56 | (long)(ab[5] & 0xFF) << 48 | (long)(ab[6] & 0xFF) << 40 | (long)(ab[7] & 0xFF) << 32 | (long)(ab[8] & 0xFF) << 24 | (long)(ab[9] & 0xFF) << 16 | (long)(ab[10] & 0xFF) << 8 | (long)(ab[11] & 0xFF);
        this.m_nCount = (ab[12] & 0xFF) << 24 | (ab[13] & 0xFF) << 16 | (ab[14] & 0xFF) << 8 | ab[15] & 0xFF;
    }

    public UID(String s) {
        this(UID.parseHex(s));
    }

    public UID(DataInput stream) throws IOException {
        this(UID.readBytes(stream));
    }

    private static byte[] readBytes(DataInput stream) throws IOException {
        byte[] ab = new byte[16];
        stream.readFully(ab);
        return ab;
    }

    public int getAddress() {
        return this.m_nAddr;
    }

    public long getTimestamp() {
        return this.m_lDatetime;
    }

    public int getCount() {
        return this.m_nCount;
    }

    public String toString() {
        return UID.toHexEscape(this.toByteArray());
    }

    public byte[] toByteArray() {
        byte[] ab = new byte[16];
        int nAddr = this.m_nAddr;
        long lDatetime = this.m_lDatetime;
        int nCount = this.m_nCount;
        ab[0] = (byte)(nAddr >>> 24);
        ab[1] = (byte)(nAddr >>> 16);
        ab[2] = (byte)(nAddr >>> 8);
        ab[3] = (byte)nAddr;
        ab[4] = (byte)(lDatetime >>> 56);
        ab[5] = (byte)(lDatetime >>> 48);
        ab[6] = (byte)(lDatetime >>> 40);
        ab[7] = (byte)(lDatetime >>> 32);
        ab[8] = (byte)(lDatetime >>> 24);
        ab[9] = (byte)(lDatetime >>> 16);
        ab[10] = (byte)(lDatetime >>> 8);
        ab[11] = (byte)lDatetime;
        ab[12] = (byte)(nCount >>> 24);
        ab[13] = (byte)(nCount >>> 16);
        ab[14] = (byte)(nCount >>> 8);
        ab[15] = (byte)nCount;
        return ab;
    }

    public char[] toCharArray() {
        return UID.toHex(this.toByteArray()).toCharArray();
    }

    public boolean equals(Object o) {
        if (o instanceof UID) {
            UID that = (UID)o;
            return this.m_nAddr == that.m_nAddr && this.m_lDatetime == that.m_lDatetime && this.m_nCount == that.m_nCount;
        }
        return false;
    }

    public int compareTo(Object o) {
        UID that = (UID)o;
        if (this.m_lDatetime != that.m_lDatetime) {
            return this.m_lDatetime < that.m_lDatetime ? -1 : 1;
        }
        if (this.m_nAddr != that.m_nAddr) {
            return this.m_nAddr < that.m_nAddr ? -1 : 1;
        }
        if (this.m_nCount != that.m_nCount) {
            return this.m_nCount < that.m_nCount ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.m_nAddr ^ (int)(this.m_lDatetime >>> 32) ^ (int)this.m_lDatetime ^ this.m_nCount;
    }

    public void save(DataOutput stream) throws IOException {
        stream.write(this.toByteArray());
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nAddr = in.readInt();
        this.m_lDatetime = in.readLong();
        this.m_nCount = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nAddr);
        out.writeLong(this.m_lDatetime);
        out.writeInt(this.m_nCount);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nAddr = in.readInt(0);
        this.m_lDatetime = in.readLong(1);
        this.m_nCount = in.readInt(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nAddr);
        out.writeLong(1, this.m_lDatetime);
        out.writeInt(2, this.m_nCount);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.m_nAddr);
        out.writeLong(this.m_lDatetime);
        out.writeInt(this.m_nCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_nAddr = in.readInt();
        this.m_lDatetime = in.readLong();
        this.m_nCount = in.readInt();
    }

    public static long toLong(InetAddress addr) {
        byte[] ab = addr.getAddress();
        return ((long)ab[0] & 0xFFL) << 24 | ((long)ab[1] & 0xFFL) << 16 | ((long)ab[2] & 0xFFL) << 8 | (long)ab[3] & 0xFFL;
    }

    public static String toString(long l) {
        return ((l & 0xFF000000L) >>> 24) + "." + ((l & 0xFF0000L) >>> 16) + "." + ((l & 0xFF00L) >>> 8) + "." + (l & 0xFFL);
    }

    static {
        s_nLastCount = s_rnd.nextInt();
        LOCK = new Object();
        s_nHostAddr = s_rnd.nextInt();
        try {
            byte[] abIP = InetAddress.getLocalHost().getAddress();
            int nIP = (abIP[0] & 0xFF) << 24 | (abIP[1] & 0xFF) << 16 | (abIP[2] & 0xFF) << 8 | abIP[3] & 0xFF;
            if (nIP != 0 && nIP != 2130706433) {
                s_nHostAddr = nIP;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

