/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.CanonicallyNamed;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.function.Remote;
import java.util.Objects;

@FunctionalInterface
public interface ValueExtractor<T, E>
extends Remote.Function<T, E>,
Remote.ToIntFunction<T>,
Remote.ToLongFunction<T>,
Remote.ToDoubleFunction<T>,
CanonicallyNamed {
    public E extract(T var1);

    default public int getTarget() {
        return 0;
    }

    @Override
    default public String getCanonicalName() {
        return Lambdas.getValueExtractorCanonicalName(this);
    }

    @Override
    default public E apply(T value) {
        return this.extract(value);
    }

    @Override
    default public int applyAsInt(T value) {
        return ((Number)this.extract(value)).intValue();
    }

    @Override
    default public long applyAsLong(T value) {
        return ((Number)this.extract(value)).longValue();
    }

    @Override
    default public double applyAsDouble(T value) {
        return ((Number)this.extract(value)).doubleValue();
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static <T> ValueExtractor<T, T> identity() {
        return IdentityExtractor.INSTANCE();
    }

    public static <T, E> ValueExtractor<T, E> identityCast() {
        return IdentityExtractor.INSTANCE;
    }

    public static <T, E> ValueExtractor<T, E> of(ValueExtractor<T, E> extractor) {
        return Lambdas.ensureRemotable(extractor);
    }

    @Override
    default public <V> ValueExtractor<V, E> compose(ValueExtractor<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return before instanceof ChainedExtractor ? before.andThen(this) : new ChainedExtractor(before, this);
    }

    @Override
    default public <V> ValueExtractor<T, V> andThen(ValueExtractor<? super E, ? extends V> after) {
        Objects.requireNonNull(after);
        return after instanceof ChainedExtractor ? after.compose(this) : new ChainedExtractor(this, after);
    }

    default public ValueExtractor<T, E> fromKey() {
        if (this instanceof KeyExtractor) {
            return this;
        }
        return new KeyExtractor(this);
    }
}

