/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrapperObservableMap<K, V>
extends AbstractKeySetBasedMap<K, V>
implements ObservableMap<K, V> {
    protected Map<K, V> m_map;
    protected MapListenerSupport m_listenerSupport;
    protected MapListener<K, V> m_listenerInternal;
    protected SimpleCacheStatistics m_stats;
    private boolean m_fCollectStats;
    protected boolean m_fTranslateEvents;
    protected boolean m_fDeferredEvent;
    private boolean m_fEventBypass;

    public WrapperObservableMap(Map<K, V> map) {
        this(map, false);
    }

    public WrapperObservableMap(Map<K, V> map, boolean fDeferredEvent) {
        if (map == null) {
            throw new IllegalArgumentException("Map must be specified");
        }
        this.m_map = map;
        this.m_fDeferredEvent = fDeferredEvent;
    }

    @Override
    public synchronized void clear() {
        if (this.isEventFabricator()) {
            Iterator<K> iter = this.getInternalKeySet().iterator();
            while (iter.hasNext()) {
                this.dispatchPendingEvent(iter.next(), 3, null, false);
            }
        }
        this.getMap().clear();
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getMap().containsValue(oValue);
    }

    @Override
    public V get(Object oKey) {
        Map<K, V> mapInner = this.getMap();
        if (this.isCollectStats()) {
            boolean fContains;
            long ldtStart = WrapperObservableMap.getSafeTimeMillis();
            V oValue = mapInner.get(oKey);
            boolean bl = fContains = oValue != null || mapInner.containsKey(oKey);
            if (fContains) {
                this.m_stats.registerHit(ldtStart);
            } else {
                this.m_stats.registerMiss(ldtStart);
            }
            return oValue;
        }
        return mapInner.get(oKey);
    }

    @Override
    public V put(K oKey, V oValue) {
        V oOrig;
        long ldtStart;
        Map<K, V> mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
            oOrig = mapInner.put(oKey, oValue);
            this.dispatchEvent(new CacheEvent<K, V>(this, nEvent, oKey, oOrig, oValue, false));
        } else {
            oOrig = mapInner.put(oKey, oValue);
        }
        if (fStats) {
            this.m_stats.registerPut(ldtStart);
        }
        return oOrig;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        long ldtStart;
        Map<? extends K, ? extends V> mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K oKey = entry.getKey();
                int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
                this.dispatchPendingEvent(oKey, nEvent, entry.getValue(), false);
            }
        }
        mapInner.putAll(map);
        if (fStats) {
            this.m_stats.registerPuts(map.size(), ldtStart);
        }
    }

    @Override
    public V remove(Object oKey) {
        Map<K, V> mapInner = this.getMap();
        if (this.isEventFabricator()) {
            Object oOrig;
            boolean fContained = mapInner.containsKey(oKey);
            Object v = oOrig = fContained ? (Object)mapInner.remove(oKey) : null;
            if (fContained) {
                this.dispatchEvent(new CacheEvent<Object, Object>(this, 3, oKey, oOrig, null, false));
            }
            return oOrig;
        }
        return mapInner.remove(oKey);
    }

    @Override
    protected Set<K> getInternalKeySet() {
        return this.getMap().keySet();
    }

    @Override
    protected boolean isInternalKeySetIteratorMutable() {
        return !this.isEventFabricator();
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        if (this.isEventFabricator()) {
            boolean fRemoved = false;
            if (this.getMap().containsKey(oKey)) {
                this.dispatchPendingEvent(oKey, 3, null, false);
                this.getMap().keySet().remove(oKey);
                fRemoved = true;
            }
            return fRemoved;
        }
        return this.getMap().keySet().remove(oKey);
    }

    @Override
    public synchronized void addMapListener(MapListener<? super K, ? super V> listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public synchronized void removeMapListener(MapListener<? super K, ? super V> listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void addMapListener(MapListener<? super K, ? super V> listener, K oKey, boolean fLite) {
        WrapperObservableMap.azzert(listener != null);
        Map<K, V> map = this.getMap();
        if (this.m_fEventBypass || !this.isTranslateEvents() && map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(listener, oKey, fLite);
            this.m_fEventBypass = true;
        } else {
            MapListenerSupport support = this.ensureMapListenerSupport();
            boolean fWasEmpty = support.isEmpty(oKey);
            boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(oKey);
            support.addListener(listener, oKey, fLite);
            if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
                ObservableMap mapSource = (ObservableMap)map;
                MapListener<K, V> listenerInternal = this.ensureInternalListener();
                if (fWasLite && !fLite) {
                    mapSource.removeMapListener(listenerInternal, oKey);
                }
                mapSource.addMapListener(listenerInternal, oKey, fLite);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener<? super K, ? super V> listener, K oKey) {
        WrapperObservableMap.azzert(listener != null);
        Map<K, V> map = this.getMap();
        if (this.m_fEventBypass) {
            ((ObservableMap)map).removeMapListener(listener, oKey);
        } else {
            MapListenerSupport support = this.m_listenerSupport;
            if (support != null) {
                boolean fWasStandard = support.containsStandardListeners(oKey);
                support.removeListener(listener, oKey);
                MapListener<K, V> listenerInternal = this.m_listenerInternal;
                if (listenerInternal != null) {
                    ObservableMap mapSource = (ObservableMap)this.getMap();
                    if (support.isEmpty(oKey)) {
                        mapSource.removeMapListener(listenerInternal, oKey);
                        if (support.isEmpty()) {
                            this.m_listenerSupport = null;
                            this.m_listenerInternal = null;
                        }
                    } else if (fWasStandard && !support.containsStandardListeners(oKey)) {
                        mapSource.removeMapListener(listenerInternal, oKey);
                        mapSource.addMapListener(listenerInternal, oKey, true);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener<? super K, ? super V> listener, Filter filter, boolean fLite) {
        WrapperObservableMap.azzert(listener != null);
        Map<K, V> map = this.getMap();
        if (this.m_fEventBypass || !this.isTranslateEvents() && map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(listener, filter, fLite);
            this.m_fEventBypass = true;
        } else {
            MapListenerSupport support = this.ensureMapListenerSupport();
            boolean fWasEmpty = support.isEmpty(filter);
            boolean fWasLite = !fWasEmpty && !support.containsStandardListeners(filter);
            support.addListener(listener, filter, fLite);
            if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
                ObservableMap mapSource = (ObservableMap)map;
                MapListener<K, V> listenerInternal = this.ensureInternalListener();
                if (fWasLite && !fLite) {
                    mapSource.removeMapListener(listenerInternal, filter);
                }
                mapSource.addMapListener(listenerInternal, filter, fLite);
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener<? super K, ? super V> listener, Filter filter) {
        WrapperObservableMap.azzert(listener != null);
        Map<K, V> map = this.getMap();
        if (this.m_fEventBypass) {
            ((ObservableMap)map).removeMapListener(listener, filter);
        } else {
            MapListenerSupport support = this.m_listenerSupport;
            if (support != null) {
                boolean fWasStandard = support.containsStandardListeners(filter);
                support.removeListener(listener, filter);
                MapListener<K, V> listenerInternal = this.m_listenerInternal;
                if (listenerInternal != null) {
                    ObservableMap mapSource = (ObservableMap)this.getMap();
                    if (support.isEmpty(filter)) {
                        mapSource.removeMapListener(listenerInternal, filter);
                        if (support.isEmpty()) {
                            this.m_listenerSupport = null;
                            this.m_listenerInternal = null;
                        }
                    } else if (fWasStandard && !support.containsStandardListeners(filter)) {
                        mapSource.removeMapListener(listenerInternal, filter);
                        mapSource.addMapListener(listenerInternal, filter, true);
                    }
                }
            }
        }
    }

    public Map<K, V> getMap() {
        return this.m_map;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    public boolean isCollectStats() {
        return this.m_fCollectStats;
    }

    public void setCollectStats(boolean fCollectStats) {
        if (fCollectStats != this.m_fCollectStats) {
            if (fCollectStats && this.m_stats == null) {
                this.m_stats = new SimpleCacheStatistics();
            }
            this.m_fCollectStats = fCollectStats;
        }
    }

    public boolean isTranslateEvents() {
        return this.m_fTranslateEvents;
    }

    public void setTranslateEvents(boolean fTranslate) {
        if (fTranslate != this.m_fTranslateEvents) {
            WrapperObservableMap.azzert(!this.hasListeners() && !this.m_fEventBypass);
            this.m_fTranslateEvents = fTranslate;
        }
    }

    protected String getDescription() {
        Map<K, V> map = this.getMap();
        return "Map {class=" + map.getClass().getName() + ", size=" + map.size() + ", observable=" + (map instanceof ObservableMap) + "}, CollectStats=" + this.isCollectStats() + ", CacheStatistics=" + this.getCacheStatistics() + ", hasListeners=" + this.hasListeners() + ", EventFabricator=" + this.isEventFabricator();
    }

    @Override
    public String toString() {
        return "WrapperObservableMap {" + this.getDescription() + "}";
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected MapListenerSupport ensureMapListenerSupport() {
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            this.m_listenerSupport = support = new MapListenerSupport();
        }
        return support;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    protected boolean isEventFabricator() {
        return this.hasListeners() && this.m_listenerInternal == null;
    }

    protected static <K, V> boolean isSynthetic(MapEvent<K, V> evt) {
        return evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
    }

    protected void dispatchPendingEvent(K oKey, int nId, V oNewValue, boolean fSynthetic) {
        CacheEvent event = this.m_fDeferredEvent ? new CacheEvent<K, V>(this, nId, oKey, null, oNewValue, fSynthetic){
            private V m_oOldValue;

            @Override
            public V getOldValue() {
                if (this.isInsert()) {
                    return null;
                }
                Object oOldValue = this.m_oOldValue;
                if (oOldValue == null) {
                    this.m_oOldValue = oOldValue = WrapperObservableMap.this.get(this.getKey());
                }
                return oOldValue;
            }
        } : new CacheEvent<K, V>(this, nId, oKey, this.get(oKey), oNewValue, fSynthetic);
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent<? extends K, ? extends V> evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            if (this.isTranslateEvents() && evt.getMap() != this) {
                final CacheEvent evtOrig = evt;
                evt = new CacheEvent<K, V>(this, evt.getId(), evt.getKey(), null, null, false){

                    @Override
                    public V getOldValue() {
                        return evtOrig.getOldValue();
                    }

                    @Override
                    public V getNewValue() {
                        return evtOrig.getNewValue();
                    }

                    @Override
                    public boolean isSynthetic() {
                        return WrapperObservableMap.isSynthetic(evtOrig);
                    }
                };
            }
            WrapperObservableMap wrapperObservableMap = this;
            synchronized (wrapperObservableMap) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.getMap().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.getMap().equals(o);
    }

    protected MapListener<K, V> ensureInternalListener() {
        MapListener<K, V> listenerInternal = this.m_listenerInternal;
        if (listenerInternal == null) {
            this.m_listenerInternal = listenerInternal = this.instantiateInternalListener();
        }
        return listenerInternal;
    }

    protected MapListener<K, V> instantiateInternalListener() {
        return new InternalListener();
    }

    protected class InternalListener
    extends MultiplexingMapListener<K, V> {
        protected InternalListener() {
        }

        @Override
        protected void onMapEvent(MapEvent<K, V> evt) {
            WrapperObservableMap.this.dispatchEvent(evt);
        }
    }
}

