/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.comparator;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.QueryMap;
import com.tangosol.util.comparator.SafeComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

public class EntryComparator
extends SafeComparator {
    public static final int CMP_AUTO = 0;
    public static final int CMP_VALUE = 1;
    public static final int CMP_KEY = 2;
    public static final int CMP_ENTRY = 3;
    @JsonbProperty(value="style")
    protected int m_nStyle;

    public EntryComparator() {
    }

    public EntryComparator(Comparator comparator) {
        this(comparator, 0);
    }

    public EntryComparator(Comparator comparator, int nStyle) {
        super(comparator);
        switch (nStyle) {
            case 0: {
                nStyle = EntryComparator.isKeyComparator(comparator) ? 2 : 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid comparison style: " + nStyle);
            }
        }
        this.m_nStyle = nStyle;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Map.Entry e1 = (Map.Entry)o1;
        Map.Entry e2 = (Map.Entry)o2;
        switch (this.m_nStyle) {
            case 2: {
                return super.compare(e1.getKey(), e2.getKey());
            }
            case 3: {
                if (!(e1 instanceof QueryMap.Entry) || !(e2 instanceof QueryMap.Entry)) break;
                return this.compareEntries((QueryMap.Entry)e1, (QueryMap.Entry)e2);
            }
        }
        return super.compare(e1.getValue(), e2.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof EntryComparator) {
            EntryComparator that = (EntryComparator)o;
            return super.equals(o) && this.m_nStyle == that.m_nStyle;
        }
        return false;
    }

    public int getComparisonStyle() {
        return this.m_nStyle;
    }

    public boolean isCompareValue() {
        return this.m_nStyle == 1;
    }

    public boolean isCompareKey() {
        return this.m_nStyle == 2;
    }

    public boolean isCompareEntry() {
        return this.m_nStyle == 3;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_nStyle = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.m_nStyle);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_nStyle = in.readInt(10);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeInt(10, this.m_nStyle);
    }
}

