/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.oracle.coherence.common.internal.util.CanonicalNames;
import com.tangosol.internal.util.extractor.TargetReflectionDescriptor;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class UniversalExtractor<T, E>
extends AbstractExtractor<T, E>
implements ValueExtractor<T, E>,
ExternalizableLite,
PortableObject {
    public static final String[] BEAN_ACCESSOR_PREFIXES = CanonicalNames.VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES;
    public static final String METHOD_SUFFIX = "()";
    @JsonbProperty(value="name")
    protected String m_sName;
    @JsonbProperty(value="params")
    protected Object[] m_aoParam;
    protected transient String m_sNameCanon = null;
    private transient TargetReflectionDescriptor m_cacheTarget;
    private transient boolean m_fMethod;

    public UniversalExtractor() {
    }

    public UniversalExtractor(String sName) {
        this(sName, null, 0);
    }

    public UniversalExtractor(String sName, Object[] aoParam) {
        this(sName, aoParam, 0);
    }

    @JsonbCreator
    public UniversalExtractor(@JsonbProperty(value="name") String sName, @JsonbProperty(value="params") Object[] aoParam, @JsonbProperty(value="target") int nTarget) {
        UniversalExtractor.azzert(sName != null);
        if (aoParam != null && aoParam.length > 0 && !sName.endsWith(METHOD_SUFFIX)) {
            throw new IllegalArgumentException("UniversalExtractor constructor: parameter sName[value:" + sName + "] must end with method suffix \"" + METHOD_SUFFIX + "\" when optional parameters provided");
        }
        this.m_sName = sName;
        this.m_aoParam = aoParam;
        this.m_nTarget = nTarget;
        this.init();
    }

    @Override
    public E extract(T oTarget) {
        if (oTarget == null) {
            return null;
        }
        TargetReflectionDescriptor targetPrev = this.m_cacheTarget;
        try {
            if (targetPrev != null && oTarget.getClass() == targetPrev.getTargetClass()) {
                return (E)(targetPrev.isMap() ? ((Map)oTarget).get(this.getCanonicalName()) : targetPrev.getMethod().invoke(oTarget, this.m_aoParam));
            }
            return this.extractComplex(oTarget);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.suggestExtractFailureCause(oTarget.getClass(), false));
        }
        catch (Exception e) {
            throw UniversalExtractor.ensureRuntimeException(e, oTarget.getClass().getName() + this + '(' + oTarget + ')');
        }
    }

    @Override
    public String getCanonicalName() {
        String sCName = Lambdas.getValueExtractorCanonicalName(this);
        if (sCName == null) {
            sCName = this.m_sNameCanon = CanonicalNames.computeValueExtractorCanonicalName(this.m_sName, this.m_aoParam);
        }
        return sCName;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (this.isCanonicallyEquatable(o)) {
            return false;
        }
        if (o instanceof UniversalExtractor) {
            UniversalExtractor that = (UniversalExtractor)o;
            return this.m_nTarget == that.m_nTarget && UniversalExtractor.equals(this.m_sName, that.m_sName) && UniversalExtractor.equalsDeep(this.m_aoParam, that.m_aoParam);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String sCName = this.getCanonicalName();
        return sCName == null ? this.m_sName.hashCode() : super.hashCode();
    }

    public String toString() {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        StringBuilder sb = new StringBuilder();
        if (this.m_nTarget == 1) {
            sb.append(".getKey()");
        }
        if (this.isPropertyExtractor()) {
            String sCName = this.getCanonicalName();
            if (sCName != null && sCName.length() > 0) {
                sb.append("." + sCName);
                return sb.toString();
            }
            return "";
        }
        if (this.isMethodExtractor()) {
            sb.append('.').append(this.getMethodName()).append('(');
            for (int i = 0; i < cParams; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(aoParam[i]);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    protected void init() {
        String sCName = this.getCanonicalName();
        this.m_fMethod = sCName == null || sCName.endsWith(METHOD_SUFFIX);
    }

    public String getMethodName() {
        int METHOD_SUFFIX_LENGTH = METHOD_SUFFIX.length();
        String sCName = this.getCanonicalName();
        String sName = sCName == null ? this.m_sName : sCName;
        return this.isMethodExtractor() ? sName.substring(0, sName.length() - METHOD_SUFFIX_LENGTH) : "get" + Character.toUpperCase(sCName.charAt(0)) + sCName.substring(1);
    }

    public String getName() {
        return this.m_sName;
    }

    public String getPropertyName() {
        return this.isPropertyExtractor() ? this.getCanonicalName() : null;
    }

    public boolean isPropertyExtractor() {
        return !this.m_fMethod;
    }

    public boolean isMethodExtractor() {
        return this.m_fMethod;
    }

    public Object[] getParameters() {
        return this.m_aoParam;
    }

    protected E extractComplex(T oTarget) throws InvocationTargetException, IllegalAccessException {
        Class<?> clzTarget = oTarget.getClass();
        Object[] aoParam = this.m_aoParam;
        Class[] clzParam = ClassHelper.getClassArray(aoParam);
        String sCName = this.getCanonicalName();
        boolean fProperty = this.isPropertyExtractor();
        Method method = null;
        if (fProperty) {
            String sBeanAttribute = Character.toUpperCase(sCName.charAt(0)) + sCName.substring(1);
            for (int cchPrefix = 0; cchPrefix < BEAN_ACCESSOR_PREFIXES.length && method == null; ++cchPrefix) {
                method = ClassHelper.findMethod(clzTarget, BEAN_ACCESSOR_PREFIXES[cchPrefix] + sBeanAttribute, clzParam, false);
            }
        } else {
            method = ClassHelper.findMethod(clzTarget, this.getMethodName(), clzParam, false);
        }
        if (method == null) {
            if (fProperty && oTarget instanceof Map) {
                this.m_cacheTarget = new TargetReflectionDescriptor(clzTarget);
                return (E)((Map)oTarget).get(sCName);
            }
        } else {
            if (!ClassHelper.isReflectionAllowed(oTarget)) {
                this.m_cacheTarget = null;
                throw new IllegalArgumentException(this.suggestExtractFailureCause(clzTarget, true));
            }
            this.m_cacheTarget = new TargetReflectionDescriptor(clzTarget, method);
        }
        return (E)method.invoke(oTarget, aoParam);
    }

    private String suggestExtractFailureCause(Class clzTarget, boolean fFiltered) {
        TargetReflectionDescriptor targetPrev = this.m_cacheTarget;
        if (targetPrev != null && targetPrev.isMap()) {
            return "Failed accessing target of class " + clzTarget.getCanonicalName() + " using property " + this.getCanonicalName();
        }
        String sMsg = "Missing or inaccessible method: " + clzTarget.getName() + this;
        if (MapEvent.class.isAssignableFrom(clzTarget)) {
            sMsg = sMsg + " (the object is a com.oracle.coherence.util.MapEvent, which may suggest that a raw com.oracle.coherence.util.Filter is being used to filter map events rather than a com.oracle.coherence.util.filter.MapEventFilter)";
        }
        if (fFiltered) {
            sMsg = sMsg + " (The type, " + clzTarget.getName() + ", is disallowed as a reflection target by the current reflection filter configuration)";
        }
        return sMsg;
    }

    public static <T, E> ValueExtractor<T, E> createExtractor(String sNames) {
        if (sNames == null || sNames.length() == 0) {
            return IdentityExtractor.INSTANCE;
        }
        return sNames.indexOf(46) < 0 ? new UniversalExtractor<T, E>(sNames) : new ChainedExtractor(ChainedExtractor.createExtractors(sNames));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sName = UniversalExtractor.readUTF(in);
        int cParams = UniversalExtractor.readInt(in);
        UniversalExtractor.azzert(cParams < 256, "Unexpected number of method parameters.");
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = UniversalExtractor.readObject(in);
        }
        this.m_aoParam = aoParam;
        this.m_nTarget = UniversalExtractor.readInt(in);
        this.init();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        String sMethod = this.m_sName;
        if (sMethod == null) {
            throw new NotActiveException("UniversalExtractor was constructed without a method name");
        }
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        UniversalExtractor.writeUTF(out, sMethod);
        UniversalExtractor.writeInt(out, cParams);
        for (int i = 0; i < cParams; ++i) {
            UniversalExtractor.writeObject(out, aoParam[i]);
        }
        UniversalExtractor.writeInt(out, this.m_nTarget);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sName = in.readString(0);
        this.m_aoParam = in.readArray(1, Object[]::new);
        this.m_nTarget = in.readInt(2);
        this.init();
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        String sMethod = this.m_sName;
        if (sMethod == null) {
            throw new NotActiveException("UniversalExtractor was constructed without a method name");
        }
        out.writeString(0, sMethod);
        out.writeObjectArray(1, this.m_aoParam);
        out.writeInt(2, this.m_nTarget);
    }
}

