/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.QueryRecorderFilter;
import com.tangosol.util.filter.WrapperQueryRecorderFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public abstract class ArrayFilter
extends ExternalizableHelper
implements EntryFilter,
IndexAwareFilter,
QueryRecorderFilter,
ExternalizableLite,
PortableObject {
    private static final Filter[] EMPTY_FILTER_ARRAY = new Filter[0];
    @JsonbProperty(value="filters")
    protected Filter[] m_aFilter;
    @JsonbProperty(value="preserveOrder")
    protected boolean m_fPreserveOrder;

    public ArrayFilter() {
    }

    public ArrayFilter(Filter[] aFilter) {
        ArrayFilter.azzert(aFilter != null);
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            ArrayFilter.azzert(aFilter[i] != null, "Null element");
        }
        this.m_aFilter = aFilter;
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        return this.evaluateEntry(entry, null, null);
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        return this.applyIndex(mapIndexes, setKeys, null, null);
    }

    @Override
    public void explain(QueryContext ctx, QueryRecord.PartialResult.ExplainStep step, Set setKeys) {
        this.optimizeFilterOrder(ctx.getBackingMapContext().getIndexMap(), setKeys);
        for (Filter filter : this.m_aFilter) {
            QueryRecord.PartialResult.ExplainStep subStep = step.ensureStep(filter);
            QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
            filterRecorder.explain(ctx, subStep, setKeys);
        }
    }

    @Override
    public Filter trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Set setKeys) {
        step.recordPreFilterKeys(setKeys.size());
        long ldtStart = System.currentTimeMillis();
        Filter filterRemaining = this.applyIndex(ctx.getBackingMapContext().getIndexMap(), setKeys, ctx, step);
        long ldtEnd = System.currentTimeMillis();
        step.recordPostFilterKeys(setKeys.size());
        step.recordDuration(ldtEnd - ldtStart);
        return filterRemaining;
    }

    @Override
    public boolean trace(QueryContext ctx, QueryRecord.PartialResult.TraceStep step, Map.Entry entry) {
        step.recordPreFilterKeys(1);
        long ldtStart = System.currentTimeMillis();
        boolean fResult = this.evaluateEntry(entry, ctx, step);
        long ldtEnd = System.currentTimeMillis();
        step.recordPostFilterKeys(fResult ? 1 : 0);
        step.recordDuration(ldtEnd - ldtStart);
        return fResult;
    }

    protected abstract Filter applyIndex(Map var1, Set var2, QueryContext var3, QueryRecord.PartialResult.TraceStep var4);

    protected abstract boolean evaluateEntry(Map.Entry var1, QueryContext var2, QueryRecord.PartialResult.TraceStep var3);

    public Filter[] getFilters() {
        return this.m_aFilter;
    }

    public void honorOrder() {
        this.m_fPreserveOrder = true;
    }

    protected void optimizeFilterOrder(Map mapIndexes, Set setKeys) {
        int i;
        if (this.m_fPreserveOrder) {
            return;
        }
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        Object[] awf = new WeightedFilter[cFilters];
        int nMax = setKeys.size() * ExtractorFilter.EVAL_COST;
        boolean fSort = false;
        int nEffect0 = -1;
        for (i = 0; i < cFilters; ++i) {
            Filter filter = aFilter[i];
            int nEffect = filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : nMax;
            awf[i] = new WeightedFilter(filter, nEffect);
            if (i == 0) {
                nEffect0 = nEffect;
                continue;
            }
            fSort |= nEffect != nEffect0;
        }
        if (fSort) {
            Arrays.sort(awf);
            for (i = 0; i < cFilters; ++i) {
                aFilter[i] = ((WeightedFilter)awf[i]).getFilter();
            }
        }
        this.m_fPreserveOrder = true;
    }

    protected Filter applyFilter(Filter filter, int iFilter, Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        if (ctx == null) {
            return ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys);
        }
        QueryRecord.PartialResult.TraceStep subStep = step.ensureStep(filter);
        QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
        return filterRecorder.trace(ctx, subStep, setKeys);
    }

    protected boolean evaluateFilter(Filter filter, Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        if (ctx == null) {
            return InvocableMapHelper.evaluateEntry(filter, entry);
        }
        QueryRecorderFilter filterRecorder = filter instanceof QueryRecorderFilter ? (QueryRecorderFilter)filter : new WrapperQueryRecorderFilter(filter);
        return filterRecorder.trace(ctx, step, entry);
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayFilter) {
            ArrayFilter that = (ArrayFilter)o;
            return this.getClass() == that.getClass() && ArrayFilter.equalsDeep(this.m_aFilter, that.m_aFilter);
        }
        return false;
    }

    public int hashCode() {
        int iHash = 0;
        for (Filter filter : this.m_aFilter) {
            iHash += filter == null ? 0 : filter.hashCode();
        }
        return iHash;
    }

    public String toString() {
        String sClass = this.getClass().getName();
        StringBuilder sb = new StringBuilder(sClass.substring(sClass.lastIndexOf(46) + 1));
        sb.append('(');
        Filter[] aFilter = this.m_aFilter;
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aFilter[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cFilters = ArrayFilter.readInt(in);
        ArrayFilter.azzert(cFilters < 16384, "Unexpected number of filters.");
        Filter[] aFilter = new Filter[cFilters];
        for (int i = 0; i < cFilters; ++i) {
            aFilter[i] = (Filter)ArrayFilter.readObject(in);
        }
        this.m_aFilter = aFilter;
        this.m_fPreserveOrder = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        ArrayFilter.writeInt(out, cFilters);
        for (int i = 0; i < cFilters; ++i) {
            ArrayFilter.writeObject(out, aFilter[i]);
        }
        out.writeBoolean(this.m_fPreserveOrder);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aFilter = (Filter[])in.readObjectArray(0, EMPTY_FILTER_ARRAY);
        this.m_fPreserveOrder = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aFilter);
        out.writeBoolean(1, this.m_fPreserveOrder);
    }

    protected static class WeightedFilter
    implements Comparable {
        private Filter m_filter;
        private int m_nEffect;

        protected WeightedFilter(Filter filter, int nEffect) {
            this.m_filter = filter;
            this.m_nEffect = nEffect;
        }

        public int compareTo(Object o) {
            int nThis = this.m_nEffect;
            int nThat = ((WeightedFilter)o).m_nEffect;
            return nThis < nThat ? -1 : (nThis > nThat ? 1 : 0);
        }

        public Filter getFilter() {
            return this.m_filter;
        }
    }
}

