/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public abstract class ExtractorFilter<T, E>
extends AbstractQueryRecorderFilter<T>
implements EntryFilter<Object, T>,
ExternalizableLite,
PortableObject,
IndexAwareFilter<Object, T> {
    public static int EVAL_COST = 1000;
    @JsonbProperty(value="extractor")
    protected ValueExtractor<? super T, ? extends E> m_extractor;

    public ExtractorFilter() {
    }

    public ExtractorFilter(ValueExtractor<? super T, ? extends E> extractor) {
        ExtractorFilter.azzert(extractor != null);
        this.m_extractor = Lambdas.ensureRemotable(extractor);
    }

    public ExtractorFilter(String sMethod) {
        this.m_extractor = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
    }

    @Override
    public boolean evaluate(T target) {
        return this.evaluateExtracted(this.extract(target));
    }

    @Override
    public boolean evaluateEntry(Map.Entry<?, ? extends T> entry) {
        ValueExtractor<T, E> extractor = this.getValueExtractor();
        return this.evaluateExtracted(entry instanceof QueryMap.Entry ? ((QueryMap.Entry)entry).extract(extractor) : InvocableMapHelper.extractFromEntry(extractor, entry));
    }

    protected abstract boolean evaluateExtracted(E var1);

    protected E extract(T o) {
        return this.getValueExtractor().extract(o);
    }

    public ValueExtractor<? super T, ? extends E> getValueExtractor() {
        return this.m_extractor;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? ExtractorFilter.calculateIteratorEffectiveness(setKeys.size()) : index.getIndexContents().size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        HashSet setMatch = new HashSet();
        Map mapValues = index.getIndexContents();
        for (Map.Entry entry : mapValues.entrySet()) {
            if (!this.evaluateExtracted(entry.getKey())) continue;
            setMatch.addAll(ExtractorFilter.ensureSafeSet(entry.getValue()));
        }
        setKeys.retainAll(setMatch);
        return null;
    }

    public static int calculateIteratorEffectiveness(int cKeys) {
        long lCost = (long)EVAL_COST * (long)cKeys;
        return lCost <= Integer.MAX_VALUE ? (int)lCost : Integer.MAX_VALUE;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)ExtractorFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExtractorFilter.writeObject(out, this.m_extractor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
    }

    protected static Set ensureSafeSet(Set set) {
        return set == null ? Collections.emptySet() : set;
    }
}

