/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NotEqualsFilter<T, E>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public NotEqualsFilter() {
    }

    public NotEqualsFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public NotEqualsFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        return !NotEqualsFilter.equals(extracted, this.getValue());
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateMatchEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Map mapContents = index.getIndexContents();
        Object oValue = this.getValue();
        if (index.isPartial()) {
            HashSet setNE = new HashSet();
            for (Map.Entry entry : mapContents.entrySet()) {
                if (entry.getKey().equals(oValue)) continue;
                setNE.addAll(NotEqualsFilter.ensureSafeSet(entry.getValue()));
            }
            setKeys.retainAll(setNE);
        } else {
            Set setEquals = mapContents.get(oValue);
            setKeys.removeAll(NotEqualsFilter.ensureSafeSet(setEquals));
        }
        return null;
    }
}

