/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import com.tangosol.util.fsm.Model;
import com.tangosol.util.fsm.Transition;

public class Render {
    public static <S extends Enum<S>> String asGraphViz(Model<S> model, boolean fVerbose) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph finite_state_machine {\n");
        builder.append("    rankdir=LR;\n");
        builder.append("    node [shape=circle];\n");
        for (Enum state : model.getStates()) {
            builder.append("    ").append(state.name()).append(" [ label=\"").append(state.name()).append("\" ];\n");
        }
        for (Enum state : model.getStates()) {
            for (Transition<Enum> transition : model.getTransitions()) {
                if (!transition.isStartingState(state)) continue;
                builder.append("    ").append(state.name()).append(" -> ").append(((Enum)transition.getEndingState()).name());
                if (fVerbose) {
                    builder.append("[ label=\"").append(transition.getName()).append("\" ];\n");
                    continue;
                }
                builder.append(";\n");
            }
        }
        builder.append("}\n");
        return builder.toString();
    }
}

