/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Versionable;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public class VersionedPutAll<K, V extends Versionable>
extends AbstractProcessor<K, V, V>
implements ExternalizableLite,
PortableObject {
    private static final Object NO_RESULT = new Object();
    @JsonbProperty(value="entries")
    protected Map<? extends K, ? extends V> m_map;
    @JsonbProperty(value="insert")
    protected boolean m_fInsert;
    @JsonbProperty(value="return")
    protected boolean m_fReturn;

    public VersionedPutAll() {
    }

    public VersionedPutAll(Map<? extends K, ? extends V> map) {
        this(map, false, false);
    }

    public VersionedPutAll(Map<? extends K, ? extends V> map, boolean fAllowInsert, boolean fReturn) {
        VersionedPutAll.azzert(map != null, "Map is null");
        this.m_map = new HashMap<K, V>(map);
        this.m_fInsert = fAllowInsert;
        this.m_fReturn = fReturn;
    }

    @Override
    public V process(InvocableMap.Entry<K, V> entry) {
        Object oResult = this.processEntry(entry, this.m_map, this.m_fInsert, this.m_fReturn);
        return (V)(oResult == NO_RESULT ? null : (Versionable)oResult);
    }

    @Override
    public Map<K, V> processAll(Set<? extends InvocableMap.Entry<K, V>> setEntries) {
        LiteMap<K, Object> mapResult = new LiteMap<K, Object>();
        Map<? extends K, ? extends V> mapAll = this.m_map;
        boolean fInsert = this.m_fInsert;
        boolean fReturn = this.m_fReturn;
        for (InvocableMap.Entry<K, V> entry : setEntries) {
            Object oResult = this.processEntry(entry, mapAll, fInsert, fReturn);
            if (oResult == NO_RESULT) continue;
            mapResult.put(entry.getKey(), oResult);
        }
        return mapResult;
    }

    public boolean equals(Object o) {
        if (o instanceof VersionedPutAll) {
            VersionedPutAll that = (VersionedPutAll)o;
            return VersionedPutAll.equals(this.m_map, that.m_map) && this.m_fInsert == that.m_fInsert && this.m_fReturn == that.m_fReturn;
        }
        return false;
    }

    public int hashCode() {
        return this.m_map.hashCode() + (this.m_fInsert ? 1 : 2) + (this.m_fReturn ? 3 : 4);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{InsertAllowed=" + this.m_fInsert + ", ReturnRequired=" + this.m_fReturn + ", Map=" + this.m_map + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_map = new HashMap<K, V>();
        HashMap<? extends K, ? extends V> map = this.m_map;
        ExternalizableHelper.readMap(in, map, null);
        this.m_fInsert = in.readBoolean();
        this.m_fReturn = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeMap(out, this.m_map);
        out.writeBoolean(this.m_fInsert);
        out.writeBoolean(this.m_fReturn);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_map = in.readMap(0, new HashMap());
        this.m_fInsert = in.readBoolean(1);
        this.m_fReturn = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeMap(0, this.m_map);
        out.writeBoolean(1, this.m_fInsert);
        out.writeBoolean(2, this.m_fReturn);
    }

    protected Object processEntry(InvocableMap.Entry<K, V> entry, Map<? extends K, ? extends V> mapAll, boolean fInsert, boolean fReturn) {
        K oKey = entry.getKey();
        if (mapAll.containsKey(oKey)) {
            boolean fMatch;
            Versionable oValueCur = (Versionable)entry.getValue();
            Versionable oValueNew = (Versionable)mapAll.get(oKey);
            if (oValueCur == null) {
                fMatch = fInsert;
            } else {
                Object verNew;
                Object verCur = oValueCur.getVersionIndicator();
                boolean bl = fMatch = verCur.compareTo(verNew = oValueNew.getVersionIndicator()) == 0;
            }
            if (fMatch) {
                oValueNew.incrementVersion();
                entry.setValue(oValueNew, false);
                return NO_RESULT;
            }
            return fReturn ? oValueCur : NO_RESULT;
        }
        return NO_RESULT;
    }
}

