/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.stream;

import com.tangosol.internal.util.stream.collectors.SimpleRemoteCollector;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface RemoteCollector<T, A, R>
extends Collector<T, A, R>,
Serializable {
    public static <T, R> RemoteCollector<T, R, R> of(Supplier<R> supplier, BiConsumer<R, T> accumulator, BinaryOperator<R> combiner, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(characteristics);
        EnumSet<Collector.Characteristics> cs = characteristics.length == 0 ? EnumSet.of(Collector.Characteristics.IDENTITY_FINISH) : EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, characteristics);
        return new SimpleRemoteCollector(supplier, accumulator, combiner, Collections.unmodifiableSet(cs));
    }

    public static <T, R> RemoteCollector<T, R, R> of(Remote.Supplier<R> supplier, Remote.BiConsumer<R, T> accumulator, Remote.BinaryOperator<R> combiner, Collector.Characteristics ... characteristics) {
        return RemoteCollector.of(supplier, accumulator, combiner, characteristics);
    }

    public static <T, A, R> RemoteCollector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(finisher);
        Objects.requireNonNull(characteristics);
        Set<Collector.Characteristics> cs = Collections.emptySet();
        if (characteristics.length > 0) {
            cs = EnumSet.noneOf(Collector.Characteristics.class);
            Collections.addAll(cs, characteristics);
            cs = Collections.unmodifiableSet(cs);
        }
        return new SimpleRemoteCollector<T, A, R>(supplier, accumulator, combiner, finisher, cs);
    }

    public static <T, A, R> RemoteCollector<T, A, R> of(Remote.Supplier<A> supplier, Remote.BiConsumer<A, T> accumulator, Remote.BinaryOperator<A> combiner, Remote.Function<A, R> finisher, Collector.Characteristics ... characteristics) {
        return RemoteCollector.of(supplier, accumulator, combiner, finisher, characteristics);
    }
}

