/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.internal.net.WrapperServerSocket;
import com.oracle.coherence.common.internal.net.WrapperSocket;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.InetSocketProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class DemultiplexedSocketProvider
extends InetSocketProvider {
    protected final MultiplexedSocketProvider m_delegate;
    protected final int m_nSubport;

    public DemultiplexedSocketProvider(MultiplexedSocketProvider delegate, int subport) {
        if (subport == 0 || subport < -1 || subport > 65535) {
            throw new IllegalArgumentException("Illegal subport: " + subport);
        }
        this.m_nSubport = subport;
        this.m_delegate = delegate;
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new DemultiplexedServerSocketChannel(this.m_delegate);
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return this.openServerSocketChannel().socket();
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new DemultiplexedSocketChannel(this.m_delegate);
    }

    @Override
    public Socket openSocket() throws IOException {
        return new DemultiplexedSocket((MultiplexedSocketProvider.MultiplexedSocket)this.m_delegate.openSocket());
    }

    public String toString() {
        return "DemultiplexedSocketProvider(" + this.m_delegate + ")";
    }

    @Override
    public MultiplexedSocketProvider getDelegate() {
        return this.m_delegate;
    }

    protected InetSocketAddress32 getMultiplexedSocketAddress(SocketAddress address) {
        if (address == null) {
            return null;
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddr = (InetSocketAddress)address;
            return new InetSocketAddress32(inetAddr.getAddress(), MultiplexedSocketProvider.getPort(inetAddr.getPort(), this.m_nSubport));
        }
        throw new IllegalArgumentException("Invalid socket address type: " + address);
    }

    protected class DemultiplexedSocket
    extends WrapperSocket {
        protected SocketAddress m_addressLocal;
        protected SocketAddress m_addressRemote;

        public DemultiplexedSocket(MultiplexedSocketProvider.MultiplexedSocket delegate) {
            super(delegate);
        }

        @Override
        public void bind(SocketAddress addr) throws IOException {
            super.bind(DemultiplexedSocketProvider.this.getMultiplexedSocketAddress(addr));
            this.m_addressLocal = addr;
        }

        @Override
        public void connect(SocketAddress addr) throws IOException {
            this.connect(addr, 0);
        }

        @Override
        public void connect(SocketAddress addr, int cMillis) throws IOException {
            super.connect(DemultiplexedSocketProvider.this.getMultiplexedSocketAddress(addr), cMillis);
            this.m_addressRemote = addr;
        }

        @Override
        public int getLocalPort() {
            return MultiplexedSocketProvider.getBasePort(super.getLocalPort());
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            SocketAddress addrLocal = this.m_addressLocal;
            if (addrLocal == null) {
                addrLocal = this.m_addressLocal = MultiplexedSocketProvider.getTransportAddress((InetSocketAddress32)super.getLocalSocketAddress());
            }
            return addrLocal;
        }

        @Override
        public int getPort() {
            return MultiplexedSocketProvider.getBasePort(super.getPort());
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            SocketAddress addrRemote = this.m_addressRemote;
            if (addrRemote == null) {
                addrRemote = this.m_addressRemote = MultiplexedSocketProvider.getTransportAddress((InetSocketAddress32)super.getRemoteSocketAddress());
            }
            return addrRemote;
        }
    }

    protected class DemultiplexedSocketChannel
    extends MultiplexedSocketProvider.MultiplexedSocketChannel {
        public DemultiplexedSocketChannel(MultiplexedSocketProvider.MultiplexedSocketChannel delegate) {
            super(delegate.delegate(), delegate.m_addrLocal, delegate.m_bufHeaderIn);
            if (delegate.getClass() != MultiplexedSocketProvider.MultiplexedSocketChannel.class) {
                throw new IllegalArgumentException("DemultiplexedSocketChannel can only work with MultiplexedSocketChannel");
            }
        }

        public DemultiplexedSocketChannel(MultiplexedSocketProvider provider) throws IOException {
            super(provider.getDependencies().getDelegateProvider().openSocketChannel(), null, null);
        }

        @Override
        public boolean connect(SocketAddress remote) throws IOException {
            return super.connect(DemultiplexedSocketProvider.this.getMultiplexedSocketAddress(remote));
        }

        @Override
        protected Socket wrapSocket(Socket socket) {
            return new DemultiplexedSocket((MultiplexedSocketProvider.MultiplexedSocket)super.wrapSocket(socket)){

                @Override
                public SocketChannel getChannel() {
                    return DemultiplexedSocketChannel.this;
                }
            };
        }
    }

    protected class DemultiplexedServerSocketChannel
    extends MultiplexedSocketProvider.MultiplexedServerSocketChannel {
        public DemultiplexedServerSocketChannel(MultiplexedSocketProvider provider) throws IOException {
            super(provider);
        }

        @Override
        public SocketChannel accept() throws IOException {
            MultiplexedSocketProvider.MultiplexedSocketChannel channel = (MultiplexedSocketProvider.MultiplexedSocketChannel)super.accept();
            return channel == null ? channel : new DemultiplexedSocketChannel(channel);
        }

        @Override
        protected ServerSocket createServerSocket() throws IOException {
            return new WrapperServerSocket(super.createServerSocket()){
                protected SocketAddress m_address;

                @Override
                public ServerSocketChannel getChannel() {
                    return DemultiplexedServerSocketChannel.this;
                }

                @Override
                public void bind(SocketAddress endpoint) throws IOException {
                    this.bind(endpoint, 0);
                }

                @Override
                public void bind(SocketAddress endpoint, int backlog) throws IOException {
                    super.bind(DemultiplexedSocketProvider.this.getMultiplexedSocketAddress(endpoint), backlog);
                    this.m_address = endpoint;
                }

                @Override
                public int getLocalPort() {
                    return MultiplexedSocketProvider.getBasePort(super.getLocalPort());
                }

                @Override
                public SocketAddress getLocalSocketAddress() {
                    SocketAddress addr = this.m_address;
                    if (addr == null) {
                        addr = this.m_address = MultiplexedSocketProvider.getTransportAddress((InetSocketAddress32)super.getLocalSocketAddress());
                    }
                    return addr;
                }
            };
        }

        @Override
        protected ServerSocketChannel getChannel() {
            return this;
        }
    }
}

