/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.util.ConverterCollections;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WrapperSelector
extends AbstractSelector {
    private static final Method METHOD_REMOVE_KEY;
    protected final Selector m_delegate;
    protected final Set m_setKeys;
    protected final Set m_setSelectedKeys;
    protected final ReadWriteLock f_lockSelector = new ReentrantReadWriteLock();
    protected final Lock f_lockRead = this.f_lockSelector.readLock();
    protected final Lock f_lockWrite = this.f_lockSelector.writeLock();

    public WrapperSelector(Selector selector, SelectorProvider provider) throws IOException {
        super(provider);
        this.m_delegate = selector;
        this.m_setKeys = new KeySet(selector.keys());
        this.m_setSelectedKeys = new KeySet(selector.selectedKeys());
    }

    public Selector getDelegate() {
        return this.m_delegate;
    }

    public static Selector open() {
        throw new UnsupportedOperationException();
    }

    public Set keys() {
        return this.m_setKeys;
    }

    public Set selectedKeys() {
        return this.m_setSelectedKeys;
    }

    @Override
    public int select() throws IOException {
        return this.select(0L);
    }

    @Override
    public int selectNow() throws IOException {
        return this.select(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long timeout) throws IOException {
        WrapperSelector wrapperSelector = this;
        synchronized (wrapperSelector) {
            Set set = this.m_setKeys;
            synchronized (set) {
                Set set2 = this.m_setSelectedKeys;
                synchronized (set2) {
                    int n;
                    try {
                        n = timeout > 0L ? Blocking.select(this.m_delegate, timeout) : (timeout == 0L ? Blocking.select(this.m_delegate) : this.m_delegate.selectNow());
                    }
                    catch (Throwable throwable) {
                        this.cleanupCancelledKeys();
                        throw throwable;
                    }
                    this.cleanupCancelledKeys();
                    return n;
                }
            }
        }
    }

    @Override
    public Selector wakeup() {
        this.m_delegate.wakeup();
        return this;
    }

    @Override
    protected void implCloseSelector() throws IOException {
        this.f_lockWrite.lock();
        try {
            this.m_delegate.close();
        }
        finally {
            this.f_lockWrite.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        this.f_lockRead.lock();
        try {
            WrapperSelectionKey wrapperSelectionKey = ((WrapperSelectableChannel)((Object)ch)).registerInternal(this, ops, att);
            return wrapperSelectionKey;
        }
        catch (IOException e) {
            WrapperSelectionKey wrapperSelectionKey = new WrapperSelectionKey(this, null, att){

                @Override
                public SelectableChannel channel() {
                    throw new CancelledKeyException();
                }

                @Override
                public boolean isValid() {
                    return false;
                }

                @Override
                public void cancel() {
                }

                @Override
                public int interestOps() {
                    throw new CancelledKeyException();
                }

                @Override
                public SelectionKey interestOps(int ops) {
                    throw new CancelledKeyException();
                }

                @Override
                public int readyOps() {
                    throw new CancelledKeyException();
                }
            };
            return wrapperSelectionKey;
        }
        finally {
            this.f_lockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupCancelledKeys() throws IOException {
        Set<SelectionKey> setCanceled = this.cancelledKeys();
        SelectionKey[] aKey = null;
        Set<SelectionKey> set = setCanceled;
        synchronized (set) {
            if (!setCanceled.isEmpty()) {
                this.m_delegate.selectNow();
                aKey = setCanceled.toArray(new SelectionKey[setCanceled.size()]);
                setCanceled.clear();
            }
        }
        if (aKey != null && METHOD_REMOVE_KEY != null) {
            for (Set<SelectionKey> set2 : aKey) {
                SelectableChannel chan = ((SelectionKey)((Object)set2)).channel();
                if (!(chan instanceof AbstractSelectableChannel)) continue;
                try {
                    METHOD_REMOVE_KEY.invoke((Object)chan, set2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static {
        Method metRemove = null;
        try {
            if (System.getProperty("java.vm.specification.version").startsWith("1.")) {
                metRemove = AccessController.doPrivileged(() -> {
                    try {
                        Method met = AbstractSelectableChannel.class.getDeclaredMethod("removeKey", SelectionKey.class);
                        met.setAccessible(true);
                        return met;
                    }
                    catch (Throwable e) {
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        METHOD_REMOVE_KEY = metRemove;
    }

    public class KeySet
    extends ConverterCollections.ConverterSet {
        protected KeySet(Set setBack) {
            super(setBack, key -> ((SelectionKey)key).attachment(), key -> ((WrapperSelectionKey)key).m_delegate);
        }
    }

    public static abstract class WrapperSelectionKey
    extends SelectionKey {
        protected WrapperSelector m_selector;
        protected final SelectionKey m_delegate;

        public WrapperSelectionKey(WrapperSelector selector, SelectionKey key, Object att) {
            this.m_selector = selector;
            this.m_delegate = key;
            this.attach(att);
            if (key != null) {
                key.attach(this);
            }
        }

        @Override
        public abstract SelectableChannel channel();

        @Override
        public Selector selector() {
            return this.m_selector;
        }

        @Override
        public boolean isValid() {
            return this.m_delegate.isValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Set setCancel;
            Set set = setCancel = this.m_selector.cancelledKeys();
            synchronized (set) {
                this.m_delegate.cancel();
                setCancel.add(this);
            }
        }

        @Override
        public int interestOps() {
            return this.m_delegate.interestOps();
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.m_delegate.interestOps(ops);
            return this;
        }

        @Override
        public int readyOps() {
            return this.m_delegate.readyOps();
        }

        protected String getKeyString(SelectionKey key) {
            return key.isValid() ? "interest=" + key.interestOps() + ", ready=" + key.readyOps() : "cancelled";
        }

        public String toString() {
            return this.getKeyString(this);
        }
    }

    public static interface WrapperSelectableChannel {
        public WrapperSelectionKey registerInternal(WrapperSelector var1, int var2, Object var3) throws IOException;
    }
}

