/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.socketbus;

import com.oracle.coherence.common.internal.net.socketbus.SharedBuffer;
import com.oracle.coherence.common.internal.net.socketbus.SocketMessageBus;
import com.oracle.coherence.common.io.SingleBufferSequence;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;

public class SingleBufferMessageEvent
extends SingleBufferSequence
implements Event {
    protected SocketMessageBus.MessageConnection m_src;
    protected final SharedBuffer m_bufferShared;

    public SingleBufferMessageEvent(SocketMessageBus.MessageConnection src, SharedBuffer buffer) {
        super(null, buffer.get().slice());
        this.m_src = src;
        this.m_bufferShared = buffer;
    }

    public SingleBufferMessageEvent(SocketMessageBus.MessageConnection src, SharedBuffer buffer, int nPos, int cb) {
        super(null, buffer.get(), nPos, cb);
        this.m_src = src;
        this.m_bufferShared = buffer;
    }

    @Override
    public Event.Type getType() {
        return Event.Type.MESSAGE;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.m_src == null ? null : this.m_src.getPeer();
    }

    @Override
    public Object getContent() {
        return this;
    }

    @Override
    public Object dispose(boolean fTakeContent) {
        SocketMessageBus.MessageConnection src = this.m_src;
        this.m_src = null;
        if (fTakeContent) {
            src.onMessageDispose(this);
            return this;
        }
        if (src != null) {
            src.onMessageDispose(this);
        }
        this.m_bufferShared.dispose();
        this.m_buffer = null;
        return null;
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getType()) + " event for " + this.getEndPoint() + " containing " + this.getLength() + " bytes";
    }
}

