/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.ssl;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.internal.net.WrapperSocket;
import com.oracle.coherence.common.net.SSLSocketProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

public class SSLSocket
extends WrapperSocket {
    protected final SSLSocketProvider m_provider;

    public SSLSocket(Socket socket, SSLSocketProvider provider) throws IOException {
        super(socket);
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.m_provider = provider;
        if (socket.isConnected()) {
            this.m_delegate = this.wrapSocket(socket, false);
        }
    }

    @Override
    public synchronized void connect(SocketAddress addr, int cMillis) throws IOException {
        Socket delegate = this.m_delegate;
        int cMillisRestore = delegate.getSoTimeout();
        try (Timeout t = Timeout.after(cMillis == 0 ? Long.MAX_VALUE : (long)cMillis);){
            Blocking.connect(delegate, addr);
            long cMillisRemaining = Timeout.remainingTimeoutMillis();
            delegate.setSoTimeout(cMillisRemaining >= Integer.MAX_VALUE ? 0 : (int)cMillisRemaining);
            this.m_delegate = this.wrapSocket(delegate, true);
        }
        catch (InterruptedException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
        finally {
            if (!delegate.isClosed()) {
                try {
                    delegate.setSoTimeout(cMillisRestore);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String toString() {
        return "SSLSocket{" + this.m_delegate + "}";
    }

    public javax.net.ssl.SSLSocket wrapSocket(Socket delegate, boolean fClientMode) throws IOException {
        try {
            String[] asProtocols;
            String[] asCiphers;
            SSLSocketProvider provider = this.m_provider;
            SSLSocketProvider.Dependencies deps = provider.getDependencies();
            InetAddress addrConnected = delegate.getInetAddress();
            javax.net.ssl.SSLSocket sslDelegate = (javax.net.ssl.SSLSocket)deps.getSSLContext().getSocketFactory().createSocket(delegate, addrConnected.getHostName(), delegate.getPort(), true);
            sslDelegate.setUseClientMode(fClientMode);
            if (!fClientMode) {
                switch (deps.getClientAuth()) {
                    case wanted: {
                        sslDelegate.setNeedClientAuth(false);
                        sslDelegate.setWantClientAuth(true);
                        break;
                    }
                    case required: {
                        sslDelegate.setWantClientAuth(true);
                        sslDelegate.setNeedClientAuth(true);
                        break;
                    }
                    default: {
                        sslDelegate.setWantClientAuth(false);
                        sslDelegate.setNeedClientAuth(false);
                    }
                }
            }
            if ((asCiphers = deps.getEnabledCipherSuites()) != null) {
                sslDelegate.setEnabledCipherSuites(asCiphers);
            }
            if ((asProtocols = deps.getEnabledProtocolVersions()) != null) {
                sslDelegate.setEnabledProtocols(asProtocols);
            }
            provider.ensureSessionValidity(sslDelegate.getSession(), delegate);
            return sslDelegate;
        }
        catch (Exception e) {
            try {
                delegate.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

