/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.internal.util.Histogram;

public class ScaledHistogram
extends Histogram {
    protected final int f_cHighRes;
    public static final double LOG10 = Math.log(10.0);
    protected static final double STRETCH = 10.0;

    public ScaledHistogram() {
        this(1000000);
    }

    public ScaledHistogram(int cMax) {
        this(cMax, 100);
    }

    public ScaledHistogram(int cMax, int cHighRes) {
        super(ScaledHistogram.computeSlot(cHighRes, cMax));
        this.f_cHighRes = cHighRes;
    }

    @Override
    public int getIndex(int nValue) {
        return ScaledHistogram.computeSlot(this.f_cHighRes, nValue);
    }

    @Override
    public int getLabelMin(int nSlot) {
        return nSlot <= this.f_cHighRes ? nSlot : this.f_cHighRes + (int)Math.ceil(Math.pow(10.0, (double)(nSlot - this.f_cHighRes) / 10.0));
    }

    protected static int computeSlot(int cHigh, int nValue) {
        return nValue <= cHigh ? nValue : cHigh + (int)(Math.log(nValue - cHigh) / LOG10 * 10.0);
    }
}

