/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.internal.util.TaskQueue;
import com.oracle.coherence.common.internal.util.Timer;
import com.oracle.coherence.common.internal.util.TimerTask;
import com.oracle.coherence.common.util.SafeClock;
import java.util.logging.Level;
import java.util.logging.Logger;

class TimerThread
extends Thread {
    boolean newTasksMayBeScheduled = true;
    private TaskQueue queue;

    TimerThread(TaskQueue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mainLoop();
        }
        finally {
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                this.newTasksMayBeScheduled = false;
                this.queue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        while (true) {
            TimerTask task = null;
            try {
                boolean taskFired;
                TaskQueue taskQueue = this.queue;
                synchronized (taskQueue) {
                    long currentTime;
                    long executionTime;
                    while (this.queue.isEmpty() && this.newTasksMayBeScheduled) {
                        Blocking.wait(this.queue);
                    }
                    if (this.queue.isEmpty()) {
                        break;
                    }
                    task = this.queue.getMin();
                    Object object = task.lock;
                    synchronized (object) {
                        if (task.state == 3) {
                            this.queue.removeMin();
                            continue;
                        }
                        executionTime = task.nextExecutionTime;
                        currentTime = SafeClock.INSTANCE.getSafeTimeMillis();
                        taskFired = executionTime <= currentTime;
                        if (taskFired) {
                            if (task.period == 0L) {
                                this.queue.removeMin();
                                task.state = 2;
                            } else {
                                this.queue.rescheduleMin(task.period < 0L ? currentTime - task.period : executionTime + task.period);
                            }
                        }
                    }
                    if (!taskFired) {
                        Blocking.wait(this.queue, executionTime - currentTime);
                    }
                }
                if (!taskFired) continue;
                task.run();
            }
            catch (InterruptedException taskFired) {
            }
            catch (Throwable e) {
                Logger.getLogger(Timer.class.getName()).log(Level.WARNING, "Ignoring unhandled exception from the timer task " + task, e);
            }
        }
    }
}

