/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.internal.io.AbstractBufferManager;
import com.oracle.coherence.common.internal.io.CheckedBufferManager;
import com.oracle.coherence.common.internal.io.SegmentedBufferManager;
import com.oracle.coherence.common.internal.io.SlabBufferManager;
import com.oracle.coherence.common.internal.io.WrapperBufferManager;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.util.MemorySize;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BufferManagers {
    private static final long DEFAULT_POOL_SIZE = Math.min(Runtime.getRuntime().totalMemory() / 4L, Runtime.getRuntime().maxMemory() / 20L);
    private static final Logger LOGGER = Logger.getLogger(BufferManagers.class.getName());
    public static final boolean ZERO_ON_RELEASE = Boolean.getBoolean(BufferManagers.class.getName() + ".zeroed");

    public static BufferManager getHeapManager() {
        return HeapManagerHolder.INSTANCE;
    }

    public static BufferManager getDirectManager() {
        return DirectManagerHolder.INSTANCE;
    }

    public static BufferManager getNetworkDirectManager() {
        return NetworkDirectManagerHolder.INSTANCE;
    }

    private static class NonDisposableBufferManager
    extends WrapperBufferManager {
        public NonDisposableBufferManager(BufferManager delegate) {
            super(delegate);
        }

        @Override
        public void dispose() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NetworkDirectManagerHolder {
        public static final BufferManager INSTANCE = DirectManagerHolder.INSTANCE;

        private NetworkDirectManagerHolder() {
        }
    }

    private static class DirectManagerHolder {
        public static final BufferManager INSTANCE;

        private DirectManagerHolder() {
        }

        static {
            BufferManager mgr;
            long lcbPool = new MemorySize(System.getProperty(BufferManagers.class.getName() + ".direct.pool", System.getProperty(BufferManagers.class.getName() + ".pool", Long.toString(DEFAULT_POOL_SIZE)))).getByteCount();
            int cbBuf = (int)new MemorySize(System.getProperty(BufferManagers.class.getName() + ".direct.base", System.getProperty(BufferManagers.class.getName() + ".base", Long.toString(1024L)))).getByteCount();
            if (lcbPool > 0L) {
                SlabBufferManager mgrSlab = new SlabBufferManager(new SlabBufferManager.DirectBufferAllocator(), cbBuf, lcbPool);
                mgrSlab.setName("DirectBufferManager");
                mgr = mgrSlab;
            } else {
                mgr = new AbstractBufferManager(){

                    @Override
                    public ByteBuffer acquire(int cb) {
                        return ByteBuffer.allocateDirect(cb);
                    }

                    @Override
                    public void dispose() {
                    }

                    @Override
                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (!buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
            }
            mgr = new NonDisposableBufferManager(mgr);
            LOGGER.log(Level.FINE, "initialized DirectBufferManager " + mgr);
            INSTANCE = Boolean.valueOf(System.getProperty(BufferManagers.class.getName() + ".direct.checked", System.getProperty(BufferManagers.class.getName() + ".checked"))) != false ? new CheckedBufferManager(mgr) : mgr;
        }
    }

    private static class HeapManagerHolder {
        public static final BufferManager INSTANCE;

        private HeapManagerHolder() {
        }

        static {
            BufferManager mgr;
            String sHeap = System.getProperty(BufferManagers.class.getName() + ".heap.pool", System.getProperty(BufferManagers.class.getName() + ".pool", Long.toString(DEFAULT_POOL_SIZE)));
            int cbBuf = (int)new MemorySize(System.getProperty(BufferManagers.class.getName() + ".heap.base", System.getProperty(BufferManagers.class.getName() + ".base", Long.toString(1024L)))).getByteCount();
            if (sHeap.startsWith("-")) {
                throw new IllegalStateException("Negative heap pool size");
            }
            long lcbPool = new MemorySize(sHeap).getByteCount();
            if (lcbPool > 0L) {
                SegmentedBufferManager mgrSeg = new SegmentedBufferManager(new SegmentedBufferManager.BufferAllocator(){

                    @Override
                    public ByteBuffer allocate(int cb) {
                        return ByteBuffer.allocate(cb);
                    }

                    @Override
                    public void release(ByteBuffer buff) {
                        if (buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }

                    public String toString() {
                        return "HeapBufferAllocator";
                    }
                }, cbBuf, lcbPool);
                mgrSeg.setName("HeapBufferManager");
                mgr = mgrSeg;
            } else {
                mgr = new AbstractBufferManager(){

                    @Override
                    public ByteBuffer acquire(int cb) {
                        return ByteBuffer.allocate(cb);
                    }

                    @Override
                    public void dispose() {
                    }

                    @Override
                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
            }
            mgr = new NonDisposableBufferManager(mgr);
            LOGGER.log(Level.FINE, "initialized HeapBufferManager " + mgr);
            INSTANCE = Boolean.valueOf(System.getProperty(BufferManagers.class.getName() + ".heap.checked", System.getProperty(BufferManagers.class.getName() + ".checked"))) != false ? new CheckedBufferManager(mgr) : mgr;
        }
    }
}

