/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class SingleBufferSequence
extends AtomicInteger
implements BufferSequence {
    protected final BufferManager f_manager;
    protected ByteBuffer m_buffer;
    protected final int f_nPosition;
    protected final int f_nLimit;
    protected IOException m_stackDispose;
    private static final boolean TRACK_DISPOSE = Boolean.getBoolean(BufferSequence.class.getName() + ".trackDispose");

    public SingleBufferSequence(BufferManager manager, ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        this.f_manager = manager;
        this.m_buffer = buffer;
        this.f_nPosition = buffer.position();
        this.f_nLimit = buffer.limit();
    }

    public SingleBufferSequence(BufferManager manager, ByteBuffer buffer, int nPos, int cb) {
        super(1);
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (nPos < 0 || cb < 0 || nPos + cb > buffer.capacity()) {
            throw new IllegalArgumentException("specified position and length exceed buffer capacity");
        }
        this.f_manager = manager;
        this.m_buffer = buffer;
        this.f_nPosition = nPos;
        this.f_nLimit = nPos + cb;
    }

    @Override
    public long getLength() {
        return this.f_nLimit - this.f_nPosition;
    }

    @Override
    public int getBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        if (iBuffer == 0) {
            return this.getSafeBuffer();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuffer getUnsafeBuffer(int iBuffer) {
        if (iBuffer == 0) {
            return this.m_buffer;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferPosition(int iBuffer) {
        if (iBuffer == 0) {
            return this.f_nPosition;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferLimit(int iBuffer) {
        if (iBuffer == 0) {
            return this.f_nLimit;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferLength(int iBuffer) {
        if (iBuffer == 0) {
            return this.f_nLimit - this.f_nPosition;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return new ByteBuffer[]{this.getSafeBuffer()};
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        if (iBuffer != 0 || cBuffers > 1) {
            throw new IndexOutOfBoundsException();
        }
        if (cBuffers == 1) {
            abufDest[iDest] = this.getSafeBuffer();
        }
    }

    @Override
    public void dispose() {
        ByteBuffer buff = this.m_buffer;
        if (buff == null) {
            throw new IllegalStateException("already disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if (TRACK_DISPOSE) {
            this.m_stackDispose = new IOException("disposed at");
        }
        this.m_buffer = null;
        BufferManager manager = this.f_manager;
        if (manager != null) {
            manager.release(buff);
        }
    }

    @Override
    public String toString() {
        return Buffers.toString(this);
    }

    public boolean isDisposed() {
        return this.m_buffer == null;
    }

    protected final ByteBuffer getSafeBuffer() {
        ByteBuffer buff = this.m_buffer;
        if (buff == null) {
            throw new IllegalStateException("disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if (this.compareAndSet(0, 1)) {
            return buff;
        }
        buff = buff.duplicate();
        buff.limit(this.f_nLimit).position(this.f_nPosition);
        return buff;
    }
}

