/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetSocketProvider;
import com.oracle.coherence.common.net.SocketProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SdpSocketProvider
extends InetSocketProvider {
    public static final SdpSocketProvider INSTANCE = new SdpSocketProvider();
    public static final MultiplexedSocketProvider MULTIPLEXED = new MultiplexedSocketProvider(new MultiplexedSocketProvider.DefaultDependencies().setDelegateProvider(INSTANCE)){

        @Override
        public SocketAddress resolveAddress(String sAddr) {
            try {
                SdpSocketProvider.verifySDP();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return super.resolveAddress(sAddr);
        }
    };
    protected static final Method METHOD_OPEN_SERVER_CHANNEL;
    protected static final Method METHOD_OPEN_SERVER;
    protected static final Method METHOD_OPEN_CLIENT_CHANNEL;
    protected static final Method METHOD_OPEN_CLIENT;

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        try {
            return (ServerSocketChannel)METHOD_OPEN_SERVER_CHANNEL.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            SdpSocketProvider.verifySDP();
            throw SdpSocketProvider.ensureIOException(e);
        }
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        try {
            return (ServerSocket)METHOD_OPEN_SERVER.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            SdpSocketProvider.verifySDP();
            throw SdpSocketProvider.ensureIOException(e);
        }
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        try {
            return (SocketChannel)METHOD_OPEN_CLIENT_CHANNEL.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            SdpSocketProvider.verifySDP();
            throw SdpSocketProvider.ensureIOException(e);
        }
    }

    @Override
    public Socket openSocket() throws IOException {
        try {
            return (Socket)METHOD_OPEN_CLIENT.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            SdpSocketProvider.verifySDP();
            throw SdpSocketProvider.ensureIOException(e);
        }
    }

    @Override
    public SocketAddress resolveAddress(String sAddr) {
        try {
            SdpSocketProvider.verifySDP();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return super.resolveAddress(sAddr);
    }

    @Override
    public SocketProvider getDelegate() {
        return null;
    }

    public static void verifySDP() throws IOException {
        if (METHOD_OPEN_SERVER_CHANNEL == null) {
            throw new IOException("SDP classes are unavailable");
        }
        if (!Boolean.getBoolean("java.net.preferIPv4Stack")) {
            throw new IOException("SDP requires the java.net.preferIPv4Stack system property be set to true");
        }
    }

    public static IOException ensureIOException(Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        if (e.getCause() instanceof IOException) {
            return (IOException)e.getCause();
        }
        return new IOException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method metServerChan = null;
        Method metServer = null;
        Method metClientChan = null;
        Method metClient = null;
        try {
            Class<?> clz = Class.forName("com.oracle.net.Sdp");
            metServerChan = clz.getMethod("openServerSocketChannel", new Class[0]);
            metServer = clz.getMethod("openServerSocket", new Class[0]);
            metClientChan = clz.getMethod("openSocketChannel", new Class[0]);
            metClient = clz.getMethod("openSocket", new Class[0]);
        }
        catch (Throwable throwable) {
        }
        finally {
            METHOD_OPEN_SERVER_CHANNEL = metServerChan;
            METHOD_OPEN_SERVER = metServer;
            METHOD_OPEN_CLIENT_CHANNEL = metClientChan;
            METHOD_OPEN_CLIENT = metClient;
        }
    }
}

