/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net.exabus.util;

import com.oracle.coherence.common.base.Pollable;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.util.AbstractPollingEventCollector;
import com.oracle.coherence.common.net.exabus.util.PollingEventCollector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueueingEventCollector
extends AbstractPollingEventCollector
implements Pollable<Event> {
    protected final BlockingQueue<Event> f_queue = new LinkedBlockingQueue<Event>();

    @Override
    public Event poll(long timeout, TimeUnit unit) throws InterruptedException {
        PollingEventCollector.BusProcessor processor = this.m_busProcessor;
        if (processor == null) {
            return this.f_queue.poll(timeout, unit);
        }
        Event event = (Event)this.f_queue.poll();
        if (event == null) {
            processor.poll(timeout, unit);
            event = (Event)this.f_queue.poll();
        }
        return event;
    }

    @Override
    public Event poll() {
        Event event = (Event)this.f_queue.poll();
        PollingEventCollector.BusProcessor processor = this.m_busProcessor;
        if (processor == null) {
            return event;
        }
        if (event == null) {
            try {
                processor.poll(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            event = (Event)this.f_queue.poll();
        }
        return event;
    }

    @Override
    public void add(Event event) {
        this.f_queue.add(event);
    }

    @Override
    public void flush() {
        PollingEventCollector.BusProcessor processor = this.m_busProcessor;
        if (processor != null) {
            processor.cancel();
        }
    }
}

