/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

public final class CommonMonitor {
    private static final CommonMonitor[] MONITORS;
    protected int m_nonvolatile;
    protected volatile int m_barrier;

    public final void writeBarrier() {
        int n;
        this.m_barrier = (n = ++this.m_nonvolatile) == -1 ? 0 : n;
    }

    public final void readBarrier() {
        if (this.m_barrier == -1) {
            throw new IllegalStateException();
        }
    }

    public static CommonMonitor getCommonMonitor(int i) {
        CommonMonitor[] aMonitors = MONITORS;
        return aMonitors[(i & Integer.MAX_VALUE) % aMonitors.length];
    }

    public static CommonMonitor getCommonMonitor(long l) {
        CommonMonitor[] aMonitors = MONITORS;
        return aMonitors[(int)((l & Long.MAX_VALUE) % (long)aMonitors.length)];
    }

    public static CommonMonitor getCommonMonitor(Object o) {
        return CommonMonitor.getCommonMonitor(System.identityHashCode(o));
    }

    static {
        String sMonitors = System.getProperty(CommonMonitor.class.getName() + ".monitors");
        int cMonitors = Runtime.getRuntime().availableProcessors() * 512;
        if (sMonitors != null) {
            int c = Integer.parseInt(sMonitors);
            if (c < cMonitors / 8) {
                System.err.println("The specified number of " + c + " common monitors is significantly lower then the recommended " + cMonitors + " and may result in performance degradation.");
            }
            cMonitors = c;
        }
        MONITORS = new CommonMonitor[cMonitors];
        for (int i = 0; i < cMonitors; ++i) {
            CommonMonitor.MONITORS[i] = new CommonMonitor();
        }
    }
}

