/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.stream.Collectors;

public class Options<T> {
    private LinkedHashMap<Class<? extends T>, T> m_mapOptions = new LinkedHashMap();
    private Class<T> m_clsType;
    private static final Options EMPTY = new EmptyOptions();

    private Options(Class<T> clsType) {
        this.m_clsType = clsType;
    }

    private Options(Class<T> clsType, T[] aOptions) {
        this.m_clsType = clsType;
        this.addAll(aOptions);
    }

    public <U extends T> U get(Class<U> clzOption) {
        return this.get(clzOption, this.getDefaultFor(clzOption));
    }

    public <U extends T> U get(Class<U> clzOption, U optDefault) {
        if (clzOption == null) {
            return null;
        }
        T option = this.m_mapOptions.get(clzOption);
        if (option == null) {
            return optDefault;
        }
        return (U)option;
    }

    public <O extends T> boolean contains(Class<O> clzOption) {
        return this.get(clzOption) != null;
    }

    public boolean contains(T option) {
        if (option == null) {
            return false;
        }
        Class<T> clzOption = this.getClassOf(option);
        T value = this.get(clzOption);
        return value != null && value.equals(option);
    }

    public <O> Iterable<O> getInstancesOf(Class<O> clz) {
        return this.m_mapOptions.values().stream().filter(clz::isInstance).map(value -> value).collect(Collectors.toCollection(LinkedList::new));
    }

    public T[] asArray() {
        Object[] aOptions = new Object[this.m_mapOptions.size()];
        int i = 0;
        for (T option : this.m_mapOptions.values()) {
            aOptions[i++] = option;
        }
        return aOptions;
    }

    public String toString() {
        StringBuilder bldrResult = new StringBuilder();
        bldrResult.append("Options{");
        boolean fFirst = true;
        for (T option : this.m_mapOptions.values()) {
            if (fFirst) {
                fFirst = false;
            } else {
                bldrResult.append(", ");
            }
            bldrResult.append(option);
        }
        bldrResult.append("}");
        return bldrResult.toString();
    }

    @SafeVarargs
    public static <T> Options<T> from(Class<T> clsType, T ... aOptions) {
        return aOptions == null || aOptions.length == 0 ? Options.empty() : new Options<T>(clsType, aOptions);
    }

    public static <T> Options<T> empty() {
        return EMPTY;
    }

    private Options<T> add(T option) {
        Class<T> clz = this.getClassOf(option);
        this.m_mapOptions.put(clz, option);
        return this;
    }

    private Options<T> addAll(T[] aOptions) {
        if (aOptions != null) {
            for (T option : aOptions) {
                this.add(option);
            }
        }
        return this;
    }

    private Options<T> addAll(Options<? extends T> options) {
        for (T option : options.asArray()) {
            this.add(option);
        }
        return this;
    }

    private Class<T> getClassOf(T option) {
        return option == null ? null : this.getClassOf(option.getClass());
    }

    private <O extends T> Class<O> getClassOf(Class<?> classOfOption) {
        if (this.m_clsType.equals(classOfOption)) {
            return classOfOption;
        }
        Stack hierarchy = new Stack();
        while (classOfOption != null) {
            hierarchy.push(classOfOption);
            for (Class<?> interfaceClass : classOfOption.getInterfaces()) {
                if (this.m_clsType.equals(interfaceClass)) {
                    while (classOfOption != null && Modifier.isAbstract(classOfOption.getModifiers()) && !classOfOption.isInterface()) {
                        classOfOption = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                    }
                    return classOfOption == null ? null : (classOfOption.isSynthetic() ? interfaceClass : classOfOption);
                }
                if (!this.m_clsType.isAssignableFrom(interfaceClass)) continue;
                while (classOfOption != null && Modifier.isAbstract(classOfOption.getModifiers()) && !classOfOption.isInterface()) {
                    classOfOption = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                }
                if (classOfOption == null) {
                    return null;
                }
                return interfaceClass;
            }
            classOfOption = classOfOption.getSuperclass();
        }
        return null;
    }

    protected <U extends T> U getDefaultFor(Class<U> clzOption) {
        int modifiers;
        if (clzOption == null) {
            return null;
        }
        for (Method method : clzOption.getMethods()) {
            modifiers = method.getModifiers();
            if (method.getAnnotation(Default.class) == null || method.getParameterCount() != 0 || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !clzOption.isAssignableFrom(method.getReturnType())) continue;
            try {
                return (U)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : clzOption.getFields()) {
            modifiers = ((Field)accessibleObject).getModifiers();
            if (((Field)accessibleObject).getAnnotation(Default.class) == null || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !clzOption.isAssignableFrom(((Field)accessibleObject).getType())) continue;
            try {
                return (U)((Field)accessibleObject).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Constructor<U> constructor = clzOption.getConstructor(new Class[0]);
            int modifiers2 = constructor.getModifiers();
            if (constructor.getAnnotation(Default.class) != null && Modifier.isPublic(modifiers2)) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})
    public static @interface Default {
    }

    private static final class EmptyOptions<T>
    extends Options<T> {
        private static final Object[] EMPTY = new Object[0];

        public EmptyOptions() {
            super((Class)null);
        }

        @Override
        public <U extends T> U get(Class<U> clzOption) {
            return this.getDefaultFor(clzOption);
        }

        @Override
        public <U extends T> U get(Class<U> clzOption, U optDefault) {
            return optDefault;
        }

        @Override
        public <O extends T> boolean contains(Class<O> clzOption) {
            return false;
        }

        @Override
        public boolean contains(T option) {
            return false;
        }

        @Override
        public <O> Iterable<O> getInstancesOf(Class<O> clz) {
            return Collections.EMPTY_SET;
        }

        @Override
        public T[] asArray() {
            return EMPTY;
        }

        @Override
        public String toString() {
            return "EmptyOptions{}";
        }
    }
}

