/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.util.Duration;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Threads {
    private static final LockAnalysis DUMP_LOCKS;

    public static String getThreadDump() {
        return Threads.getThreadDump(DUMP_LOCKS);
    }

    public static String getThreadDump(boolean fLocks) {
        return Threads.getThreadDump(fLocks ? LockAnalysis.FULL : LockAnalysis.NONE);
    }

    public static String getThreadDump(LockAnalysis locks) {
        ThreadInfo[] ainfo;
        String sMsg;
        boolean fLocks;
        switch (locks) {
            case FULL: {
                fLocks = true;
                sMsg = "";
                break;
            }
            case OWNERSHIP: {
                fLocks = true;
                sMsg = "(excluding deadlock analysis)";
                break;
            }
            default: {
                fLocks = false;
                sMsg = "(excluding locks and deadlock analysis)";
            }
        }
        long ldtStart = System.currentTimeMillis();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        Set<Long> setDeadLocked = locks == LockAnalysis.FULL ? Threads.collectDeadlockedIds(bean) : null;
        StringBuilder sbAll = new StringBuilder("Full Thread Dump: ").append(sMsg);
        StringBuilder sbThreads = new StringBuilder();
        StringBuilder sbDeadlocks = new StringBuilder();
        StringBuilder sbTemp = new StringBuilder();
        for (ThreadInfo info : ainfo = bean.dumpAllThreads(fLocks && bean.isObjectMonitorUsageSupported(), fLocks && bean.isSynchronizerUsageSupported())) {
            boolean fDeadlocked = locks == LockAnalysis.FULL && setDeadLocked.contains(info.getThreadId());
            sbTemp.setLength(0);
            Threads.collectThreadHeader(info, sbTemp, fDeadlocked);
            Threads.collectStackTrace(info, sbTemp);
            Threads.collectLockedSyncs(info, sbTemp);
            sbThreads.append((CharSequence)sbTemp);
            if (!fDeadlocked) continue;
            sbDeadlocks.append((CharSequence)sbTemp);
        }
        long cMillis = System.currentTimeMillis() - ldtStart;
        if (cMillis > 1000L) {
            sbAll.append(" took ").append(new Duration(cMillis, Duration.Magnitude.MILLI));
        }
        sbAll.append("\n").append((CharSequence)sbThreads);
        if (locks == LockAnalysis.FULL && !setDeadLocked.isEmpty()) {
            sbAll.append("\n Found following deadlocked threads:\n");
            sbAll.append((CharSequence)sbDeadlocks);
        }
        return sbAll.toString();
    }

    protected static Set<Long> collectDeadlockedIds(ThreadMXBean bean) {
        ThreadInfo[] ainfo;
        long[] alThreadId;
        long[] lArray = alThreadId = bean.isSynchronizerUsageSupported() ? bean.findDeadlockedThreads() : bean.findMonitorDeadlockedThreads();
        if (alThreadId == null || alThreadId.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Long> setIds = new HashSet<Long>();
        for (ThreadInfo info : ainfo = bean.getThreadInfo(alThreadId, Integer.MAX_VALUE)) {
            if (info == null) continue;
            setIds.add(info.getThreadId());
        }
        return setIds;
    }

    protected static void collectThreadHeader(ThreadInfo infoThread, StringBuilder sbTrace, boolean fDeadlocked) {
        sbTrace.append("\n\"").append(infoThread.getThreadName()).append("\" id=").append(infoThread.getThreadId()).append(" State:").append(fDeadlocked ? "DEADLOCKED" : infoThread.getThreadState());
        if (infoThread.isSuspended()) {
            sbTrace.append(" (suspended)");
        }
        if (infoThread.isInNative()) {
            sbTrace.append(" (in native)");
        }
        sbTrace.append("\n");
    }

    protected static void collectLockedSyncs(ThreadInfo infoThread, StringBuilder sbTrace) {
        LockInfo[] aLock = infoThread.getLockedSynchronizers();
        if (aLock.length > 0) {
            sbTrace.append("\n\tLocked synchronizers:\n");
            for (LockInfo info : aLock) {
                sbTrace.append("\t").append(info).append("\n");
            }
        }
    }

    protected static void collectStackTrace(ThreadInfo infoThread, StringBuilder sbTrace) {
        StackTraceElement[] aStackElement = infoThread.getStackTrace();
        MonitorInfo[] aMonitor = infoThread.getLockedMonitors();
        LockInfo infoLock = infoThread.getLockInfo();
        int c = aStackElement.length;
        for (int iDepth = 0; iDepth < c; ++iDepth) {
            sbTrace.append("\tat ").append(aStackElement[iDepth]).append("\n");
            if (iDepth == 0 && infoLock != null) {
                String sOwner = infoThread.getLockOwnerName();
                sbTrace.append("\t-  ").append(sOwner != null ? "waiting to lock " : "waiting on ").append(infoLock);
                if (sOwner != null) {
                    sbTrace.append(" owned by:\"").append(sOwner).append("\" id=").append(infoThread.getLockOwnerId());
                }
                sbTrace.append("\n");
            }
            for (MonitorInfo info : aMonitor) {
                if (info.getLockedStackDepth() != iDepth) continue;
                sbTrace.append("\t-  locked ").append(info).append("\n");
            }
        }
    }

    static {
        String sLock = System.getProperty(Threads.class.getName() + ".dumpLocks", LockAnalysis.OWNERSHIP.name());
        DUMP_LOCKS = "true".equalsIgnoreCase(sLock) ? LockAnalysis.FULL : ("false".equalsIgnoreCase(sLock) ? LockAnalysis.NONE : LockAnalysis.valueOf(sLock));
    }

    public static enum LockAnalysis {
        NONE,
        OWNERSHIP,
        FULL;

    }
}

