/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.application.console.Coherence$Logger$Queue;
import com.tangosol.coherence.component.application.console.Coherence$Logger$ShutdownHook;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Coherence$Logger
extends Logger {
    private boolean __m_CommandPrompt;
    private boolean __m_Configured;
    private Method __m_DMSActiveContextMethod;
    private volatile boolean __m_DMSErrored;
    private transient int __m_HashCode;
    private long __m_LastPromptTimeMillis;
    private transient Object[] __m_LogParameters;
    private Constructor __m_ODLRecordConstructor;
    private Method __m_ODLRecordGetCtxMethod;
    private Method __m_ODLRecordInitMethod;
    private boolean __m_PendingLineFeed;
    private boolean __m_PendingPrompt;
    private String __m_Prompt;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        Coherence$Logger.__initStatic();
    }

    public Coherence$Logger() {
        this(null, null, true);
    }

    public Coherence$Logger(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setFormat("{date} Oracle Coherence {version} <{level}> (thread={thread}): {text}");
            this.setLevel(10);
            this.setLimit(65536);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOverflowed(false);
            this.setParameters(new String[]{"{logRecord}", "{uptime}", "{thread}", "{member}", "{role}", "{location}", "{product}", "{version}"});
            this.setPriority(3);
            this.setWaitMillis(5000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Coherence$Logger$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", Coherence$Logger$Queue.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.util.logging.Level");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean checkDiagnosability() {
        try {
            Method methDMSActiveCtx = this.getDMSActiveContextMethod();
            return !(!(methDMSActiveCtx != null) ? false : this.isDMSErrored() ^ true) ? false : methDMSActiveCtx.invoke(null, null) != null;
        }
        catch (Exception e) {
            this.setDMSErrored(true);
            System.err.println("Oracle Diagnostic Logging was discovered but accessing expected methods was unsuccessful.");
            e.printStackTrace();
            return false;
        }
    }

    protected Object[] collectLogParameters() {
        Object[] aoParam = this.getLogParameters();
        try {
            Coherence app = (Coherence)this.get_Module();
            SafeCluster cluster = Coherence.getCluster();
            Member member = (cluster == null ? true : cluster.isRunning() ^ true) ? null : (Member)cluster.getLocalMember();
            int nMemberNew = member == null ? 0 : member.getId();
            int nMemberOld = aoParam == null ? -1 : (Integer)aoParam[0];
            if (nMemberNew != nMemberOld) {
                aoParam = member == null ? new Object[]{Base.makeInteger(0), null, null, app.getProduct()} : new Object[]{Base.makeInteger(nMemberNew), member.getRoleName(), member.getLocationInfo(), app.getProduct()};
                this.setLogParameters(aoParam);
            }
        }
        catch (Throwable throwable) {}
        return aoParam;
    }

    protected String formatLogRecord(String sFormat, LogRecord logRecord) {
        String sMessage = super.formatLogRecord(sFormat, logRecord);
        String sECID = null;
        Method methODLGetCtx = this.getODLRecordGetCtxMethod();
        if (!(methODLGetCtx != null) ? false : logRecord.getClass() == methODLGetCtx.getDeclaringClass()) {
            try {
                Object oCtx = methODLGetCtx.invoke((Object)logRecord, null);
                if (oCtx != null) {
                    sECID = (String)ClassHelper.invoke(oCtx, "getECID", null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sMessage = Base.replace(sMessage, "{ecid}", this.formatParameter("{ecid}", sECID));
        return sMessage;
    }

    protected String formatParameter(String sParamName, Object oParamValue) {
        if (!(sParamName != null) ? false : sParamName.length() > 3) {
            switch (sParamName.charAt(1)) {
                case 'e': {
                    if (!sParamName.equals("{ecid}")) break;
                    return oParamValue == null ? "n/a" : (String)oParamValue;
                }
                case 'm': {
                    if (!sParamName.equals("{member}")) break;
                    int nMember = oParamValue instanceof Integer ? (Integer)oParamValue : 0;
                    return nMember == 0 ? "n/a" : String.valueOf(nMember);
                }
                case 'l': 
                case 'r': {
                    if (!(sParamName.equals("{role}") ? true : sParamName.equals("{location}"))) break;
                    return oParamValue == null ? "" : (String)oParamValue;
                }
                case 'p': {
                    if (!sParamName.equals("{product}")) break;
                    String sProduct = (String)oParamValue;
                    return sProduct == null ? Coherence.TITLE : sProduct;
                }
                case 'v': {
                    if (!sParamName.equals("{version}")) break;
                    return Coherence.VERSION;
                }
            }
        }
        return super.formatParameter(sParamName, oParamValue);
    }

    protected Method getDMSActiveContextMethod() {
        return this.__m_DMSActiveContextMethod;
    }

    public long getDefaultWaitMillis() {
        return 500L;
    }

    public int getHashCode() {
        int nHash = this.__m_HashCode;
        return nHash == 0 ? System.identityHashCode(this.get_Module()) : nHash;
    }

    protected long getLastPromptTimeMillis() {
        return this.__m_LastPromptTimeMillis;
    }

    public Object[] getLogParameters() {
        return this.__m_LogParameters;
    }

    protected Constructor getODLRecordConstructor() {
        return this.__m_ODLRecordConstructor;
    }

    protected Method getODLRecordGetCtxMethod() {
        return this.__m_ODLRecordGetCtxMethod;
    }

    protected Method getODLRecordInitMethod() {
        return this.__m_ODLRecordInitMethod;
    }

    public String getPrompt() {
        return this.__m_Prompt;
    }

    public String getThreadName() {
        return new StringBuilder(String.valueOf(super.getThreadName())).append("@").append(this.getHashCode()).append(" ").append(Coherence.VERSION).toString();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/application/console/Coherence$Logger".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Coherence$Logger();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected LogRecord instantiateLogRecord(Level level, String sMessage) {
        block3: {
            if (!this.checkDiagnosability()) break block3;
            try {
                Constructor consLogRecord = this.getODLRecordConstructor();
                Method methInitLogCtx = this.getODLRecordInitMethod();
                if (!(consLogRecord != null) ? false : methInitLogCtx != null) {
                    LogRecord logRecord = (LogRecord)consLogRecord.newInstance(level, sMessage);
                    methInitLogCtx.invoke((Object)logRecord, null);
                    return logRecord;
                }
            }
            catch (Exception exception) {}
        }
        return super.instantiateLogRecord(level, sMessage);
    }

    public boolean isCommandPrompt() {
        return this.__m_CommandPrompt;
    }

    public boolean isConfigured() {
        return this.__m_Configured;
    }

    protected boolean isDMSErrored() {
        return this.__m_DMSErrored;
    }

    public boolean isPendingLineFeed() {
        return this.__m_PendingLineFeed;
    }

    protected boolean isPendingPrompt() {
        return this.__m_PendingPrompt;
    }

    public void onInit() {
        super.onInit();
        this.setPrompt("?");
        Class<?> clzDMSCtx = null;
        Class<?> clzODLLogRec = null;
        ClassLoader loader = Coherence$Logger.get_CLASS().getClassLoader();
        try {
            clzDMSCtx = Class.forName("oracle.dms.context.DMSContextManager", false, loader);
            clzODLLogRec = Class.forName("oracle.core.ojdl.logging.ODLLogRecord", false, loader);
            Class[] aclzParams = new Class[]{};
            Method methActiveCtx = clzDMSCtx.getMethod("getActiveContext", aclzParams);
            Method methInitCtx = clzODLLogRec.getMethod("initLoggingContext", aclzParams);
            Method methGetCtx = clzODLLogRec.getMethod("getLoggingContext", aclzParams);
            Constructor<?> consLogRec = clzODLLogRec.getConstructor(Coherence$Logger.__sm0(), Coherence$Logger.__sm1());
            this.setDMSActiveContextMethod(methActiveCtx);
            this.setODLRecordInitMethod(methInitCtx);
            this.setODLRecordGetCtxMethod(methGetCtx);
            this.setODLRecordConstructor(consLogRec);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            System.err.println("Oracle Diagnostic Logging was discovered but expected methods were not found.");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInterval() {
        super.onInterval();
        Coherence coh = (Coherence)this.get_Module();
        if (!(Coherence.getCluster() == null) ? false : this.getQueue().isEmpty()) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                if (Coherence.getCluster() == null) {
                    coh.setLogger(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLog() {
        super.onLog();
        if (this.isPendingLineFeed()) {
            PrintStream out;
            PrintStream printStream = out = System.out;
            synchronized (printStream) {
                out.println();
            }
            this.setPendingLineFeed(false);
        }
        this.setPendingPrompt(this.isCommandPrompt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNotify() {
        long lCurrent;
        super.onNotify();
        if (this.isPendingPrompt() && (lCurrent = Base.getSafeTimeMillis()) > this.getLastPromptTimeMillis() + this.getWaitMillis()) {
            PrintStream out;
            PrintStream printStream = out = System.out;
            synchronized (printStream) {
                out.print(new StringBuilder(String.valueOf("\nMap (")).append(this.getPrompt()).append("): ").toString());
                out.flush();
            }
            this.setPendingPrompt(false);
            this.setPendingLineFeed(true);
            this.setLastPromptTimeMillis(lCurrent);
        }
    }

    public void setCommandPrompt(boolean fPrompt) {
        this.__m_CommandPrompt = fPrompt;
        this.setPendingPrompt(fPrompt);
        this.setLastPromptTimeMillis(0L);
        this.setWaitMillis(fPrompt ? this.getDefaultWaitMillis() : 5000L);
        this.getNotifier().signal();
    }

    public void setConfigured(boolean fConfigured) {
        this.__m_Configured = fConfigured;
    }

    protected void setDMSActiveContextMethod(Method methodContext) {
        this.__m_DMSActiveContextMethod = methodContext;
    }

    protected void setDMSErrored(boolean fErrored) {
        this.__m_DMSErrored = fErrored;
    }

    public void setHashCode(int n) {
        this.__m_HashCode = n;
        Thread thread = this.getThread();
        if (thread != null) {
            thread.setName(this.getThreadName());
        }
    }

    protected void setLastPromptTimeMillis(long nTime) {
        this.__m_LastPromptTimeMillis = nTime;
    }

    public void setLogParameters(Object[] aoParameters) {
        this.__m_LogParameters = aoParameters;
    }

    protected void setODLRecordConstructor(Constructor consLogRec) {
        this.__m_ODLRecordConstructor = consLogRec;
    }

    protected void setODLRecordGetCtxMethod(Method methGetCtx) {
        this.__m_ODLRecordGetCtxMethod = methGetCtx;
    }

    protected void setODLRecordInitMethod(Method methInit) {
        this.__m_ODLRecordInitMethod = methInit;
    }

    public void setPendingLineFeed(boolean fPending) {
        this.__m_PendingLineFeed = fPending;
    }

    protected void setPendingPrompt(boolean fPending) {
        this.__m_PendingPrompt = fPending;
    }

    public void setPrompt(String sPrompt) {
        this.__m_Prompt = sPrompt;
    }

    public synchronized void shutdown() {
        super.shutdown();
        if (this.isCommandPrompt()) {
            System.out.println();
        }
    }
}

