/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.oracle.coherence.common.net.exabus.Depot;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$IpMonitor;
import com.tangosol.coherence.component.net.Cluster$NameService;
import com.tangosol.coherence.component.net.Cluster$NameServiceBridge;
import com.tangosol.coherence.component.net.Cluster$PacketListener1;
import com.tangosol.coherence.component.net.Cluster$PacketListener1P;
import com.tangosol.coherence.component.net.Cluster$PacketListenerBT;
import com.tangosol.coherence.component.net.Cluster$PacketListenerBU;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher;
import com.tangosol.coherence.component.net.Cluster$PacketReceiver;
import com.tangosol.coherence.component.net.Cluster$PacketReceiver$AddressedBuffer;
import com.tangosol.coherence.component.net.Cluster$PacketSpeaker;
import com.tangosol.coherence.component.net.Cluster$PublicGuardian;
import com.tangosol.coherence.component.net.Cluster$ShutdownHook;
import com.tangosol.coherence.component.net.Cluster$SocketManager;
import com.tangosol.coherence.component.net.Cluster$SocketManager$AcceptorChannel;
import com.tangosol.coherence.component.net.Cluster$SocketManager$BroadcastTcpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$BroadcastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$PreferredUnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$TransportService;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.unit.Millis;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.io.BufferManagerWriteBufferPool;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.internal.net.service.extend.NameServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.tracing.LegacyXmlTracingHelper;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.nio.ByteBufferInputStream;
import com.tangosol.io.nio.ByteBufferOutputStream;
import com.tangosol.license.LicensedObject;
import com.tangosol.license.ProcessorInfo;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.CompositeAddressProvider;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.NameService;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.SystemDatagramSocketProvider;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.net.internal.SubstitutionSocketAddressProvider;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;

public class Cluster
extends Net
implements com.tangosol.net.Cluster,
NameService.LookupCallback {
    public static final int MAX_SYSTEM_SERVICE = 1;
    public static final int POOL_RX_PACKETS = 8192;
    public static final int POOL_TX_PACKETS = 2048;
    public static final int STATE_EXITED = 6;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_JOINING = 2;
    public static final int STATE_LEAVING = 4;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STOPPING = 5;
    public static final String TRANSPORT_DATAGRAM = "datagram";
    private String __m_ClusterName;
    private ByteBuffer __m_ClusterNameBuffer;
    private Cluster$ClusterService __m_ClusterService;
    private ClusterDependencies __m_Dependencies;
    private volatile int __m_GuardRecoverCount;
    private volatile int __m_GuardTerminateCount;
    private Cluster$PublicGuardian __m_Guardian;
    private transient boolean __m_Halted;
    private Cluster$IpMonitor __m_IpMonitor;
    private transient Registry __m_Management;
    private MessagePublisher __m_MessagePublisher;
    private Cluster$NameService __m_NameService;
    private Cluster$NameServiceBridge __m_NameServiceBridge;
    private OperationalContext __m_OperationalContext;
    private Cluster$PacketListener1 __m_PointListener;
    private Cluster$PacketListener1P __m_PreferredListener;
    private Cluster$PacketPublisher __m_Publisher;
    private Cluster$PacketReceiver __m_Receiver;
    private transient ResourceRegistry __m_ResourceRegistry;
    private transient long __m_ShutdownTimeout;
    private Cluster$PacketSpeaker __m_Speaker;
    private Throwable __m_StartException;
    private volatile int __m_State;
    private Cluster$PacketListenerBT __m_TcpBroadcastListener;
    private ThreadGroup __m_ThreadGroup;
    private TracingShim.Control __m_TracingControl;
    private Cluster$TransportService __m_TransportService;
    private Cluster$PacketListenerBU __m_UdpBroadcastListener;
    private List __m_WrapperStreamFactoryList;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;
    private static /* synthetic */ Class __sf2;

    public Cluster() {
        this(null, null, true);
    }

    public Cluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setHalted(false);
            this.setResourceRegistry(new SimpleResourceRegistry());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Cluster$ClusterService("ClusterService", this, true), "ClusterService");
        this._addChild(new Cluster$IpMonitor("IpMonitor", this, true), "IpMonitor");
        this._addChild(new Cluster$NameService("NameService", this, true), "NameService");
        this._addChild(new Cluster$NameServiceBridge("NameServiceBridge", this, true), "NameServiceBridge");
        this._addChild(new Cluster$PacketListener1("PacketListener1", this, true), "PacketListener1");
        this._addChild(new Cluster$PacketListener1P("PacketListener1P", this, true), "PacketListener1P");
        this._addChild(new Cluster$PacketListenerBT("PacketListenerBT", this, true), "PacketListenerBT");
        this._addChild(new Cluster$PacketListenerBU("PacketListenerBU", this, true), "PacketListenerBU");
        this._addChild(new Cluster$PacketPublisher("PacketPublisher", this, true), "PacketPublisher");
        this._addChild(new Cluster$PacketReceiver("PacketReceiver", this, true), "PacketReceiver");
        this._addChild(new Cluster$PacketSpeaker("PacketSpeaker", this, true), "PacketSpeaker");
        this._addChild(new Cluster$PublicGuardian("PublicGuardian", this, true), "PublicGuardian");
        this._addChild(new Cluster$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this._addChild(new Cluster$SocketManager("SocketManager", this, true), "SocketManager");
        this._addChild(new Cluster$TransportService("TransportService", this, true), "TransportService");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.net.NameService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("com.oracle.coherence.common.base.Disposable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm2() {
        Class<?> clazz = __sf2;
        if (clazz == null) {
            try {
                clazz = __sf2 = Class.forName("com.tangosol.net.Guardian");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void applyWrapperStreamFactories(Grid service, List listNames) {
        List listFilter;
        if ((!(listNames != null) ? false : listNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listNames)).isEmpty() ^ true) {
            service.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
        service.setWrapperStreamFactoryAllList(this.getWrapperStreamFactoryList());
    }

    protected void bindService(Grid service) {
        String sServiceType;
        DefaultServiceFailurePolicy policy;
        ClusterDependencies config = this.getDependencies();
        ServiceFailurePolicyBuilder builder = config.getServiceFailurePolicyBuilder();
        ServiceFailurePolicy serviceFailurePolicy = policy = (builder == null ? true : service instanceof Cluster$TransportService) ? new DefaultServiceFailurePolicy(DefaultServiceFailurePolicy.POLICY_EXIT_CLUSTER) : builder.realize(new NullParameterResolver(), this.getContextClassLoader(), null);
        if (service instanceof Cluster$ClusterService) {
            sServiceType = "ClusterService";
        } else {
            service.setCluster(this);
            sServiceType = service.getServiceType();
        }
        service.setThreadGroup(this.getThreadGroup());
        service.setDefaultGuardTimeout(config.getGuardTimeoutMillis());
        service.setServiceFailurePolicy(policy);
        service.setBufferManager(this.getReceiver().getBufferManager());
        this.applyWrapperStreamFactories(service, config.getServiceFilterMap().get(sServiceType));
    }

    protected void checkShutdownPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Cluster.shutdown"));
        }
    }

    public synchronized void configure(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    protected void configureBroadcast() {
        ClusterDependencies config = this.getDependencies();
        Cluster$SocketManager manager = this.getSocketManager();
        Cluster$SocketManager$UnicastUdpSocket socketU = manager.getUnicastUdpSocket();
        Cluster$SocketManager$PreferredUnicastUdpSocket socketP = manager.getPreferredUnicastUdpSocket();
        Cluster$SocketManager$BroadcastUdpSocket socketBU = manager.getBroadcastUdpSocket();
        Cluster$SocketManager$BroadcastTcpSocket socketBT = manager.getBroadcastTcpSocket();
        Cluster$PacketPublisher publisher = this.getPublisher();
        AddressProvider provider = config.getWellKnownAddresses();
        if (provider == null) {
            publisher.setMulticastAddress(new InetSocketAddress(config.getGroupAddress(), config.getGroupPort()));
            publisher.setUdpSocketMulticast(socketBU);
        } else {
            CompositeAddressProvider setBroadcast = new CompositeAddressProvider(provider);
            Cluster$ClusterService service = this.getClusterService();
            service.setBroadcastAddresses(setBroadcast);
            service.setWellKnownAddresses(provider instanceof Set ? (Set)((Object)provider) : new CompositeAddressProvider(provider));
            publisher.setBroadcastAddresses(setBroadcast);
            publisher.setMulticastEnabled(false);
        }
        socketBU.setSoTimeout(config.getClusterHeartbeatDelayMillis());
        int nPortGroup = config.getGroupPort();
        socketBU.setPort(nPortGroup);
        socketBT.setPort(nPortGroup);
        int cbPacketMax = socketU.getPacketLength();
        socketBU.setPacketLength(cbPacketMax);
        socketBT.setPacketLength(cbPacketMax);
        int cbBuffer = socketU.getBufferSentBytes();
        socketBU.setBufferSentBytes(cbBuffer);
        socketBT.setBufferSentBytes(cbBuffer);
        cbBuffer = socketU.getBufferReceivedBytes();
        socketBU.setBufferReceivedBytes(cbBuffer);
        socketBT.setBufferReceivedBytes(cbBuffer);
    }

    protected void configureDaemons() {
        List listFilter;
        DefaultClusterDependencies config = (DefaultClusterDependencies)this.getDependencies();
        Cluster$SocketManager manager = this.getSocketManager();
        ThreadGroup group = this.getThreadGroup();
        if (group == null) {
            group = new ThreadGroup(this.get_Name());
            group.setDaemon(true);
            this.setThreadGroup(group);
        }
        Cluster$ClusterService daemonClusterService = this.getClusterService();
        Cluster$TransportService daemonTransport = this.getTransportService();
        Cluster$IpMonitor daemonIpMonitor = this.getIpMonitor();
        Cluster$PublicGuardian daemonGuardian = this.getGuardian();
        daemonClusterService.setCluster(this);
        daemonClusterService.setDependencies(null);
        daemonClusterService.setThreadGroup(group);
        daemonTransport.setThreadGroup(group);
        daemonIpMonitor.setThreadGroup(group);
        daemonGuardian.setThreadGroup(group);
        Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        Cluster$SocketManager$PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        Cluster$SocketManager$BroadcastUdpSocket udpsocketUdpBroadcast = manager.getBroadcastUdpSocket();
        Cluster$SocketManager$BroadcastTcpSocket udpsocketTcpBroadcast = manager.getBroadcastTcpSocket();
        ServerSocketChannel channelTcpRing = manager.getAcceptorChannel().getChannel();
        Member member = daemonClusterService.instantiateMember();
        member.configure(config, config.computeLocalAddress(), udpsocketUnicast.getPort(), channelTcpRing == null ? 0 : channelTcpRing.socket().getLocalPort(), this.getCounters());
        daemonClusterService.setAnnounceMember(member);
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = udpsocketUnicastPref.getPacketLength();
        MasterMemberSet setMember = daemonClusterService.getClusterMemberSet();
        setMember.setMaximumPacketLength(cbPacket);
        int cHeartbeatMillis = config.getClusterHeartbeatDelayMillis();
        int cTimeoutMillis = config.getPublisherResendTimeoutMillis();
        int cMillisRepeatDelay = config.getPublisherResendDelayMillis();
        daemonClusterService.setBroadcastTimeoutMillis(Math.max(config.getClusterAnnounceTimeoutMillis(), cMillisRepeatDelay * ClusterService.ANNOUNCE_BIND_THRESHOLD));
        daemonClusterService.setBroadcastRepeatMillis(cMillisRepeatDelay);
        daemonClusterService.setDeliveryTimeoutMillis(cTimeoutMillis);
        daemonClusterService.setMaximumPacketLength(cbPacket);
        daemonClusterService.setTimestampMaxVariance(config.getClusterTimestampMaxVarianceMillis());
        setMember.setRecycleMillis(cTimeoutMillis * 4);
        try {
            ClusterService$TcpRing ring = daemonClusterService.getTcpRing();
            if (config.isTcpRingEnabled()) {
                ring.setEnabled(true);
                ring.setSocketProvider(manager.getTcpRingSocketProvider());
                ring.setServerSocketChannel(manager.getAcceptorChannel().getChannel());
                ring.setRedundancyLevel(Integer.parseInt(Config.getProperty("coherence.tcpRing.redundancyLevel", "1")));
            } else {
                ring.setEnabled(false);
                Component._trace(new StringBuilder(String.valueOf("TcpRing has been explicitly disabled, this is not a recommended ")).append("practice and will result in a minimum death detection time of ").append((long)cTimeoutMillis / 1000L).append(" seconds for failed processes.").toString(), 2);
                ring.setSelector(Selector.open());
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        if (this.isTransportServiceEnabled()) {
            DefaultGridDependencies depsTrans = new DefaultGridDependencies();
            depsTrans.setReliableTransport(config.getReliableTransport());
            daemonTransport.setDependencies(depsTrans);
            daemonTransport.setEnabled(true);
        }
        Cluster$NameService ns = this.getNameService();
        ns.setCluster(this);
        ns.setOperationalContext(this.getOperationalContext());
        ns.configure(CacheFactory.getServiceConfig(NameService.NAME_DEFAULT));
        this.getResourceRegistry().registerResource(Cluster.__sm0(), ns);
        boolean fIpMonitorEnabled = config.isIpMonitorEnabled();
        if (fIpMonitorEnabled) {
            daemonIpMonitor.configure(config, daemonClusterService);
            daemonIpMonitor.setWaitMillis(cHeartbeatMillis);
        } else {
            Component._trace(new StringBuilder(String.valueOf("IPMonitor has been explicitly disabled, this is not a recommended ")).append("practice and will result in a minimum death detection time of ").append((long)cTimeoutMillis / 1000L).append(" seconds for failed machines or networks.").toString(), 2);
        }
        daemonGuardian.setWaitMillis(cHeartbeatMillis);
        ActionPolicy policyAction = (ActionPolicy)config.getClusterActionPolicyBuilder().realize(new NullParameterResolver(), this.getContextClassLoader(), null);
        daemonClusterService.setActionPolicy(policyAction);
        daemonClusterService.setHeartbeatDelay(cHeartbeatMillis);
        long cGuardMillis = config.getGuardTimeoutMillis();
        daemonClusterService.setDefaultGuardTimeout(cGuardMillis);
        daemonIpMonitor.setDefaultGuardTimeout(cGuardMillis);
        daemonGuardian.setDefaultGuardTimeout(cGuardMillis);
        if (!(cGuardMillis > (long)0) ? false : fIpMonitorEnabled) {
            daemonClusterService.guard(daemonIpMonitor.getGuardable());
            daemonIpMonitor.guard(daemonClusterService.getGuardable());
        }
        Cluster$PacketListener1 daemonPointListener = this.getPointListener();
        Cluster$PacketListener1P daemonPreferredListener = this.getPreferredListener();
        Cluster$PacketListenerBT daemonTcpBroadcastListener = this.getTcpBroadcastListener();
        Cluster$PacketListenerBU daemonUdpBroadcastListener = this.getUdpBroadcastListener();
        Cluster$PacketReceiver daemonReceiver = this.getReceiver();
        Cluster$PacketSpeaker daemonSpeaker = this.getSpeaker();
        Cluster$PacketPublisher daemonPublisher = this.getPublisher();
        daemonPointListener.setThreadGroup(group);
        daemonPreferredListener.setThreadGroup(group);
        daemonUdpBroadcastListener.setThreadGroup(group);
        daemonTcpBroadcastListener.setThreadGroup(group);
        daemonReceiver.setThreadGroup(group);
        daemonSpeaker.setThreadGroup(group);
        daemonPublisher.setThreadGroup(group);
        daemonPointListener.setPriority(config.getLocalListenerPriority());
        daemonUdpBroadcastListener.setPriority(config.getLocalListenerPriority());
        daemonTcpBroadcastListener.setPriority(config.getLocalListenerPriority());
        daemonPreferredListener.setPriority(config.getLocalListenerPriority());
        daemonReceiver.setPriority(config.getReceiverPriority());
        daemonSpeaker.setPriority(config.getSpeakerPriority());
        daemonPublisher.setPriority(config.getPublisherPriority());
        daemonIpMonitor.setPriority(config.getIpMonitorPriority());
        daemonPointListener.setMemberSet(setMember);
        daemonPreferredListener.setMemberSet(setMember);
        daemonUdpBroadcastListener.setMemberSet(setMember);
        daemonTcpBroadcastListener.setMemberSet(setMember);
        daemonReceiver.setMemberSet(setMember);
        daemonSpeaker.setMemberSet(setMember);
        daemonPublisher.setMemberSet(setMember);
        ByteBuffer bufClusterName = ByteBuffer.allocate(MemberIdentity.MEMBER_IDENTITY_LIMIT * 2 + 2);
        try {
            DataOutputStream outName = new DataOutputStream(new ByteBufferOutputStream(bufClusterName));
            outName.writeUTF(config.getMemberIdentity().getClusterName());
            outName.close();
            ((Buffer)bufClusterName).flip();
            ByteBuffer bufTrim = ByteBuffer.allocate(bufClusterName.remaining());
            ((Buffer)bufTrim.put(bufClusterName)).flip();
            bufClusterName = bufTrim;
            this.setClusterNameBuffer(bufClusterName);
            daemonPublisher.setClusterNameBuffer(bufClusterName);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        BufferManager bufferManager = BufferManagers.getHeapManager();
        daemonPointListener.setUdpSocket(udpsocketUnicast);
        daemonPointListener.setBufferManager(bufferManager);
        daemonPointListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonPreferredListener.setUdpSocket(udpsocketUnicastPref);
        daemonPreferredListener.setBufferManager(bufferManager);
        daemonPreferredListener.setPacketLength(cbPacketPref);
        daemonUdpBroadcastListener.setUdpSocket(udpsocketUdpBroadcast);
        daemonUdpBroadcastListener.setBufferManager(bufferManager);
        daemonUdpBroadcastListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonTcpBroadcastListener.setUdpSocket(udpsocketTcpBroadcast);
        daemonTcpBroadcastListener.setBufferManager(bufferManager);
        daemonTcpBroadcastListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonReceiver.setClusterService(daemonClusterService);
        daemonReceiver.setAckSendQueue(daemonPublisher.getAckQueue());
        daemonReceiver.setConfirmationQueue(daemonPublisher.getConfirmationQueue());
        daemonReceiver.setBufferManager(bufferManager);
        daemonReceiver.setMaximumPacketLength(cbPacket);
        daemonReceiver.setPreferredPacketLength(cbPacketPref);
        daemonReceiver.setNackEnabled(config.isReceiverNackEnabled());
        daemonReceiver.setPublisher(daemonPublisher);
        if (!(daemonTransport.isEnabled() ^ true) ? false : config.isSpeakerEnabled()) {
            PacketSpeaker$BundlingQueue queueSpeaker = (PacketSpeaker$BundlingQueue)daemonSpeaker.getQueue();
            int nVolume = config.getSpeakerVolumeMinimum();
            try {
                queueSpeaker.setVolumeTunable(nVolume < 0);
                queueSpeaker.setVolumeThreshold(nVolume < 0 ? udpsocketUnicast.getDatagramSocket().getSendBufferSize() / cbPacketPref : nVolume);
                if (queueSpeaker.isBundlingEnabled()) {
                    queueSpeaker.setDeferralThresholdNanos(config.getPacketBundlingThresholdNanos());
                    queueSpeaker.setBundlingAggression(config.getPacketBundlingAggression());
                }
                queueSpeaker.setCloggedCount(config.getPublisherCloggedCount());
                queueSpeaker.setCloggedDelay(config.getPublisherCloggedDelayMillis());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        daemonPublisher.setUdpSocketUnicast(udpsocketUnicast);
        daemonPublisher.setUdpSocketMulticast(udpsocketUdpBroadcast);
        daemonPublisher.setSendQueue(daemonSpeaker.getQueue());
        daemonPublisher.setMaximumPacketLength(cbPacket);
        daemonPublisher.setPreferredPacketLength(cbPacketPref);
        daemonPublisher.setNackEnabled(config.isReceiverNackEnabled());
        daemonPublisher.setNackDelayMillis(config.getPublisherNackDelayMillis());
        daemonPublisher.setMessageBufferAllocator(new BufferManagerWriteBufferPool(bufferManager));
        if (config.isFlowControlEnabled()) {
            daemonPublisher.setDeferredReadyQueue(new Queue());
            Member$FlowControl.setEnabled(true);
            int iMax = config.getOutstandingPacketMaximum();
            int iMin = config.getOutstandingPacketMinimum();
            Member$FlowControl.setOutstandingPacketMaximum(iMax);
            Member$FlowControl.setOutstandingPacketMinimum(iMin);
            Member$FlowControl.setLostPacketThreshold(config.getLostPacketThreshold());
        }
        daemonPublisher.setResendDelay(config.getPublisherResendDelayMillis());
        daemonPublisher.setResendTimeout(cTimeoutMillis);
        daemonPublisher.setAckDelay(config.getPublisherAckDelayMillis());
        daemonPublisher.setCloggedCount(config.getPublisherCloggedCount());
        daemonPublisher.setCloggedDelay(config.getPublisherCloggedDelayMillis());
        daemonPublisher.setMulticastThreshold((double)config.getPublisherGroupThreshold() / 100.0);
        List<String> listFilterNames = config.getFilterList();
        if ((!(listFilterNames != null) ? false : listFilterNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listFilterNames)).isEmpty() ^ true) {
            this.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
        Cluster$NameServiceBridge nsClient = this.getNameServiceBridge();
        nsClient.setOperationalContext(this.getOperationalContext());
        NameServiceDependencies depsNS = (NameServiceDependencies)this.getNameService().getDependencies();
        TcpAcceptorDependencies depsAccept = (TcpAcceptorDependencies)depsNS.getAcceptorDependencies();
        DefaultTcpInitiatorDependencies depsFNsInit = new DefaultTcpInitiatorDependencies();
        depsFNsInit.setRemoteSocketAddressProviderBuilder(SubstitutionSocketAddressProvider.createBuilder(depsAccept.getLocalAddressProviderBuilder(), InetAddress.getLoopbackAddress(), config.getGroupPort(), 0));
        depsFNsInit.setSocketProviderBuilder(new SocketProviderBuilder(TcpSocketProvider.MULTIPLEXED));
        depsFNsInit.setConnectTimeoutMillis(100L);
        depsFNsInit.setRequestSendTimeoutMillis(100L);
        depsFNsInit.setRequestTimeoutMillis(100L);
        DefaultRemoteServiceDependencies depsFNs = new DefaultRemoteServiceDependencies();
        depsFNs.setRemoteServiceName("NameService");
        depsFNs.setInitiatorDependencies(depsFNsInit);
        nsClient.setDependencies(depsFNs);
    }

    protected void configureSockets() {
        int cbBufferSent;
        DefaultClusterDependencies config = (DefaultClusterDependencies)this.getDependencies();
        InetAddress addrLocal = config.computeLocalAddress();
        if (InetAddressHelper.isLoopbackAddress(addrLocal)) {
            Component._trace(new StringBuilder(String.valueOf("Local address \"")).append(InetAddressHelper.toString(addrLocal)).append("\" is a loopback address; this cluster node will not connect").append(" to nodes located on different machines").toString(), 2);
        }
        Cluster$SocketManager manager = this.getSocketManager();
        SocketProviderBuilder bldrUnicastSocketProvider = config.getUnicastSocketProviderBuilder();
        DatagramSocketProvider provider = bldrUnicastSocketProvider.getDatagramSocketProvider(MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_TCMP_DATAGRAM.getSubPort());
        manager.setUnicastUdpSocketProvider(provider);
        manager.setTcpRingSocketProvider(bldrUnicastSocketProvider.getDemultiplexedSocketProvider(MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_TCP_RING.getSubPort()));
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = config.getPacketPreferredLength();
        int cbHeaderSize = provider instanceof SystemDatagramSocketProvider ? 48 : 68;
        if (cbPacketPref == 0) {
            int nMTU = 0;
            try {
                nMTU = InetAddresses.getLocalMTU(addrLocal);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (nMTU == 0) {
                nMTU = InetAddresses.getLocalMTU();
            }
            nMTU = Math.min(65535, nMTU);
            cbPacketPref = nMTU - cbHeaderSize;
        }
        if ((cbBufferSent = config.getPublisherSocketBufferSize()) == 0) {
            cbBufferSent = (this.isTransportServiceEnabled() ? true : cbPacketPref < 1500) ? Math.max(16 * cbPacketPref, 32 * 1024) : (cbPacketPref < 9000 ? 256 * 1024 : 512 * 1024);
        } else if (cbBufferSent < 0) {
            cbBufferSent *= -cbPacketPref;
        }
        cbBufferSent = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferSent);
        int cbBufferPref = config.getLocalBufferSize();
        if (cbBufferPref == 0) {
            cbBufferPref = (this.isTransportServiceEnabled() ? true : cbPacketPref < 1500) ? Math.max(16 * cbPacketPref, 2 * 1024 * 1024) : (cbPacketPref < 9000 ? 4 * 1024 * 1024 : 8 * 1024 * 1024);
        } else if (cbBufferPref < 0) {
            cbBufferPref *= -cbPacketPref;
        }
        cbBufferPref = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferPref);
        int cbBufferGroup = config.getGroupBufferSize();
        if (cbBufferGroup == 0) {
            cbBufferGroup = (this.isTransportServiceEnabled() ? true : cbPacketPref < 1500) ? Math.max(16 * cbPacketPref, 1 * 1024 * 1024) : (cbPacketPref < 9000 ? 2 * 1024 * 1024 : 4 * 1024 * 1024);
        } else if (cbBufferGroup < 0) {
            cbBufferGroup *= -cbPacketPref;
        }
        cbBufferGroup = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferGroup);
        Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        Cluster$SocketManager$PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        Cluster$SocketManager$BroadcastUdpSocket udpsocketUdpBroadcast = manager.getBroadcastUdpSocket();
        Cluster$SocketManager$BroadcastTcpSocket udpsocketTcpBroadcast = manager.getBroadcastTcpSocket();
        InetAddress addrDiscovery = config.getLocalDiscoveryAddress();
        InetAddress addrUnicast = config.getLocalAddress();
        if (addrUnicast == null) {
            InetAddress inetAddress = addrUnicast = (!addrDiscovery.isAnyLocalAddress() ? false : config.getWellKnownAddresses() != null) ? addrDiscovery : addrLocal;
        }
        if (InetAddresses.isNatLocalAddress(addrUnicast, config.getLocalPort(), config.getLocalPortAutoAdjust())) {
            addrUnicast = InetAddresses.ADDR_ANY;
        }
        if (InetAddresses.isNatLocalAddress(addrDiscovery, config.getLocalPort(), config.getLocalPortAutoAdjust())) {
            addrDiscovery = InetAddresses.ADDR_ANY;
        }
        udpsocketUnicast.setBufferSentBytes(cbBufferSent);
        udpsocketUnicast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketUnicast.setInetAddress(addrUnicast);
        udpsocketUnicast.setPacketLength(Math.max(cbPacket, cbPacketPref));
        udpsocketUnicastPref.setBufferReceivedBytes(cbBufferPref);
        udpsocketUnicastPref.setInetAddress(addrUnicast);
        udpsocketUnicastPref.setPacketLength(cbPacketPref);
        InetAddress addrBroadcast = config.getWellKnownAddresses() == null ? InetAddresses.ADDR_ANY : addrDiscovery;
        udpsocketUdpBroadcast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketUdpBroadcast.setInetAddress(addrBroadcast);
        udpsocketUdpBroadcast.setPacketLength(65535);
        udpsocketTcpBroadcast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketTcpBroadcast.setInetAddress(addrBroadcast);
        udpsocketTcpBroadcast.setPacketLength(65535);
        try {
            Cluster$SocketManager$AcceptorChannel channel = manager.getAcceptorChannel();
            channel.setInetAddress(addrDiscovery);
            channel.setBacklog(config.getTcpBacklog());
            this.getClusterService().getTcpRing().getSocketOptions().copyOptions(config.getTcpRingSocketOptions());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public boolean configureTracing(TracingShim.Dependencies deps) {
        TracingShim.Control control = this.getTracingControl();
        if (control != null) {
            control.close();
            this.setTracingControl(null);
        }
        if (deps == null) {
            return true;
        }
        if (deps.getIdentity() == null) {
            ClusterDependencies config = this.getDependencies();
            MemberIdentity identity = config.getMemberIdentity();
            String sIdentity = identity.getMemberName();
            if (sIdentity == null) {
                sIdentity = new StringBuilder(String.valueOf(identity.getClusterName())).append(".").append(identity.getRoleName()).toString();
            }
            deps = new TracingShim.DefaultDependencies(deps).setIdentity(sIdentity);
        }
        if ((control = TracingHelper.initialize(deps)) != null) {
            this.setTracingControl(control);
            return true;
        }
        return false;
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport) {
        Cluster$SocketManager mgrSocket = this.getSocketManager();
        return this.createMessageBus(sServiceType, sTransport, mgrSocket.getDepot(), this.getClusterService().getThisMember().getAddress().getHostAddress(), mgrSocket.getAcceptorChannel().getPort());
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport, Depot depot, String sAddr, int nPort) {
        return this.createMessageBus(sServiceType, sTransport, depot, sAddr, nPort, true);
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport, Depot depot, String sAddr, int nPort, boolean fMultiplexed) {
        if (!(sTransport != null) ? false : sTransport.isEmpty() ^ true) {
            if (sTransport.equals("imb")) {
                sTransport = "tmb";
            } else if (sTransport.equals("imbs")) {
                sTransport = "tmbs";
            }
        }
        String sTransportOrig = sTransport;
        String sPort = Integer.toString(nPort);
        if (!(sTransport != null) ? false : sTransport.isEmpty()) {
            sTransport = null;
            sTransportOrig = null;
        }
        if (!(sTransport == null) ? false : this.getTransportService().getServiceType().equals(sServiceType)) {
            sTransport = Platform.getPlatform().isExaEnabled() ? (this.getSocketManager().getUnicastUdpSocketProvider().isSecure() ? "tmbs" : "tmb") : (this.getSocketManager().getUnicastUdpSocketProvider().isSecure() ? "tmbs" : "tmb");
        }
        while (!(sTransport == null)) {
            if (((sTransport.equals("tmb") ? true : sTransport.equals("tmbs")) ? true : sTransport.equals("sdmb")) ? true : sTransport.equals("sdmbs")) {
                boolean fEphemeral = !(this.getDependencies().getLocalPort() == 0) ? false : sTransport.startsWith("sdmb");
                sTransport = new StringBuilder(String.valueOf(sTransport)).append(new StringBuilder(String.valueOf("://{member-ip}:")).append(fEphemeral ? "0.0" : (fMultiplexed ? "{member-port}.0" : "{member-port}")).toString()).toString();
            } else if (sTransport.equals(TRANSPORT_DATAGRAM)) {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf(TRANSPORT_DATAGRAM)).append(" is not a bus transport").toString());
            }
            sTransport = sTransport.replace("{member-ip}", sAddr);
            sTransport = sTransport.replace("{member-port}", sPort);
            try {
                return depot.createMessageBus(depot.resolveEndPoint(sTransport));
            }
            catch (RuntimeException e) {
                if (sTransportOrig == null) {
                    sTransport = sTransport.startsWith("sdmbs") ? "tmbs" : (sTransport.startsWith("sdmb") ? "tmb" : null);
                    continue;
                }
                throw e;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Service ensureService(String sName, String sType) {
        if (sName == null ? true : sName.length() == 0) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid service name: ")).append(sName).toString());
        }
        Grid service = (Grid)this.getService(sName);
        if (service == null ? true : service.isRunning() ^ true) {
            Cluster cluster = this;
            // MONITORENTER : cluster
            if (service == null) {
                service = (Grid)this.getService(sName);
            } else {
                int cTries = 0;
                while (cTries < 10) {
                    Grid grid = service;
                    // MONITORENTER : grid
                    service = (Grid)this.getService(sName);
                    if (service == null ? true : service.isRunning()) {
                        Object var7_9 = null;
                        // MONITOREXIT : grid
                        break;
                    }
                    // MONITOREXIT : grid
                    if (cTries == 9) {
                        throw new IllegalStateException(new StringBuilder(String.valueOf("Failed to unregister: ")).append(service).toString());
                    }
                    Base.sleep(10 * (cTries + 1));
                    ++cTries;
                }
            }
            if (service == null) {
                String sComponent = this.getDependencies().getServiceMap().get(sType);
                if (sComponent != null) {
                    try {
                        service = (Grid)Component._newInstance(new StringBuilder(String.valueOf("Component.Util.Daemon.QueueProcessor.Service.Grid.")).append(sComponent).toString());
                    }
                    catch (SecurityException e) {
                        throw Base.ensureRuntimeException(null, new StringBuilder(String.valueOf(sType)).append(" service: ").append(e.getMessage()).toString());
                    }
                }
                if (service == null) {
                    throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unknown service type: ")).append(sType).append(":").append(sComponent).toString());
                }
                service.setServiceName(sName);
                this.bindService(service);
            }
            // MONITOREXIT : cluster
        }
        if (!(service.getServiceType().equals(sType) ^ true)) return service;
        throw new IllegalArgumentException(new StringBuilder(String.valueOf("Requested service type \"")).append(sType).append("\", but the existing service has type \"").append(service.getServiceType()).append('\"').toString());
    }

    public void ensureStopped() {
        if (this.getState() != STATE_EXITED) {
            long ldtTimeout = Base.getSafeTimeMillis() + (long)(4 * this.getDependencies().getClusterHeartbeatDelayMillis());
            do {
                try {
                    Blocking.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
                if (!(this.getState() == STATE_EXITED)) continue;
                return;
            } while (!(Base.getSafeTimeMillis() >= ldtTimeout));
            throw new RequestTimeoutException("Timeout while waiting for cluster to stop.");
        }
    }

    public String formatPointToPointStats() {
        MasterMemberSet members = this.getClusterService().getClusterMemberSet();
        Member memberThis = members.getThisMember();
        StringBuffer sb = new StringBuffer();
        try {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(!(member != null) ? false : member != memberThis)) continue;
                sb.append("\nMember=").append(member.getId()).append(", ").append(member.formatStats());
            }
        }
        catch (ConcurrentModificationException e) {}
        return sb.toString();
    }

    public String formatStats() {
        Cluster$IpMonitor ipMonitor;
        StringBuffer sb = new StringBuffer();
        sb.append("\nPacketPublisher: ").append(this.getPublisher().formatStats()).append("\nPacketSpeaker  : ").append(this.getSpeaker().formatStats()).append("\nPacketReceiver : ").append(this.getReceiver().formatStats());
        if (this.getDependencies().isTcpRingEnabled()) {
            sb.append("\nTcpRing        : ").append(this.getClusterService().getTcpRing().formatStats());
        }
        if ((ipMonitor = this.getIpMonitor()).isStarted()) {
            sb.append("\nIpMonitor      : ").append(ipMonitor.formatStats());
        }
        return sb.toString();
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public ByteBuffer getClusterNameBuffer() {
        return this.__m_ClusterNameBuffer;
    }

    public Cluster$ClusterService getClusterService() {
        return this.__m_ClusterService;
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public int[] getCounters() {
        ClusterDependencies config = this.getDependencies();
        int nMachineId = config.getMemberIdentity().getMachineId();
        if (nMachineId == 0) {
            try {
                InetAddress addr = InetAddresses.getLocalHost();
                long lAddr = InetAddresses.toLong(addr);
                nMachineId = (int)((lAddr & 0xFF000000L) >>> 24 & (long)255 ^ (lAddr & 0xFF0000L) >>> 16 & (long)255 ^ (lAddr & 0xFF00L) >>> 8 & (long)255) << 8 | (int)(lAddr & 0xFFL) & 0xFF;
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (nMachineId == 0) {
                nMachineId = 1;
            }
        }
        int nCpu = Runtime.getRuntime().availableProcessors();
        int[] ac = new int[]{nCpu, nCpu, nMachineId};
        LicensedObject.LicenseData[] aLicense = (LicensedObject.LicenseData[])((Cluster)this.get_Module()).getClusterService().get_Feed();
        if (!(aLicense != null) ? false : aLicense.length > 0) {
            ProcessorInfo procinfo = new ProcessorInfo(aLicense[0].uid);
            ac[0] = procinfo.getCpuCount();
            ac[1] = procinfo.getSocketCount();
        }
        return ac;
    }

    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public int getGuardRecoverCount() {
        return this.__m_GuardRecoverCount;
    }

    public int getGuardTerminateCount() {
        return this.__m_GuardTerminateCount;
    }

    public Cluster$PublicGuardian getGuardian() {
        return this.__m_Guardian;
    }

    public Cluster$IpMonitor getIpMonitor() {
        return this.__m_IpMonitor;
    }

    public com.tangosol.net.Member getLocalMember() {
        return this.getClusterService().getClusterMemberSet().getThisMember();
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getClusterService().getClusterMemberSet();
    }

    public MessagePublisher getMessagePublisher() {
        return this.__m_MessagePublisher;
    }

    public Cluster$NameService getNameService() {
        return this.__m_NameService;
    }

    public Cluster$NameServiceBridge getNameServiceBridge() {
        return this.__m_NameServiceBridge;
    }

    public com.tangosol.net.Member getOldestMember() {
        return this.getClusterService().getClusterOldestMember();
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public Cluster$PacketListener1 getPointListener() {
        return this.__m_PointListener;
    }

    public Cluster$PacketListener1P getPreferredListener() {
        return this.__m_PreferredListener;
    }

    public Cluster$PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    public Cluster$PacketReceiver getReceiver() {
        return this.__m_Receiver;
    }

    public Disposable getResource(String sName) {
        return (Disposable)this.getResourceRegistry().getResource(Cluster.__sm1(), sName);
    }

    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public Service getService(String sName) {
        return this.getClusterService().getService(sName);
    }

    public com.tangosol.net.ServiceInfo getServiceInfo(String sName) {
        return this.getClusterService().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        ArrayList<String> list = new ArrayList<String>();
        Cluster$ClusterService service = this.getClusterService();
        int cServices = service.getServiceInfoCount();
        int i = 0;
        while (i < cServices) {
            ServiceInfo info = service.getServiceInfo(i);
            if (info != null) {
                list.add(info.getServiceName());
            }
            ++i;
        }
        return new SimpleEnumerator<String>(list.toArray(new String[list.size()]));
    }

    public long getShutdownTimeout() {
        return this.__m_ShutdownTimeout;
    }

    public Cluster$SocketManager getSocketManager() {
        return (Cluster$SocketManager)this._findChild("SocketManager");
    }

    public Cluster$PacketSpeaker getSpeaker() {
        return this.__m_Speaker;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public int getState() {
        return this.__m_State;
    }

    public Cluster$PacketListenerBT getTcpBroadcastListener() {
        return this.__m_TcpBroadcastListener;
    }

    public Cluster$PacketListenerBT getTcpBroadcastListenera() {
        return null;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public long getTimeMillis() {
        return this.getClusterService().getTimestamp();
    }

    public TracingShim.Control getTracingControl() {
        return this.__m_TracingControl;
    }

    public Cluster$TransportService getTransportService() {
        return this.__m_TransportService;
    }

    public Cluster$PacketListenerBU getUdpBroadcastListener() {
        return this.__m_UdpBroadcastListener;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster();
    }

    private final Component get_Module() {
        return this;
    }

    public void halt() {
        this.setHalted(true);
        try {
            this.getPublisher().halt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getTransportService().halt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getSocketManager().getBroadcastUdpSocket().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getSocketManager().getBroadcastTcpSocket().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getNameService().halt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getNameServiceBridge().halt();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getSocketManager().releaseSockets();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getClusterService().getTcpRing().close();
        }
        catch (Exception exception) {}
    }

    protected List instantiateWrapperStreamFactoryList(List listNames) {
        ClusterDependencies config = this.getDependencies();
        ArrayList<WrapperStreamFactory> listFilter = new ArrayList<WrapperStreamFactory>();
        Map<String, WrapperStreamFactory> mapFilter = config.getFilterMap();
        Iterator iter = listNames.iterator();
        while (iter.hasNext()) {
            String sName = (String)iter.next();
            WrapperStreamFactory factory = mapFilter.get(sName);
            if (factory == null) {
                Component._trace(new StringBuilder(String.valueOf("Cannot find WrapperStreamFactory for filter-name: ")).append(sName).toString(), 1);
                continue;
            }
            listFilter.add(factory);
        }
        return listFilter;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getDependencies().getAuthorizedHostFilter();
        try {
            return filterHost == null ? true : filterHost.evaluate(addr);
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf(filterHost)).append(" evaluation failed: ").append(e).toString(), 1);
            return false;
        }
    }

    public boolean isClusterPortBound() {
        return this.getTcpBroadcastListener().isStarted() ? true : this.getNameServiceBridge().isForeignBroadcastBound();
    }

    public boolean isClusterPortSharingEnabled() {
        return !(this.getDependencies().getPublisherGroupThreshold() >= 100) ? false : this.getSocketManager().getUnicastUdpSocketProvider().isSecure() ^ true;
    }

    public boolean isCommEndangered(Member member) {
        long lTrintCutoff = this.getPublisher().getMessageOutgoing().getLastIndex() - (long)(Packet.TRINT_MAX_VARIANCE >>> 3);
        PacketIdentifier packetidTo = member.getContiguousToPacketId();
        return packetidTo == null ? true : packetidTo.getFromMessageId() < lTrintCutoff;
    }

    public boolean isHalted() {
        return this.__m_Halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        while (true) {
            switch (this.getState()) {
                case 3: {
                    return true;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            Cluster cluster = this;
            synchronized (cluster) {
                try {
                    Blocking.wait(this, 1000);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    boolean bl = this.getState() == STATE_RUNNING;
                    Object var4_5 = null;
                    return bl;
                }
            }
        }
    }

    public boolean isTransportServiceEnabled() {
        return TRANSPORT_DATAGRAM.equals(this.getDependencies().getReliableTransport()) ^ true;
    }

    public Object lookup(String sName, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) throws NamingException {
        String sPrefix = "Cluster/";
        if (!(sName != null) ? false : sName.startsWith(sPrefix)) {
            if ((sName = sName.substring(sPrefix.length())).equals("info")) {
                return this.toString();
            }
            if (sName.equals("version")) {
                return Coherence.VERSION;
            }
            if (sName.equals("edition")) {
                return Coherence.EDITION_NAMES[((Coherence)Coherence.get_Instance()).getEdition()];
            }
            if (sName.equals("mode")) {
                return Coherence.MODE_NAMES[((Coherence)Coherence.get_Instance()).getMode()];
            }
            if (sName.equals("name")) {
                return this.getClusterService().getClusterName();
            }
            if (sName.equals("size")) {
                return Integer.toString(this.getClusterService().getServiceMemberSet().size());
            }
            if (sName.equals("foreign")) {
                HashSet<String> setClusters = new HashSet<String>();
                Iterator iter = this.getNameService().getDirectory().keySet().iterator();
                while (iter.hasNext()) {
                    sName = (String)iter.next();
                    if (!sName.startsWith(sPrefix = "Cluster/foreign/")) continue;
                    sName = sName.substring(sPrefix.length());
                    setClusters.add(sName.substring(0, sName.indexOf(47)));
                }
                return setClusters;
            }
            if (sName.equals("localMember")) {
                return this.getClusterService().getThisMember();
            }
            if (sName.equals("localDiscoveryInetAddress")) {
                return this.getDependencies().getLocalDiscoveryAddress();
            }
            if (sName.equals("localInetAddress")) {
                return this.getClusterService().getThisMember().getAddress();
            }
            if (sName.equals("IPv4Stack")) {
                return InetAddresses.PreferIPv4Stack;
            }
            if (sName.equals("multicastInetAddress")) {
                return this.getClusterService().isWkaEnabled() ? null : this.getDependencies().getGroupAddress();
            }
        }
        return null;
    }

    protected void onBroadcastPacket(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
        ByteBuffer bufClusterName = this.getClusterNameBuffer();
        int cbName = bufClusterName.remaining();
        int nPos = buffer.position();
        int cbHeader = 4;
        if (!(buffer.remaining() >= cbHeader + cbName) ? false : Buffers.equals(buffer, nPos + cbHeader, bufClusterName, bufClusterName.position(), cbName)) {
            Cluster$PacketReceiver$AddressedBuffer bufferAddr = new Cluster$PacketReceiver$AddressedBuffer();
            bufferAddr.setSourceAddress(addrSrc);
            bufferAddr.setBuffer(buffer);
            this.getReceiver().getQueue().add(bufferAddr);
            Cluster$PacketListenerBU listenerBU = this.getUdpBroadcastListener();
            if (listenerBU.isInGroup()) {
                listenerBU.resetSuspectGroupTimestamp();
            }
        } else {
            this.onForeignPacket(socketIn, addrSrc, buffer);
        }
    }

    public void onException(Throwable e) {
        int nState = this.getState();
        if (nState < STATE_RUNNING) {
            this.setStartException(e);
        }
        if (nState < STATE_STOPPING) {
            try {
                Component._trace(e, "Stopping cluster due to unhandled exception");
            }
            finally {
                Object var4_3 = null;
                this.stop();
            }
        }
    }

    public void onForeignPacket(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
        if (this.isClusterPortSharingEnabled()) {
            BufferManager mgr = this.getReceiver().getBufferManager();
            try {
                try {
                    Cluster$NameService ns = this.getNameService();
                    int nPos = buffer.position();
                    int nLim = buffer.limit();
                    DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
                    int nType = in.readInt();
                    String sCluster = in.readUTF();
                    int nSource = in.readUnsignedShort();
                    short nMsgType = in.readShort();
                    int ofCbMsg = buffer.position() - nPos;
                    short cbMsg = in.readShort();
                    in.close();
                    ((Buffer)buffer).position(nPos).limit(nLim);
                    InetSocketAddress addr = (InetSocketAddress)ns.lookup(new StringBuilder(String.valueOf("Cluster/foreign/")).append(sCluster).append("/Cluster/localAddress").toString());
                    if (addr != null) {
                        Integer NVer;
                        int nVer;
                        if (nMsgType == ClusterService$NewMemberAnnounce.MESSAGE_TYPE && (nVer = (NVer = (Integer)ns.lookup(new StringBuilder(String.valueOf("Cluster/foreign/")).append(sCluster).append("/Cluster/announceVersion").toString())) == null ? 0 : NVer) > 0) {
                            InetSocketAddress addrInetSrc = (InetSocketAddress)addrSrc;
                            InetAddress addrIpSrc = addrInetSrc.getAddress();
                            byte[] abIpSrc = addrIpSrc.getAddress();
                            int cbAbIpSrc = abIpSrc.length;
                            int cbAdd = 4 + cbAbIpSrc + 4;
                            ByteBuffer bufNew = mgr.acquire(buffer.remaining() + cbAdd);
                            ((Buffer)bufNew.put(buffer).putInt(cbAbIpSrc).put(abIpSrc).putInt(addrInetSrc.getPort())).flip();
                            bufNew.putShort(ofCbMsg, (short)(cbMsg + cbAdd));
                            mgr.release(buffer);
                            buffer = bufNew;
                        }
                        socketIn.send(new DatagramPacket(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), addr));
                    }
                }
                catch (Exception e) {
                }
                Object var6_9 = null;
                mgr.release(buffer);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                mgr.release(buffer);
                throw throwable;
            }
        }
        this.getReceiver().getQueue().add(buffer);
    }

    public void onGuardableRecover() {
        this.setGuardRecoverCount(this.getGuardRecoverCount() + 1);
    }

    public void onGuardableTerminate() {
        this.setGuardTerminateCount(this.getGuardTerminateCount() + 1);
    }

    public void onInit() {
        super.onInit();
        this.setPointListener((Cluster$PacketListener1)this._findName("PacketListener1"));
        this.setPreferredListener((Cluster$PacketListener1P)this._findName("PacketListener1P"));
        this.setTcpBroadcastListener((Cluster$PacketListenerBT)this._findName("PacketListenerBT"));
        this.setUdpBroadcastListener((Cluster$PacketListenerBU)this._findName("PacketListenerBU"));
        this.setReceiver((Cluster$PacketReceiver)this._findName("PacketReceiver"));
        this.setPublisher((Cluster$PacketPublisher)this._findName("PacketPublisher"));
        this.setSpeaker((Cluster$PacketSpeaker)this._findName("PacketSpeaker"));
        this.setTransportService((Cluster$TransportService)this._findName("TransportService"));
        this.setNameService((Cluster$NameService)this._findName("NameService"));
        this.setNameServiceBridge((Cluster$NameServiceBridge)this._findName("NameServiceBridge"));
        this.setIpMonitor((Cluster$IpMonitor)this._findName("IpMonitor"));
        this.setGuardian((Cluster$PublicGuardian)this._findName("PublicGuardian"));
        this.setMessagePublisher(this.getPublisher());
        this.setClusterService((Cluster$ClusterService)this._findName("ClusterService"));
        this.setShutdownTimeout(new Millis(Config.getDuration("coherence.shutdown.timeout", new Duration("2m"))).get());
        Cluster$TransportService svcTransport = this.getTransportService();
        this.getClusterService().ensureServiceInfo(1, svcTransport.getServiceName(), ((Grid)svcTransport).getServiceType());
    }

    public void onMemberJoined(Member member) {
        if (this.getDependencies().isIpMonitorEnabled()) {
            this.getIpMonitor().onMemberJoined(member);
        }
    }

    public void onMemberLeft(Member member) {
        this.getPublisher().onMemberLeft(member);
        this.getReceiver().onMemberLeft(member);
        if (this.getDependencies().isIpMonitorEnabled()) {
            this.getIpMonitor().onMemberLeft(member);
        }
    }

    public void onPacket(PacketListener listener, SocketAddress addrSrc, ByteBuffer buffer) {
        int nType;
        if (buffer.remaining() >= 4 && ((nType = buffer.getInt(buffer.position())) & 0xFFFFFFF0) == 0xDDF00D0) {
            switch (nType) {
                case 232718546: {
                    this.onBroadcastPacket(listener.getUdpSocket().getDatagramSocket(), addrSrc, buffer);
                    return;
                }
                case 232718554: {
                    this.getNameService().onDatagramLookup(listener.getUdpSocket().getDatagramSocket(), addrSrc, buffer);
                    return;
                }
            }
            if (!(this.getClusterService().getClusterMemberSet().getMember(addrSrc) != null) ? false : this.getReceiver().getQueue().add(buffer)) {
                return;
            }
        }
        listener.getBufferManager().release(buffer);
    }

    protected void onStart() {
        ClusterDependencies config = this.getDependencies();
        if (config == null) {
            throw new IllegalArgumentException("Cluster dependencies must be set!");
        }
        if (config.isTcmpEnabled() ^ true) {
            throw new UnsupportedOperationException(new StringBuilder(String.valueOf("TCMP clustering has been disabled;")).append(" this configuration may only access clustered services via Extend").append(" proxies.").toString());
        }
        Security.getInstance();
        this.setClusterName(config.getMemberIdentity().getClusterName());
        XmlElement xmlTracing = CacheFactory.getServiceConfig("$Tracing");
        if (xmlTracing != null) {
            this.configureTracing(LegacyXmlTracingHelper.fromXml(xmlTracing, new TracingShim.DefaultDependencies()));
        }
        this.configureSockets();
        this.configureBroadcast();
        try {
            this.getSocketManager().bindSockets();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        this.configureDaemons();
        this.startDaemons();
        this.setState(STATE_JOINING);
        this.startSystemServices();
        this.setState(STATE_RUNNING);
        int nShutdownOption = config.getShutdownHookOption();
        if (nShutdownOption != ClusterDependencies.SHUTDOWN_NONE) {
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.setGraceful(nShutdownOption == ClusterDependencies.SHUTDOWN_GRACEFUL);
                hook.register();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.getResourceRegistry().registerResource(Cluster.__sm2(), this.getGuardian());
    }

    public void registerResource(String sName, Disposable disposable) {
        this.getResourceRegistry().registerResource(Cluster.__sm1(), sName, disposable);
    }

    public void resetPointToPointStats() {
        try {
            Iterator iter = this.getClusterService().getClusterMemberSet().iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(member != null)) continue;
                member.resetStats();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    public void resetStats() {
        this.getPointListener().resetStats();
        this.getPreferredListener().resetStats();
        this.getUdpBroadcastListener().resetStats();
        this.getTcpBroadcastListener().resetStats();
        this.getSpeaker().resetStats();
        this.getPublisher().resetStats();
        this.getReceiver().resetStats();
        this.getClusterService().getTcpRing().resetStats();
        this.setGuardTerminateCount(0);
        this.setGuardRecoverCount(0);
    }

    public void resumeService(String sService) {
        this.getClusterService().doServiceQueiscence(sService, true);
    }

    protected void setClusterName(String sClusterName) {
        Component._assert(sClusterName != null);
        if (this.getClusterService().isStarted()) {
            throw new IllegalStateException("Cluster name cannot be changed.");
        }
        this.__m_ClusterName = sClusterName;
    }

    protected void setClusterNameBuffer(ByteBuffer sProperty) {
        this.__m_ClusterNameBuffer = sProperty;
    }

    protected void setClusterService(Cluster$ClusterService daemon) {
        this.__m_ClusterService = daemon;
    }

    public void setContextClassLoader(ClassLoader loader) {
    }

    public void setDependencies(ClusterDependencies deps) {
        if (!(this.getDependencies() == null)) {
            throw new IllegalStateException("Cluster dependencies cannot be reset");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
    }

    protected void setGuardRecoverCount(int cRecover) {
        this.__m_GuardRecoverCount = cRecover;
    }

    protected void setGuardTerminateCount(int cTerminate) {
        this.__m_GuardTerminateCount = cTerminate;
    }

    protected void setGuardian(Cluster$PublicGuardian daemon) {
        this.__m_Guardian = daemon;
    }

    protected void setHalted(boolean fHalted) {
        this.__m_Halted = fHalted;
    }

    protected void setIpMonitor(Cluster$IpMonitor daemon) {
        this.__m_IpMonitor = daemon;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    protected void setMessagePublisher(MessagePublisher publisher) {
        this.__m_MessagePublisher = publisher;
    }

    public void setNameService(Cluster$NameService serviceName) {
        this.__m_NameService = serviceName;
    }

    public void setNameServiceBridge(Cluster$NameServiceBridge bridgeService) {
        this.__m_NameServiceBridge = bridgeService;
    }

    public void setOperationalContext(OperationalContext operationalContext) {
        this.__m_OperationalContext = operationalContext;
    }

    protected void setPointListener(Cluster$PacketListener1 daemon) {
        this.__m_PointListener = daemon;
    }

    protected void setPreferredListener(Cluster$PacketListener1P daemon) {
        this.__m_PreferredListener = daemon;
    }

    protected void setPublisher(Cluster$PacketPublisher daemon) {
        this.__m_Publisher = daemon;
    }

    protected void setReceiver(Cluster$PacketReceiver daemon) {
        this.__m_Receiver = daemon;
    }

    public void setResourceRegistry(ResourceRegistry sProperty) {
        this.__m_ResourceRegistry = sProperty;
    }

    protected void setShutdownTimeout(long lTimeout) {
        this.__m_ShutdownTimeout = lTimeout;
    }

    protected void setSpeaker(Cluster$PacketSpeaker daemon) {
        this.__m_Speaker = daemon;
    }

    public void setStartException(Throwable e) {
        if (this.getStartException() == null) {
            this.__m_StartException = e;
        }
    }

    protected synchronized void setState(int nState) {
        this.__m_State = nState;
        this.notifyAll();
    }

    protected void setTcpBroadcastListener(Cluster$PacketListenerBT daemon) {
        this.__m_TcpBroadcastListener = daemon;
    }

    protected void setThreadGroup(ThreadGroup threadgroup) {
        Component._assert(this.getState() < STATE_RUNNING);
        this.__m_ThreadGroup = threadgroup;
    }

    public void setTracingControl(TracingShim.Control sProperty) {
        this.__m_TracingControl = sProperty;
    }

    protected void setTransportService(Cluster$TransportService serviceTransport) {
        this.__m_TransportService = serviceTransport;
    }

    protected void setUdpBroadcastListener(Cluster$PacketListenerBU daemon) {
        this.__m_UdpBroadcastListener = daemon;
    }

    protected void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        switch (this.getState()) {
            case 0: {
                this.setState(STATE_EXITED);
                break;
            }
            case 1: 
            case 2: {
                this.start();
            }
            case 3: {
                try {
                    this.checkShutdownPermission();
                    this.setState(STATE_LEAVING);
                    Cluster$ClusterService svcCluster = this.getClusterService();
                    int i = svcCluster.getServiceCount();
                    while (i >= 0) {
                        Grid service = svcCluster.getService(i);
                        if (service != null) {
                            service.shutdown();
                        }
                        --i;
                    }
                }
                finally {
                    Object var2_5 = null;
                    this.stop();
                }
            }
            case 4: 
            case 5: {
                while (this.getState() != STATE_EXITED) {
                    try {
                        Blocking.wait(this);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Unknown State=")).append(this.getState()).toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void start() {
        try {
            switch (this.getState()) {
                case 0: {
                    this.setState(STATE_STARTING);
                    try {
                        this.onStart();
                    }
                    catch (RuntimeException e) {
                        this.setStartException(e);
                        throw e;
                    }
                }
                case 1: 
                case 2: {
                    Throwable e;
                    do {
                        if (!(this.getState() < STATE_RUNNING)) return;
                        try {
                            Blocking.wait(this);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            if (!(this.getStartException() == null)) continue;
                            throw Base.ensureRuntimeException(e2, "Interrupted while waiting for Cluster start");
                        }
                    } while (!((e = this.getStartException()) != null));
                    throw Base.ensureRuntimeException(e);
                }
                case 3: {
                    return;
                }
                case 4: 
                case 5: {
                    throw new IllegalStateException("Cluster is shutting down!");
                }
                case 6: {
                    throw new IllegalStateException("Cluster is dead!");
                }
            }
            throw new IllegalStateException(new StringBuilder(String.valueOf("Unknown State=")).append(this.getState()).toString());
        }
        catch (Throwable e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(e instanceof Error)) throw (RuntimeException)e;
            throw (Error)e;
        }
    }

    protected void startDaemons() {
        ClusterDependencies deps = this.getDependencies();
        if (this.getTransportService().isEnabled() ^ true) {
            this.getPreferredListener().start();
            if (deps.isSpeakerEnabled()) {
                this.getSpeaker().start();
            }
        }
        if (!(deps.getPublisherGroupThreshold() < 100) ? false : this.getClusterService().getWellKnownAddresses() == null) {
            Cluster$PacketListenerBU listenerBU = this.getUdpBroadcastListener();
            listenerBU.joinGroup();
            listenerBU.start();
        }
        this.getPointListener().start();
        this.getReceiver().start();
        this.getPublisher().start();
        if (deps.isIpMonitorEnabled()) {
            this.getIpMonitor().start();
        }
    }

    public void startSystemServices() {
        Cluster$ClusterService svcCluster = this.getClusterService();
        this.bindService(svcCluster);
        svcCluster.start();
        Cluster$TransportService svcTrans = this.getTransportService();
        if (svcTrans.isEnabled()) {
            this.bindService(svcTrans);
            svcTrans.start();
            this.setMessagePublisher(svcTrans.getMessageHandler());
        }
    }

    public synchronized void stop() {
        if (this.getState() != STATE_EXITED) {
            this.checkShutdownPermission();
            this.setState(STATE_STOPPING);
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.unregister();
                this.stopDaemons();
                Cluster$TransportService svcTransport = this.getTransportService();
                if (svcTransport.isRunning()) {
                    ((Grid)svcTransport).stop();
                }
                Cluster$ClusterService daemonClusterService = this.getClusterService();
                int cServices = daemonClusterService.getServiceCount();
                LinkedList<Thread> listThreads = new LinkedList<Thread>();
                Thread threadThis = Thread.currentThread();
                int i = cServices - 1;
                while (i > 0) {
                    Grid service = daemonClusterService.getService(i);
                    if (service != null) {
                        service.stop();
                        Thread thread = service.getThread();
                        if (!(thread != null) ? false : thread != threadThis) {
                            listThreads.add(thread);
                        }
                    }
                    --i;
                }
                long cMillisMax = this.getShutdownTimeout();
                boolean fInterrupted = false;
                Iterator iter = listThreads.iterator();
                while (!(cMillisMax > (long)0) ? false : iter.hasNext()) {
                    Thread thread = (Thread)iter.next();
                    while (!(!thread.isAlive() ? false : fInterrupted ^ true) ? false : cMillisMax > (long)0) {
                        long lStart = Base.getSafeTimeMillis();
                        try {
                            thread.join(1000L);
                        }
                        catch (InterruptedException e) {
                            fInterrupted = true;
                        }
                        cMillisMax -= Base.getSafeTimeMillis() - lStart;
                    }
                }
                Thread threadCluster = daemonClusterService.getThread();
                cMillisMax = 2 * this.getDependencies().getClusterHeartbeatDelayMillis();
                fInterrupted = false;
                daemonClusterService.stop();
                if (!(!(threadCluster != null) ? false : threadCluster != threadThis) ? false : cMillisMax > (long)0) {
                    try {
                        threadCluster.join(cMillisMax);
                    }
                    catch (InterruptedException e) {
                        fInterrupted = true;
                    }
                }
                if (fInterrupted) {
                    threadThis.interrupt();
                }
                this.getSocketManager().releaseSockets();
                this.getResourceRegistry().dispose();
                this.setResourceRegistry(new SimpleResourceRegistry());
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.getSocketManager().releaseSockets();
                TracingShim.Control control = this.getTracingControl();
                if (control != null) {
                    control.close();
                }
                this.setState(STATE_EXITED);
                throw throwable;
            }
            Object var2_3 = null;
            this.getSocketManager().releaseSockets();
            TracingShim.Control control = this.getTracingControl();
            if (control != null) {
                control.close();
            }
            this.setState(STATE_EXITED);
        }
    }

    protected void stopDaemons() {
        this.getPointListener().stop();
        this.getPreferredListener().stop();
        this.getReceiver().stop();
        this.getPublisher().stop();
        this.getSpeaker().stop();
        this.getIpMonitor().stop();
        this.getGuardian().stop();
    }

    public void suspendService(String sService) {
        this.suspendService(sService, false);
    }

    public void suspendService(String sService, boolean fResumeOnFailover) {
        this.getClusterService().doServiceQueiscence(sService, false, fResumeOnFailover);
    }

    public String toString() {
        if (this.getState() == STATE_RUNNING) {
            StringBuffer sb = new StringBuffer();
            ClusterDependencies deps = this.getDependencies();
            String sClusterName = this.getClusterName();
            int nClusterPort = this.getDependencies().getGroupPort();
            sb.append("Name=").append(sClusterName.length() == 0 ? "n/a" : sClusterName).append(", ClusterPort=").append(nClusterPort).append("\n\n");
            AddressProvider providerWka = this.getDependencies().getWellKnownAddresses();
            if (providerWka == null) {
                sb.append("Group{Address=").append(InetAddressHelper.toString(deps.getGroupAddress())).append(", TTL=").append(deps.getGroupTimeToLive()).append('}');
            } else if (providerWka instanceof Set) {
                Set setWka = (Set)((Object)providerWka);
                sb.append("WellKnownAddressList(");
                Iterator iterWka = setWka.iterator();
                while (iterWka.hasNext()) {
                    InetSocketAddress addr = (InetSocketAddress)iterWka.next();
                    sb.append("\n  ").append(InetAddressHelper.toString(addr.getAddress()));
                    int nPort = addr.getPort();
                    if (!(nPort != nClusterPort)) continue;
                    sb.append(":").append(nPort);
                }
                sb.append("\n  )");
            } else {
                sb.append("WellKnownAddressProvider(").append(providerWka).append(")");
            }
            Cluster$ClusterService service = this.getClusterService();
            sb.append("\n\n").append(service.getClusterMemberSet()).append("\n\n").append(service.getTcpRing()).append("\n").append(this.getIpMonitor()).append("\n");
            return sb.toString();
        }
        return new StringBuilder(String.valueOf("Cluster is not running: State=")).append(this.getState()).toString();
    }

    public Disposable unregisterResource(String sName) {
        Disposable disposable = (Disposable)this.getResourceRegistry().getResource(Cluster.__sm1(), sName);
        this.getResourceRegistry().unregisterResource(Cluster.__sm1(), sName);
        return disposable;
    }

    public void waitHeuristicDelivery(int cMillis) {
        Cluster$PacketPublisher publisher = this.getPublisher();
        Queue queueSend = publisher.getQueue();
        PacketPublisher$ResendQueue queueResend = publisher.getResendQueue();
        Thread.yield();
        int i = 0;
        int c = cMillis / 10;
        while (!(i < c) ? false : (!queueSend.isEmpty() ? false : queueResend.isEmpty()) ^ true) {
            try {
                Blocking.sleep(10);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            ++i;
        }
        if (queueSend.isEmpty() ^ true ? true : queueResend.isEmpty() ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Shutdown send queue size=")).append(queueSend.size()).append(" resend queue size=").append(queueResend.size()).toString(), 3);
        }
    }

    public void warnDisabledGuardian(String sContext) {
        Component._trace(new StringBuilder(String.valueOf("Disabling the service-guardian by setting a timeout of 0 has ")).append("been deprecated. Instead, please configure a ").append("\"service-failure-policy\" of \"logging\" which will perform ").append("non-invasive monitoring of Coherence services.\n Configuring ").append("the ").append(sContext).append(" with a \"logging\" policy with a timeout of ").append(DefaultServiceFailurePolicy.DEFAULT_LOGGING_INTERVAL).append("ms").toString(), 2);
    }
}

