/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.io.BufferManager;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.internal.net.MessageComponent;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class Message
extends Net
implements MessageComponent {
    public static final int BUFFER_COUNT_ORDER_BIT = 0x40000000;
    private static final int MASK_DESER_REQ = 2;
    private static final int MASK_NOTIFY = 1;
    private transient Disposable __m_BufferController;
    private transient int __m_BufferUsageCounter;
    private Member __m_FromMember;
    private long __m_FromMessageId;
    private int __m_MessageType;
    private int __m_NullPacketCount;
    private MessagePacket[] __m_Packet;
    private transient Poll __m_Poll;
    private transient ReadBuffer __m_ReadBuffer;
    private Grid __m_Service;
    private MemberSet __m_ToMemberSet;
    private transient long __m_ToMessageId;
    private long __m_ToPollId;
    private SpanContext __m_TracingSpanContext;

    public Message() {
        this(null, null, true);
    }

    public Message(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addToMember(Member member) {
        this.ensureToMemberSet().add(member);
    }

    public Message cloneMessage() {
        Grid service = this.getService();
        if (service == null) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Unable to clone message: ")).append(this).toString());
        }
        return service.instantiateMessage(this.getMessageType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dispatch(Message msg) {
        int nDestination;
        Grid service = msg.getService();
        Member memberFrom = msg.getFromMember();
        if (memberFrom == null && (memberFrom = service.getThisMember()) != null) {
            msg.setFromMember(memberFrom);
        }
        MemberSet setMemberTo = msg.getToMemberSet();
        int LOCAL = 1;
        int REMOTE = 2;
        if (setMemberTo == null) {
            if (msg.isInternal()) {
                nDestination = LOCAL;
                MemberSet.writeBarrier(memberFrom);
            } else {
                if (!(service.getServiceId() == 0)) throw new IllegalStateException(new StringBuilder(String.valueOf("Broadcast Message sent from unexpected")).append(" service ").append(service).append(" (Message=").append(msg).append(")").toString());
                nDestination = REMOTE;
            }
        } else {
            int cMembers = setMemberTo.size();
            if (memberFrom.getId() == 0) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Directed message sent before Member ID obtained: ")).append(msg).toString());
            }
            nDestination = setMemberTo.contains(memberFrom) ? (cMembers == 1 ? LOCAL : LOCAL | REMOTE) : REMOTE;
            if (cMembers > 1) {
                setMemberTo = MemberSet.instantiate(setMemberTo);
                setMemberTo.remove(memberFrom);
                msg.setToMemberSet(setMemberTo);
            }
            setMemberTo.writeBarrier();
        }
        boolean fLocal = !((nDestination & LOCAL) != 0) ? false : service.getQueue().add(msg);
        boolean fRemote = !((nDestination & REMOTE) != 0) ? false : service.getMessagePublisher().post(msg);
        service.setStatsSent(service.getStatsSent() + 1L);
        if (!fLocal) return;
        service.setStatsSentLocal(service.getStatsSentLocal() + 1L);
        if (!(fRemote ^ true)) return;
        msg.notifyDelivery();
    }

    public MemberSet ensureToMemberSet() {
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            setMember = new MemberSet();
            this.setToMemberSet(setMember);
        }
        return setMember;
    }

    public Disposable getBufferController() {
        return this.__m_BufferController;
    }

    public int getBufferUsageCounter() {
        return this.__m_BufferUsageCounter;
    }

    public String getDescription() {
        return null;
    }

    public int getEstimatedByteSize() {
        return (long)1 + this.getToPollId() == 0L ? 0 : 3;
    }

    public Member getFromMember() {
        return this.__m_FromMember;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    public int getMessagePartCount() {
        MessagePacket[] aPacket = this.getPacket();
        return aPacket == null ? 0 : aPacket.length;
    }

    public int getMessageType() {
        return this.__m_MessageType;
    }

    public int getNullPacketCount() {
        return this.__m_NullPacketCount;
    }

    public MessagePacket[] getPacket() {
        return this.__m_Packet;
    }

    public MessagePacket getPacket(int i) {
        return this.getPacket()[i];
    }

    public Poll getPoll() {
        Grid service;
        long lPollId;
        Poll poll = this.__m_Poll;
        if (poll == null && (lPollId = this.getToPollId()) != 0L && (service = this.getService()) != null) {
            poll = (Poll)service.getPollArray().get(lPollId);
            this.setPoll(poll);
        }
        return poll;
    }

    public ReadBuffer getReadBuffer() {
        ReadBuffer buffer = this.__m_ReadBuffer;
        if (buffer != null ? true : this.isDeserializationRequired() ^ true) {
            return buffer;
        }
        int cPackets = this.getMessagePartCount();
        switch (cPackets) {
            case 0: {
                throw new IllegalStateException(new StringBuilder(String.valueOf("empty message: ")).append(this).toString());
            }
            case 1: {
                return new ByteBufferReadBuffer(this.getPacket(0).getByteBuffer());
            }
        }
        ReadBuffer[] arb = new ReadBuffer[cPackets];
        int i = 0;
        while (i < cPackets) {
            arb[i] = new ByteBufferReadBuffer(this.getPacket(i).getByteBuffer());
            ++i;
        }
        return new MultiBufferReadBuffer(arb);
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public MemberSet getToMemberSet() {
        return this.__m_ToMemberSet;
    }

    public long getToMessageId() {
        return this.__m_ToMessageId;
    }

    public long getToPollId() {
        return this.__m_ToPollId;
    }

    public SpanContext getTracingSpanContext() {
        return this.__m_TracingSpanContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Message".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Message();
    }

    private final Component get_Module() {
        return this;
    }

    public Component get_Parent() {
        Component parent = super.get_Parent();
        return parent == null ? this.getService() : parent;
    }

    public boolean isDelivered() {
        return this.getBufferController() == null;
    }

    public boolean isDeserializationRequired() {
        return (this.get_StateAux() & MASK_DESER_REQ) != 0;
    }

    public boolean isInternal() {
        return this.getMessageType() < 0;
    }

    public boolean isNotifyDelivery() {
        return (this.get_StateAux() & MASK_NOTIFY) != 0;
    }

    public boolean isRecipientCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return this.getService().isVersionCompatible(this.getToMemberSet(), nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    public boolean isSenderCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return this.getService().isVersionCompatible(this.getFromMember(), nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    protected void notifyDelivery() {
        if (this.isNotifyDelivery()) {
            this.setNotifyDelivery(false);
            this.getService().onMessageReceipt(this);
        }
    }

    public void onDelivery() {
    }

    public void onInit() {
        super.onInit();
        Component._assert(this.get_Parent() == null, "Message must be instantiated using instantiateMessage() method.");
    }

    public void onReceived() {
    }

    public boolean packetize(PacketPublisher publisher, ServiceMemberSet setMembersBase, ReadBuffer buffer, int cbPreferred, int cbMax) {
        int cbSequelBody;
        int cPackets;
        DependentMemberSet setTo = null;
        int nMemberTo = 0;
        MemberSet setMemberTo = this.getToMemberSet();
        switch (setMemberTo.size()) {
            case 0: {
                return false;
            }
            case 1: {
                nMemberTo = setMemberTo.getFirstId();
                if (!(nMemberTo == 0)) break;
                return false;
            }
            default: {
                setTo = new DependentMemberSet();
                setTo.setBaseSet(setMembersBase);
                setTo.addAll((Collection)setMemberTo);
                break;
            }
        }
        int cbBuffer = buffer.length();
        int cbDirectedBody = Math.min(cbBuffer, MessagePacket.calcBodyLength(Directed.calcHeaderLength(setMemberTo), cbPreferred, cbMax));
        if (cbDirectedBody >= cbBuffer) {
            cPackets = 1;
            cbSequelBody = 0;
        } else {
            cbSequelBody = MessagePacket.calcBodyLength(Sequel.calcHeaderLength(setMemberTo), cbPreferred, cbMax);
            int cbSequel = cbBuffer - cbDirectedBody;
            cPackets = 1 + (cbSequel + cbSequelBody - 1) / cbSequelBody;
        }
        this.setMessagePartCount(cPackets);
        int nMemberFrom = this.getFromMember().getId();
        int nServiceId = this.getService().getServiceId();
        int nMsgType = this.getMessageType();
        Directed packetHead = new Directed();
        if (setTo == null) {
            packetHead.setToId(nMemberTo);
        } else {
            packetHead.setToMemberSet(setTo);
        }
        packetHead.setFromId(nMemberFrom);
        packetHead.setServiceId(nServiceId);
        packetHead.setMessageType(nMsgType);
        packetHead.setMessagePartCount(cPackets);
        packetHead.defineBufferView(buffer, 0, cbDirectedBody);
        this.setPacket(0, packetHead);
        int i = 1;
        int cbWritten = cbDirectedBody;
        while (i < cPackets) {
            Sequel packet = new Sequel();
            if (setTo == null) {
                packet.setToId(nMemberTo);
            } else {
                packet.setToMemberSet((DependentMemberSet)setTo.clone());
            }
            packet.setFromId(nMemberFrom);
            packet.setServiceId(nServiceId);
            packet.setMessageType(nMsgType);
            packet.setMessagePartCount(cPackets);
            int cb = Math.min(cbSequelBody, cbBuffer - cbWritten);
            packet.defineBufferView(buffer, cbWritten, cb);
            cbWritten += cb;
            packet.setMessagePartIndex(i);
            this.setPacket(i, packet);
            ++i;
        }
        return true;
    }

    public void post() {
        this.dispatch(this);
    }

    public boolean preprocess() {
        return false;
    }

    public boolean preprocessSentNotification() {
        return false;
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
    }

    public void readInternal(ReadBuffer.BufferInput input) throws IOException {
        if (input.readBoolean()) {
            int nId = Packet.readUnsignedTrint(input);
            this.setToPollId(Packet.translateTrint(nId, this.getService().getPollArray().getFirstIndex()));
        }
    }

    public Object readObject(ReadBuffer.BufferInput input) throws IOException {
        return this.getService().readObject(input);
    }

    protected void readTracing(ReadBuffer.BufferInput input) throws IOException {
        Map mapSpanCtx;
        if (input.available() > 0 && (!((mapSpanCtx = (Map)ExternalizableHelper.readObject(input)) != null) ? false : mapSpanCtx.isEmpty() ^ true)) {
            this.setTracingSpanContext(TracingHelper.getTracer().extract(mapSpanCtx));
        }
    }

    public void releaseIncoming() {
        Component._assert(this.getBufferUsageCounter() == 1);
        Disposable controller = this.getBufferController();
        if (controller != null) {
            controller.dispose();
        }
        this.setBufferUsageCounter(0);
        this.releasePackets(this.getService().getBufferManager());
    }

    public final void releaseOutgoing(boolean fSuspect) {
        this.releaseOutgoing(fSuspect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutgoing(boolean fSuspect, boolean fOrdered) {
        Disposable controller = this.getBufferController();
        if (controller == null) {
            throw new IllegalStateException();
        }
        int cUsage = this.getBufferUsageCounter();
        if (cUsage == 1) {
            cUsage = fOrdered ? 0 : BUFFER_COUNT_ORDER_BIT;
            this.setBufferUsageCounter(cUsage);
        } else {
            Message message = this;
            synchronized (message) {
                cUsage = this.getBufferUsageCounter() - 1;
                if (fOrdered ^ true) {
                    Component._assert((cUsage & BUFFER_COUNT_ORDER_BIT) == 0);
                    cUsage |= BUFFER_COUNT_ORDER_BIT;
                }
                this.setBufferUsageCounter(cUsage);
            }
        }
        if ((cUsage & ~BUFFER_COUNT_ORDER_BIT) == 0) {
            controller.dispose();
            this.setBufferController(null);
            if (cUsage == 0) {
                this.notifyDelivery();
            }
        } else if (cUsage < 0) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutgoingComplete() {
        if (this.getBufferUsageCounter() == BUFFER_COUNT_ORDER_BIT) {
            this.setBufferUsageCounter(0);
            this.notifyDelivery();
        } else {
            Message message = this;
            synchronized (message) {
                int cUsage = this.getBufferUsageCounter();
                Component._assert((cUsage & BUFFER_COUNT_ORDER_BIT) != 0);
                this.setBufferUsageCounter(cUsage & ~BUFFER_COUNT_ORDER_BIT);
                if (cUsage == BUFFER_COUNT_ORDER_BIT) {
                    this.notifyDelivery();
                }
            }
        }
    }

    public void releasePackets(BufferManager mgr) {
        MessagePacket[] aPacket = this.getPacket();
        if (aPacket != null) {
            int i = 0;
            int c = this.getMessagePartCount();
            while (i < c) {
                mgr.release(aPacket[i].getByteBuffer());
                ++i;
            }
            this.setPacket(null);
        }
    }

    public void respondTo(RequestMessage msg) {
        this.setToMemberSet(SingleMemberSet.instantiate(msg.getFromMember()));
        this.setToPollId(msg.getFromPollId());
    }

    public void setBufferController(Disposable disposableController) {
        this.__m_BufferController = disposableController;
    }

    public void setBufferController(Disposable controller, int cUsage) {
        this.setBufferController(controller);
        this.setBufferUsageCounter(cUsage);
    }

    protected void setBufferUsageCounter(int c) {
        this.__m_BufferUsageCounter = c;
    }

    public void setDeserializationRequired(boolean fRequired) {
        if (fRequired) {
            if (this.getBufferUsageCounter() == 0) {
                this.setBufferUsageCounter(1);
            }
            this.set_StateAux(this.get_StateAux() | MASK_DESER_REQ);
        } else {
            this.set_StateAux(this.get_StateAux() & ~MASK_DESER_REQ);
        }
    }

    public void setFromMember(Member member) {
        this.__m_FromMember = member;
    }

    public void setFromMessageId(long lMsgId) {
        this.__m_FromMessageId = lMsgId;
    }

    public void setMessagePartCount(int cPackets) {
        if (cPackets < 1 ? true : this.getPacket() != null) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("cPackets: ")).append(cPackets).toString());
        }
        this.setPacket(new MessagePacket[cPackets]);
        this.setNullPacketCount(cPackets);
    }

    public void setMessageType(int nType) {
        this.__m_MessageType = nType;
    }

    protected void setNotifyDelivery(boolean fNotify) {
        if (fNotify) {
            this.set_StateAux(this.get_StateAux() | MASK_NOTIFY);
        } else {
            this.set_StateAux(this.get_StateAux() & ~MASK_NOTIFY);
        }
    }

    protected void setNullPacketCount(int cPackets) {
        this.__m_NullPacketCount = cPackets;
    }

    public void setPacket(int i, MessagePacket packet) {
        MessagePacket[] aPacket = this.getPacket();
        if (packet == null) {
            if (aPacket[i] != null) {
                this.setNullPacketCount(this.getNullPacketCount() + 1);
            }
        } else if (aPacket[i] == null) {
            this.setNullPacketCount(this.getNullPacketCount() - 1);
        }
        aPacket[i] = packet;
    }

    public void setPacket(MessagePacket[] aPacket) {
        this.__m_Packet = aPacket;
    }

    protected void setPoll(Poll poll) {
        this.__m_Poll = poll;
    }

    public void setReadBuffer(ReadBuffer buffer) {
        Component._assert(this.getReadBuffer() == null);
        this.__m_ReadBuffer = buffer;
    }

    public void setService(Grid service) {
        this.__m_Service = service;
    }

    public void setToMemberSet(MemberSet setMember) {
        this.__m_ToMemberSet = setMember;
    }

    public void setToMessageId(long lMsgId) {
        this.__m_ToMessageId = lMsgId;
    }

    public void setToPollId(long lPollId) {
        this.__m_ToPollId = lPollId;
    }

    public void setTracingSpanContext(SpanContext contextSpan) {
        this.__m_TracingSpanContext = contextSpan;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fVerbose) {
        int cParts = this.getMessagePartCount();
        int cPending = this.isDeserializationRequired() ? this.getNullPacketCount() : cParts - this.getNullPacketCount();
        StringBuilder sb = new StringBuilder();
        sb.append("Message \"").append(this.get_Name()).append("\"\n  {").append("\n  FromMember=").append(this.getFromMember()).append("\n  FromMessageId=").append(this.getFromMessageId()).append("\n  MessagePartCount=").append(cParts).append("\n  PendingCount=").append(cPending);
        int cBuffers = this.getBufferUsageCounter();
        if (cBuffers == 0) {
            sb.append("\n  Delivered");
        } else if (this.getBufferController() != null) {
            sb.append("\n  BufferCounter=").append(cBuffers);
        }
        sb.append("\n  MessageType=").append(this.getMessageType()).append("\n  ToPollId=").append(this.getToPollId()).append("\n  Poll=").append(this.getPoll());
        if (fVerbose) {
            sb.append("\n  Packets").append("\n    {");
            int cDigts = cParts > 1000 ? 4 : 3;
            int i = 0;
            while (i < cParts) {
                MessagePacket packet = this.getPacket(i);
                if (packet != null) {
                    sb.append("\n    [").append(Base.toDecString(i, cDigts)).append("]=").append(Base.indentString(packet.toString(), "          ", false));
                }
                ++i;
            }
            sb.append("\n    }");
        }
        sb.append("\n  Service=");
        Grid service = this.getService();
        if (service == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString(service.toString(), "    ", false));
        }
        sb.append("\n  ToMemberSet=");
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString(setMember.toString(), "    ", false));
        }
        sb.append("\n  NotifyDelivery=").append(this.isNotifyDelivery());
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append('\n').append(Base.indentString(sDesc, "  "));
        }
        sb.append("\n  }");
        return sb.toString();
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
    }

    public void writeInternal(WriteBuffer.BufferOutput output) throws IOException {
        long lPollId = this.getToPollId();
        boolean fResponse = lPollId != 0L;
        output.writeBoolean(fResponse);
        if (fResponse) {
            Packet.writeTrint(output, lPollId);
        }
    }

    public void writeObject(WriteBuffer.BufferOutput output, Object o) throws IOException {
        this.getService().writeObject(output, o);
    }

    protected void writeTracing(WriteBuffer.BufferOutput output) throws IOException {
        SpanContext ctxSpan = this.getTracingSpanContext();
        Map<String, String> mapSpanCtx = null;
        if (TracingHelper.isNoop(ctxSpan) ^ true) {
            mapSpanCtx = TracingHelper.getTracer().inject(ctxSpan);
        }
        ExternalizableHelper.writeObject(output, mapSpanCtx);
    }
}

