/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.internal.util.HeapDump;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;

public class MessageHandler$Connection
extends Util
implements Guardable {
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 4;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_RELEASED = 5;
    private Guardian.GuardContext __m_Context;
    private Throwable __m_DisconnectCause;
    private boolean __m_Established;
    private BufferSequence __m_LastBadMessage;
    private long __m_LastHealthyTimestamp;
    private long __m_LastHeuristicDeathTimestamp;
    private Member __m_Member;
    private EndPoint __m_Peer;
    private volatile long __m_ReceivedReceiptCount;
    private Continuation __m_ReleaseAction;
    private AtomicLong __m_SentMessageCount;
    private int __m_State;
    private long __m_SuspectReceivedReceiptCount;
    private long __m_SuspectTimeoutTimestamp;

    public MessageHandler$Connection() {
        this(null, null, true);
    }

    public MessageHandler$Connection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_SentMessageCount = new AtomicLong();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean establish() {
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            if (this.getState() >= STATE_DISCONNECTING) {
                return false;
            }
            boolean bl = true;
            if (!bl) {
                return false;
            }
            if (!(this.isEstablished() ^ true)) return true;
            Component._trace(new StringBuilder(String.valueOf("Connection established with ")).append(this.getPeer()).toString(), 3);
            this.setEstablished(true);
            return true;
        }
    }

    public String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "INITIAL";
            }
            case 1: {
                return "CONNECTING";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 4: {
                Throwable t = this.getDisconnectCause();
                return new StringBuilder(String.valueOf("DISCONNECTED")).append(t == null ? "" : new StringBuilder(String.valueOf("(")).append(t).append(")").toString()).toString();
            }
            case 5: {
                return "RELEASED";
            }
        }
        return new StringBuilder(String.valueOf("<unknown> ")).append(nState).toString();
    }

    public Guardian.GuardContext getContext() {
        return this.__m_Context;
    }

    public long getDeliveryTimeoutMillis() {
        int nImportance;
        MessageHandler handler = (MessageHandler)this.get_Module();
        long cMillis = handler.getDeliveryTimeoutMillis();
        Member member = this.getMember();
        if (member != null && ((nImportance = handler.compareImportance(member)) > 0 ? true : (!(nImportance == 0) ? false : handler.getService().getThisMember().getTimestamp() < member.getTimestamp()))) {
            cMillis += cMillis / (long)20;
        }
        return cMillis;
    }

    public Throwable getDisconnectCause() {
        return this.__m_DisconnectCause;
    }

    public BufferSequence getLastBadMessage() {
        return this.__m_LastBadMessage;
    }

    public long getLastHealthyTimestamp() {
        return this.__m_LastHealthyTimestamp;
    }

    public long getLastHeuristicDeathTimestamp() {
        return this.__m_LastHeuristicDeathTimestamp;
    }

    public Member getMember() {
        return this.__m_Member;
    }

    public EndPoint getPeer() {
        return this.__m_Peer;
    }

    public long getReceivedReceiptCount() {
        return this.__m_ReceivedReceiptCount;
    }

    public Continuation getReleaseAction() {
        return this.__m_ReleaseAction;
    }

    public AtomicLong getSentMessageCount() {
        return this.__m_SentMessageCount;
    }

    public int getState() {
        return this.__m_State;
    }

    public long getSuspectReceivedReceiptCount() {
        return this.__m_SuspectReceivedReceiptCount;
    }

    public long getSuspectTimeoutTimestamp() {
        return this.__m_SuspectTimeoutTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/MessageHandler$Connection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MessageHandler$Connection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isEstablished() {
        return this.__m_Established;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReleased() {
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            boolean bl = this.getState() >= STATE_DISCONNECTING;
            return bl;
        }
    }

    public void onDeliveryTimeout() {
        if (this.getState() < STATE_DISCONNECTING) {
            MessageHandler handler = (MessageHandler)this.get_Module();
            EndPoint peer = this.getPeer();
            Component._trace(new StringBuilder(String.valueOf("Disconnecting with ")).append(peer).append(" after failing to deliver a message for ").append(new Duration(handler.getDeliveryTimeoutMillis() * 1000000L)).toString(), 3);
            handler.getMessageBus().disconnect(peer);
        }
    }

    public void onDisconnect(Throwable tReason) {
        MessageHandler handler = (MessageHandler)this.get_Module();
        if (!(this.getState() != STATE_DISCONNECTING) ? false : handler.isClosing() ^ true) {
            String sReason;
            int nImportance;
            Grid service = handler.getService();
            Cluster cluster = (Cluster)service.getCluster();
            long cMillisMax = cluster.getDependencies().getPublisherResendTimeoutMillis() * 3 / 2;
            long cMillisMin = cluster.getIpMonitor().getAddressTimeout() * (long)3 / (long)2;
            long cMillis = cMillisMin == (long)0 ? cMillisMax : Math.max(cMillisMin, cMillisMax >> handler.getHungConnectionIPs().size());
            Member member = this.getMember();
            if (member != null && ((nImportance = service.compareImportance(member)) > 0 ? true : (!(nImportance == 0) ? false : service.getThisMember().getTimestamp() < member.getTimestamp()))) {
                cMillis += cMillis / (long)2;
            }
            if (tReason == null) {
                sReason = "n/a";
            } else {
                sReason = tReason.getMessage();
                if (sReason == null ? true : sReason.length() == 0) {
                    sReason = tReason.getClass().getName();
                }
                Component._trace(Component.getStackTrace(tReason), tReason instanceof SSLException ? 2 : (tReason instanceof IOException ? 9 : 7));
            }
            Component._trace(new StringBuilder(String.valueOf("Detected disconnect (")).append(sReason).append(") of ").append(this).append(" awaiting ServiceLeft notification with timeout of ").append(new Duration(cMillis * 1000000L)).append(" based on ").append(((MessageHandler)this.get_Module()).getDisconnectCounter()).append(" concurrent disconnects").toString(), tReason instanceof SSLException ? 2 : 7);
            service.guard(this, cMillis, 1.0f);
        }
        this.setState(STATE_DISCONNECTED);
        this.setDisconnectCause(tReason);
    }

    public void onIdle() {
    }

    public void onInterval() {
        long ldtNow = Base.getLastSafeTimeMillis();
        long cRecNow = this.getReceivedReceiptCount();
        long cRecLast = this.getSuspectReceivedReceiptCount();
        this.setSuspectReceivedReceiptCount(cRecNow);
        if (cRecNow > cRecLast) {
            long ldtLast = this.getSuspectTimeoutTimestamp();
            if (!(ldtLast != (long)0) ? false : ldtNow - ldtLast > this.getDeliveryTimeoutMillis() / (long)2) {
                this.setLastHeuristicDeathTimestamp(ldtNow);
            }
            this.setSuspectTimeoutTimestamp(0L);
            this.setLastHealthyTimestamp(ldtNow);
        } else if (cRecNow < this.getSentMessageCount().get()) {
            long ldtTimeout = this.getSuspectTimeoutTimestamp();
            if (ldtTimeout == 0L) {
                this.setSuspectTimeoutTimestamp(ldtNow + this.getDeliveryTimeoutMillis());
            } else if (ldtNow > ldtTimeout) {
                this.onDeliveryTimeout();
            }
        } else {
            this.onIdle();
        }
    }

    public void onReleased() {
        Continuation action;
        if (this.getState() != STATE_DISCONNECTED) {
            Component._trace(new StringBuilder(String.valueOf("Unexpected RELEASE event: ")).append(this).toString(), 1);
        }
        this.setState(STATE_RELEASED);
        Guardian.GuardContext context = this.getContext();
        if (context != null) {
            context.release();
        }
        if ((action = this.getReleaseAction()) != null) {
            this.setReleaseAction(null);
            action.proceed(null);
        }
    }

    public Message prepareMessage(BufferSequence bufseq) throws IOException {
        Grid service;
        MessageHandler handler = (MessageHandler)this.get_Module();
        ReadBuffer buffer = handler.createReadBuffer(bufseq);
        ReadBuffer.BufferInput input = buffer.getBufferInput();
        short nService = input.readShort();
        short nMsgType = input.readShort();
        input.setOffset(0);
        try {
            service = handler.getServiceById(nService);
        }
        catch (RuntimeException e) {
            this.setLastBadMessage(bufseq);
            String sDump = HeapDump.dumpHeapForBug("SR-3-15874362211");
            this.setLastBadMessage(null);
            throw new IllegalStateException(new StringBuilder(String.valueOf("Heap dump ")).append(sDump).append(" has been generated due to an invalid service id ").append(nService).append(" from ").append(this).append(" received in message: ").append(Buffers.toString(bufseq, true, 1024)).toString(), e);
        }
        if (service == null) {
            Component._trace(new StringBuilder(String.valueOf("Ignoring message from ")).append(this).append(" for locally stopped service ").append(nService).toString(), 3);
            return null;
        }
        try {
            Message msg = service.instantiateMessage(nMsgType);
            msg.setFromMember(this.getMember());
            msg.setReadBuffer(buffer);
            msg.setDeserializationRequired(true);
            if ((service.isAcceptingOthers() ? true : service == handler.getService()) && service.deserializeMessage(msg) ^ true) {
                msg = null;
            }
            return msg;
        }
        catch (RuntimeException e) {
            Component._trace(new StringBuilder(String.valueOf("Received corrupted message from ")).append(this).append(" content ").append(Buffers.toString(bufseq, true, 1024 * 1024)).toString(), 1);
            throw e;
        }
    }

    public void recover() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Continuation continuation) {
        boolean fEstablished;
        int nState = this.getState();
        if (nState < STATE_DISCONNECTING) {
            this.setState(STATE_DISCONNECTING);
        } else {
            Component._assert(nState < STATE_RELEASED);
        }
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            fEstablished = this.isEstablished();
        }
        if (fEstablished) {
            this.setReleaseAction(continuation);
        } else if (continuation != null) {
            continuation.proceed(null);
        }
        ((MessageHandler)this.get_Module()).getMessageBus().release(this.getPeer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(Guardian.GuardContext context) {
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            Member member = this.getMember();
            if (member != null) {
                if (this.getContext() == null) {
                    if (context != null) {
                        ((MessageHandler)this.get_Module()).getHungConnectionIPs().put(member.getAddress(), null);
                    }
                } else if (context == null) {
                    ((MessageHandler)this.get_Module()).getHungConnectionIPs().remove(member.getAddress());
                }
            }
            this.__m_Context = context;
        }
    }

    public void setDisconnectCause(Throwable tCause) {
        this.__m_DisconnectCause = tCause;
    }

    protected void setEstablished(boolean fEstablished) {
        this.__m_Established = fEstablished;
    }

    public void setLastBadMessage(BufferSequence sequenceMessage) {
        this.__m_LastBadMessage = sequenceMessage;
    }

    public void setLastHealthyTimestamp(long lTimestamp) {
        this.__m_LastHealthyTimestamp = lTimestamp;
    }

    protected void setLastHeuristicDeathTimestamp(long lTimestamp) {
        this.__m_LastHeuristicDeathTimestamp = lTimestamp;
    }

    public void setMember(Member member) {
        Component._assert(!(member != null) ? false : this.getMember() == null, "Not resettable");
        this.__m_Member = member;
    }

    public void setPeer(EndPoint peer) {
        Component._assert(peer != null);
        Component._assert(this.getPeer() == null ? true : this.getPeer().equals(peer), "Not resettable");
        this.__m_Peer = peer;
    }

    public void setReceivedReceiptCount(long atomicCount) {
        this.__m_ReceivedReceiptCount = atomicCount;
    }

    public void setReleaseAction(Continuation cont) {
        this.__m_ReleaseAction = cont;
    }

    private void setSentMessageCount(AtomicLong atomicCount) {
        this.__m_SentMessageCount = atomicCount;
    }

    public void setState(int nState) {
        this.__m_State = nState;
    }

    protected void setSuspectReceivedReceiptCount(long lTimestamp) {
        this.__m_SuspectReceivedReceiptCount = lTimestamp;
    }

    protected void setSuspectTimeoutTimestamp(long lTimestamp) {
        this.__m_SuspectTimeoutTimestamp = lTimestamp;
    }

    public void terminate() {
        MessageHandler handler = (MessageHandler)this.get_Module();
        Grid service = handler.getService();
        Component._trace(new StringBuilder(String.valueOf("This member has been unexpectedly disconnected from members on ")).append(Math.max(1, handler.getHungConnectionIPs().size())).append(" machines running service ").append(service.getServiceName()).append("; stopping service").toString(), 1);
        Throwable tReason = this.getDisconnectCause();
        if (tReason != null) {
            Component._trace(tReason);
        }
        service.stop();
    }

    public String toString() {
        long ldtLast = this.getLastHealthyTimestamp();
        long ldtStuck = this.getLastHeuristicDeathTimestamp();
        long ldtNow = Base.getSafeTimeMillis();
        long ldtNext = this.getSuspectTimeoutTimestamp();
        Member member = this.getMember();
        EndPoint peer = this.getPeer();
        MessageHandler handler = (MessageHandler)this.get_Module();
        return new StringBuilder(String.valueOf(this.get_Name())).append(" {Peer=").append(peer).append(", Service=").append(handler.getService().getServiceName()).append(", Member=").append(member == null ? 0 : member.getId()).append(this.isEstablished() ? "" : ", Not established").append(", State=").append(this.formatStateName(this.getState())).append(ldtLast == (long)0 ? "" : new StringBuilder(String.valueOf(", lastAck=")).append(new Duration((ldtNow - ldtLast) * 1000000L)).toString()).append(ldtStuck == (long)0 ? "" : new StringBuilder(String.valueOf(", lastStuck=")).append(new Duration((ldtNow - ldtStuck) * 1000000L)).toString()).append(ldtNext == (long)0 ? "" : new StringBuilder(String.valueOf(", pendingAckTimeout=")).append(new Duration(Math.max((long)0, ldtNext - ldtNow) * 1000000L)).toString()).append(", ").append(handler.getMessageBus().toString(peer)).append("}").toString();
    }
}

