/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.internal.util.HeapDump;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PacketBundle
extends Net {
    private transient int __m_AddressCount;
    private transient Object __m_Addresses;
    private transient int __m_Length;
    private int __m_MaximumLength;
    private transient int __m_PacketCount;
    private Object __m_Packets;
    private UdpSocket __m_UdpSocket;

    public PacketBundle() {
        this(null, null, true);
    }

    public PacketBundle(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addDestination(SocketAddress address) {
        int cAddresses = this.getAddressCount();
        switch (cAddresses) {
            case 0: {
                this.setAddresses(address);
                break;
            }
            case 1: {
                SocketAddress address0 = (SocketAddress)this.getAddresses();
                ArrayList<SocketAddress> list = new ArrayList<SocketAddress>(8);
                list.add(address0);
                list.add(address);
                this.setAddresses(list);
                break;
            }
            default: {
                ((ArrayList)this.getAddresses()).add(address);
                break;
            }
        }
        this.setAddressCount(cAddresses + 1);
    }

    public void addDestinations(Collection colAddr) {
        Iterator iter = colAddr.iterator();
        while (iter.hasNext()) {
            this.addDestination((SocketAddress)iter.next());
        }
    }

    public void addPacket(Packet packet) {
        int cPackets = this.getPacketCount();
        switch (cPackets) {
            case 0: {
                this.setPackets(packet);
                break;
            }
            case 1: {
                Packet packet0 = (Packet)this.getPackets();
                ArrayList<Packet> list = new ArrayList<Packet>(8);
                list.add(packet0);
                list.add(packet);
                this.setPackets(list);
                break;
            }
            default: {
                ((ArrayList)this.getPackets()).add(packet);
                break;
            }
        }
        this.setPacketCount(cPackets + 1);
        this.setLength(this.getLength() + packet.getLength());
    }

    public boolean append(PacketBundle bundle) {
        int cbMax;
        int cbTotal = this.getLength() + bundle.getLength();
        if (!(cbTotal <= (cbMax = Math.min(bundle.getMaximumLength(), this.getMaximumLength()))) ? false : this.isCommonDestination(bundle)) {
            int cPackets = bundle.getPacketCount();
            if (cPackets > 1) {
                ArrayList listPackets = (ArrayList)bundle.getPackets();
                int i = 0;
                while (i < cPackets) {
                    this.addPacket((Packet)listPackets.get(i));
                    ++i;
                }
            } else {
                this.addPacket((Packet)bundle.getPackets());
            }
            this.setMaximumLength(cbMax);
            return true;
        }
        return false;
    }

    public SocketAddress getAddress(int i) {
        Object oAddresses = this.getAddresses();
        if (this.getAddressCount() == 1) {
            if (i == 0) {
                return (SocketAddress)oAddresses;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return (SocketAddress)((ArrayList)oAddresses).get(i);
    }

    public int getAddressCount() {
        return this.__m_AddressCount;
    }

    public String getAddressDescription() {
        StringBuilder sb = new StringBuilder(91);
        int i = 0;
        int c = this.getAddressCount();
        while (i < c) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.getAddress(i));
            ++i;
        }
        return sb.append(']').toString();
    }

    protected Object getAddresses() {
        return this.__m_Addresses;
    }

    public int getLength() {
        return this.__m_Length;
    }

    public int getMaximumLength() {
        return this.__m_MaximumLength;
    }

    public Packet getPacket(int i) {
        if (this.getPacketCount() == 1) {
            if (i == 0) {
                return (Packet)this.getPackets();
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Packet)((ArrayList)this.getPackets()).get(i);
    }

    public int getPacketCount() {
        return this.__m_PacketCount;
    }

    protected Object getPackets() {
        return this.__m_Packets;
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/PacketBundle".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketBundle();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean hasDestinations() {
        return this.getAddressCount() > 0;
    }

    protected boolean isCommonDestination(PacketBundle bundle) {
        int cAddresses = this.getAddressCount();
        return !(cAddresses == bundle.getAddressCount()) ? false : Base.equals(this.getAddresses(), bundle.getAddresses());
    }

    public void send() {
        this.getUdpSocket().send(this);
    }

    protected void setAddressCount(int cAddresses) {
        this.__m_AddressCount = cAddresses;
    }

    protected void setAddresses(Object oAddresses) {
        this.__m_Addresses = oAddresses;
    }

    protected void setLength(int nLength) {
        this.__m_Length = nLength;
    }

    public void setMaximumLength(int cb) {
        this.__m_MaximumLength = cb;
    }

    protected void setPacketCount(int cPackets) {
        this.__m_PacketCount = cPackets;
    }

    protected void setPackets(Object oPackets) {
        this.__m_Packets = oPackets;
    }

    public void setUdpSocket(UdpSocket socket) {
        this.__m_UdpSocket = socket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.get_Name()).append("@").append(this.hashCode()).append(", socket=").append(this.getUdpSocket()).append(", address=").append(this.getAddressDescription()).append(", Payload={ ");
        int i = 0;
        int c = this.getPacketCount();
        while (i < c) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.getPacket(i));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public int write(WriteBuffer.BufferOutput output) throws IOException {
        int cPackets = this.getPacketCount();
        switch (cPackets) {
            case 0: {
                break;
            }
            case 1: {
                ((Packet)this.getPackets()).write(output);
                break;
            }
            default: {
                ArrayList list = (ArrayList)this.getPackets();
                int i = 0;
                while (i < cPackets) {
                    ((Packet)list.get(i)).write(output);
                    ++i;
                }
                break block0;
            }
        }
        int of = output.getOffset();
        if (of > this.getLength()) {
            String sDump = HeapDump.dumpHeapForBug("Bug25908156");
            StringBuilder sb = new StringBuilder();
            if (cPackets == 1) {
                sb.append(((Packet)this.getPackets()).toString());
            } else if (cPackets > 1) {
                ArrayList list = (ArrayList)this.getPackets();
                int i = 0;
                while (i < cPackets) {
                    sb.append(" packet").append(i).append(":");
                    sb.append(((Packet)list.get(i)).toString());
                    ++i;
                }
            }
            throw new IllegalStateException(String.format(new StringBuilder(String.valueOf("HeapDump ")).append(sDump).append(" has been generated due to illegal buffer offset in writing packet; ").append("(offset: %d, length: %d, packet-count: %d, class: %s, output: %s, packets: %s)").toString(), of, this.getLength(), cPackets, output.getClass().getName(), output, sb));
        }
        return of;
    }
}

