/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Connector$Announce;
import com.tangosol.coherence.component.net.management.Connector$ExecuteFunction;
import com.tangosol.coherence.component.net.management.Connector$InvokeRemote;
import com.tangosol.coherence.component.net.management.Connector$LookupCallback;
import com.tangosol.coherence.component.net.management.Connector$Notify;
import com.tangosol.coherence.component.net.management.Connector$Publish;
import com.tangosol.coherence.component.net.management.Connector$Register;
import com.tangosol.coherence.component.net.management.Connector$Subscribe;
import com.tangosol.coherence.component.net.management.Connector$Unregister;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.listenerHolder.LocalHolder;
import com.tangosol.coherence.component.net.management.listenerHolder.RemoteHolder;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.management.model.localModel.wrapperModel.WrapperJmxModel;
import com.tangosol.coherence.component.net.management.notificationHandler.RemoteHandler;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.discovery.NSLookup;
import com.tangosol.internal.net.management.ConnectorDependencies;
import com.tangosol.internal.net.management.DefaultConnectorDependencies;
import com.tangosol.internal.net.management.HttpHelper;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.InvocationService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NameService;
import com.tangosol.net.management.MBeanConnector;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class Connector
extends Management
implements MemberListener,
NameService.Resolvable,
SynchronousListener {
    private boolean __m_Announced;
    private JMXConnectorServer __m_ConnectorServer;
    private ConnectorDependencies __m_Dependencies;
    private boolean __m_HttpManagingDynamic;
    private boolean __m_HttpManagingNode;
    private Collection __m_JmxListenAddresses;
    private JMXServiceURL __m_JmxServiceUrl;
    private Local __m_LocalGateway;
    private Map __m_LocalRegistry;
    private boolean __m_ManagingDynamic;
    private boolean __m_ManagingNode;
    private long __m_RefreshAttributeTimeoutMillis;
    private Map __m_RemoteModels;
    private Set __m_RemoteServers;
    private long __m_RequestTimeout;
    private InvocationService __m_Service;
    private long __m_StatsNotificationCount;
    private long __m_StatsRefreshCount;
    private long __m_StatsRefreshExcessCount;
    private long __m_StatsRefreshPredictionCount;
    private long __m_StatsRefreshTimeoutCount;
    private ThreadLocal __m_ThreadLocalContinuation;
    private static ListMap __mapChildren;
    private static transient String __s_MsgFailure;

    static {
        Connector.__initStatic();
    }

    public Connector() {
        this(null, null, true);
    }

    public Connector(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalRegistry(new SafeHashMap());
            this.setRefreshAttributeTimeoutMillis(250L);
            this.setRemoteModels(new ConcurrentHashMap());
            this.setRemoteServers(new SafeHashSet());
            this.setThreadLocalContinuation(new ThreadLocal());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Announce", Connector$Announce.get_CLASS());
        Class clazz2 = __mapChildren.put("ExecuteFunction", Connector$ExecuteFunction.get_CLASS());
        Class clazz3 = __mapChildren.put("InvokeRemote", Connector$InvokeRemote.get_CLASS());
        Class clazz4 = __mapChildren.put("LookupCallback", Connector$LookupCallback.get_CLASS());
        Class clazz5 = __mapChildren.put("Notify", Connector$Notify.get_CLASS());
        Class clazz6 = __mapChildren.put("Publish", Connector$Publish.get_CLASS());
        Class clazz7 = __mapChildren.put("Register", Connector$Register.get_CLASS());
        Class clazz8 = __mapChildren.put("Subscribe", Connector$Subscribe.get_CLASS());
        Class clazz9 = __mapChildren.put("Unregister", Connector$Unregister.get_CLASS());
    }

    protected void announce(InvocationService service) {
        com.tangosol.net.Member memberThis = service.getCluster().getLocalMember();
        Set setOther = service.getInfo().getServiceMembers();
        setOther.remove(memberThis);
        Connector$Announce task = (Connector$Announce)this._newChild("Announce");
        task.setMemberFrom(memberThis.getId());
        task.setManagingNode(this.isManagingNode());
        service.execute(task, setOther, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assumeManagement() {
        JMXConnectorServer jmxServer;
        SafeCluster cluster = this.getCluster();
        Remote gatewayRemote = (Remote)cluster.getManagement();
        gatewayRemote.transitionToManaging();
        JMXServiceURL jmxUrl = this.getLocalGateway().getServiceUrl();
        if (jmxUrl == null && (jmxServer = this.jmxStartConnector()) != null) {
            this.setConnectorServer(jmxServer);
            jmxUrl = jmxServer.getAddress();
        }
        if (jmxUrl != null) {
            Connector connector = this;
            synchronized (connector) {
                this.setJmxServiceUrl(jmxUrl);
                InetAddress addrDisc = cluster.getDependencies().getLocalDiscoveryAddress();
                this.setJmxListenAddresses(addrDisc.isAnyLocalAddress() ? InetAddresses.getLocalBindableAddresses() : Collections.singleton(addrDisc));
            }
            this.jmxPublishConnector(null);
        }
    }

    protected com.tangosol.net.Member chooseRemoteServer(int nAction) {
        Set setServers = this.getRemoteServers();
        if (setServers.isEmpty()) {
            throw new RuntimeException("None of the nodes are managed");
        }
        String sReason = null;
        Iterator iter = setServers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            switch (nAction) {
                case 4: {
                    if (this.isVersionCompatible(member, 12, 2, 1, 1, 0)) {
                        return member;
                    }
                    sReason = "queryNames(...) method";
                    break;
                }
                case 7: {
                    if (this.isVersionCompatible(member, 12, 2, 1, 4, 0)) {
                        return member;
                    }
                    sReason = "addNotificationListener(...) method";
                    break;
                }
                default: {
                    return member;
                }
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(String.valueOf("All managed nodes running an older version that does not support ")).append(sReason).toString());
    }

    public DefaultConnectorDependencies cloneDependencies(ConnectorDependencies deps) {
        return new DefaultConnectorDependencies(deps);
    }

    public Connector$InvokeRemote createExecuteRequest(Remote.Function function) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_EXECUTE);
        task.setFunction(function);
        return task;
    }

    public Connector$InvokeRemote createFindOwnerRequest(String sName) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_FIND_OWNER);
        task.setName(sName);
        return task;
    }

    public Connector$InvokeRemote createGetMBeanInfoRequest(String sName) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_MBEAN_INFO);
        task.setName(sName);
        return task;
    }

    public Connector$InvokeRemote createGetRequest(String sName, Filter filter) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_GET);
        task.setName(sName);
        task.setQueryFilter(filter);
        return task;
    }

    public Connector$InvokeRemote createGetRequest(String sName, String sAttr) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_GET);
        task.setName(sName);
        task.setAttributeName(sAttr);
        return task;
    }

    public Connector$InvokeRemote createInvokeRequest(String sName, String sMethod, Object[] aoParam, String[] asSignature) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_INVOKE);
        task.setName(sName);
        task.setMethodName(sMethod);
        task.setParameters(aoParam);
        task.setSignatures(asSignature);
        return task;
    }

    public Connector$InvokeRemote createIsRegisteredRequest(String sName) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_CHECK);
        task.setName(sName);
        return task;
    }

    public Connector$InvokeRemote createQueryRequest(String sPattern, Filter filter) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_QUERY);
        task.setQueryPattern(sPattern);
        task.setQueryFilter(filter);
        return task;
    }

    public Connector$InvokeRemote createSetRequest(String sName, String sAttr, Object oValue) {
        Connector$InvokeRemote task = (Connector$InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(Connector$InvokeRemote.ACTION_SET);
        task.setName(sName);
        task.setAttributeName(sAttr);
        task.setAttributeValue(oValue);
        return task;
    }

    public LocalModel ensureFreshSnapshot(RemoteModel model) {
        int nPolicy = this.getRefreshPolicy();
        if (nPolicy == ConnectorDependencies.REFRESH_ONQUERY) {
            model.acquireExecuteMutex(this.getRefreshRequestTimeoutMillis());
            model.releaseExecuteMutex();
        } else if (model.isRefreshRequired()) {
            this.setStatsRefreshCount(this.getStatsRefreshCount() + 1L);
            if (model.isAccessed() ^ true) {
                this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
            }
            switch (nPolicy) {
                case 0: {
                    model.invokeRemote(RemoteModel.OP_GET, null, null);
                    break;
                }
                case 1: {
                    model.invokeRemote(RemoteModel.OP_GET, null, null);
                    this.refreshActiveModels(model);
                    break;
                }
                case 2: {
                    boolean fInvoked = model.invokeRemoteAsync();
                    if (!fInvoked) break;
                    this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + 1L);
                    break;
                }
            }
        }
        return model.getSnapshot();
    }

    public RemoteModel ensureRemoteModel(String sName, int nMember) {
        Map mapModel = this.getRemoteModels();
        RemoteModel modelRemote = (RemoteModel)mapModel.get(sName);
        if (modelRemote == null) {
            com.tangosol.net.Member member = nMember > 0 ? this.getMember(nMember) : this.findModelOwner(sName);
            if (member == null) {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unable to locate owning Member for MBean ")).append(sName).toString());
            }
            modelRemote = new RemoteModel();
            mapModel.put(sName, modelRemote);
            modelRemote.set_ModelName(sName);
            modelRemote.setConnector(this);
            modelRemote.setAccessed(false);
            modelRemote.setModelOwner(member);
        }
        return modelRemote;
    }

    public void extractMemberId(String sName) {
    }

    public com.tangosol.net.Member findModelOwner(String sName) {
        if (this.isRegisteredModel(sName)) {
            return this.getMember(this.getLocalMemberId());
        }
        Connector$InvokeRemote task = this.createFindOwnerRequest(sName);
        Integer NOwnerId = (Integer)this.sendProxyRequest(task);
        return NOwnerId == null ? null : this.getMember(NOwnerId);
    }

    public String formatRefreshPolicy(int nPolicy) {
        switch (nPolicy) {
            case 0: {
                return "refresh-expired";
            }
            case 1: {
                return "refresh-ahead";
            }
            case 2: {
                return "refresh-behind";
            }
            case 3: {
                return "refresh-onquery";
            }
        }
        return "n/a";
    }

    public SafeCluster getCluster() {
        InvocationService service = this.getService();
        return service == null ? Coherence.getCluster() : (SafeCluster)service.getCluster();
    }

    public JMXConnectorServer getConnectorServer() {
        return this.__m_ConnectorServer;
    }

    public ConnectorDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public com.tangosol.net.Member getDynamicSenior() {
        com.tangosol.net.Member memberOldest = null;
        long ldtOldest = Long.MAX_VALUE;
        SafeService service = (SafeService)((Object)this.getService());
        Grid _service = (Grid)service.getService();
        Member memberThis = _service.getThisMember();
        ServiceMemberSet setMember = _service.getServiceMemberSet();
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            long ldt;
            com.tangosol.net.Member member = (com.tangosol.net.Member)iter.next();
            int nMember = member.getId();
            boolean fDynamic = member == memberThis ? this.isManagingDynamic() : Boolean.TRUE.equals((Boolean)setMember.getMemberConfigMap(nMember).get("dynamic-management"));
            if (!fDynamic || !((ldt = setMember.getServiceJoinTime(nMember)) < ldtOldest)) continue;
            memberOldest = member;
            ldtOldest = ldt;
        }
        return memberOldest;
    }

    public Continuation getInvokeContinuation() {
        return (Continuation)this.getThreadLocalContinuation().get();
    }

    public Collection getJmxListenAddresses() {
        return this.__m_JmxListenAddresses;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.__m_JmxServiceUrl;
    }

    public Local getLocalGateway() {
        return this.__m_LocalGateway;
    }

    public int getLocalMemberId() {
        SafeCluster cluster = this.getCluster();
        return cluster == null ? 0 : cluster.getLocalMember().getId();
    }

    public Map getLocalRegistry() {
        return this.__m_LocalRegistry;
    }

    public Member getMember(int nId) {
        Grid service;
        SafeService serviceSafe = (SafeService)((Object)this.getService());
        if (serviceSafe != null && (!((service = (Grid)serviceSafe.getService()) != null) ? false : service.isRunning())) {
            return service.getServiceMemberSet().getMember(nId);
        }
        return null;
    }

    private static String getMsgFailure() {
        return __s_MsgFailure;
    }

    protected NameService getNameService() {
        return this.getCluster().getCluster().getNameService();
    }

    public long getRefreshAttributeTimeoutMillis() {
        return this.__m_RefreshAttributeTimeoutMillis;
    }

    public int getRefreshPolicy() {
        return this.getDependencies().getRefreshPolicy();
    }

    public long getRefreshRequestTimeoutMillis() {
        return this.getDependencies().getRefreshRequestTimeoutMillis();
    }

    public long getRefreshTimeoutMillis() {
        return this.getDependencies().getRefreshTimeoutMillis();
    }

    public Map getRemoteModels() {
        return this.__m_RemoteModels;
    }

    public Set getRemoteServers() {
        return this.__m_RemoteServers;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public InvocationService getService() {
        return this.__m_Service;
    }

    public long getStatsNotificationCount() {
        return this.__m_StatsNotificationCount;
    }

    public long getStatsRefreshCount() {
        return this.__m_StatsRefreshCount;
    }

    public long getStatsRefreshExcessCount() {
        return this.__m_StatsRefreshExcessCount;
    }

    public long getStatsRefreshPredictionCount() {
        return this.__m_StatsRefreshPredictionCount;
    }

    public long getStatsRefreshTimeoutCount() {
        return this.__m_StatsRefreshTimeoutCount;
    }

    public ThreadLocal getThreadLocalContinuation() {
        return this.__m_ThreadLocalContinuation;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/Connector".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Connector();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAnnounced() {
        return this.__m_Announced;
    }

    public boolean isHttpManagingDynamic() {
        return this.__m_HttpManagingDynamic;
    }

    public boolean isHttpManagingNode() {
        return this.__m_HttpManagingNode;
    }

    public boolean isManagingDynamic() {
        return this.__m_ManagingDynamic;
    }

    public boolean isManagingNode() {
        return this.__m_ManagingNode;
    }

    public boolean isRegisteredModel(String sName) {
        return this.getLocalRegistry().containsKey(sName);
    }

    public boolean isStarted() {
        return this.getService() != null;
    }

    protected boolean isVersionCompatible(Member member, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        Grid service;
        SafeService serviceSafe = (SafeService)((Object)this.getService());
        if (serviceSafe != null && (!((service = (Grid)serviceSafe.getService()) != null) ? false : service.isRunning())) {
            return service.isVersionCompatible(member, nMajor, nMinor, nMicro, nPatchSet, nPatch);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jmxPublishConnector(Set setMembers) {
        InvocationService service = this.getService();
        Connector$Publish task = (Connector$Publish)this._newChild("Publish");
        Connector connector = this;
        synchronized (connector) {
            task.setJMXServiceURL(this.getJmxServiceUrl());
            task.setListenAddresses(this.getJmxListenAddresses());
        }
        service.execute(task, setMembers, null);
    }

    protected JMXConnectorServer jmxStartConnector() {
        int nPort;
        Cluster cluster = this.getCluster().getCluster();
        InetAddress addrDisc = cluster.getDependencies().getLocalDiscoveryAddress();
        InetAddress addrMember = cluster.getLocalMember().getAddress();
        InetAddress addrRMI = addrDisc.isAnyLocalAddress() ? (InetAddresses.isLocalAddress(addrMember) ? addrDisc : addrMember) : addrDisc;
        String sAddr = Config.getProperty(MBeanConnector.RMI_HOST_PROPERTY, addrRMI.getHostAddress());
        HashMap<String, String> mapEnv = new HashMap<String, String>();
        int nPortMax = MBeanConnector.getConnectionPortMax();
        if (cluster.getSocketManager().getUnicastUdpSocketProvider().isSecure()) {
            mapEnv.put("com.oracle.coherence.tcmp.ssl", "true");
            nPort = MBeanConnector.getConnectionPort();
        } else {
            String sPort = Config.getProperty(MBeanConnector.RMI_CONNECTION_PORT_PROPERTY);
            nPort = sPort == null ? cluster.getLocalMember().getPort() : MBeanConnector.getConnectionPort();
        }
        Exception eLast = null;
        while (true) {
            try {
                JMXConnectorServer connector = MBeanHelper.startRmiConnector(sAddr, 0, nPort, this.getLocalGateway().getServer(), mapEnv);
                Component._trace(new StringBuilder(String.valueOf("JMXConnectorServer now listening for connections on ")).append(InetAddresses.isAnyLocalAddress(sAddr) ? InetAddress.getLocalHost().getHostName() : sAddr).append(":").append(connector.getAddress().getPort()).toString(), 3);
                return connector;
            }
            catch (Exception e) {
                eLast = e;
                if (!(nPort != 0) ? false : ++nPort <= nPortMax) continue;
                Component._trace(new StringBuilder(String.valueOf("Could not start JMXConnectorServer on ")).append(sAddr).append(":").append(nPort).append("\n").append(eLast.getMessage()).toString(), 1);
                return null;
            }
            break;
        }
    }

    public void memberJoined(MemberEvent event) {
        InvocationService service = this.getService();
        if (!event.isLocal() && (!(service != null) ? false : this.getDynamicSenior() == service.getCluster().getLocalMember())) {
            this.jmxPublishConnector(Collections.singleton(event.getMember()));
        }
    }

    public void memberLeaving(MemberEvent event) {
    }

    public void memberLeft(MemberEvent event) {
        SafeCluster cluster = this.getCluster();
        Local localGateway = this.getLocalGateway();
        com.tangosol.net.Member member = event.getMember();
        String sNodeId = new StringBuilder(String.valueOf(Registry.KEY_NODE_ID)).append(member.getId()).toString();
        if (event.isLocal()) {
            if (cluster.isRunning() ^ true) {
                if (localGateway != null) {
                    localGateway.reset();
                }
                this.removeLocalSubscriptions();
            }
            this.getRemoteServers().clear();
            this.getRemoteModels().clear();
            JMXConnectorServer jmxServer = this.getConnectorServer();
            if (jmxServer != null) {
                try {
                    jmxServer.stop();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            this.setService(null);
        } else {
            Map.Entry entry;
            this.getRemoteServers().remove(member);
            this.removeRemoteSubscriptions(member);
            Map mapRemoteModels = this.getRemoteModels();
            HashSet setRemoved = new HashSet();
            Iterator iter = mapRemoteModels.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                RemoteModel model = (RemoteModel)entry.getValue();
                if (!member.equals(model.getModelOwner())) continue;
                setRemoved.add(entry);
                iter.remove();
            }
            if (localGateway != null) {
                iter = setRemoved.iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    localGateway.unregisterModelMBean((String)entry.getKey(), (Model)entry.getValue());
                }
                localGateway.unregisterModelMBean(new StringBuilder(String.valueOf(sNodeId)).append(",*").toString(), null);
            }
            InvocationService service = this.getService();
            if (!(!(this.isManagingNode() ^ true) ? false : service != null) ? false : this.getDynamicSenior() == service.getCluster().getLocalMember()) {
                this.assumeManagement();
                this.announce(service);
            }
        }
    }

    public void onAnnouncement(Connector$Announce taskAnnounce) {
        Member memberFrom;
        if (taskAnnounce.isManagingNode() && (memberFrom = this.getMember(taskAnnounce.getMemberFrom())) != null) {
            this.getRemoteServers().add(memberFrom);
            this.registerAll(Collections.singleton(memberFrom));
        }
        taskAnnounce.setResult(this.isManagingNode() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onAnnouncementCompleted() {
        InvocationService service = this.getService();
        if (!(service != null) ? false : service.isRunning()) {
            this.setAnnounced(true);
            this.registerAll(this.getRemoteServers());
        }
    }

    protected void onDependencies(ConnectorDependencies deps) {
    }

    public void onNotify(Connector$Notify taskNotify) {
        String sName = taskNotify.getName();
        RemoteModel model = (RemoteModel)this.getRemoteModels().get(sName);
        if (model == null) {
            Component._trace(new StringBuilder(String.valueOf("Error handling notification ")).append(sName).toString(), 3);
        } else {
            model._handleNotification(taskNotify.getNotification());
            this.setStatsNotificationCount(this.getStatsNotificationCount() + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublish(Connector$Publish taskPublish) {
        Connector connector = this;
        synchronized (connector) {
            this.setJmxServiceUrl(taskPublish.getJMXServiceURL());
            this.setJmxListenAddresses(taskPublish.getListenAddresses());
        }
    }

    public void onRegister(Connector$Register taskRegister) {
        Local localGateway = this.getLocalGateway();
        if (localGateway != null) {
            Member member = this.getMember(taskRegister.getMemberFrom());
            if (member == null) {
                return;
            }
            Map mapRemoteModels = this.getRemoteModels();
            LocalModel[] aModel = taskRegister.getSnapshot();
            int i = 0;
            int c = aModel.length;
            while (i < c) {
                LocalModel model = aModel[i];
                String sName = model.get_ModelName();
                RemoteModel modelRemote = (RemoteModel)mapRemoteModels.get(sName);
                if (modelRemote == null) {
                    modelRemote = new RemoteModel();
                    mapRemoteModels.put(sName, modelRemote);
                    modelRemote.set_ModelName(sName);
                    modelRemote.setConnector(this);
                    modelRemote.setAccessed(false);
                } else if (modelRemote.isResponsibilityMBean() ^ true && ((Object)member).equals(modelRemote.getModelOwner()) ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("Unexpected multi-ownership for MBean: ")).append(sName).toString(), 1);
                }
                modelRemote.setSnapshot(model);
                modelRemote.setModelOwner(member);
                try {
                    localGateway.registerModelMBean(sName, modelRemote);
                }
                catch (RuntimeException e) {
                    Component._trace(new StringBuilder(String.valueOf("Failed to register MBean: ")).append(sName).toString(), 1);
                    Component._trace(e);
                }
                ++i;
            }
        }
    }

    public void onRemoteInvoke(Connector$InvokeRemote taskInvoke, Continuation cont) {
        Object oResult;
        boolean fAsync;
        Exception exception = taskInvoke.getReadException();
        if (exception != null) {
            cont.proceed(exception);
            return;
        }
        int nAction = taskInvoke.getAction();
        Grid service = (Grid)((SafeService)((Object)this.getService())).getService();
        String sName = taskInvoke.getName();
        ThreadLocal tlCont = this.getThreadLocalContinuation();
        boolean bl = nAction == Connector$InvokeRemote.ACTION_EXECUTE ? true : (!(!(!(!(!(nAction != Connector$InvokeRemote.ACTION_CHECK) ? false : nAction != Connector$InvokeRemote.ACTION_QUERY) ? false : nAction != Connector$InvokeRemote.ACTION_FIND_OWNER) ? false : sName != null) ? false : this.getRemoteModels().containsKey(sName)) ? false : (fAsync = service.getThread() == Thread.currentThread()));
        if (fAsync) {
            tlCont.set(cont);
        }
        try {
            switch (nAction) {
                case 0: {
                    Filter filter = taskInvoke.getQueryFilter();
                    oResult = filter == null ? this.getLocalGateway().getAttribute(sName, taskInvoke.getAttributeName()) : this.getLocalGateway().getAttributes(sName, filter);
                    break;
                }
                case 2: {
                    this.getLocalGateway().setAttribute(sName, taskInvoke.getAttributeName(), taskInvoke.getAttributeValue());
                    oResult = null;
                    break;
                }
                case 1: {
                    oResult = this.getLocalGateway().invoke(sName, taskInvoke.getMethodName(), taskInvoke.getParameters(), taskInvoke.getSignatures());
                    break;
                }
                case 5: {
                    Connector$ExecuteFunction function = (Connector$ExecuteFunction)this._newChild("ExecuteFunction");
                    function.setInvocable(taskInvoke);
                    function.setContinuation(cont);
                    service.ensureEventDispatcher().getQueue().add(function);
                    oResult = null;
                    break;
                }
                case 3: {
                    oResult = this.getLocalGateway().isMBeanRegistered(sName);
                    break;
                }
                case 4: {
                    oResult = this.getLocalGateway().queryNames(taskInvoke.getQueryPattern(), taskInvoke.getQueryFilter());
                    break;
                }
                case 6: {
                    oResult = this.getLocalGateway().getMBeanInfo(sName);
                    break;
                }
                case 7: {
                    LocalModel modelLocal = (LocalModel)this.getLocalRegistry().get(sName);
                    RemoteModel modelRemote = modelLocal == null ? this.getRemoteModels().get(sName) : null;
                    oResult = modelLocal == null ? (modelRemote == null ? null : Integer.valueOf(modelRemote.getModelOwner().getId())) : Integer.valueOf(this.getLocalMemberId());
                    break;
                }
                default: {
                    oResult = new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid action: ")).append(taskInvoke.getAction()).toString());
                    break;
                }
            }
        }
        catch (Throwable e) {
            fAsync = false;
            oResult = e;
        }
        tlCont.set(null);
        if (fAsync ^ true) {
            cont.proceed(oResult);
        }
    }

    public void onSubscribe(Connector$Subscribe taskSubscribe) {
        String sName = taskSubscribe.getName();
        LocalModel model = (LocalModel)this.getLocalRegistry().get(sName);
        if (model == null) {
            if (Gateway.isResponsibilityMBean(sName) ^ true) {
                Component._trace(new StringBuilder(String.valueOf("Error updating subscription; unable to locate local model: ")).append(sName).toString(), 2);
            }
        } else if (taskSubscribe.getAction() == Connector$Subscribe.ACTION_SUBSCRIBE) {
            model._addRemoteNotificationListener(taskSubscribe.getHolder(), this);
        } else {
            int nMemberId = taskSubscribe.getMemberId();
            long[] alId = taskSubscribe.getHolderId();
            int i = 0;
            int c = alId.length;
            while (i < c) {
                model._removeRemoteNotificationListener(nMemberId, alId[i]);
                ++i;
            }
        }
    }

    public void onUnregister(Connector$Unregister taskUnregister) {
        block5: {
            Local localGateway = this.getLocalGateway();
            if (!(localGateway != null)) break block5;
            try {
                String sName = taskUnregister.getName();
                Map mapModels = this.getRemoteModels();
                if (sName.endsWith(",*")) {
                    localGateway.unregisterModelMBean(sName, null);
                    String sPattern = sName.substring(0, sName.length() - 2);
                    Gateway.removeByPattern(mapModels, sPattern);
                } else {
                    RemoteModel model = (RemoteModel)mapModels.get(sName);
                    if (!(model != null) ? false : Base.equals(model.getModelOwner(), this.getMember(taskUnregister.getMemberFrom()))) {
                        localGateway.unregisterModelMBean(sName, model);
                        mapModels.remove(sName);
                    }
                }
            }
            catch (RuntimeException e) {
                Component._trace(new StringBuilder(String.valueOf("Ignoring UnregisterRequest exception\n")).append(Component.getStackTrace(e)).toString(), 5);
            }
        }
    }

    public void refreshActiveModels(RemoteModel model) {
        long cRefresh = 0L;
        Iterator iter = this.getRemoteModels().values().iterator();
        while (iter.hasNext()) {
            RemoteModel modelNext = (RemoteModel)iter.next();
            if (!(!(!modelNext.isRefreshRequired() ? false : modelNext.isAccessed()) ? false : modelNext.invokeRemoteAsync())) continue;
            ++cRefresh;
        }
        this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
    }

    public void refreshRemoteModels(Set setModels) {
        if (setModels != null) {
            Map mapModels = this.getRemoteModels();
            long cRefresh = 0L;
            Iterator iter = setModels.iterator();
            while (iter.hasNext()) {
                Object oMBean = iter.next();
                ObjectName oname = oMBean instanceof ObjectInstance ? ((ObjectInstance)oMBean).getObjectName() : (ObjectName)oMBean;
                RemoteModel model = (RemoteModel)mapModels.get(oname.getKeyPropertyListString());
                if (!(model != null)) continue;
                if (model.isAccessed() ^ true) {
                    this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
                }
                if (!model.invokeRemoteAsync()) continue;
                ++cRefresh;
            }
            this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
            this.setStatsRefreshCount(this.getStatsRefreshCount() + cRefresh);
        }
    }

    protected void registerAll(Set setMembers) {
        LocalModel[] aModel = this.getLocalRegistry().values().toArray(new LocalModel[0]);
        if (!(aModel != null) ? false : aModel.length > 0) {
            this.sendRegister(setMembers, aModel);
        }
    }

    public void registerMemberListener(MemberListener listener) {
        this.getService().addMemberListener(listener);
    }

    public void registerModel(LocalModel model) {
        Set setServers;
        String sName = model.get_ModelName();
        Component._assert(model.is_Snapshot() ^ true);
        Component._assert(sName != null);
        LocalModel modelOld = this.getLocalRegistry().put(sName, model);
        if (!(modelOld != null) ? false : sName.indexOf(Registry.KEY_NODE_ID) >= 0) {
            boolean fSkipSend;
            if (!(model instanceof WrapperJmxModel) ? false : modelOld instanceof WrapperJmxModel) {
                fSkipSend = ((WrapperJmxModel)model).getMBeanInfo().getClassName() == ((WrapperJmxModel)modelOld).getMBeanInfo().getClassName();
            } else if (!(model instanceof WrapperModel) ? false : modelOld instanceof WrapperModel) {
                fSkipSend = ((WrapperModel)model).getMBean().getClass() == ((WrapperModel)modelOld).getMBean().getClass();
            } else {
                boolean bl = fSkipSend = model.getClass() == modelOld.getClass();
            }
            if (fSkipSend) {
                return;
            }
        }
        if ((!(!(this.getService() != null) ? false : this.isAnnounced()) ? false : Gateway.isGlobal(sName)) && (setServers = this.getRemoteServers()).isEmpty() ^ true) {
            this.sendRegister(setServers, new LocalModel[]{model});
        }
    }

    protected void removeLocalSubscriptions() {
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            ((LocalModel)iter.next())._removeNotificationListeners();
        }
    }

    protected void removeRemoteSubscriptions(com.tangosol.net.Member member) {
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            LocalModel model = (LocalModel)iter.next();
            RemoteHandler handler = model.get_RemoteNotificationHandler();
            if (!(handler != null)) continue;
            handler.unsubscribeMember(member.getId());
        }
    }

    public String reportSubscriptions() {
        StringBuffer sb = new StringBuffer("LocalModels=\n");
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            LocalModel local = (LocalModel)iter.next();
            sb.append("Name=").append(local.get_ModelName()).append(",LocalHandler=").append(local.get_LocalNotificationHandler()).append(",RemoteHandler=").append(local.get_RemoteNotificationHandler()).append('\n');
        }
        sb.append("RemoteModels=\n");
        iter = this.getRemoteModels().values().iterator();
        while (iter.hasNext()) {
            RemoteModel remote = (RemoteModel)iter.next();
            sb.append("Name=").append(remote.get_ModelName()).append(",LocalHandler=").append(remote.get_LocalNotificationHandler()).append('\n');
        }
        return sb.toString();
    }

    public void resetStatistics() {
        this.setStatsRefreshCount(0L);
        this.setStatsRefreshPredictionCount(0L);
        this.setStatsRefreshExcessCount(0L);
        this.setStatsRefreshTimeoutCount(0L);
        this.setStatsNotificationCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve(NameService.RequestContext ctx) {
        Collection colInet;
        JMXServiceURL url;
        Connector connector = this;
        synchronized (connector) {
            url = this.getJmxServiceUrl();
            colInet = this.getJmxListenAddresses();
        }
        if (url == null) {
            return null;
        }
        String sHost = url.getHost();
        if (InetAddresses.isAnyLocalAddress(sHost)) {
            boolean fLocalDest = true;
            Iterator iter = colInet.iterator();
            while (!fLocalDest ? false : iter.hasNext()) {
                fLocalDest = InetAddresses.isLocalAddress((InetAddress)iter.next());
            }
            Collection<InetAddress> colAddresses = InetAddressHelper.getRoutableAddresses(ctx.getAcceptAddress(), InetAddresses.isLocalAddress(ctx.getSourceAddress()), colInet, fLocalDest);
            if (colAddresses == null ? true : colAddresses.isEmpty()) {
                return null;
            }
            InetAddress addr = colAddresses.iterator().next();
            try {
                url = new JMXServiceURL(url.getProtocol(), addr.getHostAddress(), url.getPort(), url.getURLPath());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return url.toString();
    }

    public void sendNotification(Set setMembers, String sName, Notification notification) {
        InvocationService service = this.getService();
        Connector$Notify task = (Connector$Notify)this._newChild("Notify");
        task.setName(sName);
        task.setNotification(notification);
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            service.execute(task, Collections.singleton(iter.next()), null);
        }
    }

    public Object sendProxyRequest(Connector$InvokeRemote task) {
        com.tangosol.net.Member member;
        Map mapResult;
        Object oResult;
        do {
            member = this.chooseRemoteServer(task.getAction());
            mapResult = this.getService().query(task, Collections.singleton(member));
            oResult = mapResult.get(member);
            if (!(oResult instanceof Throwable)) continue;
            throw Base.ensureRuntimeException((Throwable)oResult);
        } while (!(oResult != null ? true : mapResult.containsKey(member)));
        return oResult;
    }

    protected void sendRegister(Set setMembers, LocalModel[] aModel) {
        InvocationService service = this.getService();
        Connector$Register task = (Connector$Register)this._newChild("Register");
        task.setMemberFrom(this.getLocalMemberId());
        task.setSnapshot(aModel);
        try {
            Iterator iter = setMembers.iterator();
            while (iter.hasNext()) {
                service.execute(task, Collections.singleton(iter.next()), null);
            }
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to register ")).append(aModel.length).append(" MBeans ").append(Component.getStackTrace(e)).toString(), 1);
        }
    }

    protected void setAnnounced(boolean f) {
        this.__m_Announced = f;
    }

    protected void setConnectorServer(JMXConnectorServer server) {
        this.__m_ConnectorServer = server;
    }

    public void setDependencies(ConnectorDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    public void setHttpManagingDynamic(boolean fDynamic) {
        this.__m_HttpManagingDynamic = fDynamic;
    }

    public void setHttpManagingNode(boolean fNode) {
        this.__m_HttpManagingNode = fNode;
    }

    public void setJmxListenAddresses(Collection sUrl) {
        this.__m_JmxListenAddresses = sUrl;
    }

    public void setJmxServiceUrl(JMXServiceURL lUrl) {
        this.__m_JmxServiceUrl = lUrl;
    }

    public void setLocalGateway(Local gateway) {
        this.__m_LocalGateway = gateway;
    }

    protected void setLocalRegistry(Map map) {
        this.__m_LocalRegistry = map;
    }

    public void setManagingDynamic(boolean fDynamic) {
        this.__m_ManagingDynamic = fDynamic;
    }

    public void setManagingNode(boolean fManaging) {
        this.__m_ManagingNode = fManaging;
    }

    private static void setMsgFailure(String sMsg) {
        __s_MsgFailure = sMsg;
    }

    protected void setRefreshAttributeTimeoutMillis(long cMillis) {
        this.__m_RefreshAttributeTimeoutMillis = cMillis;
    }

    public void setRefreshPolicy(String sRefreshPolicy) {
        this.getDependencies().setRefreshPolicy(sRefreshPolicy);
    }

    public void setRefreshTimeoutMillis(long lRefreshTimeoutMillis) {
        this.getDependencies().setRefreshTimeoutMillis(lRefreshTimeoutMillis);
    }

    protected void setRemoteModels(Map mapModels) {
        this.__m_RemoteModels = mapModels;
    }

    protected void setRemoteServers(Set setMember) {
        this.__m_RemoteServers = setMember;
    }

    public void setRequestTimeout(long lTimeout) {
        this.__m_RequestTimeout = lTimeout;
    }

    protected void setService(InvocationService service) {
        this.__m_Service = service;
    }

    protected void setStatsNotificationCount(long cNotifications) {
        this.__m_StatsNotificationCount = cNotifications;
    }

    protected void setStatsRefreshCount(long cSync) {
        this.__m_StatsRefreshCount = cSync;
    }

    protected void setStatsRefreshExcessCount(long cMiss) {
        this.__m_StatsRefreshExcessCount = cMiss;
    }

    protected void setStatsRefreshPredictionCount(long cRefresh) {
        this.__m_StatsRefreshPredictionCount = cRefresh;
    }

    public void setStatsRefreshTimeoutCount(long cCount) {
        this.__m_StatsRefreshTimeoutCount = cCount;
    }

    protected void setThreadLocalContinuation(ThreadLocal cont) {
        this.__m_ThreadLocalContinuation = cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startService(SafeCluster cluster) {
        Connector connector = this;
        synchronized (connector) {
            if (this.isStarted()) {
                return;
            }
            if (Connector.getMsgFailure() != null) return;
            boolean bl = false;
            if (bl) {
                return;
            }
            if (cluster == null) {
                cluster = this.getCluster();
                if (cluster == null) return;
                boolean bl2 = false;
                if (bl2) {
                    return;
                }
            }
        }
        cluster.ensureLocked();
        try {
            connector = this;
            synchronized (connector) {
                block27: {
                    if (this.isStarted() ? true : Connector.getMsgFailure() != null) {
                        Object var4_6 = null;
                        // MONITOREXIT @DISABLED, blocks:[2, 19, 9] lbl25 : MonitorExitStatement: MONITOREXIT : var3_2
                        var4_6 = null;
                        cluster.unlock();
                        return;
                    }
                    try {
                        SafeService serviceSafe;
                        InvocationService service = (InvocationService)cluster.ensureService(Registry.SERVICE_NAME, InvocationService.TYPE_DEFAULT);
                        this.setService(service);
                        service.setContextClassLoader(this.getClass().getClassLoader());
                        service.setUserContext(this);
                        URL url = Resources.findResource("management-config.xml", null);
                        if (url != null) {
                            try {
                                XmlDocument xml = XmlHelper.loadXml(url.openStream());
                                if (xml != null) {
                                    service.configure(xml);
                                }
                            }
                            catch (Exception e) {
                                throw Base.ensureRuntimeException(e);
                            }
                        }
                        if ((serviceSafe = (SafeService)((Object)service)).isRestarting()) {
                            Component._trace(new StringBuilder(String.valueOf("Resetting the JMX Connector; State=")).append(serviceSafe.getSafeServiceState()).toString(), 3);
                            break block27;
                        }
                        service.start();
                        service.addMemberListener(this);
                        Grid _service = (Grid)serviceSafe.getService();
                        _service.getThisMemberConfigMap().put("dynamic-management", this.isManagingDynamic());
                        this.setRequestTimeout(_service.getRequestTimeout());
                        if (!(this.isManagingNode() ^ true) ? false : this.getDynamicSenior() == service.getCluster().getLocalMember()) {
                            this.assumeManagement();
                            if (this.isHttpManagingDynamic()) {
                                HttpHelper.startService(cluster);
                            }
                        }
                        if (this.isHttpManagingNode()) {
                            HttpHelper.startService(cluster);
                        }
                        try {
                            this.getNameService().bind(NSLookup.JMX_CONNECTOR_URL, this);
                        }
                        catch (NameAlreadyBoundException e) {
                        }
                        catch (NamingException e) {
                            throw Base.ensureRuntimeException(e);
                        }
                        this.announce(service);
                    }
                    catch (Exception e) {
                        int of;
                        String sMsg = e.toString();
                        if (e instanceof SecurityException && (of = sMsg.indexOf(10)) > 0) {
                            sMsg = sMsg.substring(0, of);
                        }
                        Connector.setMsgFailure(sMsg);
                        Component._trace(new StringBuilder(String.valueOf("Failure to initialize JMX remote management caused by: ")).append(sMsg).append(". It will not be possible to manage this node remotely.").toString(), 1);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            cluster.unlock();
            throw throwable;
        }
        Object var4_7 = null;
        cluster.unlock();
    }

    public void subscribe(String sName, com.tangosol.net.Member member, RemoteHolder holder) {
        holder.setMemberId(this.getLocalMemberId());
        Connector$Subscribe task = new Connector$Subscribe();
        task.setAction(Connector$Subscribe.ACTION_SUBSCRIBE);
        task.setName(sName);
        task.setHolder(holder);
        this.getService().execute(task, Collections.singleton(member), null);
    }

    public void unregisterModel(String sGivenName) {
        Set setServers;
        Map mapRegistry = this.getLocalRegistry();
        if (sGivenName.endsWith(",*")) {
            String sName = MBeanHelper.stripDomain(sGivenName);
            String sPattern = sName.substring(0, sName.length() - 2);
            Gateway.removeByPattern(mapRegistry, sPattern);
        } else {
            mapRegistry.remove(sGivenName);
        }
        InvocationService service = this.getService();
        if ((!(!(!(service != null) ? false : service.isRunning()) ? false : this.isAnnounced()) ? false : Gateway.isGlobal(sGivenName)) && (setServers = this.getRemoteServers()).isEmpty() ^ true) {
            Connector$Unregister task = (Connector$Unregister)this._newChild("Unregister");
            task.setMemberFrom(this.getLocalMemberId());
            task.setName(sGivenName);
            service.execute(task, setServers, null);
        }
    }

    public void unsubscribe(String sName, com.tangosol.net.Member member, Set setHolders) {
        long[] alId = new long[setHolders.size()];
        int ix = 0;
        Iterator iter = setHolders.iterator();
        while (iter.hasNext()) {
            LocalHolder holder = (LocalHolder)iter.next();
            RemoteHolder hRemote = holder.getRemoteHolder();
            if (!(hRemote != null)) continue;
            alId[ix++] = hRemote.getHolderId();
        }
        Connector$Subscribe task = new Connector$Subscribe();
        task.setAction(Connector$Subscribe.ACTION_UNSUBSCRIBE);
        task.setName(sName);
        task.setMemberId(this.getLocalMemberId());
        task.setHolderId(alId);
        this.getService().execute(task, Collections.singleton(member), null);
    }
}

