/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.gateway;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Manageable;
import com.tangosol.coherence.component.manageable.ModelAdapter;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.gateway.Local$LocalMBeanServerProxy;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.model.EmptyModel;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.internal.metrics.MetricSupport;
import com.tangosol.internal.net.management.GatewayDependencies;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class Local
extends Gateway {
    private transient ConcurrentMap __m_ModelAdapters;
    private transient Gateway __m_RemoteGateway;
    private MBeanServer __m_Server;
    private JMXServiceURL __m_ServiceUrl;
    private static ListMap __mapChildren;

    static {
        Local.__initStatic();
    }

    public Local() {
        this(null, null, true);
    }

    public Local(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("Coherence");
            this.setLocalModels(new SafeHashMap());
            this.setMetricSupport(new MetricSupport());
            this.setModelAdapters(new SegmentedConcurrentMap());
            this.setPrimary(false);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("LocalMBeanServerProxy", Local$LocalMBeanServerProxy.get_CLASS());
    }

    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().addNotificationListener(this.getObjectName(Gateway.extractTenantName(sName)), listener, filter, oHandback);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    protected RuntimeException ensureRuntimeException(Exception e, String sName, String sAttr) {
        if (e instanceof MalformedObjectNameException) {
            return new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid MBean name: ")).append(sName).toString(), e);
        }
        if (e instanceof InstanceNotFoundException) {
            return new IllegalArgumentException(new StringBuilder(String.valueOf("Cannot find MBean named: ")).append(sName).toString(), e);
        }
        if (e instanceof AttributeNotFoundException) {
            return new IllegalArgumentException(new StringBuilder(String.valueOf("Unknown attribute \"")).append(sAttr).append("\" for MBean ").append(sName).toString(), e);
        }
        if (e instanceof ListenerNotFoundException) {
            return new IllegalArgumentException(new StringBuilder(String.valueOf("The specified NotificationListener has not been added to MBean: ")).append(sName).toString(), e);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public Object executeInternal(Remote.Function function, Continuation cont) {
        Throwable oResult;
        if (cont == null) {
            return function.apply(this.getServer());
        }
        try {
            oResult = function.apply(this.getServer());
        }
        catch (Throwable t) {
            oResult = t;
        }
        cont.proceed(oResult);
        return null;
    }

    public Object getAttribute(String sName, String sAttr) {
        try {
            ObjectName name = this.getObjectName(Gateway.extractTenantName(sName));
            try {
                return this.getServer().getAttribute(name, sAttr);
            }
            catch (Exception e) {
                throw this.ensureRuntimeException(e, name.toString(), sAttr);
            }
        }
        catch (MalformedObjectNameException e) {
            throw this.ensureRuntimeException(e, sName, sAttr);
        }
    }

    public Map getAttributes(String sName, Filter filter) {
        MBeanServer mbs = this.getServer();
        LiteMap<String, Object> mapResult = new LiteMap<String, Object>();
        try {
            ObjectName mbeanName = new ObjectName(sName);
            MBeanInfo info = mbs.getMBeanInfo(mbeanName);
            MBeanAttributeInfo[] aAttributes = info.getAttributes();
            int i = 0;
            int c = aAttributes.length;
            while (i < c) {
                String sAttribute = aAttributes[i].getName();
                if (filter.evaluate(sAttribute)) {
                    mapResult.put(sAttribute, mbs.getAttribute(mbeanName, sAttribute));
                }
                ++i;
            }
            return mapResult;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public MBeanInfo getMBeanInfo(String sName) {
        Manageable adapter = null;
        try {
            ObjectName name = this.getObjectName(sName);
            adapter = (ModelAdapter)this.getModelAdapters().get(name);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return adapter == null ? null : adapter.getMBeanInfo();
    }

    public ConcurrentMap getModelAdapters() {
        return this.__m_ModelAdapters;
    }

    public Gateway getRemoteGateway() {
        return this.__m_RemoteGateway;
    }

    public MBeanServer getServer() {
        return this.__m_Server;
    }

    public JMXServiceURL getServiceUrl() {
        return this.__m_ServiceUrl;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/gateway/Local".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Local();
    }

    private final Component get_Module() {
        return this;
    }

    public static Local instantiate(SafeCluster cluster, Connector connector, GatewayDependencies deps) {
        Local gateway = new Local();
        gateway.setCluster(cluster);
        gateway.setDependencies(deps);
        gateway.makePrimary();
        gateway.register(gateway.ensureGlobalName(Registry.MANAGEMENT_TYPE), connector);
        return gateway;
    }

    public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
        try {
            return this.getServer().invoke(this.getObjectName(Gateway.extractTenantName(sName)), sMethodName, aoParam, asSignature);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    protected boolean isClusterRunning(String sDomain) {
        try {
            Boolean FRunning;
            ObjectName nameCluster = new ObjectName(new StringBuilder(String.valueOf(sDomain)).append(':').append(Registry.CLUSTER_TYPE).toString());
            if (this.getServer().isRegistered(nameCluster) && (FRunning = (Boolean)this.getServer().getAttribute(nameCluster, "Running")).booleanValue()) {
                return true;
            }
        }
        catch (JMException jMException) {}
        return false;
    }

    public boolean isMBeanRegistered(String sName) {
        return this.isRegistered(sName);
    }

    public boolean isRegistered(String sName) {
        if (sName.equals(this.ensureGlobalName(Registry.NODE_TYPE))) {
            Remote gatewayRemote = (Remote)this.getRemoteGateway();
            if (gatewayRemote != null) {
                gatewayRemote.ensureRunningConnector();
            }
            return this.getLocalModels().containsKey(sName);
        }
        try {
            return this.getServer().isRegistered(this.getObjectName(Gateway.extractTenantName(sName)));
        }
        catch (JMException e) {
            return false;
        }
    }

    public MBeanServerProxy local() {
        return (Local$LocalMBeanServerProxy)this._newChild("LocalMBeanServerProxy");
    }

    protected void lock(ObjectName oname) {
        if (Gateway.isResponsibilityMBean(oname.getCanonicalName())) {
            this.getModelAdapters().lock(oname, -1L);
        }
    }

    protected void onDependencies(GatewayDependencies deps) {
        String sCanonicalName;
        String sDomain;
        this.ensureObjectNameCache();
        String sDefaultDomain = deps.getDefaultDomain();
        this.setServer(MBeanHelper.findMBeanServer(sDefaultDomain, deps));
        this.setServiceUrl(MBeanHelper.findJMXServiceUrl(sDefaultDomain, deps));
        String sPrefix = this.getDomainName();
        String sConfiguredSuffix = deps.getDomainNameSuffix();
        if (!(sConfiguredSuffix != null) ? false : sConfiguredSuffix.length() > 0) {
            sPrefix = new StringBuilder(String.valueOf(sPrefix)).append("@").append(sConfiguredSuffix).toString();
        }
        String sSuffix = "";
        int iClone = 0;
        while (this.isClusterRunning(sDomain = new StringBuilder(String.valueOf(sPrefix)).append(sSuffix).toString())) {
            sSuffix = new StringBuilder(String.valueOf("@")).append(++iClone).toString();
        }
        this.setDomainName(sDomain);
        if (deps.isExtendedMBeanName()) {
            String sCluster = this.getCluster().getDependencies().getMemberIdentity().getClusterName();
            sCanonicalName = new StringBuilder(String.valueOf("cluster=")).append(sCluster).append(",*").toString();
        } else {
            sCanonicalName = "*";
        }
        this.unregisterModelMBean(sCanonicalName, null);
        this.getReportControl();
    }

    public void onRegistration(int nAction, String sCanonicalName, String sBeanClassName) {
    }

    public Set queryNames(String sPattern, Filter filter) {
        try {
            ObjectName oname = sPattern == null ? null : this.getObjectName(sPattern);
            return this.queryNames(oname, filter);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sPattern, null);
        }
    }

    public Set queryNames(ObjectName oname, Filter filter) {
        Set<ObjectName> setONames = this.getServer().queryNames(oname, new MBeanHelper.QueryExpFilter(filter));
        HashSet<String> setNames = new HashSet<String>(setONames.size());
        Iterator<ObjectName> iter = setONames.iterator();
        while (iter.hasNext()) {
            setNames.add(((Object)iter.next()).toString());
        }
        return setNames;
    }

    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        Component._assert(this.isPrimary());
        super.registerLocalModel(sCanonicalName, model);
        this.registerModelMBean(sCanonicalName, model);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.registerLocalModel(sCanonicalName, model);
        }
        this.registerMetrics(sCanonicalName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerModelMBean(String sCanonicalName, Model model) {
        ConcurrentMap mapAdapters;
        ObjectName name;
        boolean fRetry;
        MBeanServer server = this.getServer();
        try {
            fRetry = true;
            name = this.getObjectName(sCanonicalName);
            mapAdapters = this.getModelAdapters();
            this.lock(name);
            try {}
            catch (Throwable throwable) {
                Object var8_14 = null;
                this.unlock(name);
                throw throwable;
            }
        }
        catch (MalformedObjectNameException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to register MBean: ")).append(model).append("; reason=").append(Component.getStackTrace(e)).toString(), 1);
            return;
        }
        catch (JMException e) {
            throw Base.ensureRuntimeException(e);
        }
        while (true) {
            ModelAdapter adapter;
            if (server.isRegistered(name)) {
                adapter = (ModelAdapter)mapAdapters.get(name);
                if (adapter != null) {
                    adapter.set_Model(model);
                    Object var8_12 = null;
                    this.unlock(name);
                    return;
                }
                server.unregisterMBean(name);
            }
            try {
                adapter = this.instantiateModelMBean(model);
                server.registerMBean(adapter, name);
                mapAdapters.put(name, adapter);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!fRetry) throw e;
                name = new ObjectName(e.getMessage());
                fRetry = false;
                continue;
            }
            break;
        }
        Object var8_13 = null;
        this.unlock(name);
    }

    public void removeNotificationListener(String sName, NotificationListener listener) {
        try {
            this.getServer().removeNotificationListener(this.getObjectName(Gateway.extractTenantName(sName)), listener);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().removeNotificationListener(this.getObjectName(Gateway.extractTenantName(sName)), listener, filter, oHandback);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    public void reset() {
        super.reset();
        this.unregisterGlobalMBeans();
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.reset();
        }
    }

    public void setAttribute(String sName, String sAttr, Object oValue) {
        try {
            this.getServer().setAttribute(this.getObjectName(Gateway.extractTenantName(sName)), new Attribute(sAttr, oValue));
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, sAttr);
        }
    }

    protected void setModelAdapters(ConcurrentMap map) {
        this.__m_ModelAdapters = map;
    }

    public void setRemoteGateway(Gateway gateway) {
        this.__m_RemoteGateway = gateway;
    }

    protected void setServer(MBeanServer pServer) {
        this.__m_Server = pServer;
    }

    protected void setServiceUrl(JMXServiceURL url) {
        this.__m_ServiceUrl = url;
    }

    protected void unlock(ObjectName oname) {
        if (Gateway.isResponsibilityMBean(oname.getCanonicalName())) {
            this.getModelAdapters().unlock(oname);
        }
    }

    public void unregisterGlobalMBeans() {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName("*"), null);
            Iterator<ObjectName> iter = setNames.iterator();
            while (iter.hasNext()) {
                Object var7_9;
                ObjectName oname = iter.next();
                if (!Gateway.isGlobal(oname.getCanonicalName())) continue;
                this.lock(oname);
                try {
                    try {
                        mapNames.remove(oname.getKeyPropertyListString());
                        server.unregisterMBean(oname);
                    }
                    catch (JMException e) {
                    }
                    var7_9 = null;
                    this.unlock(oname);
                }
                catch (Throwable throwable) {
                    var7_9 = null;
                    this.unlock(oname);
                    throw throwable;
                }
            }
        }
        catch (JMException e) {
            Component._trace(new StringBuilder(String.valueOf("Unregister query failed: ")).append(e).toString(), 4);
        }
    }

    public void unregisterLocalModel(String sCanonicalName) {
        LocalModel model = (LocalModel)this.getLocalModels().get(sCanonicalName);
        super.unregisterLocalModel(sCanonicalName);
        this.unregisterModelMBean(sCanonicalName, model);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.unregisterLocalModel(sCanonicalName);
        }
    }

    public void unregisterModelMBean(String sCanonicalName, Model model) {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            ConcurrentMap mapAdapters = this.getModelAdapters();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName(sCanonicalName), null);
            Iterator<ObjectName> iter = setNames.iterator();
            while (iter.hasNext()) {
                Object var10_13;
                ObjectName oname = null;
                try {
                    try {
                        oname = iter.next();
                        this.lock(oname);
                        if (model == null) {
                            mapAdapters.remove(oname);
                            mapNames.remove(oname.getKeyPropertyListString());
                            server.unregisterMBean(oname);
                        } else {
                            ModelAdapter adapter = (ModelAdapter)mapAdapters.get(oname);
                            if (!(adapter != null) ? false : adapter.get_Model() == model) {
                                if (!Gateway.isResponsibilityMBean(sCanonicalName) ? false : model.is_SubscribedTo()) {
                                    EmptyModel model0 = new EmptyModel();
                                    model0.setMBeanInfo(adapter.getMBeanInfo());
                                    adapter.set_Model(model0);
                                } else {
                                    mapAdapters.remove(oname);
                                    mapNames.remove(oname.getKeyPropertyListString());
                                    server.unregisterMBean(oname);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Component._trace(new StringBuilder(String.valueOf("Failed to unregister MBean ")).append(oname).append("; ").append(e).toString(), 4);
                    }
                    var10_13 = null;
                    if (!(oname != null)) continue;
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    if (oname != null) {
                        this.unlock(oname);
                    }
                    throw throwable;
                }
                this.unlock(oname);
            }
            mapNames.remove(sCanonicalName);
        }
        catch (JMException e) {
            Component._trace(new StringBuilder(String.valueOf("Unregister query failed: ")).append(e).toString(), 4);
        }
    }
}

