/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet;

import com.oracle.coherence.common.net.exabus.EndPoint;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet$Iterator;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ServiceMemberSet
extends ActualMemberSet {
    public static final int MEMBER_JOINED = 2;
    public static final int MEMBER_JOINING = 1;
    public static final int MEMBER_LEAVING = 3;
    public static final int MEMBER_NEW = 0;
    private transient AtomicLong[] __m_BackloggedAtomic;
    private long __m_LastJoinTime;
    private ObservableMap[] __m_MemberConfigMap;
    private Member __m_OldestLocalMember;
    private Member __m_OldestMember;
    private transient boolean[] __m_ServiceBacklogged;
    private transient EndPoint[] __m_ServiceEndPoint;
    private transient String[] __m_ServiceEndPointName;
    private transient int __m_ServiceId;
    private long[] __m_ServiceJoinTime;
    private transient String __m_ServiceName;
    private int[] __m_ServiceVersionInt;
    private int[] __m_State;
    private Member __m_SuccessorMember;
    private Member __m_ThisMember;
    private static ListMap __mapChildren;

    static {
        ServiceMemberSet.__initStatic();
    }

    public ServiceMemberSet() {
        this(null, null, true);
    }

    public ServiceMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", MemberSet$Iterator.get_CLASS());
    }

    protected void appendEdition(StringBuilder sb, int nMember) {
    }

    protected void appendEditionHeader(StringBuilder sb) {
    }

    protected void appendTransport(StringBuilder sb, int nMember) {
        sb.append('|').append(ServiceMemberSet.formatEndPoint(this.getServiceEndPointName(nMember)));
    }

    protected void appendTransportHeader(StringBuilder sb) {
        sb.append("|EndPoint");
    }

    protected void appendVersion(StringBuilder sb, int nMember) {
    }

    protected void appendVersionHeader(StringBuilder sb) {
    }

    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    public long compareSeniority(Member memberA, Member memberB) {
        return this.getServiceJoinTime(memberA.getId()) - this.getServiceJoinTime(memberB.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ServiceMemberSet setMember) {
        Component._assert(this.isEmpty());
        this.setServiceId(setMember.getServiceId());
        this.setServiceName(setMember.getServiceName());
        ServiceMemberSet serviceMemberSet = setMember;
        synchronized (serviceMemberSet) {
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                int nMember = member.getId();
                this.add(member);
                this.setServiceVersion(nMember, setMember.getServiceVersion(nMember));
                this.setServiceJoinTime(nMember, setMember.getServiceJoinTime(nMember));
                this.setServiceEndPointName(nMember, setMember.getServiceEndPointName(nMember));
                this.setState(nMember, setMember.getState(nMember));
                this.ensureMemberConfigMap(nMember).putAll(setMember.getMemberConfigMap(nMember));
            }
            Component._assert(!this.equals(setMember) ? false : this.getOldestMember() == setMember.getOldestMember());
        }
    }

    public static int encodeVersion(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return (nMajor & 0x3F) << 6 * 4 | (nMinor & 0x3F) << 6 * 3 | (nMicro & 0x3F) << 6 * 2 | (nPatchSet & 0x3F) << 6 * 1 | nPatch & 0x3F;
    }

    public synchronized ObservableMap ensureMemberConfigMap(int i) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableHashMap map = (amap == null ? true : i >= amap.length) ? null : amap[i];
        if (map == null) {
            map = new ObservableHashMap();
            this.setMemberConfigMap(i, map);
        }
        return map;
    }

    public static String formatEndPoint(String sName) {
        return (sName == null ? true : sName.length() == 0) ? "shared" : sName;
    }

    public static String formatJoinTime(long ldt) {
        return new Timestamp(ldt).toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "NEW";
            }
            case 1: {
                return "JOINING";
            }
            case 2: {
                return "JOINED";
            }
            case 3: {
                return "LEAVING";
            }
        }
        return "<unknown>";
    }

    protected AtomicLong[] getBackloggedAtomic() {
        return this.__m_BackloggedAtomic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicLong getBackloggedAtomic(int i) {
        AtomicLong[] aBits = this.getBackloggedAtomic();
        if (aBits == null ? true : i >= aBits.length) {
            ServiceMemberSet serviceMemberSet = this;
            synchronized (serviceMemberSet) {
                aBits = this.getBackloggedAtomic();
                if (aBits == null ? true : i >= aBits.length) {
                    AtomicLong[] aBitsNew = new AtomicLong[i + 8];
                    if (aBits != null) {
                        System.arraycopy(aBits, 0, aBitsNew, 0, aBits.length);
                    }
                    int j = aBits == null ? 0 : aBits.length;
                    while (j < aBitsNew.length) {
                        aBitsNew[j] = new AtomicLong();
                        ++j;
                    }
                    aBits = aBitsNew;
                    this.setBackloggedAtomic(aBits);
                }
            }
        }
        return aBits[i];
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(new StringBuilder(String.valueOf("\n  OldestMember=")).append(this.getOldestMember()).toString()).append(new StringBuilder(String.valueOf("\n  ActualMemberSet=")).append(Base.indentString(this.toString(Member.SHOW_STD), "  ", false)).toString()).append("\n  MemberId|ServiceJoined|MemberState");
        this.appendTransportHeader(sb);
        this.appendVersionHeader(sb);
        this.appendEditionHeader(sb);
        boolean fFirst = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(',');
            }
            int nMember = ((Member)iter.next()).getId();
            sb.append("\n    ").append(nMember).append('|').append(ServiceMemberSet.formatJoinTime(this.getServiceJoinTime(nMember))).append('|').append(ServiceMemberSet.formatStateName(this.getState(nMember)));
            this.appendTransport(sb, nMember);
            this.appendVersion(sb, nMember);
            this.appendEdition(sb, nMember);
        }
        return sb.toString();
    }

    public Member getJoinedMember(long ldtJoined) {
        long[] aldtJoined = this.getServiceJoinTime();
        int i = 0;
        int c = aldtJoined.length;
        while (i < c) {
            if (aldtJoined[i] == ldtJoined) {
                return this.getMember(i);
            }
            ++i;
        }
        return null;
    }

    public long getLastJoinTime() {
        return this.__m_LastJoinTime;
    }

    protected ObservableMap[] getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public ObservableMap getMemberConfigMap(int i) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap map = (amap == null ? true : i >= amap.length) ? null : amap[i];
        if (map == null) {
            map = NullImplementation.getObservableMap();
        }
        return map;
    }

    public Member getOldestLocalMember() {
        return this.__m_OldestLocalMember;
    }

    public Member getOldestMember() {
        return this.__m_OldestMember;
    }

    protected EndPoint[] getServiceEndPoint() {
        return this.__m_ServiceEndPoint;
    }

    public EndPoint getServiceEndPoint(int i) {
        EndPoint[] aPoint = this.getServiceEndPoint();
        return (aPoint == null ? true : i >= aPoint.length) ? null : aPoint[i];
    }

    protected String[] getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public String getServiceEndPointName(int i) {
        String[] asEndPoint = this.getServiceEndPointName();
        return (asEndPoint == null ? true : i >= asEndPoint.length) ? null : asEndPoint[i];
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    protected long[] getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public long getServiceJoinTime(int i) {
        long[] alMillis = this.getServiceJoinTime();
        return (alMillis == null ? true : i >= alMillis.length) ? 0L : alMillis[i];
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceVersion(int i) {
        return ServiceMemberSet.toVersionString(this.getServiceVersionInt(i), true);
    }

    public String getServiceVersionExternal(int nMember) {
        Member member = this.getMember(nMember);
        int nVersion = this.getServiceVersionInt(nMember);
        int nYear = (nVersion & 0xFC0) >> 6;
        int nPatch = nVersion & 0x3F;
        if (!(nYear >= 20) ? false : member.getEdition() == 3) {
            int nPatchActual = nPatch & ~32;
            String sVersion = new StringBuilder(String.valueOf(nYear)).append(".").toString();
            sVersion = (nPatch & 0x20) == 0 ? new StringBuilder(String.valueOf(sVersion)).append(nYear <= 22 ? "06" : "03").toString() : new StringBuilder(String.valueOf(sVersion)).append(nYear <= 21 ? "12" : "09").toString();
            return new StringBuilder(String.valueOf(sVersion)).append(".").append(nPatchActual).toString();
        }
        return this.getServiceVersion(nMember);
    }

    public int[] getServiceVersionInt() {
        return this.__m_ServiceVersionInt;
    }

    public int getServiceVersionInt(int i) {
        int[] anVersion = this.getServiceVersionInt();
        return (anVersion == null ? true : i >= anVersion.length) ? 0 : anVersion[i];
    }

    protected int[] getState() {
        return this.__m_State;
    }

    public int getState(int i) {
        int[] anState = this.getState();
        return (anState == null ? true : i >= anState.length) ? 0 : anState[i];
    }

    public Member getSuccessorMember() {
        return this.__m_SuccessorMember;
    }

    public Member getThisMember() {
        return this.__m_ThisMember;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/memberSet/actualMemberSet/ServiceMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ServiceMemberSet();
    }

    private final Component get_Module() {
        return this;
    }

    protected static boolean isCalendarVersion(int nVersion) {
        return nVersion >= 20;
    }

    public boolean isMemberConfigured(int nMember) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap map = (amap == null ? true : nMember >= amap.length) ? null : amap[nMember];
        return map != null;
    }

    public boolean isServiceBacklogged(int i) {
        return (this.getBackloggedAtomic(i / 64).get() & 1L << i % 64) != (long)0;
    }

    public boolean isServiceJoined(int nMember) {
        return this.getState(nMember) == MEMBER_JOINED;
    }

    public boolean isServiceJoining(int nMember) {
        return this.getState(nMember) == MEMBER_JOINING;
    }

    public boolean isServiceLeaving(int nMember) {
        return this.getState(nMember) == MEMBER_LEAVING;
    }

    public static int parseVersion(String sVersion) {
        if (sVersion == null ? true : sVersion.length() == 0) {
            return 0;
        }
        int ofSuffix = sVersion.indexOf(" ");
        if (ofSuffix > 0) {
            sVersion = sVersion.substring(0, ofSuffix);
        }
        int INDEX_YEAR = 3;
        int INDEX_MONTH = 4;
        String[] asVersions = sVersion.split("\\.");
        int[] an = new int[5];
        String sYear = asVersions.length > INDEX_YEAR ? asVersions[INDEX_YEAR] : "";
        if (sYear.length() >= 4) {
            asVersions = Arrays.copyOf(asVersions, asVersions.length + 1);
            int i = asVersions.length - 2;
            while (i > INDEX_YEAR) {
                asVersions[i + 1] = asVersions[i];
                asVersions[i] = null;
                --i;
            }
            asVersions[INDEX_YEAR] = sYear.substring(0, 2);
            asVersions[INDEX_MONTH] = sYear.substring(2);
        }
        int i = 0;
        int c = Math.min(an.length, asVersions.length);
        while (i < c) {
            try {
                int nVersion = Integer.parseInt(asVersions[i]);
                if (!(i == INDEX_MONTH) ? false : ServiceMemberSet.isCalendarVersion(an[i - 1])) {
                    nVersion = nVersion > 6 ? 1 << 5 : 0;
                    nVersion |= i + 1 < asVersions.length ? Integer.parseInt(asVersions[i + 1]) : 0;
                }
                an[i] = Math.min(63, nVersion);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++i;
        }
        return ServiceMemberSet.encodeVersion(an[0], an[1], an[2], an[3], an[4]);
    }

    public synchronized boolean remove(Object o) {
        if (super.remove(o)) {
            Member memberLeft = (Member)o;
            int nId = memberLeft.getId();
            this.setServiceVersion(nId, null);
            this.setServiceJoinTime(nId, 0L);
            this.setServiceEndPoint(nId, null);
            this.setServiceBacklogged(nId, false);
            this.setMemberConfigMap(nId, null);
            this.setState(nId, 0);
            if ((memberLeft == this.getOldestMember() ? true : memberLeft == this.getOldestLocalMember()) ? true : memberLeft == this.getSuccessorMember()) {
                Member memberThis = this.getThisMember();
                Member memberOldest = null;
                Member memberOldestLocal = memberThis;
                Member memberSuccessor = null;
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    if (memberOldest == null ? true : this.compareSeniority(member, memberOldest) < 0L) {
                        memberOldest = member;
                    }
                    if (!(!(memberOldestLocal != null) ? false : memberOldestLocal.isCollocated(member)) ? false : this.compareSeniority(member, memberOldestLocal) < 0L) {
                        memberOldestLocal = member;
                    }
                    if (!(!(!(memberThis != null) ? false : this.compareSeniority(memberThis, member) < 0L) ? false : (memberSuccessor == null ? true : this.compareSeniority(member, memberSuccessor) < 0L))) continue;
                    memberSuccessor = member;
                }
                this.setOldestMember(memberOldest);
                this.setOldestLocalMember(memberOldestLocal);
                this.setSuccessorMember(memberSuccessor);
            }
            return true;
        }
        return false;
    }

    protected void setBackloggedAtomic(int i, AtomicLong point) {
        this.getBackloggedAtomic()[i] = point;
    }

    protected void setBackloggedAtomic(AtomicLong[] aPoint) {
        this.__m_BackloggedAtomic = aPoint;
    }

    protected void setLastJoinTime(long ldt) {
        this.__m_LastJoinTime = ldt;
    }

    protected synchronized void setMemberConfigMap(int i, ObservableMap map) {
        boolean fBeyondBounds;
        ObservableMap[] amap = this.getMemberConfigMap();
        boolean bl = fBeyondBounds = amap == null ? true : i >= amap.length;
        if (!(map != null) ? false : fBeyondBounds) {
            ObservableMap[] amapNew = new ObservableMap[i + 8];
            if (amap != null) {
                System.arraycopy(amap, 0, amapNew, 0, amap.length);
            }
            amap = amapNew;
            this.setMemberConfigMap(amap);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            amap[i] = map;
        }
    }

    protected void setMemberConfigMap(ObservableMap[] amap) {
        this.__m_MemberConfigMap = amap;
    }

    protected void setOldestLocalMember(Member member) {
        this.__m_OldestLocalMember = member;
    }

    protected void setOldestMember(Member member) {
        this.__m_OldestMember = member;
    }

    public void setServiceBacklogged(int i, boolean fBacklogged) {
        long lCur;
        AtomicLong atl = this.getBackloggedAtomic(i / 64);
        long iBit = 1L << i % 64;
        while (atl.compareAndSet(lCur = atl.get(), fBacklogged ? lCur | iBit : lCur & (iBit ^ 0xFFFFFFFFFFFFFFFFL)) ^ true) {
        }
    }

    public void setServiceEndPoint(int i, EndPoint point) {
        boolean fBeyondBounds;
        EndPoint[] aPoint = this.getServiceEndPoint();
        boolean bl = fBeyondBounds = aPoint == null ? true : i >= aPoint.length;
        if (!(point != null) ? false : fBeyondBounds) {
            EndPoint[] aPointNew = new EndPoint[i + 8];
            if (aPoint != null) {
                System.arraycopy(aPoint, 0, aPointNew, 0, aPoint.length);
            }
            aPoint = aPointNew;
            this.setServiceEndPoint(aPoint);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aPoint[i] = point;
            this.setServiceBacklogged(i, false);
        }
    }

    protected void setServiceEndPoint(EndPoint[] aPoint) {
        this.__m_ServiceEndPoint = aPoint;
    }

    public void setServiceEndPointName(int i, String sEndPoint) {
        boolean fBeyondBounds;
        String[] asEndPoint = this.getServiceEndPointName();
        boolean bl = fBeyondBounds = asEndPoint == null ? true : i >= asEndPoint.length;
        if (!(sEndPoint != null) ? false : fBeyondBounds) {
            String[] asEndPointNew = new String[i + 8];
            if (asEndPoint != null) {
                System.arraycopy(asEndPoint, 0, asEndPointNew, 0, asEndPoint.length);
            }
            asEndPoint = asEndPointNew;
            this.setServiceEndPointName(asEndPoint);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            asEndPoint[i] = sEndPoint;
        }
    }

    protected void setServiceEndPointName(String[] asName) {
        this.__m_ServiceEndPointName = asName;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public synchronized void setServiceJoinTime(int i, long lMillis) {
        long[] alMillis;
        boolean fBeyondBounds;
        if (lMillis > this.getLastJoinTime()) {
            this.setLastJoinTime(lMillis);
        }
        boolean bl = fBeyondBounds = (alMillis = this.getServiceJoinTime()) == null ? true : i >= alMillis.length;
        if (!(lMillis != 0L) ? false : fBeyondBounds) {
            long[] alMillisNew = new long[i + 8];
            if (alMillis != null) {
                System.arraycopy(alMillis, 0, alMillisNew, 0, alMillis.length);
            }
            alMillis = alMillisNew;
            this.setServiceJoinTime(alMillis);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            alMillis[i] = lMillis;
            Member member = this.getMember(i);
            if (member != null) {
                Member memberOldest = this.getOldestMember();
                if (memberOldest == null ? true : this.compareSeniority(member, memberOldest) < 0L) {
                    this.setOldestMember(member);
                }
                if (!(!((memberOldest = this.getOldestLocalMember()) != null) ? false : memberOldest.isCollocated(member)) ? false : this.compareSeniority(member, memberOldest) < 0L) {
                    this.setOldestLocalMember(member);
                }
                memberOldest = this.getSuccessorMember();
                Member memberThis = this.getThisMember();
                if (!(!(memberThis != null) ? false : this.compareSeniority(memberThis, member) < 0L) ? false : (memberOldest == null ? true : this.compareSeniority(member, memberOldest) < 0L)) {
                    this.setSuccessorMember(member);
                }
            }
        }
    }

    protected void setServiceJoinTime(long[] alMillis) {
        this.__m_ServiceJoinTime = alMillis;
    }

    public void setServiceJoined(int nMember) {
        this.setState(nMember, MEMBER_JOINED);
    }

    public void setServiceJoining(int nMember) {
        this.setState(nMember, MEMBER_JOINING);
    }

    public void setServiceLeaving(int nMember) {
        this.setState(nMember, MEMBER_LEAVING);
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public synchronized void setServiceVersion(int i, String sVersion) {
        this.setServiceVersionInt(i, ServiceMemberSet.parseVersion(sVersion));
    }

    protected void setServiceVersionInt(int i, int nVersion) {
        boolean fBeyondBounds;
        int[] anVersion = this.getServiceVersionInt();
        boolean bl = fBeyondBounds = anVersion == null ? true : i >= anVersion.length;
        if (!(nVersion != 0) ? false : fBeyondBounds) {
            int[] anVersionNew = new int[i + 8];
            if (anVersion != null) {
                System.arraycopy(anVersion, 0, anVersionNew, 0, anVersion.length);
            }
            anVersion = anVersionNew;
            this.setServiceVersionInt(anVersion);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            anVersion[i] = nVersion;
        }
    }

    public void setServiceVersionInt(int[] anInt) {
        this.__m_ServiceVersionInt = anInt;
    }

    public synchronized void setState(int i, int nState) {
        int[] anState = this.getState();
        if (anState == null ? true : i >= anState.length) {
            int[] anStateNew = new int[i + 8];
            if (anState != null) {
                System.arraycopy(anState, 0, anStateNew, 0, anState.length);
            }
            anState = anStateNew;
            this.setState(anState);
        }
        anState[i] = nState;
    }

    protected void setState(int[] aiState) {
        this.__m_State = aiState;
    }

    public void setSuccessorMember(Member memberSuccessor) {
        this.__m_SuccessorMember = memberSuccessor;
    }

    public void setThisMember(Member memberThis) {
        Component._assert(!(memberThis != null) ? false : memberThis.getId() != 0);
        Component._assert(this.getThisMember() == null ? true : memberThis == this.getThisMember());
        Component._assert(this.contains(memberThis));
        this.__m_ThisMember = memberThis;
        Member memberOldestLocal = memberThis;
        Member memberSuccessor = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!memberThis.isCollocated(member) ? false : this.compareSeniority(member, memberOldestLocal) < 0L) {
                memberOldestLocal = member;
            }
            if (!(!(this.compareSeniority(memberThis, member) < 0L) ? false : (memberSuccessor == null ? true : this.compareSeniority(member, memberSuccessor) < 0L))) continue;
            memberSuccessor = member;
        }
        this.setOldestLocalMember(memberOldestLocal);
        this.setSuccessorMember(memberSuccessor);
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append('(').append(this.getDescription()).append("\n  )").toString();
    }

    public static int[] toVersionArray(String sVersion) {
        int nVersion = ServiceMemberSet.parseVersion(sVersion);
        return new int[]{(nVersion & 0x3F000000) >> 6 * 4, (nVersion & 0xFC0000) >> 6 * 3, (nVersion & 0x3F000) >> 6 * 2, (nVersion & 0xFC0) >> 6 * 1, nVersion & 0x3F};
    }

    protected static String toVersionString(int nVersion, boolean fIncludePrefix) {
        int nYear = (nVersion & 0xFC0) >> 6;
        int nPatch = nVersion & 0x3F;
        String sVersion = new StringBuilder(String.valueOf((fIncludePrefix ? true : ServiceMemberSet.isCalendarVersion(nYear) ^ true) ? new StringBuilder(String.valueOf((nVersion & 0x3F000000) >> 6 * 4)).append(".").append((nVersion & 0xFC0000) >> 6 * 3).append(".").append((nVersion & 0x3F000) >> 6 * 2).append(".").toString() : "")).append(nYear).toString();
        if (ServiceMemberSet.isCalendarVersion(nYear)) {
            int nPatchActual = nPatch & ~32;
            sVersion = (nPatch & 0x20) == 0 ? new StringBuilder(String.valueOf(sVersion)).append(nYear <= 22 ? "06" : "03").toString() : new StringBuilder(String.valueOf(sVersion)).append(nYear <= 21 ? "12" : "09").toString();
            sVersion = new StringBuilder(String.valueOf(sVersion)).append(new StringBuilder(String.valueOf(".")).append(nPatchActual).toString()).toString();
        } else {
            sVersion = new StringBuilder(String.valueOf(sVersion)).append(new StringBuilder(String.valueOf(".")).append(nPatch).toString()).toString();
        }
        return sVersion;
    }

    public void updateMemberConfigMap(int nMember, Map map) {
        if (map != null) {
            ObservableMap mapConfig = this.ensureMemberConfigMap(nMember);
            mapConfig.clear();
            mapConfig.putAll(map);
        }
    }
}

