/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.ChainedRequest$Poll;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChainedRequest
extends RequestMessage {
    private transient ChainedRequest __m_IncomingRequest;
    private List __m_MemberList;
    private int __m_OriginatingMemberId;
    private static ListMap __mapChildren;

    static {
        ChainedRequest.__initStatic();
    }

    public ChainedRequest() {
        this(null, null, true);
    }

    public ChainedRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", ChainedRequest$Poll.get_CLASS());
    }

    public Message cloneMessage() {
        ChainedRequest msg = (ChainedRequest)super.cloneMessage();
        msg.setMemberList(new ArrayList(this.getMemberList()));
        msg.setOriginatingMemberId(this.getOriginatingMemberId());
        return msg;
    }

    protected void dispatch(Message msg) {
        ChainedRequest req = (ChainedRequest)msg;
        if (req.getOriginatingMemberId() == 0) {
            req.setOriginatingMemberId(req.getService().getThisMember().getId());
        }
        super.dispatch(req);
    }

    protected boolean forwardMessage(ChainedRequest msgIncoming) {
        if (this.isTerminal()) {
            return false;
        }
        ChainedRequest msgNext = (ChainedRequest)this.cloneMessage();
        msgNext.setIncomingRequest(msgIncoming);
        this.getService().post(msgNext);
        return true;
    }

    public void forwardOrReply(ChainedRequest msgIncoming) {
        if (!this.forwardMessage(msgIncoming)) {
            if (msgIncoming == null) {
                this.onRequestCompleted();
            } else {
                this.onRequestDelivered();
                Message msgResponse = msgIncoming.instantiateResponse();
                msgResponse.respondTo(msgIncoming);
                this.getService().post(msgResponse);
            }
        }
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            sb.append("all");
        } else {
            Iterator iter = listMembers.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                sb.append(member.getId());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(']');
        return new StringBuilder(String.valueOf("MemberList=")).append(sb.toString()).toString();
    }

    public ChainedRequest getIncomingRequest() {
        return this.__m_IncomingRequest;
    }

    public List getMemberList() {
        return this.__m_MemberList;
    }

    public Member getOriginatingMember() {
        return this.getService().getServiceMemberSet().getMember(this.getOriginatingMemberId());
    }

    public int getOriginatingMemberId() {
        return this.__m_OriginatingMemberId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/requestMessage/ChainedRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ChainedRequest();
    }

    private final Component get_Module() {
        return this;
    }

    protected Poll instantiatePoll() {
        return (Poll)this._newChild("Poll");
    }

    public Message instantiateResponse() {
        return this.getService().instantiateMessage("Response");
    }

    public boolean isTerminal() {
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            return !(this.getIncomingRequest() != null) ? false : this.getService().getServiceMemberSet().getSuccessorMember() == null;
        }
        return listMembers.isEmpty();
    }

    public void onReceived() {
        this.forwardOrReply(this);
    }

    public void onRequestCompleted() {
    }

    public void onRequestDelivered() {
    }

    public void post() {
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            this.setToMemberSet(MemberSet.instantiate(this.getIncomingRequest() == null ? this.getService().getServiceOldestMember() : this.getService().getServiceMemberSet().getSuccessorMember()));
        } else if (listMembers.isEmpty()) {
            this.setToMemberSet((EmptyMemberSet)EmptyMemberSet.get_Instance());
        } else {
            this.setToMemberSet(MemberSet.instantiate((Member)listMembers.remove(0)));
            if (listMembers.isEmpty()) {
                this.setMemberList(Collections.emptyList());
            }
        }
        super.post();
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        List listMembers;
        super.read(input);
        this.setOriginatingMemberId(input.readInt());
        int cMembers = input.readShort();
        if (cMembers == -1) {
            listMembers = null;
        } else if (cMembers == 0) {
            listMembers = Collections.emptyList();
        } else {
            ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
            listMembers = new ArrayList(cMembers);
            int i = 0;
            while (i < cMembers) {
                int nMember = input.readInt();
                Member member = ((MemberSet)setMembers).getMember(nMember);
                if (member != null) {
                    listMembers.add(member);
                }
                ++i;
            }
        }
        this.setMemberList(listMembers);
    }

    protected void setIncomingRequest(ChainedRequest msg) {
        this.__m_IncomingRequest = msg;
    }

    public void setMemberList(List listMember) {
        this.__m_MemberList = listMember;
    }

    public void setOriginatingMemberId(int nId) {
        this.__m_OriginatingMemberId = nId;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeInt(this.getOriginatingMemberId());
        List listMembers = this.getMemberList();
        int cMembers = listMembers == null ? -1 : listMembers.size();
        output.writeShort(cMembers);
        if (cMembers > 0) {
            int i = 0;
            while (i < cMembers) {
                Member member = (Member)listMembers.get(i);
                output.writeInt(member.getId());
                ++i;
            }
        }
    }
}

