/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Time;

public abstract class MessagePacket
extends Packet
implements PacketIdentifier,
Cloneable {
    public static final int DELIVERY_CONFIRMED = 4;
    public static final int DELIVERY_DEFERRED = 2;
    public static final int DELIVERY_LOST = 3;
    public static final int DELIVERY_OUTSTANDING = 1;
    public static final int DELIVERY_UNSENT = 0;
    public static final int TYPE_NO_DESTINATION = 0;
    private int __m_BodyLength;
    private transient ByteBuffer __m_ByteBuffer;
    private transient int __m_DeliveryState;
    private long __m_FromMessageId;
    private int __m_MessagePartCount;
    private int __m_MessagePartIndex;
    private int __m_MessageType;
    private transient boolean __m_NackInProgress;
    private transient int __m_PendingResendSkips;
    private ReadBuffer __m_ReadBuffer;
    private long __m_ResendScheduled;
    private long __m_ResendTimeout;
    private int __m_ServiceId;
    private DependentMemberSet __m_ToMemberSet;

    public MessagePacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static void assertIO(boolean fCondition) throws IOException {
        if (fCondition ^ true) {
            throw new IOException();
        }
    }

    public static int calcBodyLength(int cbHeader, int cbPref, int cbMax) {
        return Math.min(Math.max(cbHeader << 2, cbPref), Math.max(cbPref, cbMax)) - cbHeader;
    }

    public static int calcMaxMembers(int cb) {
        int cMembers = (cb -= 21) / 100 * 32;
        if ((cb %= 100) >= 7) {
            cMembers += (cb - 4) / 3;
        }
        return Math.min(MasterMemberSet.MAX_MEMBERS, cMembers);
    }

    public void clearRecipients() {
        if (this.isOutgoingMultipoint()) {
            this.getToMemberSet().clear();
        } else {
            this.setToId(0);
        }
        this.setSentMillis(Base.getSafeTimeMillis());
    }

    public Object clone() {
        MessagePacket packet;
        Component._assert(this.getByteBuffer() == null);
        try {
            packet = (MessagePacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
        ReadBuffer readBuffer = this.getReadBuffer();
        if (readBuffer != null) {
            packet.setReadBuffer((ReadBuffer)readBuffer.clone());
        }
        return packet;
    }

    public void defineBufferView(ReadBuffer buffer, int of, int cb) {
        this.setBodyLength(cb);
        this.setReadBuffer(buffer.getReadBuffer(of, cb));
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessagePacket) {
            MessagePacket that = (MessagePacket)obj;
            return !(!(this.getFromId() == that.getFromId()) ? false : this.getFromMessageId() == that.getFromMessageId()) ? false : this.getMessagePartIndex() == that.getMessagePartIndex();
        }
        return false;
    }

    public String formatDeliveryState(int nDeliveryState) {
        switch (nDeliveryState) {
            case 0: {
                return "unsent";
            }
            case 1: {
                return "outstanding";
            }
            case 2: {
                return "deferred";
            }
            case 3: {
                return "lost";
            }
            case 4: {
                return "confirmed";
            }
        }
        return "<unknown>";
    }

    public int getBodyLength() {
        return this.__m_BodyLength;
    }

    public ByteBuffer getByteBuffer() {
        return this.__m_ByteBuffer;
    }

    public int getDeliveryState() {
        return this.__m_DeliveryState;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    public int getHeaderLength() {
        return 0;
    }

    public int getLength() {
        return this.getHeaderLength() + this.getBodyLength();
    }

    public int getMessagePartCount() {
        return this.__m_MessagePartCount;
    }

    public int getMessagePartIndex() {
        return this.__m_MessagePartIndex;
    }

    public int getMessageType() {
        return this.__m_MessageType;
    }

    public int getPendingResendSkips() {
        return this.__m_PendingResendSkips;
    }

    public ReadBuffer getReadBuffer() {
        return this.__m_ReadBuffer;
    }

    public long getResendScheduled() {
        return this.__m_ResendScheduled;
    }

    public long getResendTimeout() {
        return this.__m_ResendTimeout;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public DependentMemberSet getToMemberSet() {
        return this.__m_ToMemberSet;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/MessagePacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return this.getFromId() ^ (int)this.getFromMessageId() ^ this.getMessagePartIndex();
    }

    public boolean isAddressedTo(int nMemberId) {
        if (super.isAddressedTo(nMemberId)) {
            return true;
        }
        DependentMemberSet memberSet = this.getToMemberSet();
        return !(memberSet != null) ? false : ((MemberSet)memberSet).contains(nMemberId);
    }

    public boolean isNackInProgress() {
        return this.__m_NackInProgress;
    }

    public boolean isOutgoingMultipoint() {
        return this.getToMemberSet() != null;
    }

    public boolean isResendNecessary() {
        if (this.getToId() != 0) {
            return true;
        }
        DependentMemberSet set = this.getToMemberSet();
        return !(set != null) ? false : ((MemberSet)set).isEmpty() ^ true;
    }

    public boolean registerAck(Member memberFrom) {
        DependentMemberSet set;
        if (this.isOutgoing() ^ true) {
            long lSentMillis = this.getSentMillis();
            long lRecvMillis = this.getReceivedMillis();
            Component._trace(new StringBuilder(String.valueOf("Received ACK from ")).append(memberFrom).append(" for incomming packet, with sent count of  ").append(this.getSentCount()).append(", last send timestamp of ").append(lSentMillis).append("(").append(new Time(lSentMillis)).append("), recv timestamp of ").append(lRecvMillis).append("(").append(new Time(lRecvMillis)).append("):  ").append(this).toString(), 1);
            Component._assert(this.isOutgoing());
        }
        if ((set = this.getToMemberSet()) == null) {
            int nToId = this.getToId();
            int nFromId = memberFrom.getId();
            if (nToId != 0) {
                if (nFromId != nToId) {
                    long lSentMillis = this.getSentMillis();
                    long lRecvMillis = this.getReceivedMillis();
                    Component._trace(new StringBuilder(String.valueOf("Received ACK from ")).append(memberFrom).append(" ").append(nFromId).append(" for packet sent to ").append(nToId).append(" , with sent count of  ").append(this.getSentCount()).append(", last send timestamp of ").append(lSentMillis).append("(").append(new Time(lSentMillis)).append("), recv timestamp of ").append(lRecvMillis).append("(").append(new Time(lRecvMillis)).append("):  ").append(this).toString(), 1);
                    Component._assert(nFromId == nToId);
                }
                this.setToId(0);
                return true;
            }
            return false;
        }
        return set.remove(memberFrom);
    }

    protected void setBodyLength(int cbBody) {
        this.__m_BodyLength = cbBody;
    }

    public void setByteBuffer(ByteBuffer buffer) {
        this.__m_ByteBuffer = buffer;
    }

    protected void setDeliveryState(int nState) {
        this.__m_DeliveryState = nState;
    }

    public void setDeliveryState(int nNewState, Member member) {
        int nCurrentState = this.getDeliveryState();
        if (nNewState == nCurrentState) {
            return;
        }
        Member$FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            switch (nCurrentState) {
                case 1: {
                    flowControl.setOutstandingPacketCount(flowControl.getOutstandingPacketCount() - 1);
                    break;
                }
                case 2: {
                    flowControl.setDeferredPacketCount(flowControl.getDeferredPacketCount() - 1);
                    break;
                }
            }
            switch (nNewState) {
                case 1: {
                    flowControl.setOutstandingPacketCount(flowControl.getOutstandingPacketCount() + 1);
                    break;
                }
                case 2: {
                    flowControl.setDeferredPacketCount(flowControl.getDeferredPacketCount() + 1);
                    break;
                }
            }
        }
        this.setDeliveryState(nNewState);
    }

    public void setFromMessageId(long nId) {
        this.__m_FromMessageId = nId;
    }

    public void setMessagePartCount(int cParts) {
        this.__m_MessagePartCount = cParts;
    }

    public void setMessagePartIndex(int i) {
        this.__m_MessagePartIndex = i;
    }

    public void setMessageType(int nType) {
        this.__m_MessageType = nType;
    }

    public void setNackInProgress(boolean fNack) {
        this.__m_NackInProgress = fNack;
    }

    public void setPendingResendSkips(int pPendingResendSkips) {
        this.__m_PendingResendSkips = pPendingResendSkips;
    }

    protected void setReadBuffer(ReadBuffer buffer) {
        this.__m_ReadBuffer = buffer;
    }

    public void setResendScheduled(long cMillis) {
        this.__m_ResendScheduled = cMillis;
    }

    public void setResendTimeout(long pResendTimeout) {
        this.__m_ResendTimeout = pResendTimeout;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setToMemberSet(DependentMemberSet setMember) {
        this.__m_ToMemberSet = setMember;
    }
}

