/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Sequel
extends MessagePacket {
    public Sequel() {
        this(null, null, true);
    }

    public Sequel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718552);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static int calcHeaderLength(MemberSet memberSet) {
        switch (Sequel.selectType(memberSet)) {
            case 0: {
                return 0;
            }
            case 232718553: {
                return 4 + 2 + 2 + 3 + 3 + 2;
            }
            case 232718551: {
                return 4 + 1 + 2 * memberSet.size() + 2 + 3 + 3 + 2;
            }
            case 232718552: {
                return 4 + 1 + 4 * ((memberSet.getLastId() + 31) / 32) + 2 + 3 + 3 + 2;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= (long)0 ? "none" : new StringBuilder(String.valueOf(new Time(ldtResend).toString())).append(".").append(ldtResend % (long)1000).toString();
        String sTimeout = ldtTimeout <= (long)0 ? "none" : new StringBuilder(String.valueOf(new Time(ldtTimeout).toString())).append(".").append(ldtTimeout % (long)1000).toString();
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", Body=");
        if (this.isOutgoing()) {
            sb.append(this.getReadBuffer() == null ? "Empty" : Base.toHexEscape(this.getReadBuffer().toByteArray()));
        } else {
            sb.append(this.getByteBuffer() == null ? "Empty" : Base.toHexEscape(new ByteBufferReadBuffer(this.getByteBuffer()).toByteArray()));
        }
        return sb.toString();
    }

    public int getHeaderLength() {
        return Sequel.calcHeaderLength(this.getToMemberSet());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/messagePacket/Sequel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Sequel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        switch (this.getPacketType()) {
            case 232718553: {
                input.readUnsignedShort();
                break;
            }
            case 232718551: {
                input.skip(input.readUnsignedByte() << 1);
                break;
            }
            case 232718552: {
                input.skip(input.readUnsignedByte() << 2);
                break;
            }
            default: {
                throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(this.getPacketType()).toString());
            }
        }
        this.setFromId(input.readUnsignedShort());
        this.setFromMessageId(Packet.readUnsignedTrint(input));
        this.setMessagePartIndex(Packet.readUnsignedTrint(input));
        this.setBodyLength(input.readUnsignedShort());
        MessagePacket.assertIO(input.available() >= this.getBodyLength());
    }

    protected static int selectType(MemberSet memberSet) {
        int cMembers = memberSet == null ? 1 : memberSet.size();
        switch (cMembers) {
            case 0: {
                return MessagePacket.TYPE_NO_DESTINATION;
            }
            case 1: {
                return Packet.TYPE_SEQUEL_ONE;
            }
            case 2: {
                return Packet.TYPE_SEQUEL_FEW;
            }
        }
        if (cMembers > 255) {
            return Packet.TYPE_SEQUEL_MANY;
        }
        return 15 + 2 * cMembers <= 15 + 4 * ((memberSet.getLastId() + 31) / 32) ? Packet.TYPE_SEQUEL_FEW : Packet.TYPE_SEQUEL_MANY;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        int cbSkip = 0;
        switch (nType) {
            case 232718553: {
                cbSkip += 2;
                break;
            }
            case 232718551: {
                cbSkip += input.readUnsignedByte() << 1;
                break;
            }
            case 232718552: {
                cbSkip += input.readUnsignedByte() << 2;
                break;
            }
            default: {
                throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(nType).toString());
            }
        }
        Packet.ensureSkipBytes(input, cbSkip += 8);
        Packet.ensureSkipBytes(input, input.readUnsignedShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        DependentMemberSet memberSet = this.getToMemberSet();
        if (memberSet == null) {
            this.setPacketType(Packet.TYPE_SEQUEL_ONE);
            output.writeInt(Packet.TYPE_SEQUEL_ONE);
            output.writeShort(this.getToId());
        } else {
            DependentMemberSet dependentMemberSet = memberSet;
            synchronized (dependentMemberSet) {
                int nType = Sequel.selectType(memberSet);
                if (nType == MessagePacket.TYPE_NO_DESTINATION) return;
                boolean bl = false;
                if (bl) {
                    return;
                }
                this.setPacketType(nType);
                output.writeInt(nType);
                switch (nType) {
                    case 232718553: {
                        memberSet.writeOne(output);
                        break;
                    }
                    case 232718551: {
                        memberSet.writeFew(output);
                        break;
                    }
                    case 232718552: {
                        memberSet.writeMany(output);
                        break;
                    }
                    default: {
                        throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(nType).toString());
                    }
                }
            }
        }
        output.writeShort(this.getFromId());
        Packet.writeTrint(output, this.getFromMessageId());
        Packet.writeTrint(output, this.getMessagePartIndex());
        output.writeShort(this.getBodyLength());
        output.writeBuffer(this.getReadBuffer());
    }
}

