/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.CacheMessage;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.CacheHandler$BackingMapListener;
import com.tangosol.coherence.component.util.CacheHandler$EntrySet;
import com.tangosol.coherence.component.util.CacheHandler$KeySet;
import com.tangosol.coherence.component.util.CacheHandler$Validator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.InKeySetFilter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheHandler
extends Util
implements ClassLoaderAware,
NamedCache,
XmlSerializable,
Converter {
    public static final int MAX_MAP_RETRIES = 32;
    private transient MapListener __m_BackingMapListener;
    private int __m_CacheIndex;
    private String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private transient Converter __m_ConverterFromInternal;
    private transient Converter __m_ConverterToInternal;
    private Listeners __m_DeactivationListeners;
    private transient Object __m_IgnoreKey;
    private transient Map __m_IndexMap;
    private transient Map __m_LeaseMap;
    private transient MapListenerSupport __m_ListenerSupport;
    private transient CacheHandler __m_NextHandler;
    private boolean __m_PutExpiryWarned;
    private transient Map __m_ResourceMap;
    private transient Serializer __m_Serializer;
    private long __m_StandardLeaseMillis;
    private boolean __m_UseEventDaemon;
    private boolean __m_Valid;
    private static ListMap __mapChildren;

    static {
        CacheHandler.__initStatic();
    }

    public CacheHandler() {
        this(null, null, true);
    }

    public CacheHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheIndex(-1);
            this.setDeactivationListeners(new Listeners());
            this.setIgnoreKey(new Object());
            this.setPutExpiryWarned(false);
            this.setStandardLeaseMillis(20000L);
            this.setUseEventDaemon(true);
            this.setValid(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BackingMapListener", CacheHandler$BackingMapListener.get_CLASS());
        Class clazz2 = __mapChildren.put("EntrySet", CacheHandler$EntrySet.get_CLASS());
        Class clazz3 = __mapChildren.put("KeySet", CacheHandler$KeySet.get_CLASS());
        Class clazz4 = __mapChildren.put("Validator", CacheHandler$Validator.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        InvocableMapHelper.addIndex(extractor, fOrdered, comparator, this, this.ensureIndexMap());
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().add(listener);
            return;
        } else {
            Component._assert(listener != null);
            MapListenerSupport support = this.getListenerSupport();
            if (support == null) {
                support = new MapListenerSupport();
                this.setListenerSupport(support);
            }
            if (MapListenerSupport.isPrimingListener(listener)) {
                if (!(filter instanceof InKeySetFilter)) throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
                Set<?> colKeys = ((InKeySetFilter)filter).getKeys();
                Iterator iter = colKeys.iterator();
                while (iter.hasNext()) {
                    this.addMapListener(listener, iter.next(), fLite);
                }
                return;
            } else {
                support.addListener(this.wrap(listener), filter, fLite);
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(this.wrap(listener), oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate((Collection)this.keySet(filter), agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    protected void checkAccess() {
        if (!(Thread.currentThread() != this.getService().getThread()) ? false : this.isValid() ^ true) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Map has been invalidated:\n")).append(this).toString());
        }
    }

    public void clear() {
        Enumeration enumeration = this.getResourceKeys();
        while (enumeration.hasMoreElements()) {
            Object oKey = enumeration.nextElement();
            this.remove(oKey, false);
        }
    }

    public boolean containsKey(Object oKey) {
        this.checkAccess();
        return this.getResourceMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        this.checkAccess();
        Map mapResource = this.getResourceMap();
        return mapResource.containsValue(oValue) ? true : mapResource.containsValue(ExternalizableHelper.toBinary(oValue, this.getSerializer()));
    }

    public Object convert(Object o) {
        return this.getCachedResource(o);
    }

    public void destroy() {
        this.getCacheService().destroyCache(this);
    }

    protected void dispatchEvent(MapEvent event) {
        if (event != null) {
            CacheHandler handler = this;
            do {
                MapListenerSupport support;
                if (!((support = handler.getListenerSupport()) != null)) continue;
                handler.dispatchEvent(event, support);
            } while ((handler = handler.getNextHandler()) != null);
        }
    }

    public void dispatchEvent(MapEvent event, MapListenerSupport support) {
        event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
        if (this.isUseEventDaemon()) {
            Listeners listeners = support.collectListeners(event);
            CacheEvent.dispatchSafe(MapListenerSupport.enrichEvent(event, listeners), listeners, this.getService().ensureEventDispatcher().getQueue());
        } else {
            support.fireEvent(event, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map ensureIndexMap() {
        SafeHashMap mapIndex = this.getIndexMap();
        if (mapIndex == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                mapIndex = this.getIndexMap();
                if (mapIndex == null) {
                    mapIndex = new SafeHashMap();
                    this.setIndexMap(mapIndex);
                }
            }
        }
        return mapIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease ensureLease(Object oKey) {
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            Map mapLease;
            Map map = mapLease = this.getLeaseMap();
            synchronized (map) {
                lease = this.getLease(oKey);
                if (lease == null) {
                    lease = Lease.instantiate(this.getCacheIndex(), oKey, this.getService());
                    mapLease.put(oKey, lease);
                }
            }
        }
        return lease;
    }

    public Set entrySet() {
        this.checkAccess();
        CacheHandler$EntrySet set = (CacheHandler$EntrySet)this._newChild("EntrySet");
        set.setMap(this);
        set.setSet(this.getResourceMap().entrySet());
        return set;
    }

    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, false, null);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, true, comparator);
    }

    public void fromXml(XmlElement xml) {
        Component._assert(xml.getName().equals(this.get_Name()));
        this.setCacheName(xml.getElement("CacheName").getString());
        this.setCacheIndex(xml.getElement("CacheIndex").getInt());
        this.setStandardLeaseMillis(xml.getElement("StandardLeaseMillis").getLong());
    }

    public Object get(Object oKey) {
        return this.getCachedResource(oKey);
    }

    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Object oVal = this.get(oKey);
            if (!(oVal != null ? true : this.containsKey(oKey))) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    protected MapListener getBackingMapListener() {
        return this.__m_BackingMapListener;
    }

    public int getCacheIndex() {
        return this.__m_CacheIndex;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return this.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedResource(Object oKey) {
        ClassLoader loaderResource;
        Object oResource;
        this.checkAccess();
        boolean fNew = false;
        Map mapResource = this.getResourceMap();
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            if (mapResource.containsKey(oKey) ^ true) {
                return null;
            }
            lease = this.ensureLease(oKey);
            fNew = true;
        }
        Lease lease2 = lease;
        synchronized (lease2) {
            oResource = mapResource.get(oKey);
            loaderResource = lease.getClassLoader();
            if (fNew) {
                lease.incrementResourceVersion();
            }
        }
        ClassLoader loaderCache = this.getClassLoader();
        if (!(loaderResource != null) ? false : loaderResource != loaderCache) {
            oResource = this.releaseClassLoader(lease);
        }
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert(binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), new StringBuilder(String.valueOf("CacheName=")).append(this.getCacheName()).append(", Key=").append(oKey).toString());
            }
            Lease lease3 = lease;
            synchronized (lease3) {
                if (binValue == mapResource.get(oKey)) {
                    lease.setClassLoader(loaderCache);
                    lease.setResourceSize(binValue.length());
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Converter getConverterFromInternal() {
        Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterFromInternal(loader);
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Converter getConverterToInternal() {
        Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterToInternal(loader);
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public Listeners getDeactivationListeners() {
        return this.__m_DeactivationListeners;
    }

    public Object getIgnoreKey() {
        return this.__m_IgnoreKey;
    }

    public Map getIndexMap() {
        return this.__m_IndexMap;
    }

    public Lease getLease(Object oKey) {
        return (Lease)this.getLeaseMap().get(oKey);
    }

    public Enumeration getLeaseKeys() {
        return new SimpleEnumerator<Object>(this.getLeaseMap().keySet().toArray());
    }

    public Map getLeaseMap() {
        return this.__m_LeaseMap;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Object getLockedResource(Object oKey) {
        this.checkAccess();
        if (this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), -1)) {
            return this.getCachedResource(oKey);
        }
        throw new IllegalStateException();
    }

    public CacheHandler getNextHandler() {
        return this.__m_NextHandler;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator<Object>(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public ReplicatedCache getService() {
        return (ReplicatedCache)this.get_Parent();
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public TransactionMap.Validator getValidator() {
        return (CacheHandler$Validator)this._newChild("Validator");
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/CacheHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new CacheHandler();
    }

    private final Component get_Module() {
        return this;
    }

    protected boolean hasListeners() {
        CacheHandler handler = this;
        do {
            MapListenerSupport support;
            if (!((support = handler.getListenerSupport()) != null)) continue;
            return true;
        } while ((handler = handler.getNextHandler()) != null);
        return false;
    }

    private Map instantiateBackingMap(BackingMapManager manager, String sName) {
        Map map = null;
        try {
            map = manager.instantiateBackingMap(sName);
            if (map == null) {
                Component._trace(new StringBuilder(String.valueOf("BackingMapManager ")).append(manager.getClass().getName()).append(": returned \"null\" for a cache: ").append(sName).toString(), 1);
            } else if (map.isEmpty() ^ true) {
                map.clear();
            }
        }
        catch (RuntimeException e) {
            Component._trace(new StringBuilder(String.valueOf("BackingMapManager ")).append(manager.getClass().getName()).append(": failed to instantiate a cache: ").append(sName).toString(), 1);
            Component._trace(e);
        }
        if (map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(this.instantiateBackingMapListener());
        }
        return map;
    }

    protected MapListener instantiateBackingMapListener() {
        CacheHandler$BackingMapListener listener = (CacheHandler$BackingMapListener)this._newChild("BackingMapListener");
        this.setBackingMapListener(listener);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidate() {
        CacheHandler cacheHandler = this;
        synchronized (cacheHandler) {
            String sName;
            BackingMapManager manager;
            if (this.isValid() ^ true) {
                return;
            }
            Map mapResource = this.getResourceMap();
            MapListener listener = this.getBackingMapListener();
            if (listener != null) {
                ((ObservableMap)mapResource).removeMapListener(listener);
                this.setBackingMapListener(null);
            }
            if ((manager = this.getService().getBackingMapManager()) != null && (sName = this.getCacheName()) != null) {
                try {
                    manager.releaseBackingMap(sName, mapResource);
                }
                catch (RuntimeException e) {
                    Component._trace(new StringBuilder(String.valueOf("BackingMapManager ")).append(manager.getClass().getName()).append(": failed to release a cache: ").append(sName).toString(), 1);
                    Component._trace(e);
                }
            }
            this.setClassLoader(null);
            this.setListenerSupport(null);
            this.setConverterFromInternal(null);
            this.setConverterToInternal(null);
            this.getLeaseMap().clear();
            this.setResourceMap(new SafeHashMap());
            this.setValid(false);
        }
        Listeners listeners = this.getDeactivationListeners();
        if (listeners.isEmpty() ^ true) {
            com.tangosol.net.cache.CacheEvent<Object, Object> evt = new com.tangosol.net.cache.CacheEvent<Object, Object>(this, MapEvent.ENTRY_DELETED, null, null, null, true);
            CacheEvent.dispatchSafe(evt, listeners, null);
        }
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll((Collection)this.keySet(filter), agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    public boolean isActive() {
        return this.getClassLoader() != null;
    }

    public boolean isEmpty() {
        this.checkAccess();
        return this.getResourceMap().isEmpty();
    }

    public boolean isPutExpiryWarned() {
        return this.__m_PutExpiryWarned;
    }

    public boolean isUseEventDaemon() {
        return this.__m_UseEventDaemon;
    }

    public boolean isValid() {
        return this.__m_Valid;
    }

    public Set keySet() {
        this.checkAccess();
        CacheHandler$KeySet set = (CacheHandler$KeySet)this._newChild("KeySet");
        set.setMap(this);
        set.setSet(this.getResourceMap().keySet());
        return set;
    }

    public Set keySet(Filter filter) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, false, false, null);
    }

    public boolean lock(Object oKey) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), 0);
    }

    public boolean lock(Object oKey, long cWait) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), cWait);
    }

    public void onFarewell(Member member) {
        Enumeration enumeration = this.getLeaseKeys();
        while (enumeration.hasMoreElements()) {
            Object oKey = enumeration.nextElement();
            Lease lease = this.getLease(oKey);
            if (!(lease != null)) continue;
            this.validateLease(lease);
        }
    }

    public void onInit() {
        super.onInit();
        if (this.getLeaseMap() == null) {
            Map mapLease;
            int nGraveyardSize = this.getService().getReplicatedCacheDependencies().getGraveyardSize();
            if (nGraveyardSize > 0) {
                ObservableHashMap mapFront = new ObservableHashMap();
                LocalCache mapBack = new LocalCache(nGraveyardSize, 0);
                mapBack.setEvictionType(OldCache.EVICTION_POLICY_LRU);
                mapLease = new OverflowMap(mapFront, mapBack);
            } else {
                mapLease = new SafeHashMap();
            }
            this.setLeaseMap(mapLease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaseRemove(Lease lease) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.getLease(oKey);
        if (leaseCurrent == null) {
            return;
        }
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            Component._trace(new StringBuilder(String.valueOf("Rejected remove: ")).append(leaseCurrent).append("\n by ").append(lease).toString(), 4);
            throw new EventDeathException();
        }
        MapEvent<Object, Object> event = null;
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            Object oValueOld;
            CacheHandler handlerNext;
            boolean fNotify = !(!this.isActive() ? false : this.hasListeners()) ? false : this.containsKey(oKey);
            CacheHandler handlerBase = this;
            while (!((handlerNext = handlerBase.getNextHandler()) == null)) {
                handlerBase = handlerNext;
            }
            handlerBase.setIgnoreKey(oKey);
            try {
                oValueOld = this.getResourceMap().remove(oKey);
            }
            finally {
                Object var11_13 = null;
                handlerBase.setIgnoreKey(this);
            }
            if (fNotify) {
                event = new MapEvent<Object, Object>(this, MapEvent.ENTRY_DELETED, oKey, oValueOld, null);
            }
            if (leaseCurrent.getStatus() == Lease.LEASE_AVAILABLE) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            this.dispatchEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaseUpdate(Lease lease, boolean fUpdateResource, Object oValue, long cExpiryMillis) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.ensureLease(oKey);
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            Component._trace(new StringBuilder(String.valueOf("Rejected update: ")).append(leaseCurrent).append("\n by ").append(lease).toString(), 4);
            throw new EventDeathException();
        }
        MapEvent<Object, Object> event = null;
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            leaseCurrent.copyFrom(lease);
            Map mapResource = this.getResourceMap();
            if (fUpdateResource) {
                Object oValueOld;
                int nEventId = 0;
                if (!this.isActive() ? false : this.hasListeners()) {
                    nEventId = this.containsKey(oKey) ? MapEvent.ENTRY_UPDATED : MapEvent.ENTRY_INSERTED;
                }
                leaseCurrent.setClassLoader(oValue instanceof Binary ? null : this.getClassLoader());
                if (mapResource instanceof CacheMap) {
                    oValueOld = ((CacheMap)mapResource).put(oKey, oValue, cExpiryMillis);
                } else {
                    if (cExpiryMillis > (long)0) {
                        Component._trace(new StringBuilder(String.valueOf("UnsupportedOperation: ")).append("class \"").append(mapResource.getClass().getName()).append("\" does not implement CacheMap interface").toString(), 1);
                    }
                    oValueOld = mapResource.put(oKey, oValue);
                }
                if (nEventId > 0) {
                    event = new MapEvent<Object, Object>(this, nEventId, oKey, oValueOld, oValue);
                }
            } else if (!(leaseCurrent.getStatus() == Lease.LEASE_AVAILABLE) ? false : mapResource.containsKey(oKey) ^ true) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            this.dispatchEvent(event);
        }
    }

    public void populateCache(CacheMessage msg) {
        ReplicatedCache service = this.getService();
        int iCache = this.getCacheIndex();
        int cLease = msg.getLeaseCount();
        ReadBuffer.BufferInput input = new ByteArrayReadBuffer(msg.getCacheData()).getBufferInput();
        int i = 0;
        while (i < cLease) {
            try {
                Object oKey = msg.readObject(input);
                Lease lease = Lease.instantiate(iCache, oKey, service);
                lease.read(input);
                Binary binResource = (Binary)msg.readObject(input);
                if (binResource == null) {
                    this.onLeaseUpdate(lease, false, null, 0L);
                } else {
                    lease.setResourceSize(binResource.length());
                    this.onLeaseUpdate(lease, true, binResource, 0L);
                }
            }
            catch (EventDeathException e) {
            }
            catch (IOException e) {
                Component._trace(new StringBuilder(String.valueOf("An exception (")).append(e).append(") occurred while populating cache: ").append(this).toString(), 1);
                Component._trace(e);
                break;
            }
            ++i;
        }
    }

    public Enumeration populateUpdateMessage(CacheMessage msg, int cbSize, Enumeration enumeration) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        int nOldestId = service.getServiceOldestMember().getId();
        Serializer serializer = this.getSerializer();
        Map mapResource = this.getResourceMap();
        ByteArrayOutputStream streamBytes = new ByteArrayOutputStream(1024);
        DataOutputStream streamData = new DataOutputStream(streamBytes);
        AbstractWriteBuffer resBytes = null;
        WriteBuffer.BufferOutput output = null;
        int cLease = 0;
        if (enumeration == null) {
            enumeration = this.getLeaseKeys();
        }
        while (enumeration.hasMoreElements()) {
            Object oKey = enumeration.nextElement();
            Lease lease = this.getLease(oKey);
            if (lease == null) continue;
            lease.validate();
            boolean fInclude = false;
            switch (lease.getStatus()) {
                case 1: {
                    lease.setIssuerId(nOldestId);
                }
                case 2: 
                case 3: 
                case 4: {
                    fInclude = lease.getIssuerId() == nThisId;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!fInclude) continue;
            try {
                Binary binResource = null;
                if (mapResource.containsKey(oKey)) {
                    Object oResource = mapResource.get(oKey);
                    binResource = oResource instanceof Binary ? (Binary)oResource : ExternalizableHelper.toBinary(oResource, serializer);
                }
                if (resBytes == null) {
                    int cb = lease.getResourceSize();
                    resBytes = new ByteArrayWriteBuffer(cb <= 0 ? 256 : 32 + cb);
                } else {
                    resBytes.clear();
                }
                output = resBytes.getBufferOutput();
                msg.writeObject(output, oKey);
                lease.write(output);
                msg.writeObject(output, binResource);
            }
            catch (IOException e) {
                Component._trace(new StringBuilder(String.valueOf("An exception (")).append(e).append(") occurred while serializing ").append(lease).append(" for ").append(this).toString(), 1);
                Component._trace(e);
                continue;
            }
            try {
                streamData.write(((ByteArrayWriteBuffer)resBytes).toByteArray());
            }
            catch (IOException e) {
                Component._trace(new StringBuilder(String.valueOf("An exception (")).append(e).append(") occurred while streaming the message ").append(msg).append(" for ").append(this).toString(), 1);
                Component._trace(e);
                msg.setLeaseCount(0);
                msg.setCacheData(new byte[0]);
                return null;
            }
            ++cLease;
            if (streamData.size() > cbSize) break;
        }
        msg.setLeaseCount(cLease);
        msg.setCacheData(streamBytes.toByteArray());
        return enumeration.hasMoreElements() ? enumeration : null;
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        if (!(cMillis != CacheMap.EXPIRY_DEFAULT) ? false : this.isPutExpiryWarned() ^ true) {
            Component._trace(new StringBuilder(String.valueOf("ReplicatedCache does not support per-entry expiration; ")).append("proceeding with the cache-configured expiry.").toString(), 2);
            this.setPutExpiryWarned(true);
        }
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int i = 1;
        int c = MAX_MAP_RETRIES;
        while (i <= c) {
            try {
                return this.getService().updateResource(this, oKey, oValue, cMillis, false, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Blocking.sleep(i << 4);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
                ++i;
            }
        }
        throw cme;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue(), 0L, false);
        }
    }

    public Object putFinal(Object oKey, Object oValue, boolean fReturn) throws ConcurrentModificationException {
        this.checkAccess();
        return this.getService().updateResource(this, oKey, oValue, 0L, true, fReturn);
    }

    public void release() {
        this.getCacheService().releaseCache(this);
    }

    public void releaseClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            this.setClassLoader(null);
            ReplicatedCache service = this.getService();
            Enumeration enumeration = this.getLeaseKeys();
            while (enumeration.hasMoreElements()) {
                Object oKey = enumeration.nextElement();
                Lease lease = this.getLease(oKey);
                if (!(lease != null)) continue;
                if (service.getThreadStatus(lease) == Lease.LEASE_LOCKED) {
                    service.unlockResource(this, oKey);
                }
                if (!(lease.getClassLoader() == loader)) continue;
                this.releaseClassLoader(lease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object releaseClassLoader(Lease lease) {
        Lease lease2 = lease;
        synchronized (lease2) {
            Map mapResource = this.getResourceMap();
            Object oKey = lease.getResourceKey();
            Object oValue = mapResource.get(oKey);
            lease.setClassLoader(null);
            if (oValue != null ? true : mapResource.containsKey(oKey)) {
                try {
                    Object oInternal = this.getConverterToInternal().convert(oValue);
                    if (oInternal != oValue) {
                        oValue = oInternal;
                        mapResource.put(oKey, oValue);
                    }
                }
                catch (WrapperException e) {
                    throw new WrapperException(e.getOriginalException(), new StringBuilder(String.valueOf("CacheName=")).append(this.getCacheName()).append(", Key=").append(oKey).toString());
                }
            }
            Object v = oValue;
            return v;
        }
    }

    public void releaseIndexMap() {
        Map mapIndex = this.getIndexMap();
        if (mapIndex != null) {
            HashSet setExtractors = new HashSet(mapIndex.keySet());
            Iterator iter = setExtractors.iterator();
            while (iter.hasNext()) {
                this.removeIndex((ValueExtractor)iter.next());
            }
            this.setIndexMap(null);
        }
    }

    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int i = 1;
        int c = MAX_MAP_RETRIES;
        while (i <= c) {
            try {
                return this.getService().removeResource(this, oKey, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Blocking.sleep(i << 4);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
                ++i;
            }
        }
        throw cme;
    }

    public void removeIndex(ValueExtractor extractor) {
        InvocableMapHelper.removeIndex(extractor, this, this.ensureIndexMap());
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().remove(listener);
        } else {
            Component._assert(listener != null);
            MapListenerSupport support = this.getListenerSupport();
            if (support != null) {
                support.removeListener(this.wrap(listener), filter);
                if (support.isEmpty()) {
                    this.setListenerSupport(null);
                }
            }
        }
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(this.wrap(listener), oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    protected void setBackingMapListener(MapListener listener) {
        this.__m_BackingMapListener = listener;
    }

    public void setCacheIndex(int index) {
        int indexOld;
        if (this.is_Constructed() && (!((indexOld = this.getCacheIndex()) != -1) ? false : index != indexOld)) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Attempt to modify the CacheIndex: ")).append(this).append(" to ").append(index).toString());
        }
        this.__m_CacheIndex = index;
    }

    public void setCacheName(String sName) {
        if (this.is_Constructed()) {
            Map mapActual;
            boolean fClone;
            String sNameOld = this.getCacheName();
            if (!(sNameOld != null) ? false : sNameOld.equals(sName) ^ true) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Attempt to modify the CacheName: ")).append(this).append(" to ").append(sName).toString());
            }
            BackingMapManager manager = this.getService().getBackingMapManager();
            Map map = this.getResourceMap();
            boolean bl = fClone = this.getNextHandler() != null;
            if (fClone) {
                Component._assert(map != null, "Resource map must be copied");
            } else if (map == null) {
                if (manager != null) {
                    if (sName == null) {
                        Component._trace(new StringBuilder(String.valueOf("Creating a temporary map: ")).append(this.getCacheIndex()).toString(), 5);
                    } else {
                        map = this.instantiateBackingMap(manager, sName);
                    }
                }
                this.setResourceMap(map == null ? new SafeHashMap() : map);
            } else if ((!(!(sName != null) ? false : sNameOld == null) ? false : manager != null) && (mapActual = this.instantiateBackingMap(manager, sName)) != null) {
                if (map.isEmpty() ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("Transferring ")).append(map.size()).append(" to: ").append(sName).toString(), 5);
                    mapActual.putAll(map);
                }
                this.setResourceMap(mapActual);
            }
        }
        this.__m_CacheName = sName;
    }

    public synchronized void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
        this.setConverterFromInternal(null);
        this.setSerializer(loader == null ? null : this.getService().ensureSerializer(loader));
    }

    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected void setConverterFromInternal(Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setDeactivationListeners(Listeners listeners) {
        this.__m_DeactivationListeners = listeners;
    }

    protected void setIgnoreKey(Object oKey) {
        this.__m_IgnoreKey = oKey;
    }

    public void setIndexMap(Map map) {
        this.__m_IndexMap = map;
    }

    public void setLeaseMap(Map map) {
        this.__m_LeaseMap = map;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setNextHandler(CacheHandler handler) {
        this.__m_NextHandler = handler;
    }

    protected void setPutExpiryWarned(boolean fWarned) {
        this.__m_PutExpiryWarned = fWarned;
    }

    public void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    public void setStandardLeaseMillis(long lMillis) {
        this.__m_StandardLeaseMillis = Math.max(0L, lMillis);
    }

    public void setUseEventDaemon(boolean pUseEventDaemon) {
        this.__m_UseEventDaemon = pUseEventDaemon;
    }

    protected void setValid(boolean fValid) {
        this.__m_Valid = fValid;
    }

    public int size() {
        this.checkAccess();
        return this.getResourceMap().size();
    }

    public void terminateLease(Object oKey) {
        Map mapLease = this.getLeaseMap();
        if (mapLease instanceof OverflowMap) {
            ObservableMap mapFront = ((OverflowMap)mapLease).getFrontMap();
            mapFront.remove(oKey);
        } else {
            mapLease.remove(oKey);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", Index=").append(this.getCacheIndex()).append(", ServiceName=").append(this.getService().getServiceName());
        if (this.isValid()) {
            sb.append(", ClassLoader=").append(this.getClassLoader());
        } else {
            sb.append(", INVALID");
        }
        sb.append('}');
        return sb.toString();
    }

    public XmlElement toXml() {
        SimpleElement xml = new SimpleElement(this.get_Name());
        xml.addElement("CacheName").setString(this.getCacheName());
        xml.addElement("CacheIndex").setInt(this.getCacheIndex());
        xml.addElement("StandardLeaseMillis").setLong(this.getStandardLeaseMillis());
        return xml;
    }

    public boolean unlock(Object oKey) {
        this.checkAccess();
        return this.getService().unlockResource(this, oKey);
    }

    protected void validateLease(Lease lease) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        lease.validate();
        switch (lease.getStatus()) {
            case 1: {
                lease.setIssuerId(service.getServiceOldestMember().getId());
            }
            case 2: {
                Object oKey = lease.getResourceKey();
                if (!(this.getResourceMap().containsKey(oKey) ^ true)) break;
                this.terminateLease(oKey);
                break;
            }
            case 3: 
            case 4: {
                if (!(lease.getIssuerId() == 0)) break;
                lease.setIssuerId(lease.getHolderId());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Collection values() {
        this.checkAccess();
        return ConverterCollections.getCollection(this.getResourceMap().keySet(), this, NullImplementation.getConverter());
    }

    protected MapListener wrap(MapListener listener) {
        return ContainerHelper.getContextAwareListener(this.getService(), listener);
    }
}

