/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import java.io.File;
import java.io.IOException;

public abstract class FileHelper
extends Util {
    public FileHelper(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static String getRelativePath(String sPath, String sRoot) {
        char SEP = File.separatorChar;
        try {
            String sRootAbs = new File(sRoot).getCanonicalPath();
            String sPathAbs = new File(sPath).getCanonicalPath();
            if (sPathAbs.equals(sRootAbs)) {
                return "./";
            }
            if (sPathAbs.startsWith(new StringBuilder(String.valueOf(sRootAbs)).append(SEP).toString())) {
                return new StringBuilder(String.valueOf("./")).append(sPathAbs.substring(sRootAbs.length() + 1).replace(SEP, '/')).toString();
            }
            char[] achRoot = sRootAbs.toCharArray();
            char[] achPath = sPathAbs.toCharArray();
            int cMin = Math.min(achRoot.length, achPath.length);
            int ofRoot = -1;
            int ofDiff = cMin;
            int of = 0;
            while (of < cMin) {
                char ch = achPath[of];
                if (ch == achRoot[of]) {
                    if (ch == SEP) {
                        ofRoot = of;
                    }
                } else {
                    ofDiff = of;
                    break;
                }
                ++of;
            }
            if (ofRoot > 0) {
                StringBuffer sbPath = new StringBuffer();
                int of2 = achRoot.length - 1;
                while (of2 >= ofRoot) {
                    if (achRoot[of2] == SEP) {
                        sbPath.append("../");
                    }
                    --of2;
                }
                sbPath.append(sPathAbs.substring(ofRoot + 1).replace(SEP, '/'));
                Component._assert(new File(new File(sRoot), sbPath.toString()).getCanonicalPath().equals(sPathAbs));
                return sbPath.toString();
            }
        }
        catch (IOException iOException) {}
        return sPath.replace('\\', '/');
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/FileHelper".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static boolean isFullyAccessible(File file) {
        try {
            file = file.getCanonicalFile();
            if (file.exists()) {
                if (file.canRead() ^ true ? true : file.canWrite() ^ true) {
                    return false;
                }
                File fileTmp = File.createTempFile("tmp", ".tmp", file.getParentFile());
                fileTmp.delete();
                if (file.renameTo(fileTmp) ^ true) {
                    return false;
                }
                if (fileTmp.renameTo(file) ^ true) {
                    throw new IllegalStateException(new StringBuilder(String.valueOf("File: ")).append(file).append(" was temporarily renamed to: ").append(fileTmp).append(" but could not be renamed back. The operation should be performed manually.").toString());
                }
                return true;
            }
            if (file.createNewFile()) {
                file.delete();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

