/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.extend.connection.TcpConnection;
import com.tangosol.coherence.component.net.extend.protocol.NameServiceProtocol;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.NameServiceProxy;
import com.tangosol.coherence.component.util.NameService$RequestContext;
import com.tangosol.coherence.component.util.NameService$TcpAcceptor;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.extend.DefaultNameServiceDependencies;
import com.tangosol.internal.net.service.extend.LegacyXmlNameServiceHelper;
import com.tangosol.internal.net.service.extend.NameServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NameService;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.internal.NameServicePofContext;
import com.tangosol.net.internal.WrapperSocketAddressProvider;
import com.tangosol.net.messaging.Channel;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class NameService
extends Util
implements Disposable,
SerializerFactory,
com.tangosol.net.NameService,
NameService.LookupCallback {
    private NameService$TcpAcceptor __m_Acceptor;
    private ConcurrentHashMap __m_BinderMap;
    private Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private ServiceDependencies __m_Dependencies;
    private transient Map __m_Directory;
    private transient List __m_LookupCallbacks;
    private NameServiceProxy __m_NameServiceProxy;
    private OperationalContext __m_OperationalContext;
    private String __m_ServiceName;
    private static ListMap __mapChildren;

    static {
        NameService.__initStatic();
    }

    public NameService() {
        this(null, null, true);
    }

    public NameService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBinderMap(new ConcurrentHashMap());
            this.setDirectory(new ConcurrentHashMap());
            this.setLookupCallbacks(new SafeLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new NameService$TcpAcceptor("TcpAcceptor", this, true), "TcpAcceptor");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("RequestContext", NameService$RequestContext.get_CLASS());
    }

    public void addLookupCallback(NameService.LookupCallback callback) {
        this.getLookupCallbacks().add(callback);
    }

    public void addMemberListener(MemberListener l) {
        throw new UnsupportedOperationException();
    }

    public void addServiceListener(ServiceListener l) {
        throw new UnsupportedOperationException();
    }

    public void bind(String sName, Object o) throws NamingException {
        this.bind(sName, o, null);
    }

    public void bind(String sName, Object o, Channel chan) throws NameAlreadyBoundException, NamingException {
        if (chan != null) {
            com.tangosol.coherence.component.net.Cluster cluster = (com.tangosol.coherence.component.net.Cluster)this.getCluster();
            if (InetAddresses.isLocalAddress(((TcpConnection)chan.getConnection()).getSocket().getInetAddress()) ^ true) {
                throw new UnsupportedOperationException("non-local bind attempt");
            }
            if (cluster.isClusterPortSharingEnabled() ^ true) {
                throw new UnsupportedOperationException("cluster port sharing is not supported");
            }
            if (o instanceof NameService.Resolvable) {
                throw new UnsupportedOperationException("remote Resolvable bind is not supported");
            }
        }
        if (this.getDirectory().putIfAbsent(sName, o) == null) {
            if (chan != null) {
                ConcurrentHashMap mapBind = this.getBinderMap();
                Set setNames = (Set)mapBind.get(chan);
                if (setNames == null) {
                    setNames = new SafeHashSet();
                    mapBind.put(chan, setNames);
                }
                setNames.add(sName);
            }
        } else {
            throw new NameAlreadyBoundException(sName);
        }
    }

    protected DefaultNameServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultNameServiceDependencies((NameServiceDependencies)deps);
    }

    public void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlNameServiceHelper.fromXml(xml, new DefaultNameServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
    }

    public Serializer createSerializer(ClassLoader loader) {
        return this.getSerializer();
    }

    public void dispose() {
        this.shutdown();
    }

    public NameService$TcpAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public ConcurrentHashMap getBinderMap() {
        return this.__m_BinderMap;
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public ServiceDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public Map getDirectory() {
        return this.__m_Directory;
    }

    public ServiceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public InetAddress getLocalAddress() {
        NameService$TcpAcceptor acceptor = this.getAcceptor();
        return ((InetSocketAddress32)(acceptor.isRunning() ^ true ? ((DefaultTcpAcceptorDependencies)((NameServiceDependencies)this.getDependencies()).getAcceptorDependencies()).getLocalAddressProviderBuilder().realize(new NullParameterResolver(), this.getContextClassLoader(), null).getNextAddress() : acceptor.getLocalAddress())).getAddress();
    }

    public List getLookupCallbacks() {
        return this.__m_LookupCallbacks;
    }

    public NameServiceProxy getNameServiceProxy() {
        return this.__m_NameServiceProxy;
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public ResourceRegistry getResourceRegistry() {
        return null;
    }

    public Serializer getSerializer() {
        return NameServicePofContext.INSTANCE;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public Object getUserContext() {
        throw new UnsupportedOperationException();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/NameService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new NameService();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        return this.getAcceptor().isRunning();
    }

    public Object lookup(String sName) throws NamingException {
        NameService$RequestContext context = new NameService$RequestContext();
        context.setMember(this.getCluster().getLocalMember());
        return this.lookup(sName, context);
    }

    public Object lookup(String sName, Cluster cluster, NameService.RequestContext ctx) throws NamingException {
        String sPrefix = "NameService/";
        if (!(sName != null) ? false : sName.startsWith(sPrefix)) {
            String sString;
            if ((sName = sName.substring(sPrefix.length())).startsWith(sString = "string/")) {
                Object o = this.lookup(sName.substring(sString.length()), ctx);
                return o == null ? null : (o instanceof Object[] ? Arrays.toString((Object[])o) : o.toString());
            }
            if (sName.equals("directory")) {
                return this.getDirectory().keySet();
            }
            if (sName.equals("localInetAddress")) {
                return this.getLocalAddress();
            }
        }
        return null;
    }

    public Object lookup(String sName, NameService.RequestContext context) throws NamingException {
        if (sName == null) {
            throw new NamingException("lookup name must be specified");
        }
        Map map = this.getDirectory();
        Object oResult = this.getDirectory().get(sName);
        if (!(oResult == null) ? false : map.containsKey(sName) ^ true) {
            Iterator iter = this.getLookupCallbacks().iterator();
            while (iter.hasNext()) {
                oResult = ((NameService.LookupCallback)iter.next()).lookup(sName, this.getCluster(), context);
                if (oResult != null) break;
            }
        }
        return oResult instanceof NameService.Resolvable ? ((NameService.Resolvable)oResult).resolve(context) : oResult;
    }

    protected void onDependencies(NameServiceDependencies deps) {
        if (this.getOperationalContext() == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        NameServiceProxy nameServiceProxy = new NameServiceProxy();
        this.setNameServiceProxy(nameServiceProxy);
        nameServiceProxy.setNameService(this);
        NameService$TcpAcceptor acceptor = this.getAcceptor();
        acceptor.setOperationalContext(this.getOperationalContext());
        acceptor.setDependencies(((NameServiceDependencies)this.getDependencies()).getAcceptorDependencies());
        acceptor.setServiceName(new StringBuilder(String.valueOf(this.getServiceName())).append(':').append(acceptor.getServiceName()).toString());
        acceptor.setParentService(this);
        acceptor.setLocalAddressProvider(new WrapperSocketAddressProvider(acceptor.getLocalAddressProvider(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getSubPort()));
        acceptor.setSerializerFactory(this);
        acceptor.setWrapperStreamFactoryList(null);
        acceptor.registerProtocol(NameServiceProtocol.getInstance());
        if (this.getNameServiceProxy().isEnabled()) {
            acceptor.registerReceiver(this.getNameServiceProxy());
        }
        acceptor.setContextClassLoader(this.getContextClassLoader());
    }

    public void onInit() {
        super.onInit();
        this.setServiceName(com.tangosol.net.NameService.NAME_DEFAULT);
        this.setAcceptor((NameService$TcpAcceptor)this._findChild("TcpAcceptor"));
        this.addLookupCallback(this);
    }

    public void removeMemberListener(MemberListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeServiceListener(ServiceListener l) {
        throw new UnsupportedOperationException();
    }

    protected void setAcceptor(NameService$TcpAcceptor acceptor) {
        this.__m_Acceptor = acceptor;
    }

    public void setBinderMap(ConcurrentHashMap mapBinder) {
        this.__m_BinderMap = mapBinder;
    }

    public void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        this.getAcceptor().setContextClassLoader(loader);
    }

    public void setDependencies(ServiceDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies((NameServiceDependencies)this.getDependencies());
    }

    protected void setDirectory(Map map) {
        this.__m_Directory = map;
    }

    public void setLookupCallbacks(List listCallbacks) {
        this.__m_LookupCallbacks = listCallbacks;
    }

    protected void setNameServiceProxy(NameServiceProxy proxy) {
        this.__m_NameServiceProxy = proxy;
    }

    public void setOperationalContext(OperationalContext ctx) {
        this.__m_OperationalContext = ctx;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setUserContext(Object oCtx) {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        try {
            this.getAcceptor().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop();
    }

    public void start() {
        this.getAcceptor().start();
    }

    public void stop() {
        try {
            this.getAcceptor().stop();
        }
        catch (Exception exception) {}
    }

    public String toString() {
        ServerSocket socket = this.getAcceptor().getProcessor().getServerSocket();
        return new StringBuilder(String.valueOf(this.get_Name())).append("(").append(socket == null ? (Object)this.getAcceptor().getLocalAddressProvider() : (Object)socket).append(")").toString();
    }

    public void unbind(String sName) throws NamingException {
        this.getDirectory().remove(sName);
    }
}

