/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Notifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;

public class Queue
extends Util
implements Notifier {
    private volatile RecyclingLinkedList __m_ElementList;
    private volatile transient boolean __m_Signaled;
    private static ListMap __mapChildren;

    static {
        Queue.__initStatic();
    }

    public Queue() {
        this(null, null, true);
    }

    public Queue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setElementList(new RecyclingLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", Queue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        this.getElementList().add(oElement);
        this.signal();
        return true;
    }

    public boolean addHead(Object oElement) {
        this.getElementList().add(0, oElement);
        this.signal();
        return true;
    }

    public void await() throws InterruptedException {
        this.await(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long cMillis) throws InterruptedException {
        if (!(this.isAvailable() ^ true) ? false : this.isSignaled() ^ true) {
            Queue queue = this;
            synchronized (queue) {
                if (!(this.isAvailable() ^ true) ? false : this.isSignaled() ^ true) {
                    Blocking.wait(this, cMillis);
                }
            }
        }
        this.setSignaled(false);
    }

    public void flush() {
    }

    protected RecyclingLinkedList getElementList() {
        return this.__m_ElementList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/Queue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Queue();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAvailable() {
        return this.isEmpty() ^ true;
    }

    public boolean isEmpty() {
        return this.getElementList().isEmpty();
    }

    protected boolean isSignaled() {
        return this.__m_Signaled;
    }

    public Iterator iterator() {
        Queue$Iterator iter = (Queue$Iterator)this._newChild("Iterator");
        iter.setList(this.getElementList());
        return iter;
    }

    public Object peekNoWait() {
        return this.getElementList().getFirst();
    }

    public Object remove() {
        return this.remove(0L);
    }

    public Object remove(long cMillis) {
        Object o = this.removeNoWait();
        while (o == null) {
            long cWait = cMillis <= 0L ? 1000L : Math.min(1000L, cMillis);
            try {
                this.await(cWait);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            o = this.removeNoWait();
            if (cMillis > 0L && (cMillis -= cWait) <= 0L) break;
        }
        return o;
    }

    public Object removeNoWait() {
        return this.getElementList().removeFirst();
    }

    protected void setElementList(RecyclingLinkedList list) {
        this.__m_ElementList = list;
    }

    protected void setSignaled(boolean fSignaled) {
        this.__m_Signaled = fSignaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        Queue queue = this;
        synchronized (queue) {
            this.setSignaled(true);
            this.notifyAll();
        }
    }

    public int size() {
        return this.getElementList().size();
    }
}

