/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeNamedCache$EnsureCacheAction;
import com.tangosol.coherence.component.util.SafeNamedCache$RestartCacheAction;
import com.tangosol.coherence.component.util.SafeNamedCache$Unlockable;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.AsynchronousAgent;
import com.tangosol.util.Base;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;

public class SafeNamedCache
extends Util
implements Lockable,
ClassLoaderAware,
NamedCache,
BinaryEntryStore,
CacheStore,
MapListener {
    private transient String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private boolean __m_Destroyed;
    private PrivilegedAction __m_EnsureCacheAction;
    private NamedCache __m_InternalNamedCache;
    private transient MapListenerSupport __m_ListenerSupport;
    private ReentrantLock __m_Lock;
    private boolean __m_Released;
    private PrivilegedAction __m_RestartCacheAction;
    private SafeCacheService __m_SafeCacheService;
    private Subject __m_Subject;
    private SafeNamedCache$Unlockable __m_Unlockable;
    private static ListMap __mapChildren;

    static {
        SafeNamedCache.__initStatic();
    }

    public SafeNamedCache() {
        this(null, null, true);
    }

    public SafeNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setListenerSupport(new MapListenerSupport());
            this.setLock(new ReentrantLock());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("EnsureCacheAction", SafeNamedCache$EnsureCacheAction.get_CLASS());
        Class clazz2 = __mapChildren.put("RestartCacheAction", SafeNamedCache$RestartCacheAction.get_CLASS());
        Class clazz3 = __mapChildren.put("Unlockable", SafeNamedCache$Unlockable.get_CLASS());
    }

    private void addIndex$Router(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getRunningNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.addIndex$Router(this.prepareExtractor(extractor), fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener == this) {
            NamedCache cache = this.getRunningNamedCache();
            try {
                cache.addMapListener(listener, filter, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener ? true : listener instanceof MapTriggerListener) {
            this.getRunningNamedCache().addMapListener(listener, filter, fLite);
            return;
        }
        if (listener == null) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        if (!this.getListenerSupport().addListenerWithCheck(listener, filter, fLite)) return;
        try {
            this.addMapListener((MapListener)this, filter, fLite);
            return;
        }
        catch (RuntimeException e) {
            this.getListenerSupport().removeListener(listener, filter);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        if (listener == this) {
            NamedCache cache = this.getRunningNamedCache();
            try {
                cache.addMapListener(listener, oKey, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener) {
            this.getRunningNamedCache().addMapListener(listener, oKey, fLite);
            return;
        }
        if (listener == null) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        if (!this.getListenerSupport().addListenerWithCheck(listener, oKey, fLite)) return;
        try {
            this.addMapListener((MapListener)this, oKey, fLite);
            return;
        }
        catch (RuntimeException e) {
            this.getListenerSupport().removeListener(listener, oKey);
            throw e;
        }
    }

    private Object aggregate$Router(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(filter, agent);
    }

    private Object aggregate$Router(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(collKeys, agent);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.aggregate$Router(filter, agent) : cache.aggregate(filter, agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.aggregate$Router(collKeys, agent) : cache.aggregate(collKeys, agent);
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    public void clear() {
        this.getRunningNamedCache().clear();
    }

    public boolean containsKey(Object oKey) {
        return this.getRunningNamedCache().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getRunningNamedCache().containsValue(oValue);
    }

    public void destroy() {
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safecluster = safeservice.getSafeCluster();
        this.releaseListeners();
        safeservice.destroyCache(this);
        this.ensureGlobalLock();
        try {
            this.setDestroyed(true);
            this.setReleased(true);
            this.setInternalNamedCache(null);
        }
        finally {
            Object var4_3 = null;
            this.unlockGlobal();
        }
    }

    public void ensureGlobalLock() {
        SafeCacheService service = this.getSafeCacheService();
        service.ensureGlobalLock();
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            service.unlockGlobal();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getSafeCacheService().getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= (long)0 ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException(new StringBuilder(String.valueOf("Failed to acquire NamedCache lock in ")).append(cTimeout).append("ms").toString()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire NamedCache lock");
        }
    }

    public NamedCache ensureRunningNamedCache() {
        this.checkInternalAccess();
        NamedCache cache = this.getInternalNamedCache();
        SafeCacheService serviceSafe = this.getSafeCacheService();
        if (((serviceSafe == null ? true : serviceSafe.isRunning() ^ true) ? true : cache == null) ? true : cache.isActive() ^ true) {
            block6: {
                if (!(serviceSafe == null ? true : serviceSafe.isRunning() ^ true) ? false : serviceSafe.isServiceThread()) {
                    throw new IllegalStateException("Service can not be restarted on a thread owned by the service");
                }
                this.ensureGlobalLock();
                try {
                    cache = this.getInternalNamedCache();
                    serviceSafe = this.getSafeCacheService();
                    if (!(((serviceSafe == null ? true : serviceSafe.isRunning() ^ true) ? true : cache == null) ? true : cache.isActive() ^ true)) break block6;
                    if (this.isReleased() ? true : this.isDestroyed()) {
                        String reason = this.isDestroyed() ? "destroyed" : "released";
                        throw new IllegalStateException(new StringBuilder(String.valueOf("SafeNamedCache was explicitly ")).append(reason).toString());
                    }
                    if (cache != null) {
                        this.setInternalNamedCache(null);
                        Component._trace(new StringBuilder(String.valueOf("Restarting NamedCache: ")).append(this.getCacheName()).toString(), 3);
                    }
                    cache = this.restartNamedCache();
                    this.setInternalNamedCache(cache);
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.unlockGlobal();
                    throw throwable;
                }
            }
            Object var4_5 = null;
            this.unlockGlobal();
        }
        return cache;
    }

    public void entryDeleted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public void entryInserted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public Set entrySet() {
        return this.getRunningNamedCache().entrySet();
    }

    public Set entrySet(Filter filter) {
        return this.getRunningNamedCache().entrySet(filter);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().entrySet(filter, comparator);
    }

    public void entryUpdated(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public void erase(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().erase(binEntry);
    }

    public void erase(Object oKey) {
        this.getRunningCacheStore().erase(oKey);
    }

    public void eraseAll(Collection colKeys) {
        this.getRunningCacheStore().eraseAll(colKeys);
    }

    public void eraseAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().eraseAll(setBinEntries);
    }

    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return (SafeNamedCache$Unlockable)this._newChild("Unlockable");
    }

    public Object get(Object oKey) {
        return this.getRunningNamedCache().get(oKey);
    }

    public Map getAll(Collection col) {
        return this.getRunningNamedCache().getAll(col);
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return this.getSafeCacheService();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    public PrivilegedAction getEnsureCacheAction() {
        return this.__m_EnsureCacheAction;
    }

    protected NamedCache getInternalNamedCache() {
        return this.__m_InternalNamedCache;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    public NamedCache getNamedCache() {
        this.checkInternalAccess();
        return this.getInternalNamedCache();
    }

    protected NamedCache getNonblockingCache() {
        NamedCache cache;
        if (NonBlocking.isNonBlockingCaller()) {
            cache = this.getInternalNamedCache();
            if (cache == null) {
                throw new ServiceStoppedException("Service has been terminated");
            }
        } else {
            cache = null;
        }
        return cache;
    }

    protected NamedCache getNonblockingCache(InvocableMap.EntryAggregator agent) {
        return agent instanceof AsynchronousAgent ? this.getNonblockingCache() : null;
    }

    protected NamedCache getNonblockingCache(InvocableMap.EntryProcessor agent) {
        return agent instanceof AsynchronousAgent ? this.getNonblockingCache() : null;
    }

    public PrivilegedAction getRestartCacheAction() {
        return this.__m_RestartCacheAction;
    }

    protected BinaryEntryStore getRunningBinaryEntryStore() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (BinaryEntryStore)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected CacheLoader getRunningCacheLoader() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheLoader)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected CacheStore getRunningCacheStore() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheStore)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected NamedCache getRunningNamedCache() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningNamedCache();
        }
        return (NamedCache)AccessController.doPrivileged(new DoAsAction(this.getEnsureCacheAction()));
    }

    public SafeCacheService getSafeCacheService() {
        return this.__m_SafeCacheService;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public SafeNamedCache$Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SafeNamedCache();
    }

    private final Component get_Module() {
        return this;
    }

    private Object invoke$Router(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invoke(oKey, agent);
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invoke$Router(oKey, agent) : cache.invoke(oKey, agent);
    }

    private Map invokeAll$Router(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(filter, agent);
    }

    private Map invokeAll$Router(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(collKeys, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invokeAll$Router(filter, agent) : cache.invokeAll(filter, agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invokeAll$Router(collKeys, agent) : cache.invokeAll(collKeys, agent);
    }

    public boolean isActive() {
        try {
            return this.getInternalNamedCache().isActive();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isDestroyed() {
        try {
            return this.__m_Destroyed ? true : this.getInternalNamedCache().isDestroyed();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.getRunningNamedCache().isEmpty();
    }

    public boolean isReleased() {
        try {
            return this.__m_Released ? true : this.getInternalNamedCache().isReleased();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Set keySet() {
        return this.getRunningNamedCache().keySet();
    }

    public Set keySet(Filter filter) {
        return this.getRunningNamedCache().keySet(filter);
    }

    public void load(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().load(binEntry);
    }

    public Object load(Object oKey) {
        return this.getRunningCacheLoader().load(oKey);
    }

    public Map loadAll(Collection colKeys) {
        return this.getRunningCacheLoader().loadAll(colKeys);
    }

    public void loadAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().loadAll(setBinEntries);
    }

    public boolean lock(Object oKey) {
        return this.getRunningNamedCache().lock(oKey);
    }

    public boolean lock(Object oKey, long cMillis) {
        return this.getRunningNamedCache().lock(oKey, cMillis);
    }

    public void onInit() {
        this.setEnsureCacheAction((SafeNamedCache$EnsureCacheAction)this._newChild("EnsureCacheAction"));
        this.setRestartCacheAction((SafeNamedCache$RestartCacheAction)this._newChild("RestartCacheAction"));
        this.setUnlockable((SafeNamedCache$Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    protected ValueExtractor prepareExtractor(ValueExtractor extractor) {
        return Lambdas.ensureRemotable(extractor);
    }

    public Object put(Object oKey, Object oValue) {
        return this.getRunningNamedCache().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.getRunningNamedCache().put(oKey, oValue, cMillis);
    }

    public void putAll(Map map) {
        this.getRunningNamedCache().putAll(map);
    }

    public void release() {
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safecluster = safeservice.getSafeCluster();
        this.releaseListeners();
        safeservice.releaseCache(this);
        this.ensureGlobalLock();
        try {
            this.setReleased(true);
            this.setClassLoader(null);
            this.setInternalNamedCache(null);
        }
        finally {
            Object var4_3 = null;
            this.unlockGlobal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseListeners() {
        MapListenerSupport support = this.getListenerSupport();
        if (support.isEmpty() ^ true) {
            LinkedList listFilter = new LinkedList();
            LinkedList listKeys = new LinkedList();
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                if (support.isEmpty() ^ true) {
                    listFilter.addAll(support.getFilterSet());
                    listKeys.addAll(support.getKeySet());
                    support.clear();
                }
            }
            Iterator iter = listFilter.iterator();
            while (iter.hasNext()) {
                this.removeMapListener((MapListener)this, (Filter)iter.next());
            }
            iter = listKeys.iterator();
            while (iter.hasNext()) {
                this.removeMapListener((MapListener)this, iter.next());
            }
        }
    }

    public Object remove(Object oKey) {
        return this.getRunningNamedCache().remove(oKey);
    }

    private void removeIndex$Router(ValueExtractor extractor) {
        this.getRunningNamedCache().removeIndex(extractor);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.removeIndex$Router(this.prepareExtractor(extractor));
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMapListener(MapListener listener, Filter filter) {
        if ((listener == this ? true : listener instanceof MapListenerSupport.SynchronousListener) ? true : listener instanceof MapTriggerListener) {
            NamedCache cache = this.getInternalNamedCache();
            try {
                cache.removeMapListener(listener, filter);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        } else {
            if (listener == null) {
                return;
            }
            boolean bl = true;
            if (!bl) return;
            if (!this.getListenerSupport().removeListenerWithCheck(listener, filter)) return;
            this.removeMapListener((MapListener)this, filter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMapListener(MapListener listener, Object oKey) {
        if (listener == this ? true : listener instanceof MapListenerSupport.SynchronousListener) {
            NamedCache cache = this.getInternalNamedCache();
            try {
                cache.removeMapListener(listener, oKey);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        } else {
            if (listener == null) {
                return;
            }
            boolean bl = true;
            if (!bl) return;
            if (!this.getListenerSupport().removeListenerWithCheck(listener, oKey)) return;
            this.removeMapListener((MapListener)this, oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedCache restartNamedCache() {
        MapListenerSupport support;
        NamedCache cache;
        Subject subject = this.getSubject();
        if (subject == null) {
            CacheService service = (CacheService)this.getSafeCacheService().getRunningService();
            cache = service.ensureCache(this.getCacheName(), this.getClassLoader());
        } else {
            cache = (NamedCache)Subject.doAs(subject, this.getRestartCacheAction());
        }
        Filter[] aFilter = new Filter[]{};
        Object[] aoKey = new Object[]{};
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            if (support.isEmpty() ^ true) {
                aFilter = support.getFilterSet().toArray(aFilter);
                aoKey = support.getKeySet().toArray();
            }
        }
        int i = 0;
        int c = aFilter.length;
        while (i < c) {
            Filter filter = aFilter[i];
            cache.addMapListener(this, filter, support.containsStandardListeners(filter) ^ true);
            ++i;
        }
        i = 0;
        c = aoKey.length;
        while (i < c) {
            Object oKey = aoKey[i];
            cache.addMapListener(this, oKey, support.containsStandardListeners(oKey) ^ true);
            ++i;
        }
        return cache;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
    }

    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    private void setDestroyed(boolean fDestroyed) {
        this.__m_Destroyed = fDestroyed;
    }

    protected void setEnsureCacheAction(PrivilegedAction action) {
        this.__m_EnsureCacheAction = action;
    }

    public void setInternalNamedCache(NamedCache cache) {
        this.__m_InternalNamedCache = cache;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    public void setReleased(boolean fRelease) {
        this.ensureLocked();
        try {
            if (!this.isReleased() ? false : fRelease ^ true) {
                throw new IllegalStateException("Cache cannot be un-released");
            }
            this.__m_Released = fRelease;
        }
        finally {
            Object var3_2 = null;
            this.getLock().unlock();
        }
    }

    protected void setRestartCacheAction(PrivilegedAction action) {
        this.__m_RestartCacheAction = action;
    }

    public void setSafeCacheService(SafeCacheService service) {
        this.__m_SafeCacheService = service;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void setUnlockable(SafeNamedCache$Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    public int size() {
        return this.getRunningNamedCache().size();
    }

    public void store(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().store(binEntry);
    }

    public void store(Object oKey, Object oValue) {
        this.getRunningCacheStore().store(oKey, oValue);
    }

    public void storeAll(Map mapEntries) {
        this.getRunningCacheStore().storeAll(mapEntries);
    }

    public void storeAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().storeAll(setBinEntries);
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(": ").append(this.getInternalNamedCache()).toString();
    }

    protected void translateMapEvent(MapEvent evt) {
        if (evt.getSource() == this.getInternalNamedCache()) {
            evt = MapListenerSupport.convertEvent(evt, this, null, null);
            this.getListenerSupport().fireEvent(evt, true);
        }
    }

    public void truncate() {
        this.getRunningNamedCache().truncate();
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public boolean unlock(Object oKey) {
        return this.getRunningNamedCache().unlock(oKey);
    }

    public void unlockGlobal() {
        this.unlock();
        this.getSafeCacheService().unlockGlobal();
    }

    public Collection values() {
        return this.getRunningNamedCache().values();
    }
}

