/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.IpMonitor$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IpMonitor
extends Daemon {
    private volatile transient InetAddress[] __m_AddressScanArray;
    private long __m_AddressTimeout;
    private volatile Map __m_CollocatedMembersMap;
    private long __m_CurrentTimeoutMillis;
    private transient NetworkInterface __m_LocalInterface;
    private volatile Member __m_MachineSeniorMember;
    private int __m_PingTimeout;
    private transient int __m_Position;
    private ClusterService __m_Service;
    private long __m_StatsTimeouts;
    private InetAddress __m_Suspect;

    public IpMonitor() {
        this(null, null, true);
    }

    public IpMonitor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new IpMonitor$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void advanceIpMonitor() {
        this.setSuspect(null);
        this.setCurrentTimeoutMillis(0L);
        InetAddress[] aAddr = this.getAddressScanArray();
        if (aAddr.length == 0) {
            this.setPosition(0);
        } else {
            this.setPosition((this.getPosition() + 1) % aAddr.length);
        }
    }

    protected InetAddress[] calculateAddressScanArray(Set setAddress) {
        setAddress.remove(this.getThisMember().getAddress());
        int cAddr = setAddress.size();
        return (InetAddress[])Base.randomize(setAddress.toArray(new InetAddress[cAddr]));
    }

    public void configure(ClusterDependencies config, ClusterService service) {
        this.setService(service);
        this.setWaitMillis(config.getClusterHeartbeatDelayMillis());
        int cPingTimeout = (int)config.getIpMonitorTimeoutMillis();
        int cAttempts = Math.max(config.getIpMonitorAttempts(), 1);
        int cIpMonitorDefault = 5000;
        this.setPingTimeout(cPingTimeout);
        this.setAddressTimeout(cAttempts * cPingTimeout);
        if (cPingTimeout < cIpMonitorDefault) {
            Component._trace(new StringBuilder(String.valueOf("The timeout value configured for IpMonitor pings is shorter than the")).append(" value of 5 seconds. Short ping timeouts may cause an IP address to be").append(" wrongly reported as unreachable on some platforms.").toString(), 2);
        }
    }

    public void ensureSeniority() {
        Member memberThis;
        Member memberSenior = memberThis = this.getThisMember();
        Map mapAddress = this.groupMembersByAddress(this.getServiceMemberSet());
        MemberSet setLocal = (MemberSet)mapAddress.get(memberThis.getAddress());
        Iterator iter = setLocal.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(member.getTimestamp() < memberSenior.getTimestamp())) continue;
            memberSenior = member;
        }
        this.setMachineSeniorMember(memberSenior);
        if (memberSenior == memberThis) {
            this.setCollocatedMembersMap(mapAddress);
            this.setAddressScanArray(this.calculateAddressScanArray(mapAddress.keySet()));
        }
    }

    public String formatStats() {
        return new StringBuilder(String.valueOf("Timeouts=")).append(this.getStatsTimeouts()).toString();
    }

    private InetAddress[] getAddressScanArray() {
        return this.__m_AddressScanArray;
    }

    public long getAddressTimeout() {
        return this.__m_AddressTimeout;
    }

    public Map getCollocatedMembersMap() {
        return this.__m_CollocatedMembersMap;
    }

    public InetAddress getCurrentAddress() {
        InetAddress[] aAddr;
        int cAddr;
        InetAddress addr = this.getSuspect();
        if (addr == null && (cAddr = (aAddr = this.getAddressScanArray()).length) > 0) {
            addr = aAddr[this.getPosition() % cAddr];
            if (this.getCurrentTimeoutMillis() == 0L) {
                this.setCurrentTimeoutMillis(Base.getSafeTimeMillis() + this.getAddressTimeout());
            }
        }
        return addr;
    }

    public long getCurrentTimeoutMillis() {
        return this.__m_CurrentTimeoutMillis;
    }

    public NetworkInterface getLocalInterface() {
        return this.__m_LocalInterface;
    }

    protected Member getMachineSeniorMember() {
        return this.__m_MachineSeniorMember;
    }

    public int getPingTimeout() {
        return this.__m_PingTimeout;
    }

    private int getPosition() {
        return this.__m_Position;
    }

    public ClusterService getService() {
        return this.__m_Service;
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.getService().getServiceMemberSet();
    }

    public long getStatsTimeouts() {
        return this.__m_StatsTimeouts;
    }

    private InetAddress getSuspect() {
        return this.__m_Suspect;
    }

    public Member getThisMember() {
        Member member = this.getService().getThisMember();
        return member == null ? this.getService().getAnnounceMember() : member;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/IpMonitor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new IpMonitor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Map groupMembersByAddress(MemberSet setMembers) {
        HashMap<InetAddress, MemberSet> mapByAddress = new HashMap<InetAddress, MemberSet>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            InetAddress addr = member.getAddress();
            MemberSet setByAddr = (MemberSet)mapByAddress.get(addr);
            if (setByAddr == null) {
                setByAddr = new ActualMemberSet();
                mapByAddress.put(addr, setByAddr);
            }
            setByAddr.add(member);
        }
        return mapByAddress;
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        guardable = this.getService().instantiateWrapperGuardable(guardable);
        return super.guard(guardable, cMillis, flPctRecover);
    }

    public boolean isMachineSenior() {
        return Base.equals(this.getMachineSeniorMember(), this.getThisMember());
    }

    protected boolean isReachable(InetAddress addr, int cMillisTimeout) {
        try {
            NetworkInterface nicSrc = this.getLocalInterface();
            if (addr.isReachable(nicSrc, 0, cMillisTimeout)) {
                return true;
            }
            this.setLocalInterface(nicSrc == null ? NetworkInterface.getByInetAddress(this.getThisMember().getAddress()) : null);
        }
        catch (IOException e) {
            Component._trace(new StringBuilder(String.valueOf("Network failure encountered during InetAddress.isReachable(): ")).append(Component.getStackTrace(e)).toString(), 3);
        }
        return false;
    }

    protected void onEnter() {
        this.resetStats();
    }

    public void onInit() {
        super.onInit();
        this.setAddressScanArray(new InetAddress[0]);
    }

    public void onMemberJoined(Member memberJoin) {
        if (this.isMachineSenior()) {
            Map mapByAddress = this.groupMembersByAddress(this.getServiceMemberSet());
            MemberSet setCollocated = (MemberSet)mapByAddress.get(memberJoin.getAddress());
            this.setCollocatedMembersMap(mapByAddress);
            if (!(setCollocated != null) ? false : setCollocated.size() == 1) {
                this.setAddressScanArray(this.calculateAddressScanArray(mapByAddress.keySet()));
            }
        }
    }

    public void onMemberLeft(Member memberLeft) {
        if (memberLeft.equals(this.getMachineSeniorMember())) {
            this.ensureSeniority();
        } else if (this.isMachineSenior()) {
            Map mapByAddress = this.groupMembersByAddress(this.getServiceMemberSet());
            MemberSet setCollocated = (MemberSet)mapByAddress.get(memberLeft.getAddress());
            this.setCollocatedMembersMap(mapByAddress);
            if (setCollocated == null ? true : setCollocated.isEmpty()) {
                this.setAddressScanArray(this.calculateAddressScanArray(mapByAddress.keySet()));
            }
        }
    }

    protected void onNotify() {
        InetAddress addr;
        int cIter = (int)Math.ceil(this.getAddressTimeout() / (long)this.getPingTimeout());
        while (!((addr = this.getCurrentAddress()) != null) ? false : --cIter > 0) {
            if (this.verifyReachable(addr)) {
                this.advanceIpMonitor();
                return;
            }
            if (Base.getSafeTimeMillis() > this.getCurrentTimeoutMillis()) {
                this.getService().doNotifyIpTimeout(addr);
                this.setStatsTimeouts(this.getStatsTimeouts() + (long)1);
                this.advanceIpMonitor();
            } else {
                this.setSuspect(addr);
            }
            this.heartbeat();
        }
    }

    protected void onWait() throws InterruptedException {
        this.heartbeat();
        super.onWait();
    }

    public void resetStats() {
        this.setStatsTimeouts(0L);
    }

    private void setAddressScanArray(InetAddress[] pAddressScanArray) {
        this.__m_AddressScanArray = pAddressScanArray;
    }

    public void setAddressTimeout(long pAddressTimeout) {
        this.__m_AddressTimeout = pAddressTimeout;
    }

    protected void setCollocatedMembersMap(Map mapMembers) {
        this.__m_CollocatedMembersMap = mapMembers;
    }

    public void setCurrentTimeoutMillis(long pCurrentTimeoutMillis) {
        this.__m_CurrentTimeoutMillis = pCurrentTimeoutMillis;
    }

    public void setLocalInterface(NetworkInterface interfaceLocal) {
        this.__m_LocalInterface = interfaceLocal;
    }

    protected void setMachineSeniorMember(Member member) {
        this.__m_MachineSeniorMember = member;
    }

    public void setPingTimeout(int pPingTimeout) {
        this.__m_PingTimeout = pPingTimeout;
    }

    private void setPosition(int pPosition) {
        this.__m_Position = pPosition;
    }

    public void setService(ClusterService pService) {
        this.__m_Service = pService;
    }

    public void setStatsTimeouts(long pStatsTimeouts) {
        this.__m_StatsTimeouts = pStatsTimeouts;
    }

    private void setSuspect(InetAddress pSuspect) {
        this.__m_Suspect = pSuspect;
    }

    public String toString() {
        return this.isStarted() ? new StringBuilder(String.valueOf("IpMonitor{Addresses=")).append(this.getAddressScanArray().length).append(", Timeout=").append(new Duration(this.getAddressTimeout(), Duration.Magnitude.MILLI)).append('}').toString() : "IpMonitor is disabled";
    }

    public boolean verifyReachable(Member member) {
        return this.verifyReachable(member.getAddress());
    }

    public boolean verifyReachable(InetAddress addr) {
        long ldtCutoff = this.getCurrentTimeoutMillis() - (this.getAddressTimeout() + this.getWaitMillis());
        Map mapByAddress = this.getCollocatedMembersMap();
        MemberSet setCollocated = mapByAddress == null ? null : (MemberSet)mapByAddress.get(addr);
        if ((this.wasReachable(setCollocated, ldtCutoff) ? true : this.isReachable(addr, this.getPingTimeout())) ? true : this.wasReachable(setCollocated, ldtCutoff)) {
            return true;
        }
        this.getService().heartbeat(setCollocated);
        return false;
    }

    protected boolean wasReachable(MemberSet setMember, long ldt) {
        if (setMember != null) {
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (!(((Member)iter.next()).getLastIncomingMillis() > ldt)) continue;
                return true;
            }
        }
        return false;
    }
}

