/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.LogOutput;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger$ShutdownHook;
import com.tangosol.coherence.component.util.logOutput.Jdk;
import com.tangosol.coherence.component.util.logOutput.Log4j;
import com.tangosol.coherence.component.util.logOutput.Log4j2;
import com.tangosol.coherence.component.util.logOutput.SLF4J;
import com.tangosol.coherence.component.util.logOutput.Standard;
import com.tangosol.internal.net.logging.DefaultLoggingDependencies;
import com.tangosol.internal.net.logging.LoggingDependencies;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Logger
extends QueueProcessor {
    public static final int LEVEL_ALL = 10;
    public static final int LEVEL_D4 = 4;
    public static final int LEVEL_D5 = 5;
    public static final int LEVEL_D6 = 6;
    public static final int LEVEL_D7 = 7;
    public static final int LEVEL_D8 = 8;
    public static final int LEVEL_D9 = 9;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_INTERNAL = 0;
    public static final int LEVEL_NONE = -1;
    public static final String[] LEVEL_TEXT;
    public static final int LEVEL_WARNING = 2;
    public static final int QUEUE_DROP_SIZE = 500;
    public static final int QUEUE_MAX_THRESHOLD = 8000;
    public static final char THREAD_NAME_DELIM = '|';
    private LoggingDependencies __m_Dependencies;
    private String __m_Destination;
    private String __m_Format;
    private int __m_Level;
    private int __m_Limit;
    private LogOutput __m_LogOutput;
    private volatile transient boolean __m_Overflowed;
    private volatile int __m_OverflowedLevel;
    private String[] __m_Parameters;
    private int __m_QueueHalfThreshold;
    private static ListMap __mapChildren;
    private static Integer[] __s_Integer;
    private static Level[] __s_LogLevel;

    static {
        try {
            LEVEL_TEXT = new String[]{"Internal", "Error", "Warning", "Info", "D4", "D5", "D6", "D7", "D8", "D9"};
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Logger._initStatic();
    }

    public Logger() {
        this(null, null, true);
    }

    public Logger(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLevel(10);
            this.setLimit(65536);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOverflowed(false);
            this.setParameters(new String[]{"{logRecord}", "{uptime}", "{thread}"});
            this.setPriority(3);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Logger$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static void _initStatic$Default() {
        Logger.__initStatic();
    }

    protected static void _initStatic() {
        Logger._initStatic$Default();
        Integer[] ai = new Integer[]{Base.makeInteger(LEVEL_NONE), Base.makeInteger(LEVEL_INTERNAL), Base.makeInteger(LEVEL_ERROR), Base.makeInteger(LEVEL_WARNING), Base.makeInteger(LEVEL_INFO), Base.makeInteger(LEVEL_D4), Base.makeInteger(LEVEL_D5), Base.makeInteger(LEVEL_D6), Base.makeInteger(LEVEL_D7), Base.makeInteger(LEVEL_D8), Base.makeInteger(LEVEL_D9), Base.makeInteger(LEVEL_ALL)};
        Logger.setInteger(ai);
        Level[] aLogLevel = new Level[]{Level.parse("0"), Level.parse("1"), Level.parse("2"), Level.parse("3"), Level.parse("4"), Level.parse("5"), Level.parse("6"), Level.parse("7"), Level.parse("8"), Level.parse("9")};
        Logger.setLogLevel(aLogLevel);
    }

    public boolean checkDiagnosability() {
        return false;
    }

    protected DefaultLoggingDependencies cloneDependencies(LoggingDependencies deps) {
        return new DefaultLoggingDependencies(deps);
    }

    protected Object[] collectLogParameters() {
        return null;
    }

    protected Object[] createMessage(int nLevel, Throwable throwable, String sMessage) {
        Object[] aoParam = this.collectLogParameters();
        int cParams = aoParam == null ? 0 : aoParam.length;
        Object[] aoMessage = new Object[3 + cParams];
        LogRecord logRecord = this.instantiateLogRecord(Logger.getLogLevel(nLevel), sMessage);
        logRecord.setMillis(System.currentTimeMillis());
        logRecord.setThrown(throwable);
        aoMessage[0] = logRecord;
        aoMessage[1] = new Long(Base.getUpTimeMillis());
        aoMessage[2] = Thread.currentThread();
        if (cParams > 0) {
            System.arraycopy(aoParam, 0, aoMessage, 3, cParams);
        }
        return aoMessage;
    }

    protected String formatLogRecord(String sFormat, LogRecord logRecord) {
        String sMessage = sFormat;
        sMessage = Base.replace(sMessage, "{text}", this.formatParameter("{text}", logRecord.getMessage()));
        sMessage = Base.replace(sMessage, "{date}", this.formatParameter("{date}", new Timestamp(logRecord.getMillis())));
        sMessage = Base.replace(sMessage, "{level}", this.formatParameter("{level}", logRecord.getLevel()));
        return sMessage;
    }

    public String formatMessage(Object[] aoParam) {
        LogRecord logRecord = (LogRecord)aoParam[0];
        String sMessage = logRecord.getMessage();
        if (logRecord.getLevel().intValue() != LEVEL_INTERNAL) {
            String sFormat = this.getFormat();
            String[] aoParamName = this.getParameters();
            int cParamNames = aoParamName == null ? 0 : aoParamName.length;
            int cParams = aoParam.length;
            if (sFormat != null) {
                sMessage = this.formatLogRecord(sFormat, logRecord);
                int i = 1;
                while (i < cParamNames) {
                    String sParamName = aoParamName[i];
                    Object oParamValue = i < cParams ? aoParam[i] : null;
                    sMessage = Base.replace(sMessage, sParamName, this.formatParameter(sParamName, oParamValue));
                    ++i;
                }
            }
            logRecord.setMessage(sMessage);
        }
        return sMessage;
    }

    protected String formatParameter(String sParamName, Object oParamValue) {
        String sParam = null;
        if (!(sParamName != null) ? false : sParamName.length() > 2) {
            switch (sParamName.charAt(1)) {
                case 'd': {
                    if (!(!sParamName.equals("{date}") ? false : oParamValue instanceof Timestamp) || !((sParam = oParamValue.toString()).length() < 23)) break;
                    sParam = new StringBuilder(String.valueOf(sParam)).append("000").toString().substring(0, 23);
                    break;
                }
                case 'u': {
                    if (!(!sParamName.equals("{uptime}") ? false : oParamValue instanceof Long)) break;
                    long cMillisUp = (Long)oParamValue;
                    long cSec = cMillisUp / (long)1000;
                    long cMillis = cMillisUp % (long)1000;
                    if (cMillis < (long)10) {
                        sParam = new StringBuilder(String.valueOf(cSec)).append(".00").append(cMillis).toString();
                        break;
                    }
                    if (cMillis < (long)100) {
                        sParam = new StringBuilder(String.valueOf(cSec)).append(".0").append(cMillis).toString();
                        break;
                    }
                    sParam = new StringBuilder(String.valueOf(cSec)).append(".").append(cMillis).toString();
                    break;
                }
                case 'l': {
                    if (!(!sParamName.equals("{level}") ? false : oParamValue instanceof Level)) break;
                    sParam = LEVEL_TEXT[((Level)oParamValue).intValue()];
                    break;
                }
                case 't': {
                    if (!sParamName.equals("{thread}") ? false : oParamValue instanceof Thread) {
                        sParam = ((Thread)oParamValue).getName();
                        int ofDecor = sParam.indexOf(THREAD_NAME_DELIM);
                        if (!(ofDecor > 0)) break;
                        sParam = sParam.substring(0, ofDecor);
                        break;
                    }
                    if (!sParamName.equals("{text}")) break;
                    sParam = oParamValue instanceof String ? (String)oParamValue : "";
                    break;
                }
            }
        }
        if (sParam == null) {
            return oParamValue == null ? "n/a" : oParamValue.toString();
        }
        return sParam;
    }

    public LoggingDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public String getDestination() {
        return this.__m_Destination;
    }

    public String getFormat() {
        return this.__m_Format;
    }

    protected static Integer[] getInteger() {
        return __s_Integer;
    }

    protected static Integer getInteger(int nIndex) {
        nIndex = nIndex < LEVEL_INTERNAL ? LEVEL_INTERNAL : nIndex;
        nIndex = nIndex > LEVEL_D9 ? LEVEL_D9 : nIndex;
        return __s_Integer[nIndex + 1];
    }

    public int getLevel() {
        return this.__m_Level;
    }

    public int getLimit() {
        return this.__m_Limit;
    }

    public static Level[] getLogLevel() {
        return __s_LogLevel;
    }

    public static Level getLogLevel(int nLevel) {
        nLevel = nLevel < LEVEL_INTERNAL ? LEVEL_INTERNAL : nLevel;
        nLevel = nLevel > LEVEL_D9 ? LEVEL_D9 : nLevel;
        return __s_LogLevel[nLevel];
    }

    protected LogOutput getLogOutput() {
        return this.__m_LogOutput;
    }

    public int getOverflowedLevel() {
        return this.__m_OverflowedLevel;
    }

    public String[] getParameters() {
        return this.__m_Parameters;
    }

    public int getQueueHalfThreshold() {
        return this.__m_QueueHalfThreshold;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Logger".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Logger();
    }

    private final Component get_Module() {
        return this;
    }

    protected LogRecord instantiateLogRecord(Level level, String sMessage) {
        return new LogRecord(level, sMessage);
    }

    public static boolean isDiagnosabilityEnabled() {
        return ((Coherence)Application.get_Instance()).getLogger().checkDiagnosability();
    }

    public boolean isEnabled(int nLevel) {
        LogOutput logOutput = this.getLogOutput();
        return !((nLevel = Logger.getInteger(nLevel).intValue()) <= this.getLevel()) ? false : (logOutput == null ? true : logOutput.isEnabled(nLevel));
    }

    public boolean isOverflowed() {
        return this.__m_Overflowed;
    }

    public void log(int nLevel, String sMessage) {
        this.log(nLevel, null, sMessage);
    }

    public void log(int nLevel, Throwable throwable) {
        this.log(nLevel, throwable, null);
    }

    public void log(int nLevel, Throwable throwable, String sMessage) {
        if (this.isEnabled(nLevel)) {
            int cHalf;
            nLevel = nLevel < LEVEL_NONE ? LEVEL_NONE : nLevel;
            nLevel = nLevel > LEVEL_ALL ? LEVEL_ALL : nLevel;
            Queue queue = this.getQueue();
            int cSize = queue.size();
            if (cSize >= (cHalf = this.getQueueHalfThreshold())) {
                boolean fOverflow = this.isOverflowed();
                if (fOverflow) {
                    if (!(nLevel > this.getOverflowedLevel()) ? false : cSize >= 2 * cHalf) {
                        return;
                    }
                } else {
                    boolean bl = fOverflow = cSize >= 2 * cHalf;
                }
                if (fOverflow) {
                    this.processOverflow(this.createMessage(nLevel, throwable, sMessage), throwable);
                    return;
                }
            }
            queue.add(this.createMessage(nLevel, throwable, sMessage));
        }
    }

    protected void onDependencies(LoggingDependencies deps) {
        String sDest = deps.getDestination();
        LogOutput output = null;
        try {
            output = "jdk".equalsIgnoreCase(sDest) ? new Jdk() : ("log4j".equalsIgnoreCase(sDest) ? new Log4j() : ("log4j2".equalsIgnoreCase(sDest) ? new Log4j2() : ("slf4j".equalsIgnoreCase(sDest) ? new SLF4J() : new Standard())));
            output.configure(deps);
        }
        catch (Throwable e) {
            ((DefaultLoggingDependencies)deps).setDestination("stderr");
            output = new Standard();
            output.configure(deps);
            output.log(Logger.getInteger(LEVEL_ERROR), e, "Error configuring logger; using default settings.");
        }
        this.setDestination(deps.getDestination());
        this.setFormat(deps.getMessageFormat());
        this.setLevel(deps.getSeverityLevel());
        this.setLimit(deps.getCharacterLimit());
        this.setLogOutput(output);
    }

    protected void onException(Throwable e) {
        System.err.println(new StringBuilder(String.valueOf("Logger: ")).append(e).toString());
        e.printStackTrace(System.err);
    }

    public void onInit() {
        try {
            Logger$ShutdownHook hook = (Logger$ShutdownHook)this._findName("ShutdownHook");
            hook.register();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onLog() {
    }

    protected void onNotify() {
        int MAX_TOTAL = this.getLimit();
        int cchTotal = 0;
        boolean fTruncate = false;
        int cTruncate = 0;
        int cTruncateLines = 0;
        int cchTruncate = 0;
        boolean fDone = false;
        do {
            Object[] aoMessage;
            if ((aoMessage = (Object[])this.getQueue().removeNoWait()) == null) {
                if (!(!fTruncate ? false : cTruncate > 0)) break;
                aoMessage = this.createMessage(LEVEL_WARNING, null, new StringBuilder(String.valueOf("Asynchronous logging character limit exceeded; discarding ")).append(cTruncate).append(" log messages ").append("(lines=").append(cTruncateLines).append(", chars=").append(cchTruncate).append(")").toString());
                fDone = true;
            }
            if (aoMessage.length == 0) {
                this.setExiting(true);
                return;
            }
            LogRecord logRecord = (LogRecord)aoMessage[0];
            if (this.isEnabled(logRecord.getLevel().intValue()) ^ true) continue;
            String sText = this.formatMessage(aoMessage);
            String sTextSafe = sText == null ? "" : sText;
            Throwable throwable = logRecord.getThrown();
            String sThrowable = throwable == null ? "" : Component.getStackTrace(throwable);
            if (sTextSafe == null) {
                sTextSafe = "";
            }
            cchTotal += sTextSafe.length() + sThrowable.length();
            if (!fTruncate ? false : fDone ^ true) {
                ++cTruncate;
                cTruncateLines += Base.parseDelimitedString(sTextSafe, '\n').length;
                cTruncateLines += Base.parseDelimitedString(sThrowable, '\n').length;
                cchTruncate += sTextSafe.length();
                cchTruncate += sThrowable.length();
                continue;
            }
            if (cchTotal > MAX_TOTAL) {
                fTruncate = true;
            }
            this.onLog();
            LogOutput out = this.getLogOutput();
            if (out == null) {
                try {
                    System.err.println(sTextSafe);
                    if (!(throwable != null)) continue;
                    throwable.printStackTrace();
                }
                catch (Throwable e) {}
                continue;
            }
            out.log(logRecord);
        } while (fDone ^ true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processOverflow(Object[] aoMessage, Throwable throwable) {
        Queue queue = this.getQueue();
        int cHalf = this.getQueueHalfThreshold();
        int cDrop = 0;
        Queue queue2 = queue;
        synchronized (queue2) {
            if (this.isOverflowed()) {
                int cSize = queue.size();
                if (cSize <= cHalf + QUEUE_DROP_SIZE) {
                    this.setOverflowed(false);
                    queue.add(aoMessage);
                    return;
                }
                cDrop = (cSize - 2 * cHalf + QUEUE_DROP_SIZE) / QUEUE_DROP_SIZE;
            } else {
                this.setOverflowed(true);
                this.setOverflowedLevel(this.getLevel());
                cDrop = 1;
            }
        }
        int nLevelCurrent = this.getOverflowedLevel();
        if (nLevelCurrent > LEVEL_ERROR) {
            queue.add(aoMessage);
            if (!(cDrop > 0)) return;
            int nLevelTarget = Math.max(LEVEL_ERROR, this.getLevel() - cDrop);
            if (!(nLevelTarget < nLevelCurrent)) return;
            this.setOverflowedLevel(nLevelTarget);
            String sMsg = new StringBuilder(String.valueOf("The configured logger is stuck or too slow (backlog of ")).append(queue.size()).append(" messages) at threshold log level of \"").append(LEVEL_TEXT[nLevelCurrent]).append("\"").append(nLevelTarget == LEVEL_ERROR ? "; switching to synchronous \"err\" logging" : new StringBuilder(String.valueOf("; lowering the threshold to \"")).append(LEVEL_TEXT[nLevelTarget]).append("\"").toString()).toString();
            queue.add(this.createMessage(Math.min(nLevelCurrent, LEVEL_WARNING), null, sMsg));
            if (!(nLevelTarget == LEVEL_ERROR)) return;
            System.err.println(this.formatMessage(this.createMessage(LEVEL_ERROR, null, sMsg)));
            return;
        }
        String sText = this.formatMessage(aoMessage);
        System.err.println(sText == null ? "" : sText);
        if (!(throwable != null)) return;
        throwable.printStackTrace();
    }

    public void setDependencies(LoggingDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    protected void setDestination(String sDestination) {
        this.__m_Destination = sDestination;
    }

    public void setFormat(String sFormat) {
        this.__m_Format = sFormat;
    }

    protected static void setInteger(int nIndex, Integer integer) {
        Logger.getInteger()[nIndex] = integer;
    }

    protected static void setInteger(Integer[] aInteger) {
        __s_Integer = aInteger;
    }

    public void setLevel(int nLevel) {
        this.__m_Level = nLevel;
    }

    public void setLimit(int nLimit) {
        this.setQueueHalfThreshold(Math.min(QUEUE_MAX_THRESHOLD / 2, nLimit / 256));
        this.__m_Limit = nLimit;
    }

    protected static void setLogLevel(int i, Level level) {
        Logger.getLogLevel()[i] = level;
    }

    protected static void setLogLevel(Level[] aLevel) {
        __s_LogLevel = aLevel;
    }

    protected void setLogOutput(LogOutput output) {
        this.__m_LogOutput = output;
    }

    protected void setOverflowed(boolean fOverflowed) {
        this.__m_Overflowed = fOverflowed;
    }

    protected void setOverflowedLevel(int nLevel) {
        this.__m_OverflowedLevel = nLevel;
    }

    protected void setParameters(String[] asParams) {
        this.__m_Parameters = asParams;
    }

    public void setQueueHalfThreshold(int nLimit) {
        this.__m_QueueHalfThreshold = nLimit;
    }

    public synchronized void shutdown() {
        Logger$ShutdownHook hook = (Logger$ShutdownHook)this._findName("ShutdownHook");
        hook.unregister();
        if (this.isStarted()) {
            this.getQueue().add(new Object[0]);
            if (this.getThread() != Thread.currentThread()) {
                try {
                    try {
                        Blocking.wait(this, 1000);
                    }
                    catch (InterruptedException e) {
                        this.stop();
                    }
                    Object var3_4 = null;
                    this.getLogOutput().close();
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.getLogOutput().close();
                    throw throwable;
                }
            }
        } else {
            this.onNotify();
        }
    }
}

