/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue$Iterator;
import com.tangosol.coherence.component.util.queue.OptimisticQueue;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PacketPublisher$ResendQueue
extends OptimisticQueue {
    public static final long IMMEDIATE = -1L;
    private transient MemberSet __m_DiagnosticMemberSet;
    private byte __m_DiagnosticTimeToLive;
    private long __m_DiagnosticWindowMillis;
    private transient long __m_LastDiagnosticMillis;
    private volatile transient int __m_MultipointPacketCount;
    private int __m_ResendMillis;
    private int __m_TimeoutMillis;
    private static ListMap __mapChildren;

    static {
        PacketPublisher$ResendQueue.__initStatic();
    }

    public PacketPublisher$ResendQueue() {
        this(null, null, true);
    }

    public PacketPublisher$ResendQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setElementList(new RecyclingLinkedList());
            this.setResendMillis(400);
            this.setTimeoutMillis(20000);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", PacketPublisher$ResendQueue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        MessagePacket packet = (MessagePacket)oElement;
        if (packet.isNackInProgress()) {
            return this.addHead(packet);
        }
        packet.setResendScheduled(packet.getSentMillis() + (long)this.getResendMillis());
        this.onPacketAdd(packet);
        return super.add(packet);
    }

    public boolean addAllHead(List listPackets, boolean fNack) {
        long ldtScheduled = Base.getSafeTimeMillis();
        RecyclingLinkedList list = this.getElementList();
        int iInsert = 0;
        int cPackets = list.size();
        while (!(iInsert < cPackets) ? false : ((MessagePacket)list.get(iInsert)).getResendScheduled() <= ldtScheduled) {
            ++iInsert;
        }
        int iStart = 0;
        int iCurr = 0;
        Iterator iter = listPackets.iterator();
        while (iter.hasNext()) {
            MessagePacket packet = (MessagePacket)iter.next();
            packet.setResendScheduled(ldtScheduled);
            if (fNack) {
                if (packet.isNackInProgress()) {
                    if (iCurr != iStart) {
                        list.addAll(iInsert, listPackets.subList(iStart, iCurr));
                    }
                    iStart = ++iCurr;
                    continue;
                }
                packet.setNackInProgress(true);
            }
            this.onPacketAdd(packet);
            ++iCurr;
        }
        if (iStart == 0) {
            list.addAll(iInsert, listPackets);
        } else {
            list.addAll(iInsert, listPackets.subList(iStart, iCurr));
        }
        return true;
    }

    public boolean addHead(Object oElement) {
        MessagePacket packet = (MessagePacket)oElement;
        packet.setResendScheduled(IMMEDIATE);
        this.onPacketAdd(packet);
        RecyclingLinkedList listPackets = this.getElementList();
        int iInsert = 0;
        int cPackets = listPackets.size();
        while (!(iInsert < cPackets) ? false : ((MessagePacket)listPackets.get(iInsert)).getResendScheduled() <= IMMEDIATE) {
            ++iInsert;
        }
        listPackets.add(iInsert, packet);
        return true;
    }

    public MemberSet getDiagnosticMemberSet() {
        return this.__m_DiagnosticMemberSet;
    }

    public byte getDiagnosticTimeToLive() {
        return this.__m_DiagnosticTimeToLive;
    }

    public long getDiagnosticWindowMillis() {
        return this.__m_DiagnosticWindowMillis;
    }

    public long getLastDiagnosticMillis() {
        return this.__m_LastDiagnosticMillis;
    }

    public WindowedArray getMessageOutgoing() {
        return ((PacketPublisher)this.get_Module()).getMessageOutgoing();
    }

    public int getMultipointPacketCount() {
        return this.__m_MultipointPacketCount;
    }

    public int getResendMillis() {
        return this.__m_ResendMillis;
    }

    public int getTimeoutMillis() {
        return this.__m_TimeoutMillis;
    }

    public long getWaitMillis() {
        MessagePacket packet = (MessagePacket)this.peekNoWait();
        if (packet == null) {
            return 0L;
        }
        long ldtScheduled = packet.getResendScheduled();
        if (ldtScheduled < 0L) {
            return -1L;
        }
        long cMillisWait = ldtScheduled - Base.getSafeTimeMillis();
        return cMillisWait <= 0L ? -1L : cMillisWait;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$ResendQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketPublisher$ResendQueue();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void onInit() {
        this.setDiagnosticTimeToLive(Byte.parseByte(Config.getProperty("coherence.tcmp.diag.ttl", "2")));
        this.setDiagnosticWindowMillis(Long.parseLong(Config.getProperty("coherence.tcmp.diag.window", "2000")));
        this.setDiagnosticMemberSet(new MemberSet());
        super.onInit();
    }

    protected void onPacketAdd(MessagePacket packet) {
        if (packet.getResendTimeout() == 0L) {
            packet.setResendTimeout(packet.getSentMillis() + (long)this.getTimeoutMillis());
            if (packet.isOutgoingMultipoint()) {
                this.setMultipointPacketCount(this.getMultipointPacketCount() + 1);
            }
        }
    }

    protected void onPacketDone(MessagePacket packet) {
        long lMsgId;
        WindowedArray waMsg;
        Message msg;
        if (packet.isOutgoingMultipoint()) {
            this.setMultipointPacketCount(this.getMultipointPacketCount() - 1);
        }
        if ((msg = (Message)(waMsg = this.getMessageOutgoing()).get(lMsgId = packet.getFromMessageId())) == null) {
            Component._trace(new StringBuilder(String.valueOf("Encountered orphan packet:\n")).append(packet).append("\nOutgoing Message Array:\n").append(waMsg).toString(), 1);
            throw new IllegalStateException("Encountered orphan packet");
        }
        msg.setPacket(packet.getMessagePartIndex(), null);
        if (msg.getNullPacketCount() == msg.getMessagePartCount()) {
            msg.releaseOutgoing(true, false);
            if (lMsgId == waMsg.getFirstIndex()) {
                long lLastId = waMsg.getLastIndex();
                do {
                    waMsg.remove(lMsgId);
                    msg.releaseOutgoingComplete();
                    msg = null;
                    while (!(msg == null) ? false : lMsgId < lLastId) {
                        msg = (Message)waMsg.get(++lMsgId);
                    }
                } while (!(msg != null) ? false : msg.getNullPacketCount() == msg.getMessagePartCount());
            } else if (msg.isNotifyDelivery() ^ true) {
                waMsg.remove(lMsgId);
                msg.releaseOutgoingComplete();
            }
        }
    }

    protected void onPacketLost(Member member, MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        boolean fTimedout = packet.getPendingResendSkips() == 0;
        Member$FlowControl flowControl = member.getFlowControl();
        long ldtNow = Base.getLastSafeTimeMillis();
        if (!(flowControl != null) ? false : packet.isDeferrable()) {
            int iLostPacketThreshold;
            int cSeqLost = flowControl.getSequentialLostCount();
            flowControl.setSequentialLostCount(++cSeqLost);
            if (fTimedout && (!(!(!((iLostPacketThreshold = Member$FlowControl.getLostPacketThreshold()) > 0) ? false : cSeqLost > iLostPacketThreshold) ? false : flowControl.isPaused() ^ true) ? false : ldtNow - packet.getResendScheduled() < Daemon.getClockResolutionMillis())) {
                flowControl.setPaused(true);
            }
            packet.setDeliveryState(MessagePacket.DELIVERY_LOST, member);
            publisher.drainDeferredPackets(member);
        }
        if (!publisher.isNackEnabled() ? false : fTimedout) {
            member.getRecentPacketQueue().remove(packet);
        }
        long ldtTimeout = packet.getResendTimeout();
        if (!(!(member.isDeaf() ^ true) ? false : ldtTimeout - ldtNow < this.getDiagnosticWindowMillis()) ? false : ldtTimeout > ldtNow) {
            if (ldtNow >= this.getLastDiagnosticMillis() + (long)this.getResendMillis()) {
                this.getDiagnosticMemberSet().clear();
                this.setLastDiagnosticMillis(ldtNow);
            }
            if (this.getDiagnosticMemberSet().add(member)) {
                DiagnosticPacket packetDiag;
                int nToId = member.getId();
                byte nTTL = this.getDiagnosticTimeToLive();
                if (member.getPreferredPort() != 0) {
                    packetDiag = new DiagnosticPacket();
                    packetDiag.setPreferredPortUsed(true);
                    packetDiag.setToId(nToId);
                    packetDiag.setTimeToLive(nTTL);
                    publisher.sendDiagnosticPacket(packetDiag);
                }
                packetDiag = new DiagnosticPacket();
                packetDiag.setToId(nToId);
                packetDiag.setTimeToLive(nTTL);
                publisher.sendDiagnosticPacket(packetDiag);
            }
        }
    }

    protected void onPacketLost(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        if (packet.isOutgoingMultipoint()) {
            int[] anToId = packet.getToMemberSet().toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = publisher.getMember(anToId[i]);
                if (member != null) {
                    this.onPacketLost(member, packet);
                }
                ++i;
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                this.onPacketLost(member, packet);
            }
        }
        if (packet.isNackInProgress()) {
            packet.setNackInProgress(false);
        }
    }

    public Object peekNoWait() {
        RecyclingLinkedList list = this.getElementList();
        while (list.isEmpty() ^ true) {
            MessagePacket packet = (MessagePacket)list.get(0);
            if (packet == null) {
                return null;
            }
            if (packet.isNackInProgress()) {
                packet.setNackInProgress(false);
                packet.setPendingResendSkips(packet.getPendingResendSkips() + 1);
            } else if (packet.getPendingResendSkips() > 0) {
                if (packet == list.remove(0)) {
                    packet.setPendingResendSkips(packet.getPendingResendSkips() - 1);
                    continue;
                }
                throw new IllegalStateException();
            }
            return packet;
        }
        return null;
    }

    public Object remove() {
        throw new UnsupportedOperationException();
    }

    public Object removeNoWait() {
        MessagePacket packet = (MessagePacket)this.peekNoWait();
        while (packet != null) {
            block13: {
                block10: {
                    block11: {
                        PacketPublisher publisher;
                        long ldtSlowTimeout;
                        long ldtScheduled;
                        block14: {
                            long ldtResendTimeout;
                            long ldtNow;
                            block12: {
                                if (!packet.isResendNecessary()) break block10;
                                ldtNow = Base.getSafeTimeMillis();
                                ldtScheduled = packet.getResendScheduled();
                                if (ldtScheduled > ldtNow) break;
                                if (packet != super.removeNoWait()) {
                                    throw new IllegalStateException();
                                }
                                ldtResendTimeout = packet.getResendTimeout();
                                long cMillisTimeout = this.getTimeoutMillis();
                                long ldtHeuristicTimeout = ldtResendTimeout - (cMillisTimeout >> 1);
                                ldtSlowTimeout = ldtResendTimeout - (cMillisTimeout >> 2);
                                if (!(ldtScheduled > ldtHeuristicTimeout)) break block11;
                                publisher = (PacketPublisher)this.get_Module();
                                if (!(publisher.verifyResendNecessary(packet) ^ true)) break block12;
                                this.onPacketDone(packet);
                                break block13;
                            }
                            int nToId = packet.getToId();
                            if (nToId != 0) {
                                Member member = publisher.getMember(nToId);
                                if (member != null) {
                                    member.setLastHeuristicDeathMillis(ldtNow);
                                }
                            } else {
                                DependentMemberSet setToMember = packet.getToMemberSet();
                                if (setToMember != null) {
                                    Iterator iter = setToMember.iterator();
                                    while (iter.hasNext()) {
                                        Member member = (Member)iter.next();
                                        member.setLastHeuristicDeathMillis(ldtNow);
                                    }
                                }
                            }
                            if (!(ldtScheduled > ldtResendTimeout)) break block14;
                            publisher.onUndeliverablePacket(packet);
                            if (!(packet.isResendNecessary() ^ true)) break block11;
                            this.onPacketDone(packet);
                            break block13;
                        }
                        if (ldtScheduled > ldtSlowTimeout) {
                            publisher.onSlowPacket(packet);
                        }
                    }
                    this.onPacketLost(packet);
                    return packet;
                }
                if (packet == super.removeNoWait()) {
                    this.onPacketDone(packet);
                } else {
                    throw new IllegalStateException();
                }
            }
            packet = (MessagePacket)this.peekNoWait();
        }
        return null;
    }

    public void setDiagnosticMemberSet(MemberSet setMember) {
        this.__m_DiagnosticMemberSet = setMember;
    }

    protected void setDiagnosticTimeToLive(byte cTrips) {
        this.__m_DiagnosticTimeToLive = cTrips;
    }

    protected void setDiagnosticWindowMillis(long cMillis) {
        this.__m_DiagnosticWindowMillis = cMillis;
    }

    public void setLastDiagnosticMillis(long lMillis) {
        this.__m_LastDiagnosticMillis = lMillis;
    }

    protected void setMultipointPacketCount(int cPackets) {
        this.__m_MultipointPacketCount = cPackets;
    }

    public void setResendMillis(int cMillis) {
        this.__m_ResendMillis = Math.max(1, cMillis);
    }

    public void setTimeoutMillis(int cMillis) {
        this.__m_TimeoutMillis = Math.max(10, cMillis);
    }
}

